/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.service.open;

import java.sql.Timestamp;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.id.IDService;
import kd.bos.openapi.common.constant.ApiDefType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.platform.core.api.openapi.v2.OpenApiField;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;
import kd.isc.iscx.platform.core.res.meta.event.ApiEvent;
import kd.isc.iscx.platform.core.res.runtime.DataFlowTrigger;
import kd.isc.iscx.platform.core.service.open.DataFlow2ApiDispatcher;

public class DataFlow2ApiBuilder {
    private long dataFlowTriggerId;
    private ApiEvent event;

    public DataFlow2ApiBuilder(ApiEvent event, long dataFlowTriggerId) {
        this.dataFlowTriggerId = dataFlowTriggerId;
        this.event = event;
    }

    public void publish() {
        DynamicObject api = this.getWebApiDynamicObject();
        this.setHeaderInfo(api);
        this.setInputParams(api);
        this.setOutputParams(api);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"openapi_customapi", (DynamicObject[])new DynamicObject[]{api}, (OperateOption)CommonUtil.getSkipPermissionOption());
        CommonUtil.check((OperationResult)result);
    }

    private void setInputParams(DynamicObject api) {
        StructSchema schema = this.event.getParams().getDataType();
        DynamicObjectCollection bodyEntries = api.getDynamicObjectCollection("bodyentryentity");
        bodyEntries.clear();
        if (this.event.isArray()) {
            long batchParentBodyId = this.addBatchParentBody(bodyEntries);
            this.addBodyInputs(batchParentBodyId, schema, bodyEntries, 2);
        } else {
            this.addBodyInputs(0L, schema, bodyEntries, 1);
        }
    }

    private void addBodyInputs(long pid, StructSchema schema, DynamicObjectCollection bodyEntries, int level) {
        for (int i = 0; i < schema.fieldCount(); ++i) {
            DataType fieldType;
            DynamicObject entry = bodyEntries.addNew();
            Field field = schema.getField(i);
            long id = IDService.get().genLongId();
            entry.set("id", (Object)id);
            entry.set("paramname", (Object)field.getName());
            entry.set("bodyparamdes", (Object)field.getLabel());
            String typeDef = field.getTypeDef();
            kd.bos.openapi.common.constant.DataType type = OpenApiField.structTypeToOpenApiType((String)typeDef);
            Object example = type.defaultValue();
            entry.set("example", (Object)("-".equals(example) ? "" : Json.toString((Object)example, (boolean)true)));
            entry.set("paramtype", (Object)type.type());
            entry.set("is_req_mul_value", (Object)field.isMultiple());
            entry.set("must", (Object)(field.isRequired() ? "1" : "0"));
            entry.set("pid", (Object)pid);
            entry.set("body_level", (Object)level);
            if (kd.bos.openapi.common.constant.DataType.STRUCT != type || !((fieldType = field.getType()) instanceof StructSchema)) continue;
            StructSchema structSchema = (StructSchema)fieldType;
            this.addBodyInputs(id, structSchema, bodyEntries, level + 1);
        }
    }

    private long addBatchParentBody(DynamicObjectCollection bodyEntries) {
        DynamicObject entry = bodyEntries.addNew();
        long id = IDService.get().genLongId();
        entry.set("id", (Object)id);
        entry.set("paramname", (Object)"$batch");
        entry.set("bodyparamdes", (Object)ResManager.loadKDString((String)"\u6279\u91cf\u6570\u636e\u5305", (String)"DataFlow2ApiBuilder_2", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        entry.set("paramtype", (Object)kd.bos.openapi.common.constant.DataType.STRUCT.type());
        entry.set("is_req_mul_value", (Object)true);
        entry.set("must", (Object)"0");
        entry.set("pid", (Object)0L);
        entry.set("body_level", (Object)1);
        return id;
    }

    private void setOutputParams(DynamicObject api) {
        DynamicObjectCollection respEntries = api.getDynamicObjectCollection("respentryentity");
        respEntries.clear();
        DynamicObject respEntry = respEntries.addNew();
        long id = IDService.get().genLongId();
        respEntry.set("ID", (Object)id);
        respEntry.set("respparamname", (Object)"dataFlowInstId");
        respEntry.set("respdes", (Object)ResManager.loadKDString((String)"\u6570\u636e\u6d41\u5b9e\u4f8bID", (String)"DataFlow2ApiBuilder_3", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
        kd.bos.openapi.common.constant.DataType openApiType = kd.bos.openapi.common.constant.DataType.LONG;
        Object object = openApiType.defaultValue();
        respEntry.set("respparamtype", (Object)openApiType.type());
        respEntry.set("respexample", (Object)("-".equals(object) ? "-" : Json.toString((Object)object, (boolean)true)));
        respEntry.set("is_resp_mul_value", (Object)false);
        respEntry.set("pid", (Object)0L);
        respEntry.set("resp_level", (Object)1);
    }

    private void setHeaderInfo(DynamicObject api) {
        DataFlowTrigger trigger = DataFlowTrigger.get(this.dataFlowTriggerId);
        api.set("number", (Object)trigger.getNumber());
        api.set("name", (Object)trigger.getName());
        api.set("urlformat", (Object)("/v2/iscx/data_flow/" + trigger.getNumber()));
        api.set("appid", (Object)"2SLS+84NGM=B");
        api.set("apiservicetype", (Object)2);
        api.set("enable", (Object)1);
        api.set("status", (Object)"C");
        api.set("httpmethod", (Object)1);
        api.set("version", (Object)"2");
        api.set("classname", (Object)DataFlow2ApiDispatcher.class.getName());
        api.set("methodname", (Object)"route");
        api.set("customsort", (Object)1338403334104677376L);
        api.set("apideftype", (Object)ApiDefType.WSDL.getCode());
        api.set("discription", (Object)ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u6570\u636e\u6d41\u542f\u52a8\u65b9\u6848\u542f\u7528\u65f6\u53d1\u5e03\u6b64API\uff0c\u5982\u679c\u9700\u8981\u542f\u7528/\u7981\u7528API\u5e94\u8be5\u5728\u201c\u96c6\u6210\u4e91 - \u6570\u636e\u6d41 - \u542f\u52a8\u65b9\u6848\u201d\u5904\u64cd\u4f5c\uff0c\u5426\u5219\u5c06\u5bfc\u81f4\u4e8c\u8005\u72b6\u6001\u4e0d\u4e00\u81f4\u3002", (String)"DataFlow2ApiBuilder_1", (String)"isc-iscx-platform-core", (Object[])new Object[0]));
    }

    private DynamicObject getWebApiDynamicObject() {
        DynamicObject api;
        long id = this.dataFlowTriggerId;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long userId = RequestContext.get().getCurrUserId();
        if (QueryServiceHelper.exists((String)"openapi_customapi", (Object)id)) {
            api = BusinessDataServiceHelper.loadSingle((Object)id, (String)"openapi_customapi");
            api.set("modifier", (Object)userId);
            api.set("modifytime", (Object)now);
        } else {
            api = BusinessDataServiceHelper.newDynamicObject((String)"openapi_customapi");
            api.set("id", (Object)id);
            api.set("modifier", (Object)userId);
            api.set("modifytime", (Object)now);
            api.set("creator", (Object)userId);
            api.set("createtime", (Object)now);
        }
        return api;
    }

    public void unpublish() {
        long id = this.dataFlowTriggerId;
        if (QueryServiceHelper.exists((String)"openapi_customapi", (Object)id)) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"openapi_customapi");
            obj.set("status", (Object)"D");
            obj.set("enable", (Object)"0");
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"openapi_customapi", (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)CommonUtil.getSkipPermissionOption());
            CommonUtil.check((OperationResult)result);
        }
    }
}

