/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.platform.core.service.open;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.api.model.ServiceApiData;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.service.IscDataFlowServiceImpl;

@ApiController(value="iscx", desc="openApi2.0_dispatcher")
public class DataFlow2ApiDispatcher {
    @ApiPostMapping(value="/data_flow", desc="\u96c6\u6210\u4e91\u6570\u636e\u6d41\u670d\u52a1::DataFlow2ApiDispatcher_2::isc-iscx-platform-core")
    public CustomApiResult<Object> route(@ApiParam(value="\u5165\u53c2::DataFlow2ApiDispatcher_3::isc-iscx-platform-core") @ApiParam(value="\u5165\u53c2::DataFlow2ApiDispatcher_3::isc-iscx-platform-core") Map<String, Object> data) {
        OpenApiRequest request = ServiceApiContext.getRequest();
        ServiceApiData serviceApiData = request.getServiceApiData();
        try {
            long procInstId = this.startDataFlow(data, serviceApiData);
            return this.generateSuccessResult(procInstId);
        }
        catch (Exception e) {
            return this.generateFailedResult(e);
        }
    }

    private CustomApiResult<Object> generateFailedResult(Exception e) {
        CustomApiResult customApiResult = new CustomApiResult();
        customApiResult.setStatus(false);
        customApiResult.setErrorCode(e instanceof IscBizException ? ((IscBizException)e).getCode() : "500");
        customApiResult.setMessage(StringUtil.getCascadeMessage((Throwable)e));
        return customApiResult;
    }

    private CustomApiResult<Object> generateSuccessResult(long procInstId) {
        CustomApiResult customApiResult = new CustomApiResult();
        customApiResult.setStatus(true);
        customApiResult.setErrorCode("");
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("dataFlowInstId", procInstId);
        customApiResult.setData(result);
        customApiResult.setMessage("");
        return customApiResult;
    }

    private long startDataFlow(Map<String, Object> data, ServiceApiData serviceApiData) {
        long procInstId;
        String triggerNumber = serviceApiData.getApiNumber();
        if (data.size() == 1 && data.get("$batch") instanceof List) {
            List batch = (List)data.get("$batch");
            procInstId = new IscDataFlowServiceImpl().startX(triggerNumber, batch);
        } else {
            procInstId = new IscDataFlowServiceImpl().start(triggerNumber, data);
        }
        return procInstId;
    }
}

