/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.opplugin.resource;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class ResourceDeleteOpPlugin
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        int count = dataEntities.length;
        if (count == 0) {
            return;
        }
        HashMap<Long, String> numbers = new HashMap<Long, String>(count);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT b.fbasedataid as fid,a.fnumber as fnumber,c.fname as fname FROM t_iscx_res_main a \nleft join t_iscx_res_main_depends b  on a.fid = b.fid \nleft join t_iscx_res_type c on a.ftype = c.fid\nWHERE b.fbasedataid in(");
        ArrayList<Integer> types = new ArrayList<Integer>(count);
        ArrayList<Object> values = new ArrayList<Object>(count);
        for (DynamicObject res : dataEntities) {
            if (values.size() > 0) {
                sql.append(',');
            }
            sql.append('?');
            types.add(-5);
            Long id = res.getLong("id");
            values.add(id);
            numbers.put(id, res.getString("name") + "(" + res.getString("number") + ")");
        }
        sql.append(')');
        String sql_1 = sql.toString();
        if (this.existReferences(sql_1, types, values, numbers, dataEntities.length > 1)) {
            e.setCancel(true);
            return;
        }
        String sql_2 = sql_1.replace("t_iscx_res_main_depends", "t_iscx_res_ext_depends");
        e.setCancel(this.existReferences(sql_2, types, values, numbers, dataEntities.length > 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existReferences(String sql, List<Integer> types, List<Object> values, Map<Long, String> numbers, boolean isBatch) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List rows = DbUtil.executeList((Connection)cn, (String)sql, values, types);
            if (!rows.isEmpty()) {
                if (isBatch) {
                    for (DataRow row : rows) {
                        OperateErrorInfo info = new OperateErrorInfo("", ErrorLevel.Error, (Object)D.l((Object)row.get((Object)"fid")));
                        info.setMessage(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u201c%1$s\u201d\u88ab\u201c%2$s\uff1a%3$s\u201d\u8d44\u6e90\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ResourceDeleteOpPlugin_3", (String)"isc-iscx-platform-opplugin", (Object[])new Object[0]), numbers.get(D.l((Object)row.get((Object)"fid"))), row.get((Object)"fname"), row.get((Object)"fnumber")));
                        this.operationResult.addErrorInfo(info);
                    }
                } else {
                    long id = 0L;
                    StringBuilder sb = new StringBuilder();
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    for (DataRow row : rows) {
                        sb.append(row.get((Object)"fname")).append('\uff1a').append(row.get((Object)"fnumber"));
                        id = D.l((Object)row.get((Object)"fid"));
                    }
                    OperateErrorInfo info = new OperateErrorInfo("", ErrorLevel.Error, (Object)id);
                    info.setMessage(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u201c%1$s\u201d\u88ab\u201c%2$s\u201d\u8d44\u6e90\u5f15\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"ResourceDeleteOpPlugin_4", (String)"isc-iscx-platform-opplugin", (Object[])new Object[0]), numbers.get(id), sb.toString()));
                    this.operationResult.addErrorInfo(info);
                }
            }
            boolean bl = !rows.isEmpty();
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }
}

