/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.opplugin.runtime;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dw.DataFlow;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;
import kd.isc.iscx.platform.core.res.runtime.BatchSupportable;
import kd.isc.iscx.platform.core.res.runtime.DataFlowEngine;
import kd.isc.iscx.platform.core.res.runtime.DataFlowTrigger;

public class DataFlowTriggerPluginUtil {
    public static void disable(long dataFlowTriggerId) {
        long dataFlowId = DataFlowTrigger.queryMaxDataFlowId((long)dataFlowTriggerId);
        if (dataFlowId > 0L) {
            DynamicObject dataFlow = BusinessDataServiceHelper.loadSingle((Object)dataFlowId, (String)"iscx_data_flow_define");
            DataFlowEngine.disable((DynamicObject)dataFlow);
        }
    }

    public static void enable(long dataFlowTriggerId) {
        int version;
        DynamicObject dataFlowTrigger = BusinessDataServiceHelper.loadSingle((Object)dataFlowTriggerId, (String)"iscx_data_flow_trigger");
        DynamicObject dataFlow = DataFlowTriggerPluginUtil.buildDataFlow(dataFlowTrigger, version = DataFlowTriggerPluginUtil.queryMaxVersion(dataFlowTriggerId) + 1);
        String crc = DataFlowTriggerPluginUtil.calcCRC(dataFlow);
        if (crc.equals(dataFlowTrigger.get("crc"))) {
            DataFlowTriggerPluginUtil.enableUnchangedDataFlow(dataFlowTriggerId, dataFlowTrigger, crc);
        } else {
            DataFlowTriggerPluginUtil.createAndEnableDataFlow(dataFlowTrigger, dataFlow, crc, version);
        }
    }

    private static void createAndEnableDataFlow(DynamicObject dataFlowTrigger, DynamicObject dataFlow, String crc, int version) {
        DataFlowEngine.enable((DynamicObject)dataFlow);
        dataFlow.set("crc", (Object)crc);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataFlow});
        dataFlowTrigger.set("version", (Object)version);
        dataFlowTrigger.set("crc", dataFlow.get("crc"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataFlowTrigger});
    }

    private static void enableUnchangedDataFlow(long dataFlowTriggerId, DynamicObject dataFlowTrigger, String crc) {
        DynamicObject dataFlow;
        long dataFlowId = DataFlowTrigger.queryMaxDataFlowId((long)dataFlowTriggerId);
        if (dataFlowId > 0L) {
            dataFlow = BusinessDataServiceHelper.loadSingle((Object)dataFlowId, (String)"iscx_data_flow_define");
            if (!crc.equals(dataFlow.get("crc"))) {
                String message = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u4efb\u52a1\uff08%s\uff09\u7684\u6570\u636e\u5b8c\u6574\u6027\u88ab\u7834\u574f\u4e86\uff0c\u5176\u8bbe\u7f6e\u7684CRC\u6821\u9a8c\u7801\u4e0e\u6570\u636e\u6d41\u5b9a\u4e49\u4e0d\u4e00\u81f4\u3002", (String)"DataFlowTriggerPluginUtil_5", (String)"isc-iscx-platform-opplugin", (Object[])new Object[0]), dataFlowTrigger.get("name"));
                throw new IscBizException(message);
            }
        } else {
            String message = String.format(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u4efb\u52a1\uff08%s\uff09\u7684\u6570\u636e\u5b8c\u6574\u6027\u88ab\u7834\u574f\u4e86\uff0c\u5176\u8bbe\u7f6e\u4e86CRC\u6821\u9a8c\u7801\uff0c\u4f46\u4e0d\u5b58\u5728\u6570\u636e\u6d41\u5b9a\u4e49\u3002", (String)"DataFlowTriggerPluginUtil_6", (String)"isc-iscx-platform-opplugin", (Object[])new Object[0]), dataFlowTrigger.get("name"));
            throw new IscBizException(message);
        }
        DataFlowEngine.enable((DynamicObject)dataFlow);
    }

    private static DynamicObject buildDataFlow(DynamicObject dataFlowTrigger, int version) {
        DynamicObject dataFlowDefine = BusinessDataServiceHelper.newDynamicObject((String)"iscx_data_flow_define");
        DataFlow dataFlowRes = (DataFlow)ResourceUtil.getResource((long)dataFlowTrigger.getLong("data_flow_id"));
        Map<String, Object> define = DataFlowTriggerPluginUtil.prepareDataFlowDefine(dataFlowTrigger, dataFlowRes);
        dataFlowDefine.set("id", (Object)IDService.get().genLongId());
        dataFlowDefine.set("data_flow_trigger", (Object)dataFlowTrigger);
        dataFlowDefine.set("number", (Object)DataFlowTriggerPluginUtil.generateNumber(dataFlowTrigger));
        dataFlowDefine.set("event_type", dataFlowTrigger.get("event_type"));
        dataFlowDefine.set("define_json", (Object)"...");
        dataFlowDefine.set("define_json_tag", (Object)Json.toString(define));
        dataFlowDefine.set("version", (Object)version);
        dataFlowDefine.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        dataFlowDefine.set("creator", (Object)RequestContext.get().getCurrUserId());
        ResourceUtil.copy((DynamicObject)dataFlowTrigger, (DynamicObject)dataFlowDefine, (String[])new String[]{"data_flow", "name", "remark", "max_threads", "log_level", "work_area_size", "job_mutex", "max_retry_times", "retry_interval", "checkpoint", "failed_notice", "success_notice", "start_mq_topic", "end_mq_topic"});
        return dataFlowDefine;
    }

    private static String calcCRC(DynamicObject dataFlow) {
        ArrayList<Object> features = new ArrayList<Object>();
        ResourceUtil.copy((DynamicObject)dataFlow, features, (String[])new String[]{"event_type", "define_json_tag", "name", "remark", "max_threads", "log_level", "work_area_size", "job_mutex", "max_retry_times", "retry_interval", "checkpoint", "failed_notice", "success_notice", "start_mq_topic", "end_mq_topic"});
        DynamicObject dataFlowTrigger = dataFlow.getDynamicObject("data_flow_trigger");
        features.add(dataFlowTrigger.get("id"));
        features.add(dataFlowTrigger.get("number"));
        features.add(dataFlowTrigger.get("name"));
        DynamicObject dataFlowRes = dataFlow.getDynamicObject("data_flow");
        features.add(dataFlowRes.get("id"));
        features.add(dataFlowRes.get("number"));
        features.add(dataFlowRes.get("name"));
        return Hash.mur32((Object[])features.toArray());
    }

    private static String generateNumber(DynamicObject dataFlowTrigger) {
        String number = Hash.mur32((Object[])new Object[]{UUID.randomUUID()}) + "@" + dataFlowTrigger.getString("number");
        if (number.length() > 30) {
            number = number.substring(0, 30);
        }
        return number;
    }

    private static Map<String, Object> prepareDataFlowDefine(DynamicObject dataFlowTrigger, DataFlow dataFlowRes) {
        AbstractEventModel event = (AbstractEventModel)ResourceUtil.getResource((long)dataFlowTrigger.getLong("event_model_id"));
        if (!event.equals((Object)dataFlowRes.getEventModel())) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u5f00\u59cb\u8282\u70b9\u7684\u4e8b\u4ef6\u6a21\u578b\u4e0e\u542f\u52a8\u65b9\u6848\u201c%s\u201d\u7684\u4e8b\u4ef6\u6a21\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u4fdd\u5b58\u542f\u52a8\u65b9\u6848\u518d\u542f\u7528\u3002", (String)"DataFlowTriggerPluginUtil_7", (String)"isc-iscx-platform-opplugin", (Object[])new Object[0]), dataFlowTrigger.get("number")));
        }
        LinkedHashMap<String, Object> define = new LinkedHashMap<String, Object>(8);
        define.put("event", event.getId());
        define.put("event_meta", event.getMetaData());
        define.put("connectors", DataFlowTriggerPluginUtil.getConnectors(dataFlowTrigger));
        define.put("params", DataFlowTriggerPluginUtil.getParams(dataFlowTrigger));
        Map diagram = (Map)Json.toObject((String)dataFlowRes.getDetailsJson());
        DataFlowTriggerPluginUtil.recordBatchMode(diagram);
        define.put("diagram", diagram);
        return define;
    }

    private static void recordBatchMode(Map<String, Object> diagram) {
        List nodes = (List)ResourceUtil.getValue(diagram, (String[])new String[]{"define", "nodes"});
        for (Map n : nodes) {
            Resource res;
            long resId = D.l((Object)ResourceUtil.getValue((Map)n, (String[])new String[]{"details", "resource", "id"}));
            if (resId == 0L || !((res = ResourceUtil.getResource((long)resId)) instanceof BatchSupportable)) continue;
            n.put("batch_mode", ((BatchSupportable)res).isBatchMode());
        }
    }

    private static Object getParams(DynamicObject dataFlowTrigger) {
        LinkedHashMap<String, String> connectors = new LinkedHashMap<String, String>(8);
        for (DynamicObject item : dataFlowTrigger.getDynamicObjectCollection("params")) {
            String number = item.getString("param_number");
            String value = item.getString("param_value");
            connectors.put(number, value);
        }
        return connectors;
    }

    private static Map<String, Map<String, Object>> getConnectors(DynamicObject dataFlowTrigger) {
        LinkedHashMap<String, Map<String, Object>> connectors = new LinkedHashMap<String, Map<String, Object>>(8);
        for (DynamicObject item : dataFlowTrigger.getDynamicObjectCollection("connectors")) {
            DynamicObject ref = item.getDynamicObject("connector_ref");
            LinkedHashMap<String, Object> connector = new LinkedHashMap<String, Object>(4);
            connector.put("id", ref.get("id"));
            connector.put("name", ref.get("name"));
            connector.put("number", ref.get("number"));
            connectors.put(item.getString("connector_number"), connector);
        }
        return connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int queryMaxVersion(long dataFlowTriggerId) {
        String sql = "SELECT MAX(fversion) FROM t_iscx_data_flow_define WHERE fdata_flow_trigger = ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            Object value = DbUtil.executeScalar((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{dataFlowTriggerId}), (List)D.asList((Object[])new Integer[]{-5}));
            int n = D.i((Object)value);
            return n;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }
}

