/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.catalog;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ResourceIsolateUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.MenuResourceTypeUtil;
import kd.isc.iscx.platform.core.res.CatalogType;
import kd.isc.iscx.platform.core.res.ResourceTypeGroup;

public abstract class CatalogExplorerBasePluginV3
extends AbstractListPlugin
implements TreeNodeClickListener,
ClickListener,
SearchEnterListener {
    protected static final String TREE_KEY = "treeviewap";
    protected static final String PAGE_CACHE_NODES = "page_cache_nodes";
    private static final String QUERY_CATALOG_PROPERTIES = "id,number,long_number,name,parent,type,icon_url,priority";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
        this.showTypeGroup();
    }

    private void initTree() {
        TreeView tree = (TreeView)this.getControl(TREE_KEY);
        tree.deleteAllNodes();
        tree.setMulti(false);
        TreeNode root = new TreeNode("", "$root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"CatalogExplorerBasePluginV3_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        tree.addNode(root);
        CatalogType[] catalogTypeArray = this.getCatalogType();
        ArrayList<String> names = new ArrayList<String>(catalogTypeArray.length);
        for (CatalogType type : catalogTypeArray) {
            names.add(type.name());
        }
        QFilter qFilter = new QFilter("type", "in", names);
        qFilter = this.appendIsolateFilter(qFilter);
        DynamicObject[] catalogs = BusinessDataServiceHelper.load((String)"iscx_catalog", (String)QUERY_CATALOG_PROPERTIES, (QFilter[])new QFilter[]{qFilter}, (String)"priority");
        for (CatalogType type : catalogTypeArray) {
            if (type.parentType() == null) {
                TreeNode node = new TreeNode("$root", type.name(), type.label());
                tree.addNode(node);
                tree.expand(type.name());
            }
            this.addTreeNode(tree, type, catalogs);
        }
        tree.focusNode(root);
        this.treeNodeClick(null);
    }

    private QFilter appendIsolateFilter(QFilter qFilter) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        QFilter sourceAppFilter = ResourceIsolateUtil.generateFilter((Map)customParams);
        if (sourceAppFilter != null) {
            qFilter = qFilter.and(sourceAppFilter);
        }
        return qFilter;
    }

    private void addTreeNode(TreeView tree, CatalogType type, DynamicObject[] catalogs) {
        for (DynamicObject c : catalogs) {
            if (!type.name().equals(c.getString("type"))) continue;
            String parentId = c.getString("parent_id");
            if ("0".equals(parentId)) {
                parentId = type.name();
            }
            String id = D.s((Object)c.getPkValue());
            String name = c.getString("name");
            TreeNode node = new TreeNode(parentId, id, name);
            this.setNodeIcon(node, c.getString("type"));
            tree.addNode(node);
            this.addNodeToCache(node, c);
        }
    }

    private void setNodeIcon(TreeNode node, String type) {
        if (CatalogType.valueOf((String)type) == CatalogType.Industry) {
            node.setIcon("kdfont kdfont-cengji");
        } else if (CatalogType.valueOf((String)type) == CatalogType.System) {
            node.setIcon("kdfont kdfont-cangku2");
        } else if (CatalogType.valueOf((String)type) == CatalogType.Module) {
            node.setIcon("kdfont kdfont-mokuai2");
        } else if (CatalogType.valueOf((String)type) == CatalogType.Scene) {
            node.setIcon("kdfont kdfont-zhiweitixifangan");
        } else if (CatalogType.valueOf((String)type) == CatalogType.Solution) {
            node.setIcon("kdfont kdfont-fenxifangan");
        } else if (CatalogType.valueOf((String)type) == CatalogType.Common) {
            node.setIcon("kdfont kdfont-gonggongshuju");
        }
    }

    private void addNodeToCache(TreeNode node, DynamicObject c) {
        Map nodes = null;
        String pagecache = this.getPageCache().get(PAGE_CACHE_NODES);
        nodes = StringUtil.isEmpty((String)pagecache) ? new LinkedHashMap() : (Map)Json.toObject((String)pagecache);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", c.getString("type"));
        data.put("name", c.getString("name"));
        data.put("parentId", c.get("parent_id"));
        data.put("long_number", c.getString("long_number"));
        nodes.put(node.getId(), data);
        this.getPageCache().put(PAGE_CACHE_NODES, Json.toString(nodes));
    }

    private Map<String, Object> getNodeData(String nodeId) {
        String pagecache = this.getView().getPageCache().get(PAGE_CACHE_NODES);
        if (StringUtil.isEmpty((String)pagecache)) {
            return null;
        }
        Map nodes = (Map)Json.toObject((String)pagecache);
        return (Map)nodes.get(nodeId);
    }

    private CatalogType[] getCatalogType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String menuIscxCatalog = D.s(customParams.get("menu_iscx_catalog"));
        String menuIscxResType = D.s(customParams.get("menu_iscx_res_type"));
        if (menuIscxResType == null) {
            return CatalogType.values();
        }
        CatalogType[] types = MenuResourceTypeUtil.getMenuForCatalogType(menuIscxResType, menuIscxCatalog);
        if (types.length != 0) {
            return types;
        }
        String errInfo = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6b64\u83dc\u5355\u9002\u914d\u7684\u8d44\u6e90\u76ee\u5f55\uff0c\u8bf7\u8054\u7cfb\u96c6\u6210\u670d\u52a1\u4e91\u7ba1\u7406\u5458\u914d\u7f6e\uff0c\u5f53\u524d\u83dc\u5355\u914d\u7f6e\u53c2\u6570\u503c\u4e3a\u3010menu_iscx_res_type=%1$s\u3011\u3010menu_iscx_catalog=%2$s\u3011", (String)"CatalogExplorerBasePluginV3_15", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), menuIscxResType, menuIscxCatalog);
        throw new IscBizException(errInfo);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String focusNodeId = this.getFocusNodeId();
        Map<String, Object> nodeData = this.getNodeData(focusNodeId);
        if ("$root".equals(focusNodeId)) {
            this.getView().getPageCache().put("filter_longnumber", null);
            this.showTypeGroup();
        } else if (nodeData == null) {
            this.getView().getPageCache().put("filter_longnumber", focusNodeId.toUpperCase());
            this.showTypeGroup(focusNodeId);
            this.expandChildren(focusNodeId);
        } else {
            this.getView().getPageCache().put("filter_longnumber", D.s((Object)nodeData.get("long_number")));
            this.showTypeGroup(D.s((Object)nodeData.get("type")));
            this.expandChildren(focusNodeId);
        }
        this.clickGroup("group_all");
        this.getView().getPageCache().put("res_type_group", null);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
        TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
        tree.expand(focusNodeId);
        if (evt == null) {
            tree.focusNode(new TreeNode("", focusNodeId, ""));
        } else {
            tree.focusNode(new TreeNode(D.s((Object)evt.getParentNodeId()), D.s((Object)evt.getNodeId()), ""));
        }
    }

    private void expandChildren(String focusNodeId) {
        QFilter filter = null;
        filter = CatalogType.Common.name().equals(focusNodeId) || CatalogType.Industry.name().equals(focusNodeId) || CatalogType.Scene.name().equals(focusNodeId) ? new QFilter("type", "=", (Object)focusNodeId) : new QFilter("parent_id", "=", (Object)D.l((Object)focusNodeId));
        DynamicObject[] children = BusinessDataServiceHelper.load((String)"iscx_catalog", (String)QUERY_CATALOG_PROPERTIES, (QFilter[])new QFilter[]{filter}, (String)"priority");
        ArrayList<TreeNode> newChildren = new ArrayList<TreeNode>(children.length);
        for (DynamicObject c : children) {
            TreeNode child = new TreeNode(focusNodeId, c.getString("id"), c.getString("name"));
            this.setNodeIcon(child, c.getString("type"));
            newChildren.add(child);
            this.addNodeToCache(child, c);
        }
        this.deleteNotExistsChildren(focusNodeId, newChildren);
        TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
        tree.addNodes(newChildren);
        tree.expand(focusNodeId);
        this.getView().updateView(TREE_KEY);
    }

    private void deleteNotExistsChildren(String nodeid, List<TreeNode> newChildren) {
        ArrayList<String> newChildrenId = new ArrayList<String>(newChildren.size());
        for (TreeNode n : newChildren) {
            newChildrenId.add(n.getId());
        }
        String pagecache = this.getPageCache().get(PAGE_CACHE_NODES);
        Map nodes = (Map)Json.toObject((String)pagecache);
        if (nodes == null) {
            return;
        }
        ArrayList deleteChildrenId = new ArrayList();
        for (Map.Entry entry : nodes.entrySet()) {
            Map value = (Map)entry.getValue();
            if ("0".equals(D.s(value.get("parentId"))) && nodeid.equals(value.get("type")) && !newChildrenId.contains(entry.getKey())) {
                deleteChildrenId.add(entry.getKey());
            }
            if (!nodeid.equals(D.s(value.get("parentId"))) || newChildrenId.contains(entry.getKey())) continue;
            deleteChildrenId.add(entry.getKey());
        }
        TreeView tree = (TreeView)this.getControl(TREE_KEY);
        tree.deleteNodes(deleteChildrenId);
    }

    public abstract void setFilter(SetFilterEvent var1);

    private void showTypeGroup() {
        this.hideAllGroup();
        this.queryAndShowGroup(null);
    }

    private void showTypeGroup(String catalogType) {
        this.hideAllGroup();
        CatalogType leaf = this.findLeafCatalogType(CatalogType.valueOf((String)catalogType));
        QFilter filter = this.decorateFilter(leaf.name());
        this.queryAndShowGroup(filter);
    }

    private void queryAndShowGroup(QFilter filter) {
        DynamicObject[] types = BusinessDataServiceHelper.load((String)"iscx_resource_type", (String)"group", (QFilter[])new QFilter[]{filter}, (String)"priority");
        HashSet<String> set = new HashSet<String>(types.length);
        for (DynamicObject t : types) {
            if (!set.add(t.getString("group"))) continue;
            String controlId = "group" + set.size();
            String groupName = t.getString("group");
            String localGroupName = ResourceTypeGroup.loadKDString((String)groupName);
            this.getView().setVisible(Boolean.TRUE, new String[]{controlId});
            FieldEdit control = (FieldEdit)this.getControl(controlId);
            control.setText(localGroupName);
            control.setCaption(new LocaleString(localGroupName));
            this.getView().getPageCache().put(controlId, groupName);
        }
    }

    private QFilter decorateFilter(String catalogType) {
        if (CatalogType.Module.name().equals(catalogType)) {
            return new QFilter("for_module", "=", (Object)Boolean.TRUE);
        }
        if (CatalogType.Solution.name().equals(catalogType)) {
            return new QFilter("for_solution", "=", (Object)Boolean.TRUE);
        }
        if (CatalogType.Common.name().equals(catalogType)) {
            return new QFilter("for_common", "=", (Object)Boolean.TRUE);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"catalogType=[%s]\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u4e0d\u662f\u76ee\u5f55\u7c7b\u578b\u7684\u53f6\u5b50\u5c42\u7ea7", (String)"CatalogExplorerBasePluginV3_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), catalogType));
    }

    private CatalogType findLeafCatalogType(CatalogType type) {
        if (type.isLeaf()) {
            return type;
        }
        for (CatalogType t : CatalogType.values()) {
            if (t.parentType() != type) continue;
            return this.findLeafCatalogType(t);
        }
        throw new IscBizException(ResManager.loadKDString((String)"CatalogType\u6570\u636e\u6784\u9020\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u53f6\u5b50\u8282\u70b9", (String)"CatalogExplorerBasePluginV3_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
    }

    private CatalogType findChildCatalogType(CatalogType type) {
        if (type.isLeaf()) {
            return type;
        }
        for (CatalogType t : CatalogType.values()) {
            if (t.parentType() != type) continue;
            return t;
        }
        throw new IscBizException(ResManager.loadKDString((String)"CatalogType\u6570\u636e\u6784\u9020\u9519\u8bef\uff0c\u627e\u4e0d\u5230\u5b50\u8282\u70b9", (String)"CatalogExplorerBasePluginV3_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
    }

    private void hideAllGroup() {
        for (int i = 1; i <= 10; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"group" + i});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (D.x((Object)this.getView().getPageCache().get("set_value_trigger"))) {
            return;
        }
        String groupName = this.getView().getPageCache().get(e.getProperty().getName());
        this.getView().getPageCache().put("res_type_group", groupName);
        this.clickGroup(e.getProperty().getName());
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    private void clickGroup(String controlId) {
        this.getView().getPageCache().put("set_value_trigger", "true");
        for (int i = 1; i <= 10; ++i) {
            this.getModel().setValue("group" + i, (Object)Boolean.FALSE);
        }
        this.getModel().setValue("group_all", (Object)Boolean.FALSE);
        this.getModel().setValue(controlId, (Object)Boolean.TRUE);
        this.getView().getPageCache().put("set_value_trigger", "false");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean permission;
        super.beforeDoOperation(args);
        AbstractOperate oper = (AbstractOperate)args.getSource();
        if ("btndel".equals(oper.getOperateKey())) {
            boolean permission2 = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"2SLS+84NGM=B", (String)"iscx_catalog", (String)"4715e1f1000000ac");
            if (!permission2) {
                String s = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8d44\u6e90\u76ee\u5f55\u7684\u5220\u9664\u6743\u9650", (String)"CatalogExplorerBasePluginV3_19", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(s);
                args.setCancel(true);
            }
        } else if ("btnnew".equals(oper.getOperateKey()) && !(permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"2SLS+84NGM=B", (String)"iscx_catalog", (String)"47156aff000000ac"))) {
            String s = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8d44\u6e90\u76ee\u5f55\u7684\u65b0\u589e\u6743\u9650", (String)"CatalogExplorerBasePluginV3_20", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(s);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("frommetadata".equals(operateKey)) {
            String focusNodeId = this.getFocusNodeId();
            Map<String, Object> focusNode = this.getNodeData(focusNodeId);
            if (focusNode != null && CatalogType.valueOf((String)D.s((Object)focusNode.get("type"))) == CatalogType.Module) {
                this.getView().getPageCache().put("catalog", focusNodeId);
                this.getView().getFormShowParameter().setCustomParam("catalog", (Object)focusNodeId);
            }
        } else if ("select_type".equals(operateKey)) {
            this.getView().getPageCache().remove("catalog");
            String focusNodeId = this.getFocusNodeId();
            Map<String, Object> focusNode = this.getNodeData(focusNodeId);
            if (focusNode != null && CatalogType.valueOf((String)D.s((Object)focusNode.get("type"))).isLeaf()) {
                this.getView().getPageCache().put("catalog", focusNodeId);
                this.getView().getFormShowParameter().setCustomParam("catalog", (Object)focusNodeId);
            }
            String group = this.getView().getPageCache().get("res_type_group");
            this.getView().getPageCache().put("group", group);
            this.getView().getFormShowParameter().setCustomParam("group", (Object)group);
        } else if ("btnnew".equals(operateKey)) {
            this.openNewCatalog();
        } else if ("btnedit".equals(operateKey)) {
            this.openEditCatalog();
        } else if ("btndel".equals(operateKey)) {
            this.deleteCatalog();
        } else if ("refresh".equals(operateKey)) {
            this.initTree();
        }
    }

    protected String getFocusNodeId() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
        return tree.getTreeState().getFocusNodeId();
    }

    public void search(SearchEnterEvent e) {
        String nodeid;
        String text = e.getText();
        String lastSearchText = this.getPageCache().get("last_search_text");
        int lastSearchIndex = 1;
        if (text.equals(lastSearchText)) {
            lastSearchIndex = D.i((Object)this.getPageCache().get("last_search_index"));
        }
        if (StringUtil.isEmpty((String)(nodeid = this.findTreeNode(text, lastSearchIndex)))) {
            lastSearchIndex = 1;
            nodeid = this.findTreeNode(text, lastSearchIndex);
            if (StringUtil.isEmpty((String)nodeid)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"CatalogExplorerBasePluginV3_7", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            } else {
                TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
                tree.focusNode(new TreeNode("", nodeid, ""));
                this.treeNodeClick(null);
                this.getPageCache().put("last_search_text", text);
                this.getPageCache().put("last_search_index", String.valueOf(++lastSearchIndex));
            }
        } else {
            TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
            tree.focusNode(new TreeNode("", nodeid, ""));
            this.treeNodeClick(null);
            this.getPageCache().put("last_search_text", text);
            this.getPageCache().put("last_search_index", String.valueOf(++lastSearchIndex));
        }
    }

    private String findTreeNode(String text, int index) {
        String pagecache = this.getPageCache().get(PAGE_CACHE_NODES);
        Map nodes = (Map)Json.toObject((String)pagecache);
        int match = 0;
        for (Map.Entry entry : nodes.entrySet()) {
            Map value = (Map)entry.getValue();
            if (!D.s(value.get("name")).contains(text) || index != ++match) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private void deleteCatalog() {
        DynamicObject[] children;
        String focusNodeId = this.getFocusNodeId();
        Map<String, Object> nodeData = this.getNodeData(focusNodeId);
        if ("$root".equals(focusNodeId) || nodeData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u3001\u5220\u9664\u3001\u7f16\u8f91\u9884\u7f6e\u6839\u8282\u70b9", (String)"CatalogExplorerBasePluginV3_18", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)focusNodeId, (String)"iscx_catalog", (String)QUERY_CATALOG_PROPERTIES);
        if (!CatalogType.valueOf((String)catalog.getString("type")).isLeaf() && (children = this.queryCatalogChildrenById(D.l((Object)focusNodeId))).length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u76ee\u5f55\u4e0b\u6709\u5b50\u76ee\u5f55\uff0c\u7981\u6b62\u5220\u9664", (String)"CatalogExplorerBasePluginV3_8", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete_card", (IFormPlugin)this);
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664%s\u5417", (String)"CatalogExplorerBasePluginV3_16", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), nodeData.get("name")), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks, null, focusNodeId);
    }

    private DynamicObject[] queryCatalogChildrenById(long id) {
        QFilter filter = new QFilter("parent", "=", (Object)id);
        return BusinessDataServiceHelper.load((String)"iscx_catalog", (String)QUERY_CATALOG_PROPERTIES, (QFilter[])new QFilter[]{filter}, (String)"priority");
    }

    private void openEditCatalog() {
        String focusNodeId = this.getFocusNodeId();
        Map<String, Object> nodeData = this.getNodeData(focusNodeId);
        if ("$root".equals(focusNodeId) || nodeData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u3001\u5220\u9664\u3001\u7f16\u8f91\u9884\u7f6e\u6839\u8282\u70b9", (String)"CatalogExplorerBasePluginV3_18", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", nodeData.get("type"));
        param.put("parent", nodeData.get("parentId"));
        param.put("catalogId", focusNodeId);
        FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_catalog_gen_editor", (String)"", param, (String)"editCatalog");
    }

    private void openNewCatalog() {
        String focusNodeId = this.getFocusNodeId();
        Map<String, Object> nodeData = this.getNodeData(focusNodeId);
        HashMap<String, Object> param = new HashMap<String, Object>();
        if ("$root".equals(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u3001\u5220\u9664\u3001\u7f16\u8f91\u9884\u7f6e\u6839\u8282\u70b9", (String)"CatalogExplorerBasePluginV3_18", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        } else if (nodeData == null) {
            param.put("type", focusNodeId);
            param.put("parent", 0L);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_catalog_gen_editor", (String)"", param, (String)"addCatalog");
        } else {
            CatalogType type = CatalogType.valueOf((String)D.s((Object)nodeData.get("type")));
            if (type.isLeaf()) {
                if (type == CatalogType.Module) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fde\u63a5\u5668\u53ea\u5141\u8bb8\u521b\u5efa\u56db\u7ea7\u76ee\u5f55", (String)"CatalogExplorerBasePluginV3_11", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                } else if (type == CatalogType.Common) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u516c\u5171\u8d44\u6e90\u53ea\u5141\u8bb8\u521b\u5efa\u4e00\u7ea7\u76ee\u5f55", (String)"CatalogExplorerBasePluginV3_12", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                } else if (type == CatalogType.Solution) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u65b9\u6848\u53ea\u5141\u8bb8\u521b\u5efa\u4e09\u7ea7\u76ee\u5f55", (String)"CatalogExplorerBasePluginV3_13", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                }
            } else {
                CatalogType child = this.findChildCatalogType(type);
                param.put("type", child.name());
                param.put("parent", D.l((Object)focusNodeId));
                FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_catalog_gen_editor", (String)"", param, (String)"addCatalog");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("addCatalog".equals(evt.getActionId())) {
            this.treeNodeClick(null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("delete_card".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"iscx_catalog", (Object[])new Object[]{evt.getCustomVaule()}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"CatalogExplorerBasePluginV3_14", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                Map<String, Object> data = this.getNodeData(evt.getCustomVaule());
                TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
                if ("0".equals(D.s((Object)data.get("parentId")))) {
                    tree.focusNode(new TreeNode("", D.s((Object)data.get("type")), ""));
                } else {
                    tree.focusNode(new TreeNode("", D.s((Object)data.get("parentId")), ""));
                }
                this.treeNodeClick(null);
            } else {
                List infos = operationResult.getAllErrorOrValidateInfo();
                StringBuilder description = new StringBuilder();
                for (IOperateInfo info : infos) {
                    description.append('\u3010').append(info.getMessage()).append('\u3011');
                }
                this.getView().showErrorNotification(description.toString());
            }
        }
    }
}

