/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.catalog;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.MenuResourceTypeUtil;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.platform.core.res.CatalogType;

public class CatalogF7SelectFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String PAGE_CACHE_NODES_KEY = "page_cache_nodes_key";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
    }

    private void initTree() {
        CatalogType[] catalogTypeArray;
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.deleteAllNodes();
        tree.setMulti(false);
        TreeNode root = new TreeNode("", "$root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"CatalogF7SelectFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        tree.addNode(root);
        tree.focusNode(root);
        for (CatalogType type : catalogTypeArray = this.getCatalogType()) {
            if (type.parentType() == null) {
                TreeNode node = new TreeNode(root.getId(), type.name(), type.label());
                tree.addNode(node);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("id", type.name());
                data.put("number", type.name());
                data.put("name", type.label());
                data.put("type", type.name());
                data.put("parent", root.getId());
                data.put("long_number", type.name().toUpperCase());
                node.setData(data);
                this.addNodeToCache(node);
                tree.expand(type.name());
            }
            this.addTreeNode(tree, type);
        }
        this.treeNodeClick(null);
    }

    private CatalogType[] getCatalogType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String resType = D.s(customParams.get("resType"));
        String catalog = D.s(customParams.get("catalog"));
        if (!StringUtil.isEmpty((String)resType)) {
            return MenuResourceTypeUtil.getMenuForCatalogType(resType, null);
        }
        if (StringUtil.isEmpty((String)resType) && !StringUtil.isEmpty((String)catalog)) {
            ArrayList<CatalogType> types = new ArrayList<CatalogType>();
            this.findLeafPath(types, CatalogType.valueOf((String)catalog));
            CatalogType[] tsArray = new CatalogType[types.size()];
            return types.toArray(tsArray);
        }
        return CatalogType.values();
    }

    private void findLeafPath(List<CatalogType> types, CatalogType type) {
        if (type.isLeaf()) {
            types.add(type);
            return;
        }
        for (CatalogType t : CatalogType.values()) {
            if (t.parentType() != type) continue;
            types.add(t);
            this.findLeafPath(types, t);
        }
    }

    private void addTreeNode(TreeView tree, CatalogType type) {
        DynamicObject[] catalogs;
        QFilter qFilter = this.buildFilter(type);
        for (DynamicObject c : catalogs = BusinessDataServiceHelper.load((String)"iscx_catalog", (String)"id, number, name, type, parent, long_number", (QFilter[])new QFilter[]{qFilter}, (String)"priority")) {
            String parentId = "";
            parentId = "0".equals(c.getString("parent_id")) ? type.name() : c.getString("parent_id");
            String id = D.s((Object)c.getPkValue());
            TreeNode node = new TreeNode(parentId, id, c.getString("name"));
            tree.addNode(node);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", id);
            data.put("number", c.getString("number"));
            data.put("name", c.getString("name"));
            data.put("type", c.getString("type"));
            data.put("parent", c.getLong("parent_id") == 0L ? c.getString("type") : c.getString("parent_id"));
            data.put("long_number", c.getString("long_number"));
            node.setData(data);
            this.addNodeToCache(node);
        }
    }

    private QFilter buildFilter(CatalogType type) {
        QFilter qFilter = new QFilter("type", "=", (Object)type.name());
        String longNumberFilter = D.s((Object)this.getView().getFormShowParameter().getCustomParam("long_number_filter"));
        if (longNumberFilter != null) {
            qFilter = new QFilter("long_number", "like", (Object)longNumberFilter);
        }
        return qFilter;
    }

    private void addNodeToCache(TreeNode node) {
        Map nodes = null;
        String pagecache = this.getPageCache().get(PAGE_CACHE_NODES_KEY);
        nodes = StringUtil.isEmpty((String)pagecache) ? new LinkedHashMap() : (Map)Json.toObject((String)pagecache);
        nodes.put(node.getId(), node.getData());
        this.getPageCache().put(PAGE_CACHE_NODES_KEY, Json.toString(nodes));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        DynamicObjectCollection entryentity;
        String focusNodeId = this.getFocusNodeId();
        Map<String, Object> focusData = this.takeTreeNodeData(focusNodeId);
        List<Map<String, Object>> leaves = "$root".equals(focusNodeId) ? this.takeChildrenLeavesByLongNumber(null) : this.takeChildrenLeavesByLongNumber(D.s((Object)focusData.get("long_number")));
        if (leaves.isEmpty() && focusData != null) {
            entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            entryentity.clear();
            if (CatalogType.valueOf((String)D.s((Object)focusData.get("type"))).isLeaf()) {
                this.addNewEntry(entryentity, focusData);
            }
        } else {
            entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            entryentity.clear();
            for (Map<String, Object> data : leaves) {
                this.addNewEntry(entryentity, data);
            }
        }
        this.getView().updateView("entryentity");
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.expand(focusNodeId);
    }

    private void addNewEntry(DynamicObjectCollection entryentity, Map<String, Object> data) {
        DynamicObject entry = entryentity.addNew();
        entry.set("id", data.get("id"));
        entry.set("name", data.get("name"));
        entry.set("number", data.get("number"));
        entry.set("type", data.get("type"));
        List<String> paths = ResourceEditorUtil.getCatalogPathByLongNumber(D.s((Object)data.get("long_number")));
        StringBuilder path = new StringBuilder();
        for (String p : paths) {
            path.append(p).append(" / ");
        }
        entry.set("path", (Object)path.substring(0, path.length() - 3));
    }

    private Map<String, Object> takeTreeNodeData(String nodeid) {
        String json = this.getView().getPageCache().get(PAGE_CACHE_NODES_KEY);
        if (!StringUtil.isEmpty((String)json)) {
            Map map = (Map)Json.toObject((String)json);
            return (Map)map.get(nodeid);
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u8d44\u6e90\u76ee\u5f55\u6570\u636e\uff0c\u8bf7\u5148\u7ef4\u62a4\u8d44\u6e90\u76ee\u5f55", (String)"CatalogF7SelectFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
    }

    private List<Map<String, Object>> takeChildrenLeavesByLongNumber(String longNumber) {
        String json = this.getView().getPageCache().get(PAGE_CACHE_NODES_KEY);
        LinkedList<Map<String, Object>> nodes = new LinkedList<Map<String, Object>>();
        if (!StringUtil.isEmpty((String)json)) {
            Map map = (Map)Json.toObject((String)json);
            for (Map.Entry entry : map.entrySet()) {
                Map data = (Map)entry.getValue();
                if (longNumber == null && CatalogType.valueOf((String)D.s(data.get("type"))).isLeaf()) {
                    nodes.add(data);
                    continue;
                }
                if (!CatalogType.valueOf((String)D.s(data.get("type"))).isLeaf() || !D.s(data.get("long_number")).startsWith(longNumber)) continue;
                nodes.add(data);
            }
            return nodes;
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u8d44\u6e90\u76ee\u5f55\u6570\u636e\uff0c\u8bf7\u5148\u7ef4\u62a4\u8d44\u6e90\u76ee\u5f55", (String)"CatalogF7SelectFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
    }

    private String getFocusNodeId() {
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        return tree.getTreeState().getFocusNodeId();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("save")) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = grid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761[\u516c\u5171\u8d44\u6e90/\u6a21\u5757/\u89e3\u51b3\u65b9\u6848]\u6570\u636e", (String)"CatalogF7SelectFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            DynamicObject select = (DynamicObject)entry.get(selectRows[0]);
            if (select.getString("id").equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7c7b\u578b\u662f[\u516c\u5171\u8d44\u6e90/\u6a21\u5757/\u89e3\u51b3\u65b9\u6848]\u7684\u6570\u636e", (String)"CatalogF7SelectFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            Map<String, Object> data = this.takeTreeNodeData(select.getString("id"));
            if (CatalogType.valueOf((String)D.s((Object)data.get("type"))).isLeaf()) {
                this.getView().returnDataToParent(data);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7c7b\u578b\u662f[\u516c\u5171\u8d44\u6e90/\u6a21\u5757/\u89e3\u51b3\u65b9\u6848]\u7684\u6570\u636e", (String)"CatalogF7SelectFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

