/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.catalog;

import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.CatalogType;
import kd.isc.iscx.platform.core.res.CatalogUtil;

public class CatalogGeneralEditorFormPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Image icon = (Image)this.getControl("icon");
        icon.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Image icon = (Image)this.getControl("icon");
        String url = UrlService.getDomainContextUrl().replace("localhost", NetUtil.getLocalAddress()) + "/kingdee/isc/";
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        CatalogType type = CatalogType.valueOf((String)D.s(customParams.get("type")));
        String typeLabel = type == CatalogType.Industry ? ResManager.loadKDString((String)"\u884c\u4e1a", (String)"CatalogGeneralEditorFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]) : CatalogType.valueOf((String)D.s(customParams.get("type"))).label();
        if (customParams.containsKey("catalogId")) {
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u7f16\u8f91\u76ee\u5f55", (String)"CatalogGeneralEditorFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0])));
            DynamicObject catalog = BusinessDataServiceHelper.loadSingle(customParams.get("catalogId"), (String)"iscx_catalog");
            String icon_url = StringUtil.isEmpty((String)catalog.getString("icon_url")) ? CatalogUtil.getDefaultLogo((String)catalog.getString("type")) : catalog.getString("icon_url");
            icon.setUrl(url + icon_url);
            this.getModel().setValue("icon_url", (Object)catalog.getString("icon_url"));
            this.getModel().setValue("name", catalog.get("name"));
            this.getModel().setValue("priority", catalog.get("priority"));
            this.getModel().setValue("remark", catalog.get("remark"));
            this.getModel().setValue("type", (Object)typeLabel);
            this.getView().setEnable(Boolean.FALSE, new String[]{"name", "type"});
        } else {
            String icon_url = CatalogUtil.getDefaultLogo((String)D.s(customParams.get("type")));
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u65b0\u589e\u76ee\u5f55", (String)"CatalogGeneralEditorFormPlugin_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0])));
            icon.setUrl(url + icon_url);
            this.getModel().setValue("icon_url", (Object)icon_url);
            this.getModel().setValue("type", (Object)typeLabel);
            this.getView().setEnable(Boolean.FALSE, new String[]{"type"});
            if (0L == D.l(customParams.get("parent"))) {
                QFilter filter = new QFilter("type", "=", (Object)D.s(customParams.get("type")));
                DynamicObject[] brothers = BusinessDataServiceHelper.load((String)"iscx_catalog", (String)"id", (QFilter[])new QFilter[]{filter});
                this.getModel().setValue("priority", (Object)(brothers.length + 1));
            } else {
                QFilter filter = new QFilter("parent", "=", customParams.get("parent"));
                DynamicObject[] brothers = BusinessDataServiceHelper.load((String)"iscx_catalog", (String)"id", (QFilter[])new QFilter[]{filter});
                this.getModel().setValue("priority", (Object)(brothers.length + 1));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equals(operationKey)) {
            Map customParams;
            if (StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue("name")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0", (String)"CatalogGeneralEditorFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ((customParams = this.getView().getFormShowParameter().getCustomParams()).containsKey("catalogId")) {
                this.checkEditPermission(args);
            } else {
                this.checkNewPermission(args);
            }
        }
    }

    private void checkNewPermission(BeforeDoOperationEventArgs args) {
        boolean permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"2SLS+84NGM=B", (String)"iscx_catalog", (String)"47156aff000000ac");
        if (!permission) {
            String s = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8d44\u6e90\u76ee\u5f55\u7684\u65b0\u589e\u6743\u9650", (String)"CatalogGeneralEditorFormPlugin_7", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(s);
            args.setCancel(true);
        }
    }

    private void checkEditPermission(BeforeDoOperationEventArgs args) {
        boolean permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"2SLS+84NGM=B", (String)"iscx_catalog", (String)"4715a0df000000ac");
        if (!permission) {
            String s = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8d44\u6e90\u76ee\u5f55\u7684\u4fee\u6539\u6743\u9650", (String)"CatalogGeneralEditorFormPlugin_8", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(s);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        if ("save".equals(key)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            DynamicObject catalog = null;
            if (customParams.containsKey("catalogId")) {
                catalog = BusinessDataServiceHelper.loadSingle(customParams.get("catalogId"), (String)"iscx_catalog");
                catalog = this.setCatalog(customParams, catalog);
            } else {
                catalog = BusinessDataServiceHelper.newDynamicObject((String)"iscx_catalog");
                String longNumber = CatalogUtil.generateLongNumber((DynamicObject)(catalog = this.setCatalog(customParams, catalog)));
                if (QueryServiceHelper.exists((String)"iscx_catalog", (Object)CatalogUtil.generateCatalogId((String)longNumber))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u76ee\u5f55", (String)"CatalogGeneralEditorFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            OperationResult result = SaveServiceHelper.saveOperate((String)"iscx_catalog", (DynamicObject[])new DynamicObject[]{catalog}, (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                this.getView().showErrorNotification(result.getMessage());
            } else {
                this.getView().invokeOperation("close");
            }
        }
    }

    public DynamicObject setCatalog(Map<String, Object> customParams, DynamicObject catalog) {
        catalog.set("name", this.getModel().getValue("name"));
        String type = D.s((Object)customParams.get("type"));
        catalog.set("type", customParams.get("type"));
        catalog.set("remark", this.getModel().getValue("remark"));
        catalog.set("priority", this.getModel().getValue("priority"));
        catalog.set("icon_url", this.getModel().getValue("icon_url"));
        if (CatalogType.valueOf((String)type).parentType() != null) {
            DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)customParams.get("parent"), (String)"iscx_catalog");
            catalog.set("parent", (Object)parent);
        }
        return catalog;
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
    }
}

