/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.home;

import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class BoardPlugin
extends AbstractFormPlugin {
    private static final int DAY = 8;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        PointLineChart pointLineChart = (PointLineChart)this.getControl("pointlinechartap");
        Axis yAxis = pointLineChart.createYAxis(ResManager.loadKDString((String)"\u4efb\u52a1\u6570(\u4e2a)", (String)"BoardPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), AxisType.value);
        Axis xAxis = pointLineChart.createXAxis("", AxisType.category);
        this.setXAxisCategoryByDay(xAxis);
        LineSeries totalSeries = pointLineChart.createSeries(ResManager.loadKDString((String)"\u603b\u4efb\u52a1\u6570", (String)"BoardPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        LineSeries successSeries = pointLineChart.createSeries(ResManager.loadKDString((String)"\u6210\u529f\u6570", (String)"BoardPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        LineSeries failSeries = pointLineChart.createSeries(ResManager.loadKDString((String)"\u5931\u8d25\u6570", (String)"BoardPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        this.setSeriesColor((Series)failSeries, "#fb2323");
        List<Object> totalNums = this.getNumsByDay(null);
        totalSeries.setPropValue("data", totalNums);
        List<Object> successNums = this.getNumsByDay("S");
        successSeries.setPropValue("data", successNums);
        List<Object> failNums = this.getNumsByDay("F");
        failSeries.setPropValue("data", failNums);
        long max = this.getMax(totalNums);
        if (max < 4L) {
            yAxis.setInterval((Number)1);
        } else {
            yAxis.setInterval((Number)(max / 4L));
        }
        HashMap<String, int[]> yaMap = new HashMap<String, int[]>(1);
        int[] xa = new int[]{0, 0, 20, 20};
        yaMap.put("padding", xa);
        yAxis.setPropValue("nameTextStyle", yaMap);
        pointLineChart.setLegendAlign(XAlign.right, YAlign.top);
        pointLineChart.setShowTooltip(true);
        pointLineChart.setMargin(Position.left, "70px");
        pointLineChart.refresh();
    }

    private long getMax(List<Object> list) {
        long max = 0L;
        for (Object l : list) {
            max = Long.max(max, D.l((Object)l));
        }
        return max;
    }

    private void setSeriesColor(Series dataSeries, String color) {
        Map<String, Object> dataStyle = this.setColorStyle(color);
        dataSeries.setPropValue("itemStyle", dataStyle);
        ArrayList<String> list = new ArrayList<String>(3);
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        dataSeries.addFuncPath(list);
    }

    private Map<String, Object> setColorStyle(String color) {
        HashMap<String, Object> itemStyle = new HashMap<String, Object>(1);
        HashMap<String, String> normal = new HashMap<String, String>(1);
        normal.put("color", color);
        itemStyle.put("normal", normal);
        return itemStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> getNumsByDay(String state) {
        StringBuilder sql = new StringBuilder("select count(1) from t_iscx_datax_stream where fcreatetime >= ? and fcreatetime < ?");
        if ("S".equals(state)) {
            sql.append(" and fstate = ?");
        } else if ("F".equals(state)) {
            sql.append(" and fstate = ?");
        }
        Date initTime = this.getInitTime();
        ArrayList<Object> valuesDay = new ArrayList<Object>(2);
        ArrayList<Integer> typesDay = new ArrayList<Integer>(2);
        typesDay.add(93);
        typesDay.add(93);
        if (state != null) {
            typesDay.add(12);
        }
        ArrayList<Object> nums = new ArrayList<Object>(8);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            for (int i = 8; i > 0; --i) {
                valuesDay.clear();
                long initTimeTime = initTime.getTime();
                Timestamp startDate = D.t((Object)(initTimeTime - (long)(i - 1) * 86400000L));
                Timestamp endDate = D.t((Object)(initTimeTime - (long)(i - 2) * 86400000L));
                valuesDay.add(startDate);
                valuesDay.add(endDate);
                if (state != null) {
                    valuesDay.add(state);
                }
                long count = D.l((Object)DbUtil.executeScalar((Connection)cn, (String)sql.toString(), valuesDay, typesDay));
                nums.add(count);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        return nums;
    }

    private void setXAxisCategoryByDay(Axis xAxis) {
        this.setXAxisStyle(xAxis);
        Date initTime = this.getInitTime();
        ArrayList<String> data = new ArrayList<String>(8);
        for (int i = 8; i > 0; --i) {
            Date date = new Date(initTime.getTime() - (long)(i - 1) * 86400000L);
            SimpleDateFormat sdf = new SimpleDateFormat("MM.dd");
            data.add(D.s((Object)sdf.format(date)));
        }
        xAxis.setCategorys(data);
    }

    private Date getInitTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    private void setXAxisStyle(Axis xAxis) {
        xAxis.setPosition(Position.bottom);
        HashMap<String, int[]> xaMap = new HashMap<String, int[]>(1);
        int[] xa = new int[]{0, 0, -25, -35};
        xaMap.put("padding", xa);
        xAxis.setPropValue("nameGap", (Object)"5");
        xAxis.setPropValue("nameTextStyle", xaMap);
        HashMap<String, Object> axisPointer = new HashMap<String, Object>();
        HashMap<String, String> shadowStyle = new HashMap<String, String>();
        axisPointer.put("show", Boolean.TRUE);
        axisPointer.put("type", "shadow");
        shadowStyle.put("color", "rgba(150,150,150,0.3)");
        axisPointer.put("shadowStyle", shadowStyle);
        xAxis.setPropValue("axisPointer", axisPointer);
    }
}

