/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.catalog.CatalogF7SelectListener;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.MenuResourceTypeUtil;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.platform.core.res.CatalogType;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ResEditorUtil;

public abstract class AbstractResourceEditorFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        CatalogF7SelectListener listener = new CatalogF7SelectListener(this, this.getResourceType());
        BasedataEdit f7 = (BasedataEdit)this.getView().getControl("catalog");
        if (f7 != null) {
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)listener);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map data;
        super.closedCallBack(e);
        String action = e.getActionId();
        if ("catalog_select".equals(action) && (data = (Map)e.getReturnData()) != null) {
            this.getModel().setValue("catalog", data.get("id"));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (D.x(this.getView().getFormShowParameter().getCustomParams().get("IsByImport_addNew"))) {
            Object importMeta_details = this.getView().getFormShowParameter().getCustomParams().get("importMeta_details");
            this.getView().setStatus(OperationStatus.ADDNEW);
            this.getModel().setValue("catalog", this.getResourceCatalog());
            this.bindResourceDetails((Map)importMeta_details, EditorMode.NEW);
            return;
        }
        long id = this.getResourceId();
        if (id == 0L) {
            this.getView().setStatus(OperationStatus.ADDNEW);
            this.getModel().setValue("catalog", this.getResourceCatalog());
            this.bindResourceDetails(Collections.emptyMap(), EditorMode.NEW);
        } else {
            boolean isCopy = this.isCopy();
            DynamicObject res = this.getRuntimeResource(id, isCopy);
            this.getModel().setValue("number", res.get("number"));
            this.getModel().setValue("name", this.getResourceName(res));
            this.getModel().setValue("catalog", res.get("catalog"));
            this.getModel().setValue("remark", res.get("remark"));
            if (isCopy) {
                this.bindResourceInCopyAddMode(res);
            } else if (this.isHistory()) {
                this.bindResourceDetails((Map)this.getView().getFormShowParameter().getCustomParam("details"), EditorMode.VIEW);
            } else {
                this.bindResourceInViewOrEditMode(res);
            }
        }
    }

    private Map<String, Object> getResourceName(DynamicObject res) {
        String lang;
        Map name = (Map)res.get("name");
        if (name.get(lang = Lang.get().name()) == null) {
            name.put(lang, name.get("GLang"));
        }
        return name;
    }

    private void bindResourceInCopyAddMode(DynamicObject res) {
        this.getView().setStatus(OperationStatus.ADDNEW);
        long referId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        this.getView().getFormShowParameter().setCustomParam("id", (Object)0);
        this.getView().getFormShowParameter().setCustomParam("referId", (Object)referId);
        this.getView().cacheFormShowParameter();
        this.bindResourceDetails(ResourceUtil.getMergedDetails((DynamicObject)res), EditorMode.NEW);
    }

    private DynamicObject getRuntimeResource(long id, boolean isCopy) {
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_resource_rtm");
        if (isCopy) {
            res = this.cloneRes(res);
        }
        return res;
    }

    private void bindResourceInViewOrEditMode(DynamicObject res) {
        boolean readOnly = this.isReadOnly();
        if (readOnly) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().cacheFormShowParameter();
        } else {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().cacheFormShowParameter();
        }
        if (readOnly) {
            this.bindResourceDetails(ResourceUtil.getMergedDetails((DynamicObject)res), EditorMode.VIEW);
        } else if (ResourceEditorUtil.isUpdatable(res)) {
            this.lockModel();
            this.bindResourceDetails(ResourceUtil.getMergedDetails((DynamicObject)res), EditorMode.UPDATE);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name", "remark"});
            this.bindResourceDetails(ResourceUtil.getMergedDetails((DynamicObject)res), EditorMode.EXTENDS);
        }
    }

    private DynamicObject cloneRes(DynamicObject res) {
        DynamicObject copyOne = BusinessDataServiceHelper.newDynamicObject((String)"iscx_resource_rtm");
        DataEntityPropertyCollection properties = res.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            if ("id".equals(propertyName)) continue;
            if ("number".equals(propertyName)) {
                copyOne.set("number", (Object)"");
                continue;
            }
            if ("name".equals(propertyName)) {
                copyOne.set("name", (Object)String.format(ResManager.loadKDString((String)"%s\uff08\u590d\u5236\uff09", (String)"AbstractResourceEditorFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), this.getResourceName(res)));
                continue;
            }
            copyOne.set(propertyName, res.get(propertyName));
        }
        return copyOne;
    }

    public boolean isHistory() {
        return D.x((Object)this.getView().getFormShowParameter().getCustomParam("isHistory"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("name".equals(e.getProperty().getName()) && !this.getResourceType().startsWith("DataModel.")) {
            this.generateNumber();
        }
    }

    protected void generateNumber() {
        IDataModel m = this.getModel();
        if (D.s((Object)m.getValue("number")) == null) {
            Object name = m.getValue("name");
            String number = ResourceUtil.genateNumber((Object)name);
            m.setValue("number", (Object)number);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            this.save();
            if (this.isAutoClosed()) {
                this.getView().close();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if (this.isUsedInTrigger() && ("modify".equalsIgnoreCase(operationKey) || "saveDiagram".equalsIgnoreCase(operationKey)) && !this.ifAllTriggerDisabled()) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(operationKey);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u8d44\u6e90\u5b58\u5728\u542f\u7528\u7684\u542f\u52a8\u65b9\u6848\uff0c\u65e0\u6cd5\u4fee\u6539\u4e0e\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\u5168\u90e8\u5173\u8054\u7684\u542f\u52a8\u65b9\u6848\uff1f", (String)"AbstractResourceEditorFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String action = evt.getCallBackId();
        if ("modify".equalsIgnoreCase(action) || "saveDiagram".equalsIgnoreCase(action)) {
            try {
                DynamicObject[] allEnabledTriggers;
                for (DynamicObject enabledTrigger : allEnabledTriggers = this.getAllEnabledTriggers()) {
                    ConnectorUtil.disable((DynamicObject)enabledTrigger);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f", (String)"AbstractResourceEditorFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation(action);
            }
            catch (Throwable e) {
                FormOpener.showErrorMessage((IFormView)this.getView(), (String)StringUtil.getCascadeMessage((Throwable)e), (String)StringUtil.toString((Throwable)e));
            }
        }
    }

    private boolean ifAllTriggerDisabled() {
        DynamicObject[] objects = this.getAllEnabledTriggers();
        return objects.length == 0;
    }

    private DynamicObject[] getAllEnabledTriggers() {
        QFilter qFilter = new QFilter(this.getUsedField(), "=", (Object)this.getResourceId());
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        return BusinessDataServiceHelper.load((String)"iscx_data_flow_trigger", (String)"id,enable", (QFilter[])new QFilter[]{qFilter});
    }

    protected boolean isUsedInTrigger() {
        return false;
    }

    protected String getUsedField() {
        return null;
    }

    protected boolean isAutoClosed() {
        return true;
    }

    protected long save() {
        long id = this.saveResource();
        HashMap<String, Number> result = new HashMap<String, Number>();
        result.put("id", id);
        result.put("saveSuccess", 1);
        this.getView().returnDataToParent(result);
        return id;
    }

    protected long saveResource() {
        long id = this.getResourceId();
        if (id == 0L) {
            return this.createResource();
        }
        this.modifyResource();
        return id;
    }

    protected boolean isCopy() {
        return D.x((Object)this.getView().getFormShowParameter().getCustomParam("is_copy"));
    }

    private void modifyResource() {
        long id = this.getResourceId();
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_resource");
        if (ResourceEditorUtil.isUpdatable(res)) {
            this.updateResource(res);
        } else {
            this.extendsResource(res);
        }
    }

    private void extendsResource(DynamicObject res) {
        DynamicObject ext = BusinessDataServiceHelper.loadSingle((Object)res.get("id"), (String)"iscx_resource_ext");
        if (!ResourceEditorUtil.isExtensible(ext)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u662f\u5728\u73af\u5883\uff08%s\uff09\u4e2d\u6269\u5c55\u7684\uff0c\u5728\u5f53\u524d\u73af\u5883\u4e0d\u5141\u8bb8\u4fee\u6539/\u6269\u5c55\u3002", (String)"AbstractResourceEditorFormPlugin_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), ext.get("ext_tenant")));
        }
        Map<String, Object> details = this.collectResourceDetails();
        Map originalDetails = (Map)Json.toObject((String)((String)res.get("details_tag")));
        ResourceEditorUtil.extendsResource(ext, details, originalDetails);
    }

    private void updateResource(DynamicObject obj) {
        IDataModel m = this.getModel();
        String number = D.s((Object)m.getValue("number"));
        Map name = (Map)m.getValue("name");
        String remark = D.s((Object)m.getValue("remark"));
        DynamicObject catalog = (DynamicObject)m.getValue("catalog");
        Map<String, Object> details = this.collectResourceDetails();
        ResourceEditorUtil.updateResource(obj, number, name, remark, catalog, details);
    }

    private long createResource() {
        IDataModel m = this.getModel();
        String number = D.s((Object)m.getValue("number"));
        Map name = (Map)m.getValue("name");
        String remark = D.s((Object)m.getValue("remark"));
        String type = this.getResourceType();
        DynamicObject catalog = (DynamicObject)m.getValue("catalog");
        Map<String, Object> details = this.collectResourceDetails();
        HashMap params = new HashMap(1);
        FormOpener.buildOpenFormParam((IFormView)this.getView(), params, (String[])new String[]{"source_app"});
        return ResEditorUtil.createResourceWithParam((String)type, (String)number, (Map)name, (String)remark, (DynamicObject)catalog, details, params);
    }

    protected long getResourceId() {
        long idFromParentView = D.l((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        if (idFromParentView > 0L) {
            return idFromParentView;
        }
        return D.l((Object)this.getView().getPageCache().get("df_res_id"));
    }

    protected Object getResourceCatalog() {
        CatalogType[] catalogType;
        long catalogId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("catalog"));
        if (catalogId == 0L) {
            return catalogId;
        }
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)catalogId, (String)"iscx_catalog", (String)"type");
        for (CatalogType t : catalogType = MenuResourceTypeUtil.getMenuForCatalogType(this.getResourceType(), null)) {
            if (!t.name().equals(catalog.getString("type"))) continue;
            return catalogId;
        }
        return 0L;
    }

    protected final boolean isReadOnly() {
        return D.x((Object)this.getView().getFormShowParameter().getCustomParam("readOnly"));
    }

    protected abstract String getResourceType();

    protected abstract void bindResourceDetails(Map<String, Object> var1, EditorMode var2);

    protected abstract Map<String, Object> collectResourceDetails();

    protected void lockModel() {
    }
}

