/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res;

import java.sql.Connection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;

public class IconSelectorFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
SearchEnterListener {
    private static final String BILLLISTAP = "billlistap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String GROUP = "group";
    private static final String GROUP_NAME = "group_name";
    private static final String LOGO = "icon_url";
    private static final String LOCALHOST = "localhost";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
            Search search = (Search)this.getControl("searchap");
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void search(SearchEnterEvent evt) {
        BillList iconList = this.iconListAfterSearchFilter(evt);
        this.refreshIconList(iconList);
        this.setDefaultGroup();
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if ("ok".equals(eventArgs.getOperateKey())) {
            BillList iconList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedIcon = iconList.getSelectedRows();
            if (selectedIcon.size() == 1) {
                long pk = D.l((Object)selectedIcon.get(0).getPrimaryKeyValue());
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"iscx_icon_repository");
                HashMap<String, Object> returns = new HashMap<String, Object>(1);
                returns.put(LOGO, obj.get(LOGO));
                this.getView().returnDataToParent(returns);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u56fe\u6807\u3002", (String)"IconSelectorFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setDefaultGroup() {
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY);
        cardEntry.selectRows(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataRow> queryResType() {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true);
        String sql = "SELECT DISTINCT FGROUP FROM T_ISCX_ICON_REPOSITORY";
        try {
            List list = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            return list;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)new iconDataProvider());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initIconGroup();
    }

    private void initIconGroup() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRYENTITY);
        entry.clear();
        DynamicObject obj = entry.addNew();
        obj.set(GROUP_NAME, (Object)ResManager.loadKDString((String)"\u5168\u90e8", (String)"IconSelectorFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        obj.set("group_code", (Object)"ALL");
        for (DataRow dataRow : this.queryResType()) {
            obj = entry.addNew();
            String value = D.s((Object)dataRow.getValue(0));
            obj.set(GROUP_NAME, (Object)value);
            obj.set("group_code", (Object)value);
        }
        this.getView().updateView(ENTRYENTITY);
        this.setDefaultGroup();
    }

    private BillList iconListAfterSearchFilter(SearchEnterEvent evt) {
        String searchText = evt.getText();
        BillList iconList = (BillList)this.getControl(BILLLISTAP);
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            iconList.getFilterParameter().setFilter(new QFilter("name", "ilike", (Object)("%" + searchText + "%")));
        }
        return iconList;
    }

    private BillList iconListAfterGroupFilter(HyperLinkClickEvent evt) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        String groupName = ((DynamicObject)collection.get(evt.getRowIndex())).getString("group_code");
        QFilter filter = "ALL".equals(groupName) ? null : new QFilter(GROUP, "=", (Object)groupName);
        BillList iconList = (BillList)this.getControl(BILLLISTAP);
        iconList.getFilterParameter().setFilter(filter);
        return iconList;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt.getRowIndex() >= 0) {
            BillList billList = this.iconListAfterGroupFilter(evt);
            this.refreshIconList(billList);
        }
    }

    private void refreshIconList(BillList billList) {
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)new iconDataProvider());
        this.getView().updateView(BILLLISTAP);
    }

    static class iconDataProvider
    extends ListDataProvider
    implements CreateListDataProviderListener {
        iconDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty() || !((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)IconSelectorFormPlugin.LOGO)) {
                return rows;
            }
            this.setIconUrl(rows);
            return rows;
        }

        private void setIconUrl(DynamicObjectCollection rows) {
            String url = UrlService.getDomainContextUrl().replace(IconSelectorFormPlugin.LOCALHOST, NetUtil.getLocalAddress());
            for (DynamicObject row : rows) {
                row.set(IconSelectorFormPlugin.LOGO, (Object)(url + "/kingdee/isc/icons/" + D.s((Object)row.get(IconSelectorFormPlugin.LOGO))));
            }
        }

        public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
            args.setListDataProvider((IListDataProvider)this);
        }
    }
}

