/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.formplugin.catalog.CatalogF7SelectListener;
import kd.isc.iscx.formplugin.res.dm.FormUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ImportMetaToIscxResourceUtil;

public class ImportMetaToIscxResource
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        CatalogF7SelectListener listener = new CatalogF7SelectListener(this, "DataModel.Entity");
        BasedataEdit f7 = (BasedataEdit)this.getView().getControl("catalog");
        if (f7 != null) {
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)listener);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map data;
        super.closedCallBack(e);
        String action = e.getActionId();
        if ("catalog_select".equals(action) && (data = (Map)e.getReturnData()) != null) {
            this.getModel().setValue("catalog", data.get("id"));
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject catalog;
        super.afterBindData(e);
        long catalog_id = D.l((Object)this.getView().getFormShowParameter().getCustomParam("catalog"));
        if (catalog_id > 0L && (catalog = BusinessDataServiceHelper.loadSingle((Object)catalog_id, (String)"iscx_catalog")) != null) {
            this.getModel().setValue("catalog", (Object)catalog);
            this.getView().updateView("flex_sys");
        }
        FormUtil.setCatalogDisplayName(this.getView(), this.getModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "btnok".equals((oper = (AbstractOperate)args.getSource()).getOperateKey())) {
            Object importMetadataPK = this.getModel().getValue("import_metadata_id");
            Object catalogPK = this.getModel().getValue("catalog_id");
            if (this.isNotfilled(importMetadataPK) || this.isNotfilled(catalogPK)) {
                String msg = this.getShowMsg();
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                return;
            }
            long catalog_id = D.l((Object)this.getModel().getValue("catalog_id"));
            Map map = ImportMetaToIscxResourceUtil.getImportModal((Object)importMetadataPK, (long)catalog_id);
            if (map.get("obj") != null) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("update_model", (IFormPlugin)this);
                this.getView().showConfirm(D.s(map.get("tips")), MessageBoxOptions.YesNo, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }

    private String getShowMsg() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String catalog_alias = D.s(customParams.get("catalog_alias"));
        if (catalog_alias != null) {
            return String.format(ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9%s\u53ca\u6240\u5bfc\u5165\u96c6\u6210\u5bf9\u8c61\u3002", (String)"ImportMetaToIscxResource_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), catalog_alias);
        }
        return ResManager.loadKDString((String)"\u5fc5\u586b\u9879\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6a21\u5757\u53ca\u6240\u5bfc\u5165\u96c6\u6210\u5bf9\u8c61\u3002", (String)"ImportMetaToIscxResource_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult() && StringUtils.equals((CharSequence)evt.getCallBackId(), (CharSequence)"update_model")) {
            try {
                Object importMetadataPK = this.getModel().getValue("import_metadata_id");
                long catalog_id = D.l((Object)this.getModel().getValue("catalog_id"));
                Map params = ImportMetaToIscxResourceUtil.getImportUpdateParams((Object)importMetadataPK, (Long)catalog_id);
                this.getView().returnDataToParent((Object)params);
                this.getView().close();
            }
            catch (Exception e) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a%s", (String)"ImportMetaToIscxResource_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), e.getMessage()), Integer.valueOf(5000));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        AbstractOperate operation;
        String operateKey;
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate && "btnok".equals(operateKey = (operation = (AbstractOperate)source).getOperateKey())) {
            try {
                Object importMetadataPK = this.getModel().getValue("import_metadata_id");
                long catalog_id = D.l((Object)this.getModel().getValue("catalog_id"));
                Map params = ImportMetaToIscxResourceUtil.getAddNewParams((Object)importMetadataPK, (Long)catalog_id);
                FormOpener.buildOpenFormParam((IFormView)this.getView(), (Map)params, (String[])new String[]{"source_app"});
                this.getView().returnDataToParent((Object)params);
                this.getView().close();
            }
            catch (Exception e) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a%s", (String)"ImportMetaToIscxResource_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), e.getMessage()), Integer.valueOf(5000));
            }
        }
    }

    private boolean isNotfilled(Object importMetadataPK) {
        return importMetadataPK == null || 0 == D.i((Object)importMetadataPK);
    }
}

