/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class JsonImportFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"upload"});
        this.addClickListeners(new String[]{"buttonap"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        ArrayList<String> fileUrls = new ArrayList<String>(1);
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        try {
            String jsonEditer = this.getJsonData((String)fileUrls.get(0));
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl("codeeditap");
            codeEdit.setText(jsonEditer);
        }
        catch (IOException e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (String)String.format(ResManager.loadKDString((String)"\u65b9\u6848\u4eceredis\u7f13\u5b58%s\u4e2d\u4e0b\u8f7d\u5931\u8d25\uff0c\u65e0\u6cd5\u5bfc\u5165\uff01", (String)"JsonImportFormPlugin_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), fileUrls.get(0)), (String)ShowStackTraceUtil.getErrorMsg((Throwable)e));
        }
    }

    private String getJsonData(String fileUrl) throws IOException {
        return this.getData(fileUrl);
    }

    private String getData(String fileUrl) throws IOException {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String[] queryParams = new URL(fileUrl).getQuery().split("&");
        HashMap<String, String> downloadFileParams = new HashMap<String, String>(2);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        return NetUtil.readText((InputStream)content.getInputStream());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "buttonap".equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("ok", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bfc\u5165\u7684Json\u6587\u4ef6\u5c06\u8986\u76d6\u539f\u914d\u7f6e\u8be6\u60c5\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"JsonImportFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() == MessageBoxResult.Yes) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        Map returns = this.getView().getFormShowParameter().getCustomParams();
        CodeEdit control = (CodeEdit)this.getView().getControl("codeeditap");
        String jsonStr = D.s((Object)control.getText());
        if (StringUtil.isEmpty((String)jsonStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165json\u6570\u636e", (String)"JsonImportFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            List<Map<String, Object>> fields = this.formatJsonData((Map)Script.parseJson((String)jsonStr));
            returns.put("jsonTag", fields);
            this.getView().returnDataToParent((Object)returns);
            this.getView().close();
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u89e3\u6790json\u5185\u5bb9\u51fa\u9519\uff0c\u8bf7\u6821\u9a8c\uff01", (String)"JsonImportFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), (String)ShowStackTraceUtil.getErrorMsg((Throwable)e));
        }
    }

    private List<Map<String, Object>> formatJsonData(Map<String, Object> jsonDataMap) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>(jsonDataMap.size());
        for (Map.Entry<String, Object> entry : jsonDataMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            HashMap<String, Object> details = new HashMap<String, Object>();
            details.put("id", IDService.get().genLongId());
            details.put("field", key);
            details.put("label", key);
            this.setTypeAndFields(value, details);
            fields.add(details);
        }
        return fields;
    }

    private void setTypeAndFields(Object value, Map<String, Object> details) {
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                Object o = list.get(0);
                details.put("is_multiple", Boolean.TRUE);
                if (o instanceof Map) {
                    details.put("data_type", "STRUCT");
                    details.put("fields", this.formatJsonData((Map)o));
                } else {
                    this.setSimpleValueType(o, details);
                }
            }
        } else if (value instanceof Map) {
            details.put("data_type", "STRUCT");
            details.put("fields", this.formatJsonData((Map)value));
        } else {
            this.setSimpleValueType(value, details);
        }
    }

    private void setSimpleValueType(Object value, Map<String, Object> details) {
        if (value instanceof Integer) {
            details.put("data_type", "integer");
        } else if (value instanceof Long) {
            details.put("data_type", "long");
        } else if (value == null || value instanceof String) {
            details.put("data_type", "string");
        } else if (value instanceof Date) {
            details.put("data_type", "datetime");
        } else if (value instanceof Double) {
            details.put("data_type", "double");
        } else if (value instanceof BigDecimal) {
            details.put("data_type", "decimal");
        } else if (value instanceof Boolean) {
            details.put("data_type", "boolean");
        } else {
            details.put("data_type", "");
        }
    }
}

