/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.platform.core.res.CatalogType;

public class MenuResourceTypeUtil {
    public static List<String> getMenuResourceType(String menuParam) {
        QFilter filter = new QFilter("id", "like", (Object)(menuParam + "%"));
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"iscx_resource_type", (String)"number", (QFilter[])new QFilter[]{filter});
        ArrayList<String> numbers = new ArrayList<String>(objects.length);
        for (DynamicObject o : objects) {
            numbers.add(o.getString("number"));
        }
        return numbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CatalogType[] getMenuForCatalogType(String menuParamResType, String menuParamCatalog) {
        boolean forSolution = false;
        boolean forModule = false;
        boolean forCommon = false;
        String sql = "select for_solution, for_module, for_common from t_iscx_res_type where fnumber like ?";
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true);
        try {
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, Collections.singletonList(menuParamResType + "%"), Collections.singletonList(12));
            for (DataRow dataRow : dataRows) {
                forSolution = forSolution || D.x((Object)dataRow.get((Object)"for_solution"));
                forModule = forModule || D.x((Object)dataRow.get((Object)"for_module"));
                forCommon = forCommon || D.x((Object)dataRow.get((Object)"for_common"));
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        if (D.s((Object)menuParamCatalog) != null) {
            String[] split = menuParamCatalog.split(",");
            HashSet config = new HashSet(split.length);
            Collections.addAll(config, split);
            forSolution = forSolution ? config.contains(CatalogType.Scene.name()) : forSolution;
            forModule = forModule ? config.contains(CatalogType.Industry.name()) : forModule;
            forCommon = forCommon ? config.contains(CatalogType.Common.name()) : forCommon;
        }
        LinkedHashSet<CatalogType> types = new LinkedHashSet<CatalogType>();
        for (CatalogType type : CatalogType.values()) {
            if (type.parentType() != null) continue;
            if (type == CatalogType.Scene && forSolution) {
                MenuResourceTypeUtil.getCatalogTypeByParent(types, CatalogType.Scene);
            }
            if (type == CatalogType.Industry && forModule) {
                MenuResourceTypeUtil.getCatalogTypeByParent(types, CatalogType.Industry);
            }
            if (type != CatalogType.Common || !forCommon) continue;
            MenuResourceTypeUtil.getCatalogTypeByParent(types, CatalogType.Common);
        }
        return types.toArray(new CatalogType[types.size()]);
    }

    private static void getCatalogTypeByParent(Set<CatalogType> types, CatalogType type) {
        types.add(type);
        for (CatalogType t : CatalogType.values()) {
            if (t.parentType() != type) continue;
            MenuResourceTypeUtil.getCatalogTypeByParent(types, t);
        }
    }
}

