/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.platform.core.res.CatalogType;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.build.util.ResEditorUtil;

public class ResourceEditorUtil {
    public static final String RESOURCE_SELECT_CLOSED_KEY = "resource_select_closed_key";

    public static void bindResourceDetailsViewer(AbstractFormPlugin form, String ... fields) {
        BeforeF7ViewDetailEventConsumer listener = new BeforeF7ViewDetailEventConsumer(form);
        for (String field : fields) {
            BasedataEdit f7 = (BasedataEdit)form.getView().getControl(field);
            f7.addBeforeF7ViewDetailListener((Consumer)listener);
        }
    }

    public static void bindResourceSelector(AbstractFormPlugin form, String ... fields) {
        IscxBeforeF7SelectListener listener = new IscxBeforeF7SelectListener(form, fields);
        for (String field : fields) {
            BasedataEdit f7 = (BasedataEdit)form.getView().getControl(field);
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)listener);
        }
    }

    public static void bindResourceSelector(AbstractFormPlugin form, List<Map<String, Object>> filters, String ... fields) {
        IscxBeforeF7SelectListener listener = new IscxBeforeF7SelectListener(form, (List)filters, fields);
        for (String field : fields) {
            BasedataEdit f7 = (BasedataEdit)form.getView().getControl(field);
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)listener);
        }
    }

    public static void bindResourceSelector(AbstractFormPlugin form, List<Map<String, Object>> filters, Map<String, Object> params, String ... fields) {
        IscxBeforeF7SelectListener listener = new IscxBeforeF7SelectListener(form, (List)filters, (Map)params, fields);
        for (String field : fields) {
            BasedataEdit f7 = (BasedataEdit)form.getView().getControl(field);
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)listener);
        }
    }

    public static void closedResourceSelector(AbstractFormPlugin form, ClosedCallBackEvent evt) {
        Map returnData;
        if (RESOURCE_SELECT_CLOSED_KEY.equals(evt.getActionId()) && (returnData = (Map)evt.getReturnData()) != null) {
            form.getView().getModel().setValue(D.s(returnData.get("customData")), returnData.get("id"));
        }
    }

    public static void openResourceEditor(long id, AbstractFormPlugin form, String callBack) {
        ResourceEditorUtil.openResourceEditor(id, form, false, callBack);
    }

    public static void openResourceEditor(long id, AbstractFormPlugin form, boolean isCopy, String callBack) {
        String formId;
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_resource", (String)"type,dev_tenant,name");
        ResourceType type = ResourceType.get((String)res.getString("type.id"));
        CaptionPrefix prefix = ResourceEditorUtil.makeCaptionPrefix(isCopy, res, type);
        String caption = prefix.label() + " - " + type.getName();
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        params.put("id", Long.valueOf(id));
        params.put("is_copy", Boolean.valueOf(isCopy));
        FormOpener.buildOpenFormParam((IFormView)form.getView(), params, (String[])new String[]{"source_app"});
        params.put("readOnly", Boolean.valueOf(prefix == CaptionPrefix.View));
        params.put("isExtensible", Boolean.valueOf(prefix == CaptionPrefix.Extend));
        String string = formId = isCopy ? type.getNewFormId() : type.getEditFormId();
        if (formId.contains("flow_diagram")) {
            caption = caption + " : " + res.getString("name");
            FormOpener.showTabForm((AbstractFormPlugin)form, (String)formId, (String)caption, params, (String)callBack);
        } else {
            FormOpener.showForm((AbstractFormPlugin)form, (String)formId, (String)caption, params, (String)callBack);
        }
    }

    private static CaptionPrefix makeCaptionPrefix(boolean isCopy, DynamicObject res, ResourceType type) {
        if (isCopy) {
            return CaptionPrefix.Copy;
        }
        boolean updatable = ResourceEditorUtil.isUpdatable(res);
        if (updatable) {
            return CaptionPrefix.Update;
        }
        if (type.isExtensible()) {
            return CaptionPrefix.Extend;
        }
        return CaptionPrefix.View;
    }

    public static void openResourceEditor2(long id, AbstractFormPlugin form) {
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_resource", (String)"type,dev_tenant,name");
        ResourceType type = ResourceType.get((String)res.getString("type.id"));
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        params.put("id", Long.valueOf(id));
        params.put("openResourceEditor2", Boolean.TRUE);
        boolean readOnly = D.x((Object)form.getView().getFormShowParameter().getCustomParam("readOnly"));
        params.put("readOnly", Boolean.valueOf(readOnly));
        boolean updatable = ResourceEditorUtil.isUpdatable(res);
        String caption = (readOnly ? CaptionPrefix.View.label() : (updatable ? CaptionPrefix.Update.label() : CaptionPrefix.Extend.label())) + " - " + type.getName();
        String formId = type.getNewFormId();
        FormOpener.showForm((AbstractFormPlugin)form, (String)formId, (String)caption, params, (String)"refresh_list");
    }

    public static void openResourceEditorByImport(long id, AbstractFormPlugin form, Map<String, Object> params, String callback) {
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_resource", (String)"type,dev_tenant,name");
        ResourceType type = ResourceType.get((String)res.getString("type.id"));
        String formId = type.getNewFormId();
        params.put("id", id);
        params.put("openResourceEditor2", Boolean.TRUE);
        boolean readOnly = D.x((Object)form.getView().getFormShowParameter().getCustomParam("readOnly"));
        params.put("readOnly", readOnly);
        FormOpener.showForm((AbstractFormPlugin)form, (String)formId, null, params, (String)callback);
    }

    public static void openResourceViewer(long id, AbstractFormPlugin form) {
        ResourceEditorUtil.openResourceEditor2(id, form);
    }

    public static void openResourceViewer1(long id, AbstractFormPlugin form) {
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_resource", (String)"type,dev_tenant,name");
        ResourceType type = ResourceType.get((String)res.getString("type.id"));
        String caption = type.getName() + "-" + res.get("name");
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        params.put("id", Long.valueOf(id));
        params.put("readOnly", Boolean.TRUE);
        FormOpener.showForm((AbstractFormPlugin)form, (String)type.getEditFormId(), (String)caption, params, (String)"refresh_list");
    }

    public static DynamicObject fromMap(Map<String, Object> ref) {
        if (ref == null || ref.isEmpty()) {
            return null;
        }
        Long id = D.l((Object)ref.get("id"));
        String entity = D.s((Object)ref.get("type"));
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)entity, (String)"id,number,name,type.id,type.number,type.name");
    }

    public static Map<String, Object> toMap(DynamicObject f7) {
        return ResEditorUtil.toMap((DynamicObject)f7);
    }

    public static Map<String, Object> toMap(Resource res) {
        if (res == null) {
            return null;
        }
        HashMap<String, Object> ref = new HashMap<String, Object>(8);
        ref.put("$ref", Boolean.TRUE);
        ref.put("type", "iscx_resource");
        ref.put("id", res.getId());
        ref.put("number", res.getNumber());
        ref.put("name", res.getName());
        return ref;
    }

    public static boolean isUpdatable(DynamicObject res) {
        return Objects.equals(RequestContext.get().getTenantId(), res.get("dev_tenant"));
    }

    public static boolean isExtensible(DynamicObject ext) {
        String ext_tenant = D.s((Object)ext.get("ext_tenant"));
        if (ext_tenant == null) {
            return true;
        }
        return Objects.equals(RequestContext.get().getTenantId(), ext_tenant);
    }

    public static List<Map<String, Object>> toList(DynamicObjectCollection entries) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(entries.size());
        for (DynamicObject entry : entries) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                Object value = entry.get(propertyName);
                if (value instanceof DynamicObject) {
                    map.put(propertyName, ResourceEditorUtil.toMap((DynamicObject)value));
                    continue;
                }
                map.put(propertyName, value);
            }
            list.add(map);
        }
        return list;
    }

    public static DynamicObjectCollection toObjectCollection(DynamicObjectCollection entries, List<Map<String, Object>> dataList) {
        entries.clear();
        if (!CollectionUtils.isEmpty(dataList)) {
            for (Map<String, Object> data : dataList) {
                ResourceEditorUtil.addEntryAndSetData(entries, data);
            }
        }
        return entries;
    }

    private static void addEntryAndSetData(DynamicObjectCollection entries, Map<String, Object> data) {
        DynamicObject entry = entries.addNew();
        DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
        for (Map.Entry<String, Object> dataEntry : data.entrySet()) {
            String key = dataEntry.getKey();
            Object value = dataEntry.getValue();
            IDataEntityProperty p = (IDataEntityProperty)properties.get((Object)key);
            if (p == null) continue;
            if (p instanceof BasedataProp) {
                entry.set(key, (Object)ResourceEditorUtil.fromMap((Map)value));
                continue;
            }
            entry.set(key, value);
        }
        if (D.l((Object)entry.getPkValue()) == 0L) {
            entry.set("id", (Object)ID.genLongId());
        }
    }

    public static long createResource(String type, String number, String name, String remark, DynamicObject catalog, Map<String, Object> details) {
        return ResEditorUtil.createResource((String)type, (String)number, (Map)ResEditorUtil.toMap((String)name), (String)remark, (DynamicObject)catalog, details);
    }

    public static long createResource(String type, String number, Map<String, String> name, String remark, DynamicObject catalog, Map<String, Object> details) {
        return ResEditorUtil.createResource((String)type, (String)number, name, (String)remark, (DynamicObject)catalog, details);
    }

    public static DynamicObject createResourceDynamic(String type, String number, String name, String remark, DynamicObject catalog, Map<String, Object> details) {
        return ResEditorUtil.createResourceDynamic((String)type, (String)number, (Map)ResEditorUtil.toMap((String)name), (String)remark, (DynamicObject)catalog, details);
    }

    public static DynamicObject createResourceDynamic(String type, String number, Map<String, String> name, String remark, DynamicObject catalog, Map<String, Object> details) {
        return ResEditorUtil.createResourceDynamic((String)type, (String)number, name, (String)remark, (DynamicObject)catalog, details);
    }

    public static void setInputAndOutputFromDataProvider(Map<String, Object> details, DynamicObject data_provider) {
        ResEditorUtil.setInputAndOutputFromDataProvider(details, (DynamicObject)data_provider);
    }

    public static void updateResource(DynamicObject res, String number, String name, String remark, DynamicObject catalog, Map<String, Object> details) {
        ResEditorUtil.updateResource((DynamicObject)res, (String)number, (Map)ResEditorUtil.toMap((String)name), (String)remark, (DynamicObject)catalog, details);
    }

    public static void updateResource(DynamicObject res, String number, Map<String, String> name, String remark, DynamicObject catalog, Map<String, Object> details) {
        ResEditorUtil.updateResource((DynamicObject)res, (String)number, name, (String)remark, (DynamicObject)catalog, details);
    }

    public static void extendsResource(DynamicObject ext, Map<String, Object> details, Map<String, Object> originalDetails) {
        ResEditorUtil.extendsResource((DynamicObject)ext, details, originalDetails);
    }

    public static List<String> getResourceCatalogPath(long id) {
        if (id <= 0L) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5efa\u8bae\u60a8\u6700\u597d\u4f20\u4e00\u4e2a\u6709\u6548\u7684\u8d44\u6e90id\uff0c\u60a8\u4f20id\u7684\u662f\uff1a%s", (String)"ResourceEditorUtil_26", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), id));
        }
        QFilter q = new QFilter("id", "=", (Object)id);
        DynamicObject resource = BusinessDataServiceHelper.loadSingle((String)"iscx_resource", (String)"catalog", (QFilter[])new QFilter[]{q});
        if (resource == null) {
            return new ArrayList<String>();
        }
        long catalogId = resource.getLong("catalog_id");
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((String)"iscx_catalog", (String)"long_number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)catalogId)});
        if (catalog == null) {
            return new ArrayList<String>();
        }
        return ResourceEditorUtil.getCatalogPathByLongNumber(catalog.getString("long_number"));
    }

    public static List<String> getResourceCatalogIdsPath(long catalogId) {
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((String)"iscx_catalog", (String)"long_number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)catalogId)});
        if (catalog == null) {
            return new ArrayList<String>();
        }
        String[] long_numbers = catalog.getString("long_number").split("/");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < long_numbers.length; ++i) {
            QFilter qFilter = new QFilter("number", "=", (Object)long_numbers[i]);
            catalog = BusinessDataServiceHelper.loadSingle((String)"iscx_catalog", (QFilter[])new QFilter[]{qFilter});
            if (catalog == null) continue;
            result.add(catalog.getString("id"));
        }
        return result;
    }

    public static List<String> getCatalogPathByLongNumber(String longNumber) {
        String[] long_numbers = longNumber.split("/");
        ArrayList<String> result = new ArrayList<String>();
        String firstName = CatalogType.valueOf((String)ResourceEditorUtil.toUpperCaseFirstChar(long_numbers[0])).label();
        result.add(firstName);
        String dynamicLongNumber = long_numbers[0];
        for (int i = 1; i < long_numbers.length; ++i) {
            dynamicLongNumber = dynamicLongNumber + "/" + long_numbers[i];
            QFilter qFilter = new QFilter("long_number", "=", (Object)dynamicLongNumber);
            DynamicObject catalog = BusinessDataServiceHelper.loadSingle((String)"iscx_catalog", (String)"name", (QFilter[])new QFilter[]{qFilter});
            if (catalog == null) {
                result.add(ResManager.loadKDString((String)"\u7a7a", (String)"ResourceEditorUtil_20", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                continue;
            }
            result.add(catalog.getString("name"));
        }
        return result;
    }

    public static String toUpperCaseFirstChar(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char firstChar = Character.toUpperCase(str.charAt(0));
        return firstChar + str.substring(1).toLowerCase();
    }

    public static DynamicObject getDynamicObjectRes(long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_resource");
    }

    private static enum CaptionPrefix {
        Copy(new MultiLangEnumBridge("\u590d\u5236", "ResourceEditorUtil_27", "isc-iscx-platform-formplugin")),
        Update(new MultiLangEnumBridge("\u4fee\u6539", "ResourceEditorUtil_28", "isc-iscx-platform-formplugin")),
        Extend(new MultiLangEnumBridge("\u6269\u5c55", "ResourceEditorUtil_29", "isc-iscx-platform-formplugin")),
        View(new MultiLangEnumBridge("\u67e5\u770b", "ResourceEditorUtil_30", "isc-iscx-platform-formplugin"));

        private final MultiLangEnumBridge label;

        private CaptionPrefix(MultiLangEnumBridge label) {
            this.label = label;
        }

        public String label() {
            return this.label.loadKDString();
        }
    }

    private static final class IscxBeforeF7SelectListener
    implements BeforeF7SelectListener {
        private final AbstractFormPlugin form;
        private List<Map<String, Object>> customeFilters;
        private Map<String, Object> customeParams;

        private IscxBeforeF7SelectListener(AbstractFormPlugin form, String ... fields) {
            this.form = form;
            String formId = form.getView().getFormShowParameter().getFormId();
            for (String field : fields) {
                DynamicProperty property = EntityMetadataCache.getDataEntityType((String)formId).getProperty(field);
                if (property instanceof BasedataProp) {
                    BasedataProp basedataProp = (BasedataProp)property;
                    String baseEntityId = basedataProp.getBaseEntityId();
                    if ("iscx_resource".equals(baseEntityId)) continue;
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u3010%1$s\u3011\u7684\u3010%2$s\u3011\u5b57\u6bb5\u5fc5\u987b\u662f\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u5e76\u4e14\u7c7b\u578b\u662f\uff08iscx_resource\uff09", (String)"ResourceEditorUtil_21", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), formId, field));
                }
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u3010%1$s\u3011\u7684\u3010%2$s\u3011\u5b57\u6bb5\u5fc5\u987b\u662f\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u5e76\u4e14\u7c7b\u578b\u662f\uff08iscx_resource\uff09", (String)"ResourceEditorUtil_21", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), formId, field));
            }
        }

        private IscxBeforeF7SelectListener(AbstractFormPlugin form, List<Map<String, Object>> filters, String ... fields) {
            this(form, fields);
            this.customeFilters = filters;
        }

        private IscxBeforeF7SelectListener(AbstractFormPlugin form, List<Map<String, Object>> filters, Map<String, Object> params, String ... fields) {
            this(form, fields);
            this.customeFilters = filters;
            this.customeParams = params;
        }

        public void beforeF7Select(BeforeF7SelectEvent e) {
            if (((BasedataEdit)e.getSource()).isF7Click()) {
                e.setCancel(true);
                String formId = this.form.getView().getFormShowParameter().getFormId();
                String prop = e.getProperty().getName();
                List<Map<String, Object>> filters = this.buildFilters(formId, prop);
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                params.put("filters", filters);
                params.put("customData", prop);
                if (this.customeParams != null) {
                    params.putAll(this.customeParams);
                }
                FormOpener.showForm((AbstractFormPlugin)this.form, (String)"iscx_res_select", (String)ResManager.loadKDString((String)"\u8d44\u6e90\u9009\u62e9", (String)"ResourceEditorUtil_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), params, (String)ResourceEditorUtil.RESOURCE_SELECT_CLOSED_KEY);
            }
        }

        private List<Map<String, Object>> buildFilters(String formId, String prop) {
            FilterCondition filterCondition = EntityMetadataCache.getBaseDataFieldFilterMeta((String)formId, (String)prop);
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)"iscx_resource"), filterCondition);
            filterBuilder.buildFilter();
            QFilter qFilter = filterBuilder.getQFilter();
            ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> f = new HashMap<String, Object>();
            f.put("property", qFilter.getProperty());
            f.put("cp", qFilter.getCP());
            f.put("value", qFilter.getValue());
            filters.add(f);
            if (this.customeFilters != null && !this.customeFilters.isEmpty()) {
                filters.addAll(this.customeFilters);
            }
            return filters;
        }
    }

    private static final class BeforeF7ViewDetailEventConsumer
    implements Consumer<BeforeF7ViewDetailEvent> {
        private final AbstractFormPlugin form;

        private BeforeF7ViewDetailEventConsumer(AbstractFormPlugin form) {
            this.form = form;
        }

        @Override
        public void accept(BeforeF7ViewDetailEvent e) {
            e.setCancel(true);
            if (this.form instanceof AbstractResourceEditorFormPlugin) {
                ResourceEditorUtil.openResourceViewer(D.l((Object)e.getPkId()), this.form);
            } else {
                ResourceEditorUtil.openResourceViewer1(D.l((Object)e.getPkId()), this.form);
            }
        }
    }
}

