/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.dt.ListType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.MultiLangStringTypeX;
import kd.isc.iscx.platform.core.res.meta.dt.RefSchema;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;

public class ResourceFieldSelectFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
RowClickEventListener {
    private static String TREE_MAPPING = "tree_mapping";
    private static String ROOT_ID = "$root";

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        this.initTree();
    }

    private void initTree() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Resource resource = ResourceUtil.getResource((long)D.l(params.get("resourceId")));
        List fields = ((AbstractDataModel)resource).getDataType().getFields();
        if (fields.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u6e90\u6ca1\u6709\u5b57\u6bb5\u53ef\u9009", (String)"ResourceFieldSelectFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode root = new TreeNode("", ROOT_ID, resource.getName());
        List<TreeNode> nodes = this.buildTreeNodes(fields, root);
        root.addChildren(nodes);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.deleteAllNodes();
        treeView.addNode(root);
        treeView.expand(root.getId());
        treeView.focusNode(root);
        this.showFieldList(ROOT_ID);
    }

    private List<TreeNode> buildTreeNodes(List<Field> fields, TreeNode parent) {
        LinkedList<TreeNode> nodes = new LinkedList<TreeNode>();
        for (Field field : fields) {
            String id = (ROOT_ID.equals(parent.getId()) ? "" : parent.getId() + ".") + field.getName();
            String fulllabel = (ROOT_ID.equals(parent.getId()) ? "" : parent.getLongText() + ".") + field.getLabel();
            TreeNode node = new TreeNode(parent.getId(), id, field.getLabel());
            node.setLongText(fulllabel);
            nodes.add(node);
            this.putTreeNodeDataToPageCache(node.getId(), fulllabel, node.getParentid(), field);
            DataType type = field.getType();
            if (field.isMultiple()) {
                node.setText(node.getText() + " [ ]");
                node.setLongText(node.getLongText() + " [ ]");
                ListType children = (ListType)field.getType();
                this.addChildrenNode(node, children.getElementType());
            }
            this.addChildrenNode(node, type);
        }
        return nodes;
    }

    private void addChildrenNode(TreeNode node, DataType type) {
        if (type instanceof StructSchema) {
            StructSchema type1 = (StructSchema)type;
            node.addChildren(this.buildTreeNodes(type1.getFields(), node));
        } else if (type instanceof RefSchema) {
            RefSchema type1 = (RefSchema)type;
            node.addChildren(this.buildTreeNodes(type1.getEntity().getFields(), node));
        } else if (type instanceof MultiLangStringTypeX) {
            List<TreeNode> children = this.buildMultiStringTreeNodes(node);
            node.addChildren(children);
        }
    }

    private List<TreeNode> buildMultiStringTreeNodes(TreeNode parent) {
        LinkedList<TreeNode> nodes = new LinkedList<TreeNode>();
        TreeNode zh_CN = new TreeNode(parent.getId(), parent.getId() + ".zh_CN", ResManager.loadKDString((String)"\u7b80\u4f53\u4e2d\u6587", (String)"ResourceFieldSelectFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        TreeNode zh_TW = new TreeNode(parent.getId(), parent.getId() + ".zh_TW", ResManager.loadKDString((String)"\u7e41\u4f53\u4e2d\u6587", (String)"ResourceFieldSelectFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        TreeNode en_US = new TreeNode(parent.getId(), parent.getId() + ".en_US", ResManager.loadKDString((String)"\u82f1\u6587", (String)"ResourceFieldSelectFormPlugin_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        nodes.add(zh_CN);
        nodes.add(zh_TW);
        nodes.add(en_US);
        String fulllabel_zh_CN = ROOT_ID.equals(parent.getId()) ? ResManager.loadKDString((String)"\u7b80\u4f53\u4e2d\u6587", (String)"ResourceFieldSelectFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"%s.\u7b80\u4f53\u4e2d\u6587", (String)"ResourceFieldSelectFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), parent.getText());
        Field field_zh_CN = new Field(this.newMultiStringFIeldMap("zh_CN", ResManager.loadKDString((String)"\u7b80\u4f53\u4e2d\u6587", (String)"ResourceFieldSelectFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0])));
        this.putTreeNodeDataToPageCache(zh_CN.getId(), fulllabel_zh_CN, zh_CN.getParentid(), field_zh_CN);
        String fulllabel_zh_TW = ROOT_ID.equals(parent.getId()) ? ResManager.loadKDString((String)"\u7e41\u4f53\u4e2d\u6587", (String)"ResourceFieldSelectFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"%s.\u7e41\u4f53\u4e2d\u6587", (String)"ResourceFieldSelectFormPlugin_7", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), parent.getText());
        Field field_zh_TW = new Field(this.newMultiStringFIeldMap("zh_TW", ResManager.loadKDString((String)"\u7e41\u4f53\u4e2d\u6587", (String)"ResourceFieldSelectFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0])));
        this.putTreeNodeDataToPageCache(zh_TW.getId(), fulllabel_zh_TW, zh_TW.getParentid(), field_zh_TW);
        String fulllabel_en_US = ROOT_ID.equals(parent.getId()) ? ResManager.loadKDString((String)"\u82f1\u6587", (String)"ResourceFieldSelectFormPlugin_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"%s.\u82f1\u6587", (String)"ResourceFieldSelectFormPlugin_8", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), parent.getText());
        Field field_en_US = new Field(this.newMultiStringFIeldMap("en_US", ResManager.loadKDString((String)"\u82f1\u6587", (String)"ResourceFieldSelectFormPlugin_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0])));
        this.putTreeNodeDataToPageCache(en_US.getId(), fulllabel_en_US, en_US.getParentid(), field_en_US);
        return nodes;
    }

    private Map<String, Object> newMultiStringFIeldMap(String code, String name) {
        HashMap<String, Object> item_zh_CN = new HashMap<String, Object>();
        item_zh_CN.put("field", code);
        item_zh_CN.put("label", name);
        item_zh_CN.put("data_type", "string");
        item_zh_CN.put("is_primary_key", Boolean.FALSE);
        item_zh_CN.put("is_required", Boolean.FALSE);
        item_zh_CN.put("is_private", Boolean.FALSE);
        item_zh_CN.put("is_multiple", Boolean.FALSE);
        return item_zh_CN;
    }

    private void putTreeNodeDataToPageCache(String nodeid, String fulllabel, String parentid, Field field) {
        String json = this.getView().getPageCache().get(TREE_MAPPING);
        Map mapping = null;
        mapping = StringUtil.isEmpty((String)json) ? new HashMap() : (Map)Json.toObject((String)json);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("parentid", parentid);
        data.put("fullnumber", nodeid);
        data.put("fulllabel", fulllabel);
        data.putAll(field.toMap());
        mapping.put(nodeid, data);
        this.getView().getPageCache().put(TREE_MAPPING, Json.toString(mapping));
    }

    private Map<String, Object> takeTreeNodeData(String nodeid) {
        String json = this.getView().getPageCache().get(TREE_MAPPING);
        if (!StringUtil.isEmpty((String)json)) {
            Map map = (Map)Json.toObject((String)json);
            return (Map)map.get(nodeid);
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u6811\u8282\u70b9\u4e0a\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5148put\u4e86\u6570\u636e", (String)"ResourceFieldSelectFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
    }

    private List<Map<String, Object>> takeTreeNodeDataByParentid(String parentid) {
        String json = this.getView().getPageCache().get(TREE_MAPPING);
        LinkedList<Map<String, Object>> nodes = new LinkedList<Map<String, Object>>();
        if (!StringUtil.isEmpty((String)json)) {
            Map map = (Map)Json.toObject((String)json);
            for (Map.Entry entry : map.entrySet()) {
                Map data = (Map)entry.getValue();
                if (!parentid.equals(data.get("parentid"))) continue;
                nodes.add(data);
            }
            return nodes;
        }
        throw new IscBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u6811\u8282\u70b9\u4e0a\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5148put\u4e86\u6570\u636e", (String)"ResourceFieldSelectFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
    }

    private List<Map<String, Object>> searchTreeNodeData(String text) {
        String json = this.getView().getPageCache().get(TREE_MAPPING);
        if (StringUtil.isEmpty((String)json)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u6811\u8282\u70b9\u4e0a\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5148put\u4e86\u6570\u636e", (String)"ResourceFieldSelectFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        }
        LinkedList<Map<String, Object>> matching = new LinkedList<Map<String, Object>>();
        Map fieldMapping = (Map)Json.toObject((String)json);
        for (Map.Entry entry : fieldMapping.entrySet()) {
            Map field = (Map)entry.getValue();
            if (!this.searchMatching(field, text)) continue;
            matching.add(field);
        }
        return matching;
    }

    private boolean searchMatching(Map<String, Object> field, String searchText) {
        if (D.s((Object)field.get("fullnumber")).contains(searchText)) {
            return true;
        }
        String label = D.s((Object)field.get("label"));
        return label != null && label.contains(searchText);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Search search = (Search)this.getControl("searchap");
        search.setSearchKey("");
        String nodeid = evt.getNodeId().toString();
        this.showFieldList(nodeid);
    }

    private void showFieldList(String nodeid) {
        Map<String, Object> fieldData = this.takeTreeNodeData(nodeid);
        List<Map<String, Object>> children = this.takeTreeNodeDataByParentid(nodeid);
        if (ROOT_ID.equals(nodeid) || !children.isEmpty()) {
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            entryentity.clear();
            for (Map<String, Object> data : children) {
                this.addNewEntry(entryentity, data);
            }
        } else {
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            entryentity.clear();
            this.addNewEntry(entryentity, fieldData);
        }
        this.getView().updateView("entryentity");
        this.updateSelectedData();
        this.checkedFiledListFromSelected();
    }

    private void checkedFiledListFromSelected() {
        DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
        HashSet<String> exists = new HashSet<String>();
        for (DynamicObject object : selectedentry) {
            exists.add(object.getString("selected"));
        }
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        ArrayList<Integer> rowIndex = new ArrayList<Integer>();
        for (int i = 0; i < entryentity.size(); ++i) {
            if (!exists.contains(((DynamicObject)entryentity.get(i)).getString("fullnumber"))) continue;
            rowIndex.add(i);
        }
        int[] rowIndexArr = new int[rowIndex.size()];
        for (int i = 0; i < rowIndex.size(); ++i) {
            rowIndexArr[i] = (Integer)rowIndex.get(i);
        }
        if (rowIndexArr.length > 0) {
            entryGrid.selectRows(rowIndexArr, rowIndexArr[0]);
        } else {
            entryGrid.selectRows(rowIndexArr, 1);
        }
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<String> currSelected = new ArrayList<String>(selectRows.length);
        for (int index : selectRows) {
            DynamicObject row = (DynamicObject)entryentity.get(index);
            currSelected.add(row.getString("fullnumber"));
        }
        this.getView().getPageCache().put("lastCheckedData", Json.toString(currSelected));
    }

    private void updateSelectedData() {
        boolean updated = D.x((Object)this.getView().getPageCache().get("is_update_selected"));
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String value = D.s(params.get("value"));
        if (StringUtil.isEmpty((String)value) || updated) {
            return;
        }
        if (D.x(params.get("single"))) {
            Map<String, Object> fieldData = this.takeTreeNodeData(value);
            if (fieldData != null) {
                Pair data = new Pair((Object)D.s((Object)fieldData.get("fullnumber")), fieldData.get("label"));
                this.setSelectedEntry(Collections.singletonList(data));
            }
        } else {
            String[] split = value.split(",");
            ArrayList<Pair<String, Object>> datas = new ArrayList<Pair<String, Object>>(split.length);
            for (String s : split) {
                Map<String, Object> fieldData = this.takeTreeNodeData(s);
                Pair data = new Pair((Object)D.s((Object)fieldData.get("fullnumber")), fieldData.get("label"));
                datas.add((Pair<String, Object>)data);
            }
            this.setSelectedEntry(datas);
        }
        this.getView().updateView("selectedentry");
        this.getView().getPageCache().put("is_update_selected", "true");
    }

    private void addNewEntry(DynamicObjectCollection entryentity, Map<String, Object> data) {
        DynamicObject entry = entryentity.addNew();
        entry.set("name", data.get("name"));
        entry.set("fullnumber", data.get("fullnumber"));
        entry.set("label", data.get("label"));
        entry.set("fulllabel", data.get("fulllabel"));
        entry.set("type", data.get("type"));
        entry.set("is_primary_key", data.get("is_primary_key"));
        entry.set("is_required", data.get("is_required"));
        entry.set("is_private", data.get("is_private"));
        entry.set("is_multiple", data.get("is_multiple"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("btnok".equals(operateKey)) {
            DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
            if (selectedentry.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5\u3002", (String)"ResourceFieldSelectFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("clear".equals(operateKey)) {
            DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
            selectedentry.clear();
            this.getView().updateView("selectedentry");
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            this.showFieldList(tree.getTreeState().getFocusNodeId());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("btnok".equals(operateKey)) {
            DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
            Map params = this.getView().getFormShowParameter().getCustomParams();
            ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(selectedentry.size());
            for (DynamicObject obejct : selectedentry) {
                Map<String, Object> fieldMap = this.takeTreeNodeData(obejct.getString("selected"));
                if (params.containsKey("customData")) {
                    fieldMap.put("customData", params.get("customData"));
                }
                resultList.add(fieldMap);
            }
            this.getView().returnDataToParent(resultList);
            this.getView().close();
        } else if ("deleteentry".equals(operateKey)) {
            this.checkedFiledListFromSelected();
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        if (StringUtil.isEmpty((String)text)) {
            this.showFieldList(ROOT_ID);
            TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
            treeView.focusNode(new TreeNode("", ROOT_ID, ""));
            return;
        }
        List<Map<String, Object>> list = this.searchTreeNodeData(text);
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entryentity.clear();
        for (Map<String, Object> data : list) {
            this.addNewEntry(entryentity, data);
        }
        this.getView().updateView("entryentity");
        this.checkedFiledListFromSelected();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("tile".equals(propertyName)) {
            boolean flag = D.x((Object)e.getChangeSet()[0].getNewValue());
            if (flag) {
                this.showTileMode();
                SplitContainer splitc = (SplitContainer)this.getControl("splitcontainerap");
                splitc.hidePanel(SplitDirection.left, true);
            } else {
                SplitContainer splitc = (SplitContainer)this.getControl("splitcontainerap");
                splitc.hidePanel(SplitDirection.left, false);
                this.getView().updateView();
            }
        }
    }

    private void showTileMode() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Resource resource = ResourceUtil.getResource((long)D.l(params.get("resourceId")));
        List fields = ((AbstractDataModel)resource).getDataType().getFields();
        HashSet<String> refField = new HashSet<String>();
        for (Field field : fields) {
            if (field.isMultiple()) {
                ListType children = (ListType)field.getType();
                if (!(children.getElementType() instanceof RefSchema) && !(children.getElementType() instanceof StructSchema)) continue;
                refField.add(field.getName());
                continue;
            }
            if (!(field.getType() instanceof RefSchema) && !(field.getType() instanceof StructSchema)) continue;
            refField.add(field.getName());
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.focusNode(new TreeNode("", ROOT_ID, ""));
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entryentity.clear();
        String json = this.getView().getPageCache().get(TREE_MAPPING);
        Map map = (Map)Json.toObject((String)json);
        for (Map.Entry entry : map.entrySet()) {
            Map data = (Map)entry.getValue();
            if (refField.contains(entry.getKey())) continue;
            this.addNewEntry(entryentity, data);
        }
        this.getView().updateView("entryentity");
        this.checkedFiledListFromSelected();
    }

    public void entryRowClick(RowClickEvent evt) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
        if (D.x(params.get("single"))) {
            entryGrid.selectRows(evt.getRow());
            selectedentry.clear();
            this.getView().updateView("selectedentry");
            if (entryGrid.getSelectRows().length != 0) {
                DynamicObject row = (DynamicObject)entryentity.get(evt.getRow());
                Pair data = new Pair((Object)row.getString("fullnumber"), row.get("label"));
                this.setSelectedEntry(Collections.singletonList(data));
            }
        } else {
            Pair<String, List<String>> checkedData = this.getCheckedData();
            this.setSelectedEntry(checkedData);
        }
    }

    private void setSelectedEntry(List<Pair<String, Object>> datas) {
        DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
        HashSet<String> exists = new HashSet<String>();
        for (DynamicObject object : selectedentry) {
            exists.add(object.getString("selected"));
        }
        for (Pair<String, Object> data : datas) {
            if (exists.contains(data.getA())) continue;
            DynamicObject selected = selectedentry.addNew();
            selected.set("selected", data.getA());
            selected.set("desc", data.getB());
        }
        this.getView().updateView("selectedentry");
    }

    private void setSelectedEntry(Pair<String, List<String>> checkedData) {
        DynamicObjectCollection selectedentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("selectedentry");
        HashSet<String> exists = new HashSet<String>();
        for (DynamicObject object : selectedentry) {
            exists.add(object.getString("selected"));
        }
        if ("increase".equals(checkedData.getKey())) {
            List addField = (List)checkedData.getValue();
            for (String f : addField) {
                if (exists.contains(f)) continue;
                Map<String, Object> fieldMap = this.takeTreeNodeData(f);
                DynamicObject selected = selectedentry.addNew();
                selected.set("selected", fieldMap.get("fullnumber"));
                selected.set("desc", fieldMap.get("label"));
            }
        }
        if ("decrease".equals(checkedData.getKey())) {
            final List decField = (List)checkedData.getValue();
            selectedentry.removeIf((Predicate)new Predicate<DynamicObject>(){

                @Override
                public boolean test(DynamicObject dynamicObject) {
                    return decField.contains(dynamicObject.getString("selected"));
                }
            });
        }
        this.getView().updateView("selectedentry");
    }

    private Pair<String, List<String>> getCheckedData() {
        String json = this.getView().getPageCache().get("lastCheckedData");
        List lastSelected = new ArrayList();
        if (json != null) {
            lastSelected = (List)Json.toObject((String)json);
        }
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<String> currSelected = new ArrayList<String>(selectRows.length);
        for (int index : selectRows) {
            DynamicObject row = (DynamicObject)entryentity.get(index);
            currSelected.add(row.getString("fullnumber"));
        }
        this.getView().getPageCache().put("lastCheckedData", Json.toString(currSelected));
        ArrayList<String> intersection = new ArrayList<String>();
        for (String last : lastSelected) {
            for (String curr : currSelected) {
                if (!last.equals(curr)) continue;
                intersection.add(last);
            }
        }
        if (intersection.isEmpty()) {
            if (currSelected.size() > lastSelected.size()) {
                return new Pair((Object)"increase", currSelected);
            }
            return new Pair((Object)"decrease", lastSelected);
        }
        currSelected.removeAll(intersection);
        lastSelected.removeAll(intersection);
        if (currSelected.size() > lastSelected.size()) {
            return new Pair((Object)"increase", currSelected);
        }
        return new Pair((Object)"decrease", lastSelected);
    }
}

