/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.MenuResourceTypeUtil;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.platform.core.res.CatalogType;
import kd.isc.iscx.platform.core.res.ResourceType;

public class ResourceSelectFormPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
TreeNodeClickListener,
HyperLinkClickListener,
ListRowClickListener,
SetFilterListener {
    private static final String PAGE_CACHE_NODES_KEY = "page_cache_nodes_key";

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addListRowDoubleClickListener((ListRowClickListener)this);
        billList.addSetFilterListener((SetFilterListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"new_btn"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject res;
        Map<String, Object> nodeData;
        super.afterCreateNewData(e);
        this.initTree();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setFilter(this.buildQFilterFromParameter());
        billList.refresh();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getView().setVisible(Boolean.valueOf(D.x(customParams.get("showAddButton"))), new String[]{"no_i_wantto", "new_btn"});
        String editResId = D.s(customParams.get("editResId"));
        if (!StringUtil.isEmpty((String)editResId) && (nodeData = this.getNodeData((res = BusinessDataServiceHelper.loadSingle((Object)editResId, (String)"iscx_resource")).getString("catalog_id"))) != null) {
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            tree.focusNode(new TreeNode("", D.s((Object)nodeData.get("id")), D.s((Object)nodeData.get("name"))));
            this.treeNodeClick(null);
            ListSelectedRowCollection selectedRows = billList.getCurrentListAllRowCollection();
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow row = selectedRows.get(i);
                if (!editResId.equals(D.s((Object)row.getPrimaryKeyValue()))) continue;
                billList.selectRows(i, true);
                this.getView().updateView("billlistap");
            }
        }
    }

    private QFilter buildQFilterFromParameter() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List filters = (List)customParams.get("filters");
        QFilter qFilter = null;
        for (Map f : filters) {
            if (qFilter == null) {
                qFilter = new QFilter(D.s(f.get("property")), D.s(f.get("cp")), f.get("value"));
                continue;
            }
            qFilter.and(new QFilter(D.s(f.get("property")), D.s(f.get("cp")), f.get("value")));
        }
        return qFilter;
    }

    private void initTree() {
        CatalogType[] catalogTypeArray;
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.deleteAllNodes();
        tree.setMulti(false);
        TreeNode root = new TreeNode("", "$root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ResourceSelectFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        tree.addNode(root);
        tree.focusNode(root);
        for (CatalogType type : catalogTypeArray = this.getCatalogType()) {
            if (type.parentType() == null) {
                TreeNode node = new TreeNode(root.getId(), type.name(), type.label());
                tree.addNode(node);
                tree.expand(type.name());
            }
            this.addTreeNode(tree, type);
        }
    }

    private CatalogType[] getCatalogType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List filters = (List)customParams.get("filters");
        if (filters.isEmpty()) {
            return CatalogType.values();
        }
        LinkedHashSet<CatalogType> catalogTypeSet = new LinkedHashSet<CatalogType>();
        for (Map f : filters) {
            if (!"type.number".equals(f.get("property"))) continue;
            Object value = f.get("value");
            if (value instanceof List) {
                List types = (List)value;
                for (String t : types) {
                    CatalogType[] ct = MenuResourceTypeUtil.getMenuForCatalogType(t, null);
                    catalogTypeSet.addAll(Arrays.asList(ct));
                }
                continue;
            }
            throw new IscBizException(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u5b57\u6bb5\u7684\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u662f\u3010\u5728...\u4e2d\u3011\uff0c\u8bf7\u68c0\u67e5\u5143\u6570\u636e", (String)"ResourceSelectFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        }
        return catalogTypeSet.toArray(new CatalogType[catalogTypeSet.size()]);
    }

    private void addTreeNode(TreeView tree, CatalogType type) {
        DynamicObject[] catalogs;
        QFilter qFilter = new QFilter("type", "=", (Object)type.name());
        for (DynamicObject c : catalogs = BusinessDataServiceHelper.load((String)"iscx_catalog", (String)"type,name,parent,long_number", (QFilter[])new QFilter[]{qFilter}, (String)"priority")) {
            String parentId = c.getString("parent_id");
            if ("0".equals(parentId)) {
                parentId = type.name();
            }
            String id = D.s((Object)c.getPkValue());
            String name = c.getString("name");
            TreeNode node = new TreeNode(parentId, id, name);
            tree.addNode(node);
            this.addNodeToCache(node, c);
        }
    }

    private void addNodeToCache(TreeNode node, DynamicObject c) {
        Map nodes = null;
        String pagecache = this.getPageCache().get(PAGE_CACHE_NODES_KEY);
        nodes = StringUtil.isEmpty((String)pagecache) ? new LinkedHashMap() : (Map)Json.toObject((String)pagecache);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", c.getString("id"));
        data.put("type", c.getString("type"));
        data.put("name", c.getString("name"));
        data.put("parentId", c.get("parent_id"));
        data.put("long_number", c.getString("long_number"));
        nodes.put(node.getId(), data);
        this.getPageCache().put(PAGE_CACHE_NODES_KEY, Json.toString(nodes));
    }

    private Map<String, Object> getNodeData(String nodeId) {
        String pagecache = this.getView().getPageCache().get(PAGE_CACHE_NODES_KEY);
        if (StringUtil.isEmpty((String)pagecache)) {
            return null;
        }
        Map nodes = (Map)Json.toObject((String)pagecache);
        return (Map)nodes.get(nodeId);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String focusNodeId = this.getFocusNodeId();
        Map<String, Object> nodeData = this.getNodeData(focusNodeId);
        if ("$root".equals(focusNodeId)) {
            this.updateResourceList(null);
        } else if (nodeData == null) {
            this.updateResourceList(focusNodeId.toUpperCase());
        } else {
            this.updateResourceList(D.s((Object)nodeData.get("long_number")));
        }
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.expand(focusNodeId);
    }

    private void updateResourceList(String longNumber) {
        QFilter qFilter = this.buildQFilterFromParameter();
        if (!StringUtil.isEmpty((String)longNumber)) {
            qFilter.and("catalog.long_number", "like", (Object)(longNumber + "%"));
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.setFilter(qFilter);
        billList.refresh();
    }

    private boolean isLeaf(String focusNodeId) {
        Map<String, Object> nodeData = this.getNodeData(focusNodeId);
        if (nodeData == null) {
            return false;
        }
        CatalogType type = CatalogType.valueOf((String)D.s((Object)nodeData.get("type")));
        return type.isLeaf();
    }

    private String getFocusNodeId() {
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        return tree.getTreeState().getFocusNodeId();
    }

    public void afterDoOperation(AfterDoOperationEventArgs a) {
        super.afterDoOperation(a);
        String key = a.getOperateKey();
        if ("btnok".equals(key)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"ResourceSelectFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("id", selectedRows.get(0).getPrimaryKeyValue());
            returnData.put("number", selectedRows.get(0).getNumber());
            returnData.put("name", selectedRows.get(0).getName());
            returnData.put("customData", customParams.get("customData"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if ("number".equals(e.getFieldName())) {
            Object pk = ((BillListHyperLinkClickEvent)e).getCurrentRow().getPrimaryKeyValue();
            ResourceEditorUtil.openResourceViewer(D.l((Object)pk), this);
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("id", row.getPrimaryKeyValue());
        returnData.put("number", row.getNumber());
        returnData.put("name", row.getName());
        returnData.put("customData", customParams.get("customData"));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("new_btn".equals(source.getKey())) {
            String focusNodeId = this.getFocusNodeId();
            if (this.isLeaf(focusNodeId)) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("catalog", focusNodeId);
                ResourceType resType = ResourceType.get((String)D.s(customParams.get("addResType")));
                FormOpener.showForm((AbstractFormPlugin)this, (String)resType.getNewFormId(), null, params, (String)"refresh_list");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u6e90\u76ee\u5f55\u6811\u7684\u53f6\u5b50\u8282\u70b9\u6570\u636e", (String)"ResourceSelectFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map data;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if ("refresh_list".equals(e.getActionId()) && returnData instanceof Map && D.l((data = (Map)returnData).get("id")) > 0L) {
            this.treeNodeClick(null);
        }
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(this.buildQFilterFromParameter());
        e.setCustomQFilters(filters);
    }

    public void search(SearchEnterEvent evt) {
        String text = evt.getText();
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.focusNode(new TreeNode("", "$root", ""));
        QFilter qFilter = this.buildQFilterFromParameter();
        if (!StringUtil.isEmpty((String)text)) {
            QFilter likeFilter = new QFilter("name", "like", (Object)("%" + text + "%")).or("number", "like", (Object)("%" + text + "%"));
            qFilter.and(likeFilter);
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.setFilter(qFilter);
        billList.refresh();
    }
}

