/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscx.platform.core.res.CatalogType;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.ResourceTypeGroup;

public class ResourceTypeSelectorFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
SearchEnterListener {
    private static final String BILLLISTAP = "billlistap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String GROUP = "group";
    private static final String TYPE_GROUP = "typegroup";
    private static final String LOGO = "icon_url";
    private static final String LOCALHOST = "localhost";
    private static final String PRIORITY = "priority";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
            Search search = (Search)this.getControl("searchap");
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void search(SearchEnterEvent evt) {
        BillList billList = this.billListAfterSearchFilter(evt);
        this.refreshBillList(billList);
        this.setDefaultGroup();
    }

    private BillList billListAfterSearchFilter(SearchEnterEvent evt) {
        String searchText = evt.getText();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            QFilter filter = new QFilter("name", "ilike", (Object)("%" + searchText + "%")).or(new QFilter("number", "ilike", (Object)("%" + searchText + "%")));
            billList.getFilterParameter().setFilter(this.decorateFilter(filter));
        }
        return billList;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt.getRowIndex() >= 0) {
            BillList billList = this.billListAfterGroupFilter(evt.getRowIndex());
            this.refreshBillList(billList);
        }
    }

    private void refreshBillList(BillList billList) {
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)new resourceTypeDataProvider());
        this.sortResourceType();
        this.getView().updateView(BILLLISTAP);
    }

    private BillList billListAfterGroupFilter(int rowIndex) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        String groupCode = ((DynamicObject)collection.get(rowIndex)).getString("group_code");
        QFilter filter = "ALL".equals(groupCode) ? null : new QFilter(GROUP, "=", (Object)groupCode);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String menuResType = D.s(customParams.get("menu_iscx_res_type"));
        if (menuResType != null && menuResType.contains(".")) {
            if (filter != null) {
                filter.and(new QFilter("number", "=", (Object)menuResType));
            } else {
                filter = new QFilter("number", "=", (Object)menuResType);
            }
        }
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.getFilterParameter().setFilter(this.decorateFilter(filter));
        return billList;
    }

    private QFilter decorateFilter(QFilter filter) {
        String catalogType = D.s((Object)this.getModel().getValue("catalog_type"));
        if (CatalogType.Module.name().equals(catalogType)) {
            return new QFilter("for_module", "=", (Object)Boolean.TRUE).and(filter);
        }
        if (CatalogType.Solution.name().equals(catalogType)) {
            return new QFilter("for_solution", "=", (Object)Boolean.TRUE).and(filter);
        }
        if (CatalogType.Common.name().equals(catalogType)) {
            return new QFilter("for_common", "=", (Object)Boolean.TRUE).and(filter);
        }
        return filter;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)new resourceTypeDataProvider());
        this.getModel().setValue("catalog_type", (Object)this.getCatalogType());
        QFilter qFilter = null;
        String group = D.s((Object)this.getView().getFormShowParameter().getCustomParam(GROUP));
        if (group != null) {
            qFilter = new QFilter(GROUP, "=", (Object)group);
        }
        billList.setFilter(this.decorateFilter(qFilter));
    }

    private String getCatalogType() {
        long catalogId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("catalog"));
        if (catalogId == 0L) {
            return "NONE";
        }
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)catalogId, (String)"iscx_catalog", (String)"type");
        return catalog.getString("type");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.sortResourceType();
        this.initResourceGroup();
        this.chooseDefaultGroup();
    }

    private void chooseDefaultGroup() {
        String group = D.s((Object)this.getView().getFormShowParameter().getCustomParam(GROUP));
        if (group != null) {
            DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRYENTITY);
            for (int i = 0; i < collection.size(); ++i) {
                String groupCode = ((DynamicObject)collection.get(i)).getString("group_code");
                if (!group.equals(groupCode)) continue;
                CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY);
                cardEntry.selectRows(i);
                break;
            }
        }
    }

    private void sortResourceType() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.setRowSort(PRIORITY, 1);
    }

    private void initResourceGroup() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRYENTITY);
        entry.clear();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String menuResType = D.s(customParams.get("menu_iscx_res_type"));
        if (menuResType == null) {
            DynamicObject newEntry = entry.addNew();
            newEntry.set(TYPE_GROUP, (Object)ResManager.loadKDString((String)"\u5168\u90e8", (String)"ResourceTypeSelectorFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            newEntry.set("group_code", (Object)"ALL");
        }
        List groupSort = ResourceTypeGroup.getResourceTypeList();
        List<DataRow> dbGroupSort = this.queryAllResourceGroup();
        HashSet<String> pageGroups = new HashSet<String>(dbGroupSort.size());
        block0: for (String s : groupSort) {
            for (DataRow dataRow : dbGroupSort) {
                String group = D.s((Object)dataRow.getValue(0));
                if (!s.equals(group) || !pageGroups.add(group)) continue;
                DynamicObject newEntry = entry.addNew();
                newEntry.set(TYPE_GROUP, (Object)ResourceTypeGroup.loadKDString((String)group));
                newEntry.set("group_code", (Object)group);
                continue block0;
            }
        }
        for (DataRow dataRow : dbGroupSort) {
            String group = D.s((Object)dataRow.getValue(0));
            if (!pageGroups.add(group)) continue;
            DynamicObject newEntry = entry.addNew();
            newEntry.set(TYPE_GROUP, (Object)ResourceTypeGroup.loadKDString((String)group));
            newEntry.set("group_code", (Object)group);
        }
        this.getView().updateView(ENTRYENTITY);
        this.setDefaultGroup();
        BillList billList = this.billListAfterGroupFilter(0);
        this.refreshBillList(billList);
    }

    private void setDefaultGroup() {
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY);
        cardEntry.selectRows(0);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if ("next".equals(eventArgs.getOperateKey())) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectResources = billList.getSelectedRows();
            if (selectResources.size() == 1) {
                this.returnResourceFormId(selectResources);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u79cd\u7c7b\u578b\u3002", (String)"ResourceTypeSelectorFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void returnResourceFormId(ListSelectedRowCollection selectResources) {
        String number = selectResources.get(0).getNumber();
        ResourceType resource = ResourceType.get((String)number);
        this.getView().returnDataToParent((Object)resource.getNewFormId());
        this.getView().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataRow> queryAllResourceGroup() {
        String catalogType = (String)this.getModel().getValue("catalog_type");
        String sql = CatalogType.Module.name().equals(catalogType) ? "SELECT DISTINCT FGROUP FROM T_ISCX_RES_TYPE WHERE for_module = '1'" : (CatalogType.Solution.name().equals(catalogType) ? "SELECT DISTINCT FGROUP FROM T_ISCX_RES_TYPE WHERE for_solution = '1'" : (CatalogType.Common.name().equals(catalogType) ? "SELECT DISTINCT FGROUP FROM T_ISCX_RES_TYPE WHERE for_common = '1'" : "SELECT DISTINCT FGROUP FROM T_ISCX_RES_TYPE WHERE 1=1"));
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String menuResType = D.s(customParams.get("menu_iscx_res_type"));
        if (menuResType != null) {
            sql = sql + " AND fnumber like ?";
            values.add(menuResType + "%");
            types.add(12);
        }
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true);
        try {
            List list = DbUtil.executeList((Connection)cn, (String)sql, values, types);
            return list;
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    static class resourceTypeDataProvider
    extends ListDataProvider
    implements CreateListDataProviderListener {
        resourceTypeDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty() || !((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)ResourceTypeSelectorFormPlugin.LOGO)) {
                return rows;
            }
            this.setFieldData(rows);
            return rows;
        }

        private void setFieldData(DynamicObjectCollection rows) {
            String url = UrlService.getDomainContextUrl().replace(ResourceTypeSelectorFormPlugin.LOCALHOST, NetUtil.getLocalAddress());
            for (DynamicObject row : rows) {
                row.set(ResourceTypeSelectorFormPlugin.LOGO, (Object)(url + "/kingdee/isc/isc_res_type_logo/" + D.s((Object)(row.get("number") + ".png"))));
                row.set(ResourceTypeSelectorFormPlugin.GROUP, (Object)ResourceTypeGroup.loadKDString((String)row.getString(ResourceTypeSelectorFormPlugin.GROUP)));
            }
        }

        public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
            args.setListDataProvider((IListDataProvider)this);
        }
    }
}

