/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.df;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.MenuResourceTypeUtil;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.df.DataFlowEditorUtil;
import kd.isc.iscx.platform.core.res.CatalogType;
import kd.isc.iscx.platform.core.res.ResourceType;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;

public class DataFlowEditorFormPlugin
extends AbstractResourceEditorFormPlugin {
    private static final Log LOG = LogFactory.getLog(DataFlowEditorFormPlugin.class);

    @Override
    protected String getResourceType() {
        return "DataWeaver.DataFlow";
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        this.initEditorHtmlData(details, mode);
        if (mode != EditorMode.NEW) {
            this.getView().setStatus(OperationStatus.ADDNEW);
            this.getModel().setValue("status", (Object)OperationStatus.VIEW.name());
        } else {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getModel().setValue("status", (Object)OperationStatus.EDIT.name());
        }
        this.getView().setVisible(Boolean.valueOf(this.isInst()), new String[]{"bar_view_detail"});
        this.getView().setVisible(Boolean.valueOf(this.isInst() && "iscx_data_stream".equals(this.getView().getFormShowParameter().getCustomParam("entityType"))), new String[]{"view_error", "view_trace"});
        this.getModel().setValue("mode", (Object)mode.name());
    }

    private void initEditorHtmlData(Map<String, Object> details, EditorMode mode) {
        Map define = (Map)details.get("define");
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.isHistory()) {
            this.getView().setVisible(Boolean.valueOf(this.isInst()), new String[]{"bar_view_details"});
        }
        data.put("categories", this.queryCategories());
        data.put("isReadOnly", mode == EditorMode.VIEW);
        data.put("isExtensible", mode == EditorMode.EXTENDS);
        data.put("isInEditMode", mode == EditorMode.NEW);
        data.put("define", define);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("systemList", details.getOrDefault("connectors", new ArrayList()));
        properties.put("number", this.getModel().getValue("number"));
        properties.put("name", this.getModel().getValue("name"));
        DynamicObject catalog = this.getModel().getDataEntity().getDynamicObject("catalog");
        if (catalog != null) {
            properties.put("catalog", ResourceEditorUtil.getResourceCatalogIdsPath(catalog.getLong("id")));
        }
        if (mode != EditorMode.VIEW) {
            data.put("enable_resources", this.queryEnableResourcesList());
        }
        properties.put("remark", this.getModel().getValue("remark"));
        data.put("properties", properties);
        ((CustomControl)this.getControl("editor")).setData(data);
    }

    private List<String> queryEnableResourcesList() {
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"iscx_resource_type", (String)"number", (QFilter[])new QFilter[0]);
        ArrayList<String> result = new ArrayList<String>(objects.length);
        for (DynamicObject o : objects) {
            result.add(o.getString("number"));
        }
        return result;
    }

    private boolean isInst() {
        return D.l((Object)this.getView().getFormShowParameter().getCustomParam("dfInstId")) > 0L;
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        return DataFlowEditorUtil.getResourceDetails(this);
    }

    private Map<String, Object> getStarterModel(Map<String, Object> define) {
        Map<String, Object> node = DataFlowEditorUtil.findNode(define, 1);
        long eventModelId = D.l((Object)ResourceUtil.getValue(node, (String[])new String[]{"details", "resource", "id"}));
        if (eventModelId == 0L) {
            return null;
        }
        AbstractEventModel e = (AbstractEventModel)ResourceUtil.getResource((long)eventModelId);
        return ResourceEditorUtil.toMap((Resource)e.getParams());
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String event = e.getEventName();
        Map datas = (Map)Json.toObject((String)e.getEventArgs());
        if ("saveDiagram".equals(event)) {
            this.saveDefineToResources(datas);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"DataFlowEditorFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        } else if ("before_closed".equals(event)) {
            this.beforeClosed(datas);
        } else if ("close".equals(event)) {
            this.closeView();
        } else if ("show_message".equals(event)) {
            this.showTipsFromVue(datas);
        } else if ("queryResources".equals(event)) {
            this.queryResources(datas);
        } else if ("viewResource".equals(event)) {
            this.viewResource(datas);
        } else if ("analyseResource".equals(event)) {
            this.analyseResource(datas);
        } else if ("addResource".equals(event)) {
            this.addResource(datas);
        } else if ("addConnector".equals(event)) {
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_conn_type_selector", (String)ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b", (String)"DataFlowEditorFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), new HashMap(), (String)"new_entry");
        } else {
            throw new UnsupportedOperationException(e.getEventName());
        }
    }

    private void analyseResource(Map<String, Object> datas) {
        List nodes = (List)datas.get("nodes");
        ArrayList<Map<String, Object>> analysisResult = new ArrayList<Map<String, Object>>(nodes.size());
        int index = 1;
        for (Map node : nodes) {
            Map details = (Map)node.get("details");
            Map resource = (Map)details.get("resource");
            long id = D.l(resource.get("id"));
            int node_id = D.i(node.get("id"));
            String resourceType = D.s(node.get("resourceType"));
            analysisResult.add(this.buildOneAnalysis(id, node_id, resourceType, D.s((Object)index)));
            ++index;
        }
        HashMap<String, Object> update = new HashMap<String, Object>(3);
        update.put("action", "analyseResource");
        update.put("analyseResource", System.currentTimeMillis());
        update.put("analysisResult", analysisResult);
        ((CustomControl)this.getControl("editor")).setData(update);
    }

    private Map<String, Object> buildOneAnalysis(long id, int node_id, String resourceType, String index) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_resource_rtm");
        result.put("seq", index);
        result.put("id", res.getString("id"));
        result.put("node_id", node_id);
        DynamicObject type = res.getDynamicObject("type");
        String name = BusinessDataServiceHelper.loadSingle((Object)type.getPkValue(), (String)type.getDataEntityType().getName(), (String)"name").getString("name");
        result.put("type", name);
        result.put("resourceType", resourceType);
        result.put("name", res.getString("name"));
        result.put("number", res.get("number"));
        result.put("categories", this.buildPath(id));
        result.put("dev", res.get("dev_tenant"));
        Map details = ResourceUtil.getMergedDetails((DynamicObject)res);
        Set resourceIds = ResourceUtil.findResourceIds((Map)details);
        if (resourceIds.size() > 0) {
            result.put("children", this.buildChildren(resourceIds, index));
        }
        return result;
    }

    private List<Map<String, Object>> buildChildren(Set<Long> resourceIds, String index) {
        ArrayList<Map<String, Object>> childList = new ArrayList<Map<String, Object>>(resourceIds.size());
        int i = 1;
        for (Long resourceId : resourceIds) {
            childList.add(this.buildOneAnalysis(resourceId, 0, null, index + "." + i));
            ++i;
        }
        return childList;
    }

    private void addResource(Map<String, Object> datas) {
        FormOpener.showForm((AbstractFormPlugin)this, (String)ResourceType.get((String)D.s((Object)datas.get("type"))).getNewFormId(), null, new HashMap(), (String)"addResource");
    }

    private void viewResource(Map<String, Object> datas) {
        String status = this.getModel().getDataEntity().getString("status");
        if ("VIEW".equalsIgnoreCase(status)) {
            ResourceEditorUtil.openResourceViewer1(D.l((Object)datas.get("id")), this);
        } else {
            ResourceEditorUtil.openResourceEditor(D.l((Object)datas.get("id")), this, false, "");
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if ("addResource".equals(evt.getActionId()) && returnData instanceof Map) {
            Map data = (Map)returnData;
            long resource_id = D.l(data.get("id"));
            if (resource_id > 0L) {
                String entityName = "iscx_resource";
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)resource_id, (String)entityName, (String)"id,number,name");
                Map<String, Object> newElSelect = this.createNewElSelect(entityName, object);
                HashMap<String, Object> update = new HashMap<String, Object>(3);
                update.put("action", "addResource");
                update.put("addResource", System.currentTimeMillis());
                update.put("resourceSystemList", DataFlowEditorUtil.getResourceSystems(resource_id));
                update.put("data", newElSelect);
                ((CustomControl)this.getControl("editor")).setData(update);
            }
        } else if ("new_entry".equalsIgnoreCase(evt.getActionId()) && returnData instanceof Map) {
            Map data = (Map)returnData;
            HashMap<String, String> connector = new HashMap<String, String>();
            connector.put("id", D.s(data.get("id")));
            connector.put("connector_number", (String)data.get("connector_number"));
            connector.put("connector_name", (String)data.get("connector_name"));
            connector.put("connector_type", (String)data.get("connector_name"));
            connector.put("connector_remark", (String)data.get("connector_remark"));
            HashMap<String, Object> update = new HashMap<String, Object>(3);
            update.put("action", "afterAddConnector");
            update.put("afterAddConnector", System.currentTimeMillis());
            update.put("connector", connector);
            ((CustomControl)this.getControl("editor")).setData(update);
        } else if ("create_trigger".equalsIgnoreCase(evt.getActionId()) && returnData instanceof Map) {
            this.showTrigger();
        }
    }

    private Map<String, Object> queryCategories() {
        CatalogType[] types = MenuResourceTypeUtil.getMenuForCatalogType("DataWeaver.DataFlow", null);
        ArrayList<String> names = new ArrayList<String>(types.length);
        for (CatalogType type : types) {
            names.add(type.name());
        }
        QFilter qFilter = new QFilter("type", "in", names);
        DynamicObject[] catalogs = BusinessDataServiceHelper.load((String)"iscx_catalog", (String)"type, parent, name", (QFilter[])new QFilter[]{qFilter}, (String)"priority");
        List<Map<String, Object>> cataList = this.buildCataList(catalogs);
        String script = "var cat = " + Json.toString(cataList, (boolean)true) + "; Collection.group(cat, e -> e.parent?.id);";
        Map eval = (Map)Script.compile((String)script).eval();
        eval.remove(null);
        return eval;
    }

    private List<Map<String, Object>> buildCataList(DynamicObject[] catalogs) {
        ArrayList<Map<String, Object>> cataList = new ArrayList<Map<String, Object>>(catalogs.length);
        for (DynamicObject catalog : catalogs) {
            HashMap<String, Object> cc;
            HashMap<String, Object> c = new HashMap<String, Object>();
            c.put("type", catalog.get("type"));
            if (catalog.get("parent") != null) {
                cc = new HashMap<String, Object>();
                cc.put("name", catalog.getDynamicObject("parent").getString("name"));
                cc.put("id", catalog.getDynamicObject("parent").get("id"));
                cc.put("type", catalog.getDynamicObject("parent").get("type"));
                c.put("parent", cc);
            } else {
                cc = new HashMap();
                cc.put("id", "$root");
                c.put("parent", cc);
            }
            c.put("name", catalog.getString("name"));
            c.put("id", catalog.get("id"));
            cataList.add(c);
        }
        return cataList;
    }

    private void saveDefineToResources(Map<String, Object> datas) {
        Map properties = (Map)datas.get("properties");
        String number = D.s(properties.get("number"));
        String name = D.s(properties.get("name"));
        String remark = D.s(properties.get("remark"));
        Map<String, Object> details = DataFlowEditorUtil.getResourceDetails(this);
        Map define = (Map)datas.get("define");
        details.put("define", define);
        details.put("input", this.getStarterModel(define));
        details.put("connectors", properties.get("systemList"));
        long id = this.getResourceId();
        List catalog = (List)properties.get("catalog");
        long l = D.l(catalog.get(catalog.size() - 1));
        DynamicObject iscx_catalog = BusinessDataServiceHelper.loadSingle((Object)l, (String)"iscx_catalog");
        if (id == 0L) {
            id = ResourceEditorUtil.createResource(this.getResourceType(), number, name, remark, iscx_catalog, details);
            this.getView().getPageCache().put("df_res_id", D.s((Object)id));
        } else {
            DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_resource");
            if (ResourceEditorUtil.isUpdatable(res)) {
                ResourceEditorUtil.updateResource(res, number, name, remark, iscx_catalog, details);
            } else {
                DynamicObject ext = BusinessDataServiceHelper.loadSingle((Object)res.get("id"), (String)"iscx_resource_ext");
                if (ResourceEditorUtil.isExtensible(ext)) {
                    Map originalDetails = (Map)Json.toObject((String)((String)res.get("details_tag")));
                    ResourceEditorUtil.extendsResource(ext, details, originalDetails);
                } else {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8d44\u6e90\u662f\u5728\u73af\u5883\uff08%s\uff09\u4e2d\u6269\u5c55\u7684\uff0c\u5728\u5f53\u524d\u73af\u5883\u4e0d\u5141\u8bb8\u4fee\u6539/\u6269\u5c55\u3002", (String)"DataFlowEditorFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), ext.get("ext_tenant")));
                }
            }
        }
    }

    private void beforeClosed(Map<String, Object> vueDefine) {
        String resourceDefine = Json.toString((Object)DataFlowEditorUtil.getResourceDetails(this).get("define"));
        if (!resourceDefine.equals(Json.toString(vueDefine))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("cancel", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u7684\u6d41\u7a0b\u56fe\u5df2\u66f4\u6539\uff0c\u662f\u5426\u653e\u5f03\u4fdd\u5b58\uff1f", (String)"DataFlowEditorFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            this.closeView();
        }
    }

    private void showTipsFromVue(Map<String, Object> datas) {
        if (D.x((Object)datas.get("isSuccess"))) {
            this.getView().showSuccessNotification(D.s((Object)datas.get("message")));
        } else {
            this.getView().showTipNotification(D.s((Object)datas.get("message")));
        }
    }

    private String buildPath(long resource_id) {
        List<String> catalogPath = ResourceEditorUtil.getResourceCatalogPath(resource_id);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : catalogPath) {
            sb.append(s);
            if (++i >= catalogPath.size()) continue;
            sb.append("->");
        }
        return sb.toString();
    }

    private void queryResources(Map<String, Object> datas) {
        String type = D.s((Object)datas.get("type"));
        String entity = "iscx_resource";
        QFilter qFilter = new QFilter("type.number", "=", (Object)type);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)entity, (String)"id,number,name,type", (QFilter[])new QFilter[]{qFilter}, (String)"modifytime desc");
        ArrayList<Map<String, Object>> resources = new ArrayList<Map<String, Object>>(objects.length);
        for (DynamicObject object : objects) {
            Map<String, Object> newElSelect = this.createNewElSelect(object, entity);
            resources.add(newElSelect);
        }
        HashMap<String, Object> update = new HashMap<String, Object>(3);
        update.put("action", "queryResources");
        update.put("queryResources", System.currentTimeMillis());
        update.put("resources", resources);
        ((CustomControl)this.getControl("editor")).setData(update);
    }

    private Map<String, Object> createNewElSelect(DynamicObject object, String entity) {
        try {
            this.checkDataExtractAndEmptyParams(object);
            return this.createNewElSelect(entity, object);
        }
        catch (Exception e) {
            LOG.warn("query  entity failed :" + entity + ":" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
            return this.createNewExceptionElSelect(entity, object, e);
        }
    }

    private void checkDataExtractAndEmptyParams(DynamicObject object) {
        Map details;
        List fields;
        Map detailsByResId;
        long params_id;
        String type = object.getDynamicObject("type").getString("number");
        if (type.startsWith("DataExtract") && (params_id = D.l((Object)ResourceUtil.getValue((Map)(detailsByResId = ResourceUtil.getDetailsByResId((long)object.getLong("id"))), (String[])new String[]{"input", "id"}))) != 0L && ((fields = (List)(details = ResourceUtil.getDetailsByResId((long)params_id)).get("fields")) == null || fields.isEmpty())) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u53c2\u6570\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u5728\u975e\u4e8b\u4ef6\u6a21\u578b\u4e2d\u914d\u7f6e\u3002", (String)"DataFlowEditorFormPlugin_7", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, Object> createNewExceptionElSelect(String entity, DynamicObject object, Exception e) {
        HashMap<String, Object> each = new HashMap<String, Object>();
        each.put("id", D.s((Object)object.get("id")));
        each.put("number", object.get("number"));
        each.put("name", object.getString("name"));
        each.put("type", entity);
        each.put("$ref", Boolean.TRUE);
        each.put("categories", this.buildPath(D.l((Object)object.get("id"))));
        each.put("exception", object.getString("number") + '(' + object.getString("name") + ')' + e.getMessage());
        each.put("isValid", Boolean.FALSE);
        return each;
    }

    private Map<String, Object> createNewElSelect(String entity, DynamicObject object) {
        HashMap<String, Object> each = new HashMap<String, Object>();
        each.put("id", D.s((Object)object.get("id")));
        each.put("number", object.get("number"));
        each.put("name", object.getString("name"));
        each.put("type", entity);
        each.put("$ref", Boolean.TRUE);
        each.put("categories", this.buildPath(D.l((Object)object.get("id"))));
        each.put("systems", DataFlowEditorUtil.getResourceSystems(object.getLong("id")));
        each.put("isValid", Boolean.TRUE);
        return each;
    }

    @Override
    protected boolean isAutoClosed() {
        return false;
    }

    private void sendActionToVue() {
        HashMap<String, Object> actionMap = new HashMap<String, Object>(3);
        actionMap.put("action", "saveDiagram");
        actionMap.put("saveDiagram", System.currentTimeMillis());
        ((CustomControl)this.getControl("editor")).setData(actionMap);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("saveDiagram".equalsIgnoreCase(e.getOperateKey())) {
            this.sendActionToVue();
        } else if ("show_trigger_list".equals(e.getOperateKey())) {
            this.showTrigger();
        } else if ("cancel".equals(e.getOperateKey())) {
            this.cancel();
        } else if ("show_all_resources".equals(e.getOperateKey())) {
            this.showAllResources();
        } else if ("modify".equals(e.getOperateKey())) {
            this.modifyDiagram();
        } else if ("view_detail".equals(e.getOperateKey())) {
            String entityType = (String)this.getView().getFormShowParameter().getCustomParam("entityType");
            long pk_id = (Long)this.getView().getFormShowParameter().getCustomParam("form_id");
            FormOpener.showTabForm((AbstractFormPlugin)this, (String)entityType, (Object)pk_id);
        } else if ("view_error".equals(e.getOperateKey())) {
            long pk_id = (Long)this.getView().getFormShowParameter().getCustomParam("form_id");
            FormOpener.showList((AbstractFormPlugin)this, (String)"iscx_data_stream_log", (String)"data_stream", (Object)pk_id);
        } else if ("view_trace".equals(e.getOperateKey())) {
            long pk_id = (Long)this.getView().getFormShowParameter().getCustomParam("form_id");
            FormOpener.showList((AbstractFormPlugin)this, (String)"iscx_data_stream_trace", (String)"data_stream", (Object)pk_id);
        } else if ("create_trigger".equalsIgnoreCase(e.getOperateKey())) {
            long resourceId = this.getResourceId();
            if (resourceId > 0L) {
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("flow_id", resourceId);
                FormOpener.showAddNew((AbstractFormPlugin)this, (String)"iscx_data_flow_trigger", params, (String)"create_trigger");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6d41\u7a0b\u56fe\u3002", (String)"DataFlowEditorFormPlugin_9", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showAllResources() {
        if (this.isHistory() && !this.isInst()) {
            Map details = (Map)this.getView().getFormShowParameter().getCustomParam("details");
            Set resourceIds = ResourceUtil.findAllResourcesIds((Map)details);
            FormOpener.showList((AbstractFormPlugin)this, (String)"iscx_resource", (QFilter)new QFilter("id", "in", (Object)resourceIds));
        } else {
            long resourceId = this.getResourceId();
            if (resourceId > 0L) {
                Set resourceIds = ResourceUtil.findAllResourcesIds((long)resourceId);
                FormOpener.showList((AbstractFormPlugin)this, (String)"iscx_resource", (QFilter)new QFilter("id", "in", (Object)resourceIds));
            }
        }
    }

    private void cancel() {
        if (this.isReadOnly()) {
            this.getView().close();
        } else {
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            data.put("action", "before_closed");
            data.put("before_closed", System.currentTimeMillis());
            ((CustomControl)this.getControl("editor")).setData(data);
        }
    }

    private void modifyDiagram() {
        this.getView().setStatus(OperationStatus.EDIT);
        this.getModel().setValue("status", (Object)OperationStatus.EDIT.name());
        HashMap<String, Object> update = new HashMap<String, Object>(3);
        update.put("action", "changeEdit");
        update.put("changeEdit", System.currentTimeMillis());
        ((CustomControl)this.getControl("editor")).setData(update);
    }

    private void showTrigger() {
        FormOpener.showList((AbstractFormPlugin)this, (String)"iscx_data_flow_trigger", (QFilter)new QFilter("data_flow_id", "=", (Object)this.getResourceId()));
    }

    @Override
    protected boolean isUsedInTrigger() {
        return true;
    }

    @Override
    protected String getUsedField() {
        return "data_flow_id";
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        if ("cancel".equals(evt.getCallBackId())) {
            this.closeView();
        }
    }

    private void closeView() {
        long id = D.l((Object)this.getPageCache().get("df_res_id"));
        if (id > 0L) {
            HashMap<String, Long> data = new HashMap<String, Long>();
            data.put("id", id);
            this.getView().returnDataToParent(data);
        }
        this.getView().close();
    }
}

