/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.dm;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class EnumValuesEditorFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String old_values = D.s(params.get("old_values"));
        Map map = (Map)Json.toObject((String)old_values);
        if (old_values != null) {
            DynamicObjectCollection enum_values = this.getModel().getDataEntity(true).getDynamicObjectCollection("enum_values");
            enum_values.clear();
            for (Map.Entry entry : map.entrySet()) {
                DynamicObject item = enum_values.addNew();
                item.set("text", entry.getValue());
                item.set("value", entry.getKey());
            }
        }
        if (D.x(params.get("dm_readOnly"))) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "save_enum".equals((oper = (AbstractOperate)args.getSource()).getOperateKey())) {
            DynamicObjectCollection enum_values = this.getModel().getDataEntity(true).getDynamicObjectCollection("enum_values");
            HashMap<String, String> map = new HashMap<String, String>(enum_values.size());
            HashSet<String> errRows = new HashSet<String>();
            for (int i = 0; i < enum_values.size(); ++i) {
                DynamicObject item = (DynamicObject)enum_values.get(i);
                String value = D.s((Object)item.get("value"));
                String key = (String)map.get(value);
                if (key == null) {
                    map.put(value, D.s((Object)(i + 1)));
                    continue;
                }
                errRows.add(value);
            }
            if (!errRows.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u679a\u4e3e\u5206\u5f55\u5b58\u5728\u91cd\u590d\u7684\u679a\u4e3e\u503c\uff1a%s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"EnumValuesEditorFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), Json.toString(errRows, (boolean)true)));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save_enum".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            DynamicObjectCollection enum_values = this.getModel().getDataEntity(true).getDynamicObjectCollection("enum_values");
            HashMap<String, String> map = new HashMap<String, String>(enum_values.size());
            for (DynamicObject enum_value : enum_values) {
                map.put(D.s((Object)enum_value.get("value")), D.s((Object)enum_value.get("text")));
            }
            String toString = Json.toString(map, (boolean)true);
            int max = 2000;
            if (toString != null && toString.length() > max) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u679a\u4e3e\u4fe1\u606f\u8fc7\u591a\uff0c\u8d85\u8fc7\u7236\u9875\u9762\u5b57\u6bb5\u6700\u5927\u957f\u5ea6\uff1a%s\uff0c\u8bf7\u8fdb\u884c\u9002\u5f53\u5220\u51cf\u3002", (String)"EnumValuesEditorFormPlugin_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), max));
                return;
            }
            Map params = this.getView().getFormShowParameter().getCustomParams();
            params.put("new_values", map);
            this.getView().returnDataToParent((Object)params);
            this.getView().close();
        }
    }
}

