/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.dp;

import java.lang.constant.Constable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.ScriptEditorUtil;
import kd.isc.iscx.formplugin.res.dp.DataQueryUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;

public class DataQueryFormPlugin
extends AbstractResourceEditorFormPlugin
implements CellClickListener {
    @Override
    protected String getResourceType() {
        return "DataExtract.DataQuery";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "input", "output");
        ResourceEditorUtil.bindResourceSelector((AbstractFormPlugin)this, "output");
        HashMap<String, Object> openResSelectorParams = new HashMap<String, Object>();
        openResSelectorParams.put("showAddButton", Boolean.TRUE);
        openResSelectorParams.put("addResType", "DataModel.Struct");
        openResSelectorParams.put("editResId", this.getModel().getValue("input_id"));
        ResourceEditorUtil.bindResourceSelector((AbstractFormPlugin)this, null, openResSelectorParams, "input");
        EntryGrid filters = (EntryGrid)this.getControl("filters");
        EntryGrid result_fields = (EntryGrid)this.getControl("result_fields");
        EntryGrid order_by_fields = (EntryGrid)this.getControl("order_by_fields");
        filters.addCellClickListener((CellClickListener)this);
        result_fields.addCellClickListener((CellClickListener)this);
        order_by_fields.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{"filter_column", "filter_value_fixed", "field_name", "sort_field", "ts_field"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        TextEdit source = (TextEdit)evt.getSource();
        String fieldKey = source.getFieldKey();
        try {
            if ("ts_field".equals(fieldKey)) {
                this.showTsFieldSelectForm();
            } else {
                int row = DataQueryUtil.getEntryRowIndex(this, fieldKey);
                DataQueryUtil.showFieldSelectForm(this, this.getModel(), fieldKey, row);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    private void showTsFieldSelectForm() {
        long outputId = this.getModel().getDataEntity().getLong("output_id");
        if (outputId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9 \u201d\u5b9e\u4f53 / \u6570\u636e\u8868 / \u89c6\u56fe\u201c \u6a21\u578b\u3002", (String)"DataQueryFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        } else {
            Resource resource = ResourceUtil.getResource((long)outputId);
            List fields = ((AbstractDataModel)resource).getDataType().getFields();
            if (fields.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u5b9e\u4f53 / \u6570\u636e\u8868 / \u89c6\u56fe\u3011\u6ca1\u6709\u5b57\u6bb5\u53ef\u9009\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataQueryFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Constable> param = new HashMap<String, Constable>();
            param.put("resourceId", Long.valueOf(outputId));
            param.put("single", Boolean.TRUE);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u65f6\u95f4\u6233\u5b57\u6bb5", (String)"DataQueryFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)"ts_field");
        }
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        IDataModel model = this.getModel();
        model.setValue("ts_field", details.get("ts_field"));
        ScriptEditorUtil.bindDataModel2(details, model);
        DataQueryUtil.setDefaultInputModel(model);
        model.setValue("filters", (Object)DataQueryUtil.toObjectCollection((List)details.get("filters"), "filters", model));
        model.setValue("result_fields", (Object)DataQueryUtil.toObjectCollection((List)details.get("result_fields"), "result_fields", model));
        model.setValue("order_by_fields", (Object)DataQueryUtil.toObjectCollection((List)details.get("order_by_fields"), "order_by_fields", model));
        if (EditorMode.EXTENDS == mode) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output", "ts_field"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"auto_fill"});
        }
    }

    @Override
    protected void lockModel() {
        super.lockModel();
        this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output"});
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        IDataModel model = this.getModel();
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("ts_field", model.getValue("ts_field"));
        ScriptEditorUtil.collectDataModel2(details, model);
        details.put("filters", DataQueryUtil.toList(model, "filters"));
        details.put("result_fields", DataQueryUtil.toList(model, "result_fields"));
        details.put("order_by_fields", DataQueryUtil.toList(model, "order_by_fields"));
        return details;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("auto_fill".equals(e.getOperateKey())) {
            DataQueryUtil.autofill(this.getView(), this.getModel());
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equals(operationKey)) {
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("result_fields");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DynamicObject obj = (DynamicObject)iterator.next();
                if (D.s((Object)obj.get("field_name")) != null) continue;
                iterator.remove();
            }
            this.getView().updateView("result_fields");
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        try {
            DataQueryUtil.showFieldSelectForm(this, this.getModel(), fieldKey, row);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        try {
            ResourceEditorUtil.closedResourceSelector(this, closedCallBackEvent);
            Object returnData = closedCallBackEvent.getReturnData();
            if (action.equals("filters") || action.equals("result_fields") || action.equals("order_by_fields")) {
                DataQueryUtil.setFields(this.getModel(), this.getView(), returnData, action);
            } else if ("filter_value_fixed".equals(action)) {
                DataQueryUtil.setFilterFixedValue(this.getModel(), this.getView(), returnData);
            } else if ("ts_field".equals(action)) {
                this.setTsField(returnData);
            }
        }
        catch (Throwable e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void setTsField(Object returnData) {
        if (returnData instanceof List) {
            Map data = (Map)((List)returnData).get(0);
            String fullnumber = D.s(data.get("fullnumber"));
            this.getModel().setValue("ts_field", (Object)fullnumber);
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("result_fields");
            Set<String> existedFieldSet = DataQueryUtil.getExistedFieldSet(entries, "result_fields");
            if (!existedFieldSet.contains(fullnumber)) {
                DynamicObject resultField = entries.addNew();
                DataQueryUtil.mapToEntry("result_fields", data, fullnumber, resultField);
                this.getView().updateView("result_fields");
            }
        }
    }
}

