/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.dp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.ScriptEditorUtil;
import kd.isc.iscx.formplugin.res.dp.DataQueryUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dt.Field;

public class DataReadFormPlugin
extends AbstractResourceEditorFormPlugin
implements CellClickListener {
    @Override
    protected String getResourceType() {
        return "DataExtract.DataRead";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "input", "output");
        ResourceEditorUtil.bindResourceSelector((AbstractFormPlugin)this, "output");
        ResourceEditorUtil.bindResourceSelector((AbstractFormPlugin)this, "input");
        EntryGrid filters = (EntryGrid)this.getControl("filters");
        EntryGrid fields = (EntryGrid)this.getControl("result_fields");
        filters.addCellClickListener((CellClickListener)this);
        fields.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{"filter_column", "filter_value_fixed", "field_name"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        try {
            TextEdit source = (TextEdit)evt.getSource();
            String fieldKey = source.getFieldKey();
            int row = DataQueryUtil.getEntryRowIndex(this, fieldKey);
            DataQueryUtil.showFieldSelectForm(this, this.getModel(), fieldKey, row);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        IDataModel model = this.getModel();
        if (!details.isEmpty()) {
            model.setValue("batch_size", details.get("batch_size"));
            ScriptEditorUtil.bindDataModel2(details, model);
            model.setValue("filters", (Object)DataQueryUtil.toObjectCollection((List)details.get("filters"), "filters", model));
            model.setValue("result_fields", (Object)DataQueryUtil.toObjectCollection((List)details.get("result_fields"), "result_fields", model));
        }
        if (EditorMode.EXTENDS == mode) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"auto_fill"});
        }
    }

    @Override
    protected void lockModel() {
        super.lockModel();
        this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output"});
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        IDataModel model = this.getModel();
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("batch_size", model.getValue("batch_size"));
        ScriptEditorUtil.collectDataModel2(details, model);
        details.put("filters", DataQueryUtil.toList(model, "filters"));
        details.put("result_fields", DataQueryUtil.toList(model, "result_fields"));
        return details;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("auto_fill".equals(e.getOperateKey())) {
            DataQueryUtil.autofill(this.getView(), this.getModel());
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        try {
            DataQueryUtil.showFieldSelectForm(this, this.getModel(), fieldKey, row);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        try {
            ResourceEditorUtil.closedResourceSelector(this, closedCallBackEvent);
            Object returnData = closedCallBackEvent.getReturnData();
            if (action.equals("filters") || action.equals("result_fields") || action.equals("order_by_fields")) {
                DataQueryUtil.setFields(this.getModel(), this.getView(), returnData, action);
            } else if ("filter_value_fixed".equals(action)) {
                DataQueryUtil.setFilterFixedValue(this.getModel(), this.getView(), returnData);
            }
        }
        catch (Throwable e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel m;
        super.propertyChanged(e);
        if ("output".equals(e.getProperty().getName())) {
            IDataModel m2 = this.getModel();
            DynamicObject output = (DynamicObject)m2.getValue("output");
            if (output != null) {
                m2.setValue("input", (Object)output);
                AbstractDataModel res = (AbstractDataModel)ResourceUtil.getResource((long)output.getLong("id"));
                ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>(4);
                for (Field f : res.getDataType().getPrimaryKeyFields()) {
                    HashMap<String, String> filter = new HashMap<String, String>();
                    filter.put("filter_column", f.getName());
                    filter.put("filter_label", f.getLabel());
                    filter.put("filter_compare", "=");
                    filter.put("filter_value_fixed", "<%" + f.getName() + "%>");
                    filter.put("param_label", f.getLabel());
                    filters.add(filter);
                }
                m2.setValue("filters", (Object)DataQueryUtil.toObjectCollection(filters, "filters", m2));
                this.getView().updateView("filters");
            }
        } else if ("input".equals(e.getProperty().getName()) && !Objects.equals((m = this.getModel()).getValue("input_id"), m.getValue("output_id"))) {
            m.setValue("filters", (Object)DataQueryUtil.toObjectCollection(Collections.emptyList(), "filters", m));
            this.getView().updateView("filters");
        }
    }
}

