/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.dp;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.ScriptEditorUtil;
import kd.isc.iscx.formplugin.res.dp.DataQueryUtil;
import kd.isc.iscx.formplugin.res.dp.ReferReadFormPlugin;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dm.DataComb;

public class EntriesReadFormPlugin
extends AbstractResourceEditorFormPlugin {
    @Override
    protected String getResourceType() {
        return "DataExtract.EntriesRead";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "data_model");
        ResourceEditorUtil.bindResourceSelector((AbstractFormPlugin)this, "data_model");
        this.addClickListeners(new String[]{"field_name", "entry_sort_field", "master_pk_field", "entry_fk_field", "entries_model"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String fieldKey = ((Control)source).getKey();
        try {
            if (fieldKey.startsWith("entry")) {
                this.showEntryFieldSelector(fieldKey);
            } else if (fieldKey.startsWith("master")) {
                this.showMasterFieldSelector(fieldKey);
            } else if (fieldKey.equals("field_name")) {
                this.showResultFieldSelector(fieldKey);
            } else if (fieldKey.equals("entries_model")) {
                this.showEntriesModel();
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    private void showEntriesModel() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long dataModel = dataEntity.getLong("data_model_id");
        Map detailsByResId = ResourceUtil.getDetailsByResId((long)dataModel);
        List relations = (List)detailsByResId.get("relations");
        for (Map relation : relations) {
            if (!relation.get("field_alias").equals(dataEntity.getString("entry_alias"))) continue;
            long id = D.l((Object)ResourceUtil.getValue((Map)relation, (String[])new String[]{"relation_model", "id"}));
            ResourceEditorUtil.openResourceViewer(id, this);
            break;
        }
    }

    private void showResultFieldSelector(String fieldKey) {
        long resId = this.getEntryModelResId();
        if (resId > 0L) {
            HashMap<String, Constable> param = new HashMap<String, Constable>();
            param.put("resourceId", Long.valueOf(resId));
            param.put("single", Boolean.TRUE);
            int row = this.getModel().getEntryCurrentRowIndex("result_fields");
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"DataQueryFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)("SELECT_FOR:" + fieldKey + "," + row));
        }
    }

    private void showMasterFieldSelector(String fieldKey) {
        DataComb res = this.getDataCombRes();
        if (res != null) {
            HashMap<String, Constable> param = new HashMap<String, Constable>();
            param.put("resourceId", Long.valueOf(res.getMainModel().getId()));
            param.put("single", Boolean.TRUE);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"DataQueryFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)("SELECT_FOR:" + fieldKey));
        }
    }

    private void showEntryFieldSelector(String fieldKey) {
        long resId = this.getEntryModelResId();
        if (resId > 0L) {
            HashMap<String, Constable> param = new HashMap<String, Constable>();
            param.put("resourceId", Long.valueOf(resId));
            param.put("single", Boolean.TRUE);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"DataQueryFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)("SELECT_FOR:" + fieldKey));
        }
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        IDataModel model = this.getModel();
        if (!details.isEmpty()) {
            model.setValue("batch_size", details.get("batch_size"));
            ScriptEditorUtil.bindDataModel(details, model);
            model.setValue("result_fields", (Object)DataQueryUtil.toObjectCollection((List)details.get("result_fields"), "result_fields", model));
            DataComb res = this.getDataCombRes();
            if (res != null) {
                this.initEntryAliasOptions(res);
            }
            model.setValue("entry_alias", details.get("entry_alias"));
            model.setValue("master_pk_field", details.get("master_pk_field"));
            model.setValue("entry_fk_field", details.get("entry_fk_field"));
            model.setValue("entry_sort_field", details.get("entry_sort_field"));
        }
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        IDataModel model = this.getModel();
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("batch_size", model.getValue("batch_size"));
        ScriptEditorUtil.collectDataModel(details, model);
        details.put("result_fields", DataQueryUtil.toList(model, "result_fields"));
        details.put("entry_alias", model.getValue("entry_alias"));
        details.put("master_pk_field", model.getValue("master_pk_field"));
        details.put("entry_fk_field", model.getValue("entry_fk_field"));
        details.put("entry_sort_field", model.getValue("entry_sort_field"));
        return details;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String action = e.getActionId();
        try {
            if ("resource_select_closed_key".equals(action) && e.getReturnData() instanceof Map) {
                this.getModel().setValue("data_model", ((Map)e.getReturnData()).get("id"));
            } else if (action.startsWith("SELECT_FOR:") && e.getReturnData() instanceof List) {
                ReferReadFormPlugin.setSelectedField(this.getModel(), e, action);
            } else if ("APPEND_RESULT_FIELDS".equals(action) && e.getReturnData() instanceof List) {
                ReferReadFormPlugin.appendSelectedResultFields(e, this.getModel(), this.getView());
            }
        }
        catch (Throwable err) {
            this.getView().showTipNotification(StringUtil.getCascadeMessage((Throwable)err));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("data_model".equals(propertyName)) {
            this.clearResultFields();
            this.clearEntryFields();
            this.getModel().setValue("entry_alias", (Object)"");
            DataComb res = this.getDataCombRes();
            if (res != null) {
                this.getModel().setValue("master_pk_field", (Object)res.getDataType().getPrimaryKey().getName());
                this.initEntryAliasOptions(res);
            }
        } else if ("entry_alias".equals(propertyName)) {
            this.clearResultFields();
            this.clearEntryFields();
        }
    }

    private void clearEntryFields() {
        this.getModel().setValue("entry_fk_field", (Object)"");
        this.getModel().setValue("entry_sort_field", (Object)"");
    }

    private void initEntryAliasOptions(DataComb res) {
        ComboEdit combo = (ComboEdit)this.getView().getControl("entry_alias");
        Map entryModels = res.getEntryModels();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(entryModels.size());
        for (Map.Entry i : entryModels.entrySet()) {
            ComboItem item = new ComboItem();
            AbstractDataModel m = (AbstractDataModel)i.getValue();
            item.setCaption(new LocaleString((String)i.getKey() + " - " + m.getName()));
            item.setValue((String)i.getKey());
            items.add(item);
        }
        combo.setComboItems(items);
    }

    private DataComb getDataCombRes() {
        DynamicObject obj = (DynamicObject)this.getModel().getValue("data_model");
        if (obj == null) {
            return null;
        }
        return (DataComb)ResourceUtil.getResource((long)obj.getLong("id"));
    }

    private long getEntryModelResId() {
        DataComb res = this.getDataCombRes();
        if (res == null) {
            return 0L;
        }
        AbstractDataModel entry = (AbstractDataModel)res.getEntryModels().get(this.getModel().getValue("entry_alias"));
        return entry == null ? 0L : entry.getId();
    }

    private void clearResultFields() {
        DynamicObjectCollection fields = this.getModel().getDataEntity(true).getDynamicObjectCollection("result_fields");
        fields.clear();
        this.getModel().setValue("result_fields", (Object)fields);
        this.getView().updateView("result_fields");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs a) {
        long resId;
        super.beforeDoOperation(a);
        if (a.getSource() instanceof NewEntry && (resId = this.getEntryModelResId()) > 0L) {
            a.setCancel(true);
            HashMap<String, Constable> param = new HashMap<String, Constable>();
            param.put("resourceId", Long.valueOf(resId));
            param.put("single", Boolean.FALSE);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"DataQueryFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)"APPEND_RESULT_FIELDS");
        }
    }
}

