/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.dp;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.ScriptEditorUtil;
import kd.isc.iscx.formplugin.res.dp.DataQueryUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dm.DataComb;
import kd.isc.iscx.platform.core.res.meta.dt.Field;

public class ReferReadFormPlugin
extends AbstractResourceEditorFormPlugin {
    @Override
    protected String getResourceType() {
        return "DataExtract.ReferRead";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "data_model");
        ResourceEditorUtil.bindResourceSelector((AbstractFormPlugin)this, "data_model");
        this.addClickListeners(new String[]{"field_name", "master_fk_field", "ref_pk_field"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        TextEdit source = (TextEdit)evt.getSource();
        String fieldKey = source.getFieldKey();
        try {
            if (fieldKey.startsWith("ref")) {
                this.showRefDataFieldSelector(fieldKey);
            } else if (fieldKey.startsWith("master")) {
                this.showMasterFieldSelector(fieldKey);
            } else if (fieldKey.equals("field_name")) {
                this.showResultFieldSelector(fieldKey);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    private void showResultFieldSelector(String fieldKey) {
        long resId = this.getRefModelResId();
        if (resId > 0L) {
            HashMap<String, Constable> param = new HashMap<String, Constable>();
            param.put("resourceId", Long.valueOf(resId));
            param.put("single", Boolean.TRUE);
            int row = this.getModel().getEntryCurrentRowIndex("result_fields");
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"DataQueryFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)("SELECT_FOR:" + fieldKey + "," + row));
        }
    }

    private void showMasterFieldSelector(String fieldKey) {
        DataComb res = this.getDataCombRes();
        if (res != null) {
            HashMap<String, Constable> param = new HashMap<String, Constable>();
            param.put("resourceId", Long.valueOf(res.getMainModel().getId()));
            param.put("single", Boolean.TRUE);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"DataQueryFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)("SELECT_FOR:" + fieldKey));
        }
    }

    private void showRefDataFieldSelector(String fieldKey) {
        long resId = this.getRefModelResId();
        if (resId > 0L) {
            HashMap<String, Constable> param = new HashMap<String, Constable>();
            param.put("resourceId", Long.valueOf(resId));
            param.put("single", Boolean.TRUE);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"DataQueryFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)("SELECT_FOR:" + fieldKey));
        }
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        IDataModel model = this.getModel();
        if (!details.isEmpty()) {
            model.setValue("batch_size", details.get("batch_size"));
            ScriptEditorUtil.bindDataModel(details, model);
            model.setValue("result_fields", (Object)DataQueryUtil.toObjectCollection((List)details.get("result_fields"), "result_fields", model));
            DataComb res = this.getDataCombRes();
            if (res != null) {
                this.initRefAliasOptions(res);
            }
            model.setValue("ref_alias", details.get("ref_alias"));
            model.setValue("master_fk_field", details.get("master_fk_field"));
            model.setValue("ref_pk_field", details.get("ref_pk_field"));
        }
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        IDataModel model = this.getModel();
        HashMap<String, Object> details = new HashMap<String, Object>();
        ScriptEditorUtil.collectDataModel(details, model);
        details.put("batch_size", model.getValue("batch_size"));
        details.put("result_fields", DataQueryUtil.toList(model, "result_fields"));
        details.put("ref_alias", model.getValue("ref_alias"));
        details.put("master_fk_field", model.getValue("master_fk_field"));
        details.put("ref_pk_field", model.getValue("ref_pk_field"));
        return details;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String action = e.getActionId();
        try {
            if ("resource_select_closed_key".equals(action) && e.getReturnData() instanceof Map) {
                this.getModel().setValue("data_model", ((Map)e.getReturnData()).get("id"));
            } else if (action.startsWith("SELECT_FOR:") && e.getReturnData() instanceof List) {
                ReferReadFormPlugin.setSelectedField(this.getModel(), e, action);
            } else if ("APPEND_RESULT_FIELDS".equals(action) && e.getReturnData() instanceof List) {
                ReferReadFormPlugin.appendSelectedResultFields(e, this.getModel(), this.getView());
            }
        }
        catch (Throwable err) {
            this.getView().showTipNotification(StringUtil.getCascadeMessage((Throwable)err));
        }
    }

    static void appendSelectedResultFields(ClosedCallBackEvent e, IDataModel model, IFormView view) {
        DynamicObjectCollection fields = model.getDataEntity(true).getDynamicObjectCollection("result_fields");
        HashSet<String> exists = new HashSet<String>();
        for (DynamicObject field : fields) {
            exists.add(field.getString("field_name"));
        }
        List list = (List)e.getReturnData();
        for (Map item : list) {
            Object field_name = item.get("fullnumber");
            if (exists.contains(field_name)) continue;
            DynamicObject field = fields.addNew();
            field.set("field_name", field_name);
            field.set("data_type", item.get("type"));
            field.set("field_label", item.get("fulllabel"));
        }
        model.setValue("result_fields", (Object)fields);
        view.updateView("result_fields");
    }

    static void setSelectedField(IDataModel model, ClosedCallBackEvent e, String action) {
        List list = (List)e.getReturnData();
        if (!list.isEmpty()) {
            int i = action.indexOf(58);
            int j = action.indexOf(44);
            Map map = (Map)list.get(0);
            if (j < 0) {
                String field = action.substring(i + 1);
                model.setValue(field, map.get("fullnumber"));
            } else {
                int row = Integer.parseInt(action.substring(j + 1));
                model.setValue("field_name", map.get("fullnumber"), row);
                model.setValue("data_type", map.get("type"), row);
                model.setValue("field_label", map.get("fulllabel"), row);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("data_model".equals(propertyName)) {
            this.clearResultFields();
            this.getModel().setValue("ref_alias", (Object)"");
            this.getModel().setValue("ref_pk_field", (Object)"");
            this.getModel().setValue("master_fk_field", (Object)"");
            DataComb res = this.getDataCombRes();
            if (res != null) {
                this.initRefAliasOptions(res);
            }
        } else if ("ref_alias".equals(propertyName)) {
            AbstractDataModel res;
            Field pk;
            this.clearResultFields();
            long resId = this.getRefModelResId();
            if (resId > 0L && (pk = (res = (AbstractDataModel)ResourceUtil.getResource((long)resId)).getDataType().getPrimaryKey()) != null) {
                this.getModel().setValue("ref_pk_field", (Object)pk.getName());
            }
        }
    }

    private void initRefAliasOptions(DataComb res) {
        ComboEdit combo = (ComboEdit)this.getView().getControl("ref_alias");
        Map refModels = res.getRefModels();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(refModels.size());
        for (Map.Entry i : refModels.entrySet()) {
            ComboItem item = new ComboItem();
            AbstractDataModel m = (AbstractDataModel)i.getValue();
            item.setCaption(new LocaleString((String)i.getKey() + " - " + m.getName()));
            item.setValue((String)i.getKey());
            items.add(item);
        }
        combo.setComboItems(items);
    }

    private DataComb getDataCombRes() {
        DynamicObject obj = (DynamicObject)this.getModel().getValue("data_model");
        if (obj == null) {
            return null;
        }
        return (DataComb)ResourceUtil.getResource((long)obj.getLong("id"));
    }

    private long getRefModelResId() {
        DataComb res = this.getDataCombRes();
        if (res == null) {
            return 0L;
        }
        AbstractDataModel ref = (AbstractDataModel)res.getRefModels().get(this.getModel().getValue("ref_alias"));
        return ref == null ? 0L : ref.getId();
    }

    private void clearResultFields() {
        DynamicObjectCollection fields = this.getModel().getDataEntity(true).getDynamicObjectCollection("result_fields");
        fields.clear();
        this.getModel().setValue("result_fields", (Object)fields);
        this.getView().updateView("result_fields");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs a) {
        long resId;
        super.beforeDoOperation(a);
        if (a.getSource() instanceof NewEntry && (resId = this.getRefModelResId()) > 0L) {
            a.setCancel(true);
            HashMap<String, Constable> param = new HashMap<String, Constable>();
            param.put("resourceId", Long.valueOf(resId));
            param.put("single", Boolean.FALSE);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"DataQueryFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)"APPEND_RESULT_FIELDS");
        }
    }
}

