/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.dp;

import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ScriptCommonUtil;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.ScriptEditorUtil;
import kd.isc.iscx.formplugin.res.dp.DataQueryUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;

public class ScriptQueryFormPlugin
extends AbstractResourceEditorFormPlugin {
    @Override
    protected String getResourceType() {
        return "DataExtract.ScriptQuery";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_open_script_editor"});
        ResourceEditorUtil.bindResourceDetailsViewer(this, "input", "output", "function_ref");
        ResourceEditorUtil.bindResourceSelector((AbstractFormPlugin)this, "output");
        HashMap<String, Object> openResSelectorParams = new HashMap<String, Object>();
        openResSelectorParams.put("showAddButton", Boolean.TRUE);
        openResSelectorParams.put("addResType", "DataModel.Struct");
        ResourceEditorUtil.bindResourceSelector((AbstractFormPlugin)this, null, openResSelectorParams, "input");
        this.addClickListeners(new String[]{"ts_field"});
    }

    @Override
    protected void lockModel() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof TextEdit) {
            if ("ts_field".equals(((TextEdit)src).getKey())) {
                this.showTsFieldSelectForm();
            }
        } else if (src instanceof Button && "btn_open_script_editor".equals(((Button)src).getKey())) {
            this.openScriptEditor();
        }
    }

    private void showTsFieldSelectForm() {
        long outputId = this.getModel().getDataEntity().getLong("output_id");
        if (outputId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9 \u201d\u8f93\u51fa\u7ed3\u679c\u884c\u63cf\u8ff0\u201c \u6a21\u578b\u3002", (String)"ScriptQueryFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        } else {
            Resource resource = ResourceUtil.getResource((long)outputId);
            List fields = ((AbstractDataModel)resource).getDataType().getFields();
            if (fields.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u8f93\u51fa\u7ed3\u679c\u884c\u63cf\u8ff0\u3011\u6ca1\u6709\u5b57\u6bb5\u53ef\u9009\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScriptQueryFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Constable> param = new HashMap<String, Constable>();
            param.put("resourceId", Long.valueOf(outputId));
            param.put("single", Boolean.TRUE);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u65f6\u95f4\u6233\u5b57\u6bb5", (String)"ScriptQueryFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)"ts_field");
        }
    }

    private void openScriptEditor() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("remark", this.getModel().getValue("script"));
        params.put("script", this.getModel().getValue("script_tag"));
        params.put("billStatus", this.getView().getFormShowParameter().getStatus());
        params.put("env", "data_copy_query_script");
        HashMap<String, String> dataModelVars = new HashMap<String, String>();
        dataModelVars.put("params", "input");
        ScriptEditorUtil.setScriptEditorTips(this, params, Arrays.asList("params", "$src"), dataModelVars, false);
        FormOpener.showForm((AbstractFormPlugin)this, (String)ScriptCommonUtil.getEditor(), (String)ResManager.loadKDString((String)"\u811a\u672c\u7f16\u8f91", (String)"ScriptQueryFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), params, (String)"get_script");
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        ResourceEditorUtil.closedResourceSelector(this, e);
        if ("get_script".equals(e.getActionId())) {
            Map params = (Map)e.getReturnData();
            if (params != null) {
                this.getModel().setValue("script", params.get("remark"));
                this.getModel().setValue("script_tag", params.get("script"));
                this.getView().updateView("script_tag");
            }
        } else if ("ts_field".equals(e.getActionId()) && (returnData = e.getReturnData()) instanceof List) {
            Map data = (Map)((List)returnData).get(0);
            this.getModel().setValue("ts_field", data.get("fullnumber"));
        }
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        IDataModel model = this.getModel();
        model.setValue("ts_field", details.get("ts_field"));
        ScriptEditorUtil.bindDataModel2(details, model);
        DataQueryUtil.setDefaultInputModel(model);
        ScriptEditorUtil.bindScript(details, model);
        ScriptEditorUtil.bindDepends(details, model);
        ScriptEditorUtil.bindWebApiDepends(details, model);
        this.getView().updateView("depends");
        this.getView().updateView("web_api_depends");
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        IDataModel model = this.getModel();
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("ts_field", model.getValue("ts_field"));
        ScriptEditorUtil.collectDataModel2(details, model);
        ScriptEditorUtil.collectScript(details, model);
        ScriptEditorUtil.collectDepends(details, model);
        ScriptEditorUtil.collectWebApiDepends(details, model);
        return details;
    }
}

