/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.ds;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.ListType;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;
import kd.isc.iscx.platform.core.res.runtime.util.Util;

public class DataLoaderFormPlugin
extends AbstractResourceEditorFormPlugin
implements CellClickListener {
    @Override
    protected String getResourceType() {
        throw new UnsupportedOperationException("todo-extends");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "input");
        EntryGrid fields = (EntryGrid)this.getView().getControl("fields");
        this.addClickListeners(new String[]{"field_name"});
        fields.addCellClickListener((CellClickListener)this);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        try {
            if ("checkandsave".equals(operationKey)) {
                this.checkCandidateKey(args);
            }
        }
        catch (Throwable e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    private void checkCandidateKey(BeforeDoOperationEventArgs args) {
        Set<String> candidateKeys = this.getAllCandidateKeys();
        Map<String, Object> multiLevelCandiKey = this.groupByFieldName(candidateKeys);
        HashSet<String> errorFields = new HashSet<String>();
        StructSchema structSchema = this.getEntitySchema();
        this.innerCheckCandidateKeyRecursively(structSchema, "", multiLevelCandiKey, errorFields);
        if (errorFields.size() > 0) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("confirmSave");
            this.getView().showConfirm(this.buildTipMsg(candidateKeys, errorFields), MessageBoxOptions.YesNo, confirmCallBackListener);
        } else {
            this.getView().invokeOperation("save");
        }
    }

    private String buildTipMsg(Set<String> candidateKeys, Set<String> errorFields) {
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5019\u9009\u952e\u53ef\u80fd\u5bfc\u81f4\u5b9e\u4f53\u64cd\u4f5c\u5931\u8d25\uff1a", (String)"DataLoaderFormPlugin_9", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        for (String candidateKey : candidateKeys) {
            for (String errorField : errorFields) {
                if (!candidateKey.startsWith(errorField)) continue;
                sb.append("\r\n");
                sb.append(candidateKey);
            }
        }
        sb.append("\r\n").append(ResManager.loadKDString((String)"\u5019\u9009\u952e\u9664\u4e86\u5206\u5f55\u5b57\u6bb5\uff0c\u5176\u4ed6\u7c7b\u578b\u5b57\u6bb5\u540e\u7f00\u5747\u4e0d\u80fd\u6709\u201c.\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f", (String)"DataLoaderFormPlugin_10", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        return sb.toString();
    }

    private StructSchema getEntitySchema() {
        long entityId = this.getModel().getDataEntity().getLong("input_id");
        Resource resource = ResourceUtil.getResource((long)entityId);
        return ((AbstractDataModel)resource).getDataType();
    }

    private void innerCheckCandidateKeyRecursively(StructSchema structSchema, String prefix, Map<String, Object> multiLevelCandiKey, Set<String> errorFields) {
        for (Map.Entry<String, Object> entry : multiLevelCandiKey.entrySet()) {
            String fieldName = entry.getKey();
            Object value = entry.getValue();
            String fullName = prefix + fieldName;
            if (!(value instanceof Map)) continue;
            Field field = structSchema.getField(fieldName);
            if (field.isEntriesType()) {
                ListType listType = (ListType)field.getType();
                this.innerCheckCandidateKeyRecursively((StructSchema)listType.getElementType(), fullName + ".", (Map)value, errorFields);
                continue;
            }
            errorFields.add(fullName);
        }
    }

    private Map<String, Object> groupByFieldName(Set<String> candidateKeys) {
        HashMap<String, Object> multiLevelCandiKey = new HashMap<String, Object>();
        for (String candidateKey : candidateKeys) {
            SQLUtil.addEntryProperty(multiLevelCandiKey, (String[])candidateKey.split("\\."));
        }
        return multiLevelCandiKey;
    }

    private Set<String> getAllCandidateKeys() {
        HashSet<String> candidateKeys = new HashSet<String>();
        DynamicObjectCollection fields = this.getModel().getDataEntity(true).getDynamicObjectCollection("fields");
        for (DynamicObject field : fields) {
            String fieldName = D.s((Object)field.get("field_name"));
            if (fieldName == null || !fieldName.contains(".") || !D.x((Object)field.get("is_candidate_key"))) continue;
            candidateKeys.add(fieldName);
        }
        return candidateKeys;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("auto_fill".equals(args.getOperateKey())) {
            try {
                this.autofill();
            }
            catch (Throwable e) {
                FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
            }
        } else if ("json_import".equals(args.getOperateKey())) {
            long inputId = this.getModel().getDataEntity().getLong("input_id");
            if (inputId == 0L) {
                this.getView().showTipNotification(this.getTipMessage(), Integer.valueOf(5000));
            } else {
                FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_json_import", (String)ResManager.loadKDString((String)"\u4ecejson\u793a\u4f8b\u6570\u636e\u89e3\u6790\u5b57\u6bb5", (String)"DataLoaderFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), null, (String)"json_import");
            }
        } else if ("fill_from_mapping".equals(args.getOperateKey())) {
            long inputId = this.getModel().getDataEntity().getLong("input_id");
            if (inputId == 0L) {
                this.getView().showTipNotification(this.getTipMessage(), Integer.valueOf(5000));
            } else {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("fill_from_mapping");
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5\u6620\u5c04\u7ec4\u4ef6\uff0c\u5e76\u6839\u636e\u6620\u5c04\u7ed3\u679c\u81ea\u52a8\u586b\u5145\u5b57\u6bb5\u4fe1\u606f\u3002\u6b64\u64cd\u4f5c\u5c06\u6e05\u7a7a\u5df2\u6709\u5b57\u6bb5\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DataLoaderFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("fill_from_mapping".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            long inputId = this.getModel().getDataEntity().getLong("input_id");
            QFilter filter = new QFilter("type", "=", (Object)"DataMapping.FieldMapping");
            filter.and("output_data_model", "=", (Object)inputId);
            FormOpener.showF7((AbstractFormPlugin)this, (String)"iscx_resource", (QFilter[])new QFilter[]{filter}, (String)"fill_from_mapping", (boolean)false);
        } else if ("confirmSave".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getView().invokeOperation("save");
        }
    }

    private void autofill() {
        long entityId = D.l((Object)this.getModel().getValue("input_id"));
        if (entityId != 0L) {
            List fieldList = Util.getAllFields((long)entityId);
            DynamicObjectCollection fields = this.getModel().getDataEntity(true).getDynamicObjectCollection("fields");
            this.getModel().setValue("fields", (Object)ResourceEditorUtil.toObjectCollection(fields, fieldList));
            this.getView().updateView("fields");
        } else {
            this.getView().showTipNotification(this.getTipMessage());
        }
    }

    protected String getTipMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6a21\u578b\u3002", (String)"DataLoaderFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]);
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        this.bindEntries(details);
    }

    protected void bindEntries(Map<String, Object> details) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection fieldEntries = dataEntity.getDynamicObjectCollection("fields");
        List fieldList = (List)details.get("fields");
        model.setValue("fields", (Object)ResourceEditorUtil.toObjectCollection(fieldEntries, fieldList));
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        throw new UnsupportedOperationException("todo-extends");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("field_name")) {
            EntryGrid grid = (EntryGrid)this.getControl("fields");
            int selectRow = grid.getSelectRows()[0];
            this.openSelectFieldForm(selectRow);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if ("field_name".equals(fieldKey)) {
            this.openSelectFieldForm(cellClickEvent.getRow());
        }
    }

    private void openSelectFieldForm(int row) {
        long entityId = this.getModel().getDataEntity().getLong("input_id");
        if (entityId == 0L) {
            this.getView().showTipNotification(this.getTipMessage(), Integer.valueOf(5000));
            return;
        }
        Resource resource = ResourceUtil.getResource((long)entityId);
        List fields = ((AbstractDataModel)resource).getDataType().getFields();
        if (fields.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u76ee\u6807\u8d44\u6e90\u6a21\u578b\u3011\u6ca1\u6709\u5b57\u6bb5\u53ef\u9009\uff0c\u8bf7\u68c0\u67e5", (String)"DataLoaderFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        HashMap<String, Integer> customData = new HashMap<String, Integer>();
        customData.put("row", row);
        param.put("customData", customData);
        param.put("resourceId", Long.valueOf(entityId));
        FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"DataLoaderFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)"setFields");
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        try {
            ListSelectedRowCollection selectedRows;
            if (action.equals("setFields")) {
                Object returnData = closedCallBackEvent.getReturnData();
                this.setFields(returnData);
            } else if (action.equals("json_import")) {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData != null) {
                    this.compareFieldAndSetFields((List)returnData.get("jsonTag"));
                }
            } else if (action.equals("fill_from_mapping") && (selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()) != null && !selectedRows.isEmpty()) {
                this.fillFieldsFromMapping(D.l((Object)selectedRows.get(0).getPrimaryKeyValue()));
            }
        }
        catch (Throwable e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void fillFieldsFromMapping(long fieldMappingId) {
        long inputId = this.getModel().getDataEntity().getLong("input_id");
        ArrayList<Map<String, Object>> commonFields = new ArrayList<Map<String, Object>>();
        List allFields = Util.getAllFields((long)inputId);
        HashMap<String, Map> fieldMap = new HashMap<String, Map>(allFields.size());
        for (Map f : allFields) {
            fieldMap.put(D.s(f.get("field_name")), f);
        }
        Map details = ResourceUtil.getDetailsByResId((long)fieldMappingId);
        List mapping_entries = (List)details.get("mapping_entries");
        for (Map map : mapping_entries) {
            String tarColumn = D.s(map.get("tar_column"));
            Map field = (Map)fieldMap.get(tarColumn);
            if (field == null) continue;
            commonFields.add(field);
        }
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("fields");
        this.getModel().setValue("fields", (Object)ResourceEditorUtil.toObjectCollection(collection, commonFields));
        this.getView().updateView("fields");
    }

    private void setFields(Object returnData) {
        if (returnData instanceof List) {
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("fields");
            List dataList = (List)returnData;
            if (dataList.size() > 0) {
                this.updateJudgeFieldsByDataList(entries, dataList);
                this.getView().updateView("fields");
            }
        }
    }

    private void compareFieldAndSetFields(List<Map<String, Object>> fields) {
        long inputId = this.getModel().getDataEntity().getLong("input_id");
        ArrayList<Map<String, Object>> commonFields = new ArrayList<Map<String, Object>>();
        List allFields = Util.getAllFields((long)inputId);
        HashMap<String, Map<String, Object>> fieldMap = new HashMap<String, Map<String, Object>>(allFields.size());
        for (Map f : allFields) {
            fieldMap.put(D.s(f.get("field_name")), f);
        }
        this.compFields(commonFields, fields, fieldMap, "");
        if (commonFields.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u6a21\u578b\u4e2d\u6ca1\u6709\u5b57\u6bb5\u4e0e\u5bfc\u5165\u7684json\u76f8\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u662f\u5426\u6765\u6e90\u4e8e\u76ee\u6807\u6570\u636e\u6a21\u578b\u3002", (String)"DataLoaderFormPlugin_8", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        } else {
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("fields");
            this.getModel().setValue("fields", (Object)ResourceEditorUtil.toObjectCollection(collection, commonFields));
            this.getView().updateView("fields");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u5165\u7684\u5b57\u6bb5", (String)"DataLoaderFormPlugin_7", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        }
    }

    private void compFields(List<Map<String, Object>> commonFields, List<Map<String, Object>> fields, Map<String, Map<String, Object>> fieldMap, String parentName) {
        for (Map<String, Object> f : fields) {
            String name = D.s((Object)f.get("field"));
            String fullname = (StringUtil.isEmpty((String)parentName) ? "" : parentName + ".") + name;
            Map<String, Object> field = fieldMap.get(fullname);
            if ("STRUCT".equals(f.get("data_type"))) {
                List fieldChildren = (List)f.get("fields");
                this.compFields(commonFields, fieldChildren, fieldMap, fullname);
                continue;
            }
            if (field == null) continue;
            commonFields.add(field);
        }
    }

    private void updateJudgeFieldsByDataList(DynamicObjectCollection entries, List<Map<String, Object>> dataList) {
        Map<String, Object> firstRecord = dataList.get(0);
        Object customData = firstRecord.get("customData");
        if (customData instanceof Map) {
            int index = D.i(((Map)customData).get("row"));
            Set<String> fieldSet = this.getExistedFieldSet(entries);
            if (dataList.size() == 1) {
                this.updateOneRecord(dataList, index, fieldSet);
            } else {
                DynamicObject entry = this.getModel().getEntryRowEntity("fields", index);
                if (StringUtil.isEmpty((String)entry.getString("field_name"))) {
                    entries.remove(index);
                }
                this.updateFields(entries, dataList, fieldSet);
            }
        }
    }

    private void updateFields(DynamicObjectCollection entries, List<Map<String, Object>> dataList, Set<String> fieldSet) {
        for (Map<String, Object> dataMap : dataList) {
            Object field = dataMap.get("fullnumber");
            if (fieldSet.contains(field)) continue;
            DynamicObject entry = entries.addNew();
            entry.set("id", (Object)ID.genLongId());
            entry.set("field_name", field);
            entry.set("data_type", dataMap.get("type"));
            entry.set("field_label", dataMap.get("fulllabel"));
        }
    }

    private void updateOneRecord(List<Map<String, Object>> dataList, int index, Set<String> fieldSet) {
        Map<String, Object> dataMap = dataList.get(0);
        Object field = dataMap.get("fullnumber");
        if (!fieldSet.contains(field)) {
            DynamicObject entry = this.getModel().getEntryRowEntity("fields", index);
            entry.set("id", (Object)ID.genLongId());
            entry.set("field_name", field);
            entry.set("data_type", dataMap.get("type"));
            entry.set("field_label", dataMap.get("fulllabel"));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010%s\u3011\u5df2\u5b58\u5728\u3002", (String)"DataLoaderFormPlugin_11", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), field));
        }
    }

    private Set<String> getExistedFieldSet(DynamicObjectCollection entries) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (DynamicObject selector : entries) {
            String field = D.s((Object)selector.get("field_name"));
            if (field == null) continue;
            fieldSet.add(field);
        }
        return fieldSet;
    }
}

