/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.ds;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.ScriptEditorUtil;
import kd.isc.iscx.formplugin.res.ds.DataLoadUtil;
import kd.isc.iscx.formplugin.res.ds.DataLoaderFormPlugin;

public class DataTableLoadFormPlugin
extends DataLoaderFormPlugin {
    @Override
    protected String getResourceType() {
        return "DataLoad.TableAction";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "output");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equalsIgnoreCase(operationKey)) {
            DataTableLoadFormPlugin.checkCandidateKeys(args, this.getModel(), this.getView());
            this.checkUpsertOp(args);
        }
    }

    private void checkUpsertOp(BeforeDoOperationEventArgs args) {
        int batchSize;
        String action = D.s((Object)this.getModel().getValue("data_action"));
        if ("_UPSERT".equals(action) && (batchSize = D.i((Object)this.getModel().getValue("batch_size"))) <= 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5927\u5c0f>1\u624d\u5141\u8bb8\u4f7f\u7528_UPSERT\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"DataTableLoadFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        }
    }

    static void checkCandidateKeys(BeforeDoOperationEventArgs args, IDataModel model, IFormView view) {
        DynamicObjectCollection fields = model.getDataEntity(true).getDynamicObjectCollection("fields");
        for (DynamicObject field : fields) {
            if (!D.x((Object)field.get("is_candidate_key"))) continue;
            return;
        }
        args.setCancel(true);
        view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5019\u9009\u952e", (String)"DataTableLoadFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected void lockModel() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output"});
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        Object dataAction;
        super.bindResourceDetails(details, mode);
        IDataModel model = this.getModel();
        ScriptEditorUtil.bindDataModel2(details, model);
        DataLoadUtil.setDefaultOutputModel(this.getModel());
        Object batchSize = details.get("batch_size");
        if (batchSize != null) {
            model.setValue("batch_size", (Object)D.i((Object)batchSize));
        }
        if ((dataAction = details.get("data_action")) != null) {
            model.setValue("data_action", dataAction);
        }
        if (EditorMode.EXTENDS == mode) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output", "data_action"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap5"});
        }
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        IDataModel model = this.getModel();
        HashMap<String, Object> details = new HashMap<String, Object>();
        ScriptEditorUtil.collectDataModel2(details, model);
        details.put("batch_size", model.getValue("batch_size"));
        details.put("data_action", model.getValue("data_action"));
        details.put("fields", ResourceEditorUtil.toList(model.getEntryEntity("fields")));
        return details;
    }

    @Override
    protected String getTipMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8868\u7ed3\u6784\u6a21\u578b\u3002", (String)"DataTableLoadFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]);
    }
}

