/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.ds;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.ds.DataLoadUtil;
import kd.isc.iscx.formplugin.res.ds.DataLoaderFormPlugin;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.runtime.util.Util;

public class EntityLoadFormPlugin
extends DataLoaderFormPlugin {
    @Override
    protected String getResourceType() {
        return "DataLoad.EntityAction";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "output");
        this.addClickListeners(new String[]{"proxy_user"});
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DataLoadUtil.setDefaultOutputModel(this.getModel());
        long entityId = this.getModel().getDataEntity().getLong("input_id");
        this.initOperationCombo(entityId);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate oper = (AbstractOperate)args.getSource();
        if (oper.getOperateKey().equals("save")) {
            EntityLoadFormPlugin.checkCandidateKeys(this, this.getModel(), args);
            this.checkProxyUserAndOperationOptions(args);
        }
    }

    @Override
    protected void lockModel() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output"});
    }

    private void checkProxyUserAndOperationOptions(BeforeDoOperationEventArgs args) {
        if (D.i((Object)this.getModel().getValue("batch_size")) > 1) {
            if (this.hasDynamicProxyUser() && this.hasDynamicOperationOption()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5927\u5c0f\u5927\u4e8e1\u65f6\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u52a8\u6001\u4ee3\u7406\u7528\u6237\u53ca\u52a8\u6001\u64cd\u4f5c\u53c2\u6570\u3002", (String)"EntityLoadFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (this.hasDynamicProxyUser()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5927\u5c0f\u5927\u4e8e1\u65f6\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u52a8\u6001\u4ee3\u7406\u7528\u6237\u3002", (String)"EntityLoadFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (this.hasDynamicOperationOption()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5927\u5c0f\u5927\u4e8e1\u65f6\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u52a8\u6001\u64cd\u4f5c\u53c2\u6570\u3002", (String)"EntityLoadFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    private boolean hasDynamicProxyUser() {
        String proxyUser = D.s((Object)this.getModel().getValue("proxy_user"));
        return proxyUser != null && proxyUser.startsWith("#{");
    }

    private boolean hasDynamicOperationOption() {
        String operationOptions = D.s((Object)this.getModel().getValue("operation_options"));
        return operationOptions != null && operationOptions.contains("#{");
    }

    public static void checkCandidateKeys(AbstractResourceEditorFormPlugin form, IDataModel model, BeforeDoOperationEventArgs args) {
        ArrayList<DynamicObject> headFields = new ArrayList<DynamicObject>();
        DynamicObjectCollection fields = model.getDataEntity(true).getDynamicObjectCollection("fields");
        ArrayList<DynamicObject> fieldsWithDots = new ArrayList<DynamicObject>(fields.size());
        for (DynamicObject field : fields) {
            String fieldName = D.s((Object)field.get("field_name"));
            if (fieldName == null) continue;
            if (fieldName.contains(".")) {
                fieldsWithDots.add(field);
                continue;
            }
            headFields.add(field);
        }
        if (!EntityLoadFormPlugin.hasCandidateKey(headFields)) {
            form.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u9700\u8981\u8bbe\u7f6e\u5019\u9009\u952e\u5b57\u6bb5", (String)"EntityLoadFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!fieldsWithDots.isEmpty()) {
            EntityLoadFormPlugin.checkEntryCandidateKey(form, model, args, fieldsWithDots);
        }
    }

    private static void checkEntryCandidateKey(AbstractResourceEditorFormPlugin form, IDataModel model, BeforeDoOperationEventArgs args, List<DynamicObject> fieldsWithDots) {
        long entityId = model.getDataEntity().getLong("input_id");
        Map entriesGroup = ((AbstractDataModel)ResourceUtil.getResource((long)entityId)).getDataType().queryEntriesKey();
        HashSet<String> chooseEntry = new HashSet<String>(fieldsWithDots.size());
        for (DynamicObject dynamicObject : fieldsWithDots) {
            String fieldName = D.s((Object)dynamicObject.get("field_name"));
            String entryName = fieldName.substring(0, fieldName.lastIndexOf("."));
            chooseEntry.add(entryName);
        }
        for (Map.Entry entry : entriesGroup.entrySet()) {
            String entryName = (String)entry.getKey();
            if (!chooseEntry.contains(entryName) || EntityLoadFormPlugin.checkEntryHasCandidateKey(fieldsWithDots, entryName)) continue;
            form.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55%s\u9700\u8981\u8bbe\u7f6e\u5019\u9009\u952e\u5b57\u6bb5", (String)"EntityLoadFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[]{entryName}));
            args.setCancel(true);
            break;
        }
    }

    private static boolean checkEntryHasCandidateKey(List<DynamicObject> fields, String entryName) {
        for (DynamicObject field : fields) {
            String suffix;
            String fieldName = D.s((Object)field.get("field_name"));
            if (!fieldName.startsWith(entryName) || (suffix = fieldName.substring(entryName.length() + 1)).contains(".") || !D.x((Object)field.get("is_candidate_key"))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasCandidateKey(List<DynamicObject> fields) {
        for (DynamicObject field : fields) {
            if (!D.x((Object)field.get("is_candidate_key"))) continue;
            return true;
        }
        return false;
    }

    private void initOperationCombo(long entityId) {
        if (entityId > 0L) {
            ComboEdit combo = (ComboEdit)this.getView().getControl("operation");
            combo.setComboItems(this.makeComboItems(entityId));
        }
    }

    private List<ComboItem> makeComboItems(long entityId) {
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)entityId, (String)"iscx_resource_rtm");
        Map details = ResourceUtil.getMergedDetails((DynamicObject)res);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        List operations = (List)details.get("operations");
        if (operations != null) {
            for (Map operation : operations) {
                ComboItem item = new ComboItem();
                String opNumber = D.s(operation.get("operation_number"));
                String opLabel = D.s(operation.get("operation_label"));
                item.setCaption(new LocaleString(Util.getResourceLabel((String)opLabel, (String)opNumber)));
                item.setValue(opNumber);
                items.add(item);
            }
        }
        return items;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("input")) {
            this.resetOperationCombo(e);
        }
    }

    private void resetOperationCombo(PropertyChangedArgs e) {
        if (e.getChangeSet().length != 0) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (oldValue != null && !oldValue.equals(newValue)) {
                this.clearfieldsAndCombo();
            }
            if (newValue != null) {
                this.initOperationCombo(newValue.getLong("id"));
                this.getView().updateView("operation");
                this.getView().updateView("fields");
            }
        }
    }

    @Override
    protected String getTipMessage() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u5b9e\u4f53\u6a21\u578b\u3002", (String)"EntityLoadFormPlugin_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]);
    }

    private void clearfieldsAndCombo() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection fields = dataEntity.getDynamicObjectCollection("fields");
        fields.clear();
        dataEntity.set("operation", null);
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        IDataModel model = this.getModel();
        if (!details.isEmpty()) {
            model.setValue("input", ((Map)details.get("input")).get("id"));
            model.setValue("output", ((Map)details.get("output")).get("id"));
            model.setValue("proxy_user", details.get("proxy_user"));
            model.setValue("batch_size", details.get("batch_size"));
            model.setValue("operation", details.get("operation"));
            model.setValue("operation_options", details.get("operation_options"));
            super.bindResourceDetails(details, mode);
        }
        if (EditorMode.EXTENDS == mode) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"input", "operation", "output"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap3"});
        }
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        IDataModel model = this.getModel();
        HashMap<String, Object> details = new HashMap<String, Object>();
        DynamicObject data_provider = (DynamicObject)model.getValue("input");
        details.put("input", ResourceEditorUtil.toMap(data_provider));
        DynamicObject output = (DynamicObject)model.getValue("output");
        details.put("output", ResourceEditorUtil.toMap(output));
        details.put("proxy_user", model.getValue("proxy_user"));
        details.put("batch_size", model.getValue("batch_size"));
        details.put("fields", ResourceEditorUtil.toList(model.getEntryEntity("fields")));
        details.put("operation", model.getValue("operation"));
        details.put("operation_options", model.getValue("operation_options"));
        return details;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("proxy_user")) {
            long entityId = this.getModel().getDataEntity().getLong("input_id");
            if (entityId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u5b9e\u4f53\u6a21\u578b\u3002", (String)"EntityLoadFormPlugin_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                return;
            }
            Resource resource = ResourceUtil.getResource((long)entityId);
            List fields = ((AbstractDataModel)resource).getDataType().getFields();
            if (fields.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u5355\u636e\u5b9e\u4f53\u6a21\u578b\u3011\u6ca1\u6709\u5b57\u6bb5\u53ef\u9009\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityLoadFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Constable> param = new HashMap<String, Constable>();
            param.put("resourceId", Long.valueOf(entityId));
            param.put("single", Boolean.TRUE);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"EntityLoadFormPlugin_7", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)"setProxyUser");
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        try {
            if (action.equals("setProxyUser")) {
                Object returnData = closedCallBackEvent.getReturnData();
                this.setProxyUser(returnData);
            }
        }
        catch (Throwable e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void setProxyUser(Object returnData) {
        List dataList;
        if (returnData instanceof List && (dataList = (List)returnData).size() > 0) {
            Map map = (Map)dataList.get(0);
            this.getModel().setValue("proxy_user", (Object)("#{" + map.get("fullnumber") + "}"));
        }
    }
}

