/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.ds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ClientActions;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.platform.core.res.meta.ds.XWebAPIUtil;

public class WebApiFormPlugin
extends AbstractResourceEditorFormPlugin
implements AfterF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "input", "output");
        this.addClickListeners(new String[]{"view", "param_var", "header_var", "tree_body_var", "tree_resp_body_var"});
        BasedataEdit web_api = (BasedataEdit)this.getView().getControl("web_api");
        if (web_api != null) {
            web_api.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    @Override
    protected String getResourceType() {
        return "DataLoad.WebAPI";
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        if (!details.isEmpty()) {
            IDataModel model = this.getModel();
            Map web_api = (Map)details.get("web_api");
            model.setValue("input", ((Map)details.get("input")).get("id"));
            model.setValue("output", ((Map)details.get("output")).get("id"));
            model.setValue("web_api", web_api.get("id"));
            DynamicObject obj = (DynamicObject)this.getModel().getValue("web_api");
            if (obj == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9d\u8d56\u7684\u96c6\u6210\u7ba1\u7406webapi\u5df2\u88ab\u5220\u9664\u3002id:%1$s,\u7f16\u7801\uff1a%2$s,\u540d\u79f0:%3$s", (String)"WebApiFormPlugin_13", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), web_api.get("id"), web_api.get("number"), web_api.get("name")));
                this.getView().setEnable(Boolean.TRUE, new String[]{"web_api"});
                return;
            }
            obj = BusinessDataServiceHelper.loadSingle((String)"isc_apic_webapi", (QFilter[])new QFilter[]{new QFilter("id", "=", obj.getPkValue())});
            Map webapi_config = (Map)details.get("webapi_config");
            this.setEditableInputEntry(obj, webapi_config);
            this.setEditableOutputEntry(obj, webapi_config);
            if (!D.x((Object)this.getView().getFormShowParameter().getCustomParam("readOnly"))) {
                this.doCheck(obj, webapi_config);
            }
        }
    }

    private void doCheck(DynamicObject obj, Map<String, Object> webapi_config) {
        String msg;
        if (webapi_config != null && D.s((Object)(msg = XWebAPIUtil.doCheck((DynamicObject)obj, webapi_config))) != null) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u96c6\u6210\u7ba1\u7406\u4e2d\u7684WebAPI\u4fee\u6539\u4e86\u5b57\u6bb5,\u8bf7\u91cd\u65b0\u914d\u7f6e\u6570\u636e\u6d41WebAPI\u8c03\u7528\u5e76\u4fdd\u5b58\u3002\u53ef\u5c55\u5f00\u8be6\u60c5\u67e5\u770b\u5177\u4f53\u5185\u5bb9\u3002", (String)"WebApiFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), (String)msg);
        }
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        IDataModel model = this.getModel();
        Map<String, Object> details = this.collectBasic(model);
        HashMap<String, Object> webapi_config = new HashMap<String, Object>();
        this.collectInputParamsReturnData(webapi_config);
        this.collectOutputParamsReturnData(webapi_config);
        details.put("webapi_config", webapi_config);
        return details;
    }

    private Map<String, Object> collectBasic(IDataModel model) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        DynamicObject input = (DynamicObject)model.getValue("input");
        details.put("input", ResourceEditorUtil.toMap(input));
        DynamicObject output = (DynamicObject)model.getValue("output");
        details.put("output", ResourceEditorUtil.toMap(output));
        DynamicObject web_api = (DynamicObject)model.getValue("web_api");
        HashMap<String, Object> ref = new HashMap<String, Object>(5);
        ref.put("id", web_api.getPkValue());
        ref.put("number", web_api.getString("number"));
        ref.put("name", web_api.getString("name"));
        ref.put("type", "isc_apic_webapi");
        DynamicObject group = (DynamicObject)web_api.get("group");
        ref.put("tar_system_name", group.getString("name"));
        details.put("web_api", ref);
        return details;
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        DynamicObject obj;
        BasedataEdit edit;
        if (event.getSource() instanceof BasedataEdit && "web_api".equals((edit = (BasedataEdit)event.getSource()).getKey()) && (obj = (DynamicObject)this.getModel().getValue("web_api")) != null) {
            obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"isc_apic_webapi");
            this.setEditableInputEntry(obj, null);
            this.setEditableOutputEntry(obj, null);
        }
    }

    private void setEditableInputEntry(DynamicObject obj, Map<String, Object> webapiConfig) {
        DynamicObjectCollection urlParams = this.getModel().getDataEntity(true).getDynamicObjectCollection("url_params");
        DynamicObjectCollection reqHeader = this.getModel().getDataEntity(true).getDynamicObjectCollection("req_header");
        DynamicObjectCollection reqBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        urlParams.clear();
        reqHeader.clear();
        reqBody.clear();
        DynamicObjectCollection webUrlParams = obj.getDynamicObjectCollection("web_url_params");
        DynamicObjectCollection webReqHeader = obj.getDynamicObjectCollection("web_req_header");
        DynamicObjectCollection webReqBody = obj.getDynamicObjectCollection("web_req_body");
        this.setUrlParams(urlParams, webUrlParams, webapiConfig);
        this.setReqHeader(reqHeader, webReqHeader, webapiConfig);
        this.setReqBody(reqBody, webReqBody, webapiConfig);
        this.getView().updateView("url_params");
        this.getView().updateView("req_header");
        this.getView().updateView("treeentryentity");
    }

    private void setUrlParams(DynamicObjectCollection urlParams, DynamicObjectCollection webUrlParams, Map<String, Object> webapiConfig) {
        Map editedData = null;
        if (webapiConfig != null) {
            editedData = (Map)webapiConfig.get("urlParams");
        }
        int i = 0;
        for (DynamicObject src : webUrlParams) {
            Map paramMap;
            DynamicObject tar = urlParams.addNew();
            String name = D.s((Object)src.get("url_param_name"));
            tar.set("param_name", (Object)name);
            tar.set("param_desc", src.get("url_param_desc"));
            String srcUrlParamValue = D.s((Object)src.get("url_param_value"));
            tar.set("param_need", (Object)(srcUrlParamValue == null ? 1 : 0));
            if (srcUrlParamValue != null) {
                if (srcUrlParamValue.startsWith("$")) {
                    tar.set("param_var", (Object)srcUrlParamValue);
                } else {
                    tar.set("param_fixed_value", (Object)srcUrlParamValue);
                }
                this.setEntryRowDisabled("url_params", i, new String[]{"param_var", "param_fixed_value"});
            } else if (editedData != null && (paramMap = (Map)editedData.get(name)) != null) {
                tar.set("param_var", paramMap.get("param_var"));
                tar.set("param_fixed_value", paramMap.get("param_fixed_value"));
            }
            ++i;
        }
    }

    private void setReqHeader(DynamicObjectCollection reqHeader, DynamicObjectCollection webReqHeader, Map<String, Object> webapiConfig) {
        Map editedData = null;
        if (webapiConfig != null) {
            editedData = (Map)webapiConfig.get("reqHeader");
        }
        int i = 0;
        for (DynamicObject src : webReqHeader) {
            Map paramMap;
            DynamicObject tar = reqHeader.addNew();
            String name = D.s((Object)src.get("req_h_param_name"));
            tar.set("header_name", (Object)name);
            tar.set("header_desc", src.get("req_h_param_desc"));
            String srcHeadParamValue = D.s((Object)src.get("req_h_param_value"));
            tar.set("header_need", (Object)(srcHeadParamValue == null ? 1 : 0));
            if (srcHeadParamValue != null) {
                if (srcHeadParamValue.startsWith("$")) {
                    tar.set("header_var", (Object)srcHeadParamValue);
                } else {
                    tar.set("header_fixed_value", (Object)srcHeadParamValue);
                }
                this.setEntryRowDisabled("req_header", i, new String[]{"header_var", "header_fixed_value"});
            } else if (editedData != null && (paramMap = (Map)editedData.get(name)) != null) {
                tar.set("header_var", paramMap.get("header_var"));
                tar.set("header_fixed_value", paramMap.get("header_fixed_value"));
            }
            ++i;
        }
    }

    private void setReqBody(DynamicObjectCollection reqBody, DynamicObjectCollection webReqBody, Map<String, Object> webapiConfig) {
        Map editedData = null;
        if (webapiConfig != null) {
            editedData = (Map)webapiConfig.get("reqBody");
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        int i = 0;
        HashMap<String, String> varMap = new HashMap<String, String>(reqBody.size());
        for (DynamicObject src : webReqBody) {
            Map paramMap;
            String srcValue = D.s((Object)src.get("req_b_param_value"));
            if (srcValue != null) {
                varMap.put(src.getString("id"), srcValue);
            }
            long pid = D.l((Object)src.get("pid"));
            long id = D.l((Object)src.getString("id"));
            map.put(src.getString("id"), id);
            DynamicObject tar = reqBody.addNew();
            tar.set("id", (Object)id);
            String name = D.s((Object)src.get("req_b_param_name"));
            tar.set("tree_body_name", (Object)name);
            tar.set("tree_body_desc", src.get("req_b_param_desc"));
            tar.set("tree_body_data_type", src.get("req_b_param_type"));
            tar.set("tree_body_is_array", src.get("req_b_param_is_array"));
            tar.set("tree_body_required", src.get("req_b_param_required"));
            if (pid != 0L) {
                tar.set("pid", map.get(D.s((Object)pid)));
            }
            if (srcValue != null) {
                if (srcValue.startsWith("$")) {
                    tar.set("tree_body_var", (Object)srcValue);
                } else {
                    tar.set("tree_body_fixed_value", (Object)srcValue);
                }
                this.setEntryRowDisabled("treeentryentity", i, new String[]{"tree_body_var", "tree_body_fixed_value"});
            } else if (editedData != null && (paramMap = (Map)editedData.get(name = XWebAPIUtil.getFullKeyStr((String)name, (DynamicObjectCollection)reqBody, (long)D.l(map.get(D.s((Object)pid))), (String)"tree_body_name"))) != null) {
                tar.set("tree_body_var", paramMap.get("tree_body_var"));
                tar.set("tree_body_fixed_value", paramMap.get("tree_body_fixed_value"));
            }
            ++i;
        }
    }

    private void setEntryRowDisabled(String entryName, int i, String[] fields) {
        for (String f : fields) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{f});
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ClientActions.createRowStyleBuilder().setRows(new int[]{i}).setBackColor("#F5F5F5").buildStyle().build().invokeControlMethod(proxy, entryName);
    }

    private void setEditableOutputEntry(DynamicObject obj, Map<String, Object> webapiConfig) {
        Map editedData = null;
        if (webapiConfig != null) {
            editedData = (Map)webapiConfig.get("respBody");
        }
        DynamicObjectCollection respBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("tree_resp_body");
        respBody.clear();
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (D.x((Object)obj.get("need_format_result"))) {
            DynamicObjectCollection webRespBody = obj.getDynamicObjectCollection("web_resp_body");
            for (DynamicObject src : webRespBody) {
                Map paramMap;
                DynamicObject tar = respBody.addNew();
                String name = D.s((Object)src.get("resp_b_param_name"));
                long id = D.l((Object)src.getString("id"));
                map.put(src.getString("id"), id);
                tar.set("id", (Object)id);
                long pid = D.l((Object)src.get("pid"));
                if (pid != 0L) {
                    tar.set("pid", map.get(D.s((Object)pid)));
                }
                tar.set("tree_resp_body_name", (Object)name);
                tar.set("tree_resp_body_data_type", src.get("resp_b_param_type"));
                tar.set("tree_resp_body_is_array", src.get("resp_b_param_is_array"));
                tar.set("tree_resp_body_desc", src.get("resp_b_param_desc"));
                if (editedData == null || (paramMap = (Map)editedData.get(name = XWebAPIUtil.getFullKeyStr((String)name, (DynamicObjectCollection)respBody, (long)D.l(map.get(D.s((Object)pid))), (String)"tree_resp_body_name"))) == null) continue;
                tar.set("tree_resp_body_var", paramMap.get("tree_resp_body_var"));
            }
        } else {
            Map paramMap;
            DynamicObject tar = respBody.addNew();
            tar.set("tree_resp_body_name", (Object)"$result");
            tar.set("id", (Object)IDService.get().genLongId());
            tar.set("tree_resp_body_data_type", (Object)"string");
            tar.set("tree_resp_body_desc", (Object)ResManager.loadKDString((String)"api\u63a5\u53e3\u8fd4\u56de\u7684\u539f\u59cb\u7ed3\u679c", (String)"WebApiFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            if (editedData != null && (paramMap = (Map)editedData.get("$result")) != null) {
                tar.set("tree_resp_body_var", paramMap.get("tree_resp_body_var"));
            }
        }
        this.getView().updateView("tree_resp_body");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(5);
            HashMap<String, String> customData = new HashMap<String, String>(2);
            if (Arrays.asList("param_var", "header_var", "tree_body_var").contains(key)) {
                DynamicObject input = (DynamicObject)this.getModel().getValue("input");
                if (input == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f93\u5165\u53c2\u6570\u6a21\u578b", (String)"WebApiFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                param.put("resourceId", input.getPkValue());
                customData.put("preStr", "$in.");
            } else if ("tree_resp_body_var".equals(key)) {
                DynamicObject output = (DynamicObject)this.getModel().getValue("output");
                if (output == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8f93\u51fa\u7ed3\u679c\u6a21\u578b", (String)"WebApiFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                param.put("resourceId", output.getPkValue());
                customData.put("preStr", "$out.");
            }
            customData.put("fieldKey", key);
            param.put("customData", customData);
            param.put("single", Boolean.TRUE);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"WebApiFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)"get_fields");
        }
        catch (Exception e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        try {
            List dataList;
            Map firstRecord;
            Object customData;
            Object returnData;
            if (action.equals("get_fields") && (returnData = closedCallBackEvent.getReturnData()) instanceof List && (customData = (firstRecord = (Map)(dataList = (List)returnData).get(0)).get("customData")) instanceof Map) {
                Map map = (Map)customData;
                String key = D.s(map.get("fieldKey"));
                this.getModel().setValue(key, (Object)(D.s(map.get("preStr")) + firstRecord.get("fullnumber")));
            }
        }
        catch (Throwable e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void collectInputParamsReturnData(Map<String, Object> params) {
        DynamicObjectCollection urlParams = this.getModel().getDataEntity(true).getDynamicObjectCollection("url_params");
        DynamicObjectCollection reqHeader = this.getModel().getDataEntity(true).getDynamicObjectCollection("req_header");
        DynamicObjectCollection reqBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        LinkedHashMap urlParamsMap = new LinkedHashMap(urlParams.size());
        for (Object i : urlParams) {
            HashMap<String, Object> line = new HashMap<String, Object>(4);
            line.put("param_desc", i.get("param_desc"));
            line.put("param_fixed_value", i.get("param_fixed_value"));
            line.put("param_var", i.get("param_var"));
            line.put("param_need", i.get("param_need"));
            urlParamsMap.put(i.getString("param_name"), line);
        }
        LinkedHashMap reqHeaderMap = new LinkedHashMap(reqHeader.size());
        for (DynamicObject i : reqHeader) {
            HashMap<String, Object> line = new HashMap<String, Object>(4);
            line.put("header_desc", i.get("header_desc"));
            line.put("header_fixed_value", i.get("header_fixed_value"));
            line.put("header_var", i.get("header_var"));
            line.put("header_need", i.get("header_need"));
            reqHeaderMap.put(i.getString("header_name"), line);
        }
        LinkedHashMap reqBodyMap = new LinkedHashMap(reqBody.size());
        for (DynamicObject i : reqBody) {
            HashMap<String, Object> line = new HashMap<String, Object>(8);
            line.put("id", i.get("id"));
            line.put("pid", i.get("pid"));
            line.put("tree_body_desc", i.get("tree_body_desc"));
            line.put("tree_body_fixed_value", i.get("tree_body_fixed_value"));
            line.put("tree_body_var", i.get("tree_body_var"));
            line.put("tree_body_name", i.get("tree_body_name"));
            reqBodyMap.put(XWebAPIUtil.getFullKeyStr((String)i.getString("tree_body_name"), (DynamicObjectCollection)reqBody, (long)D.l((Object)i.get("pid")), (String)"tree_body_name"), line);
        }
        params.put("urlParams", urlParamsMap);
        params.put("reqHeader", reqHeaderMap);
        params.put("reqBody", reqBodyMap);
    }

    private void collectOutputParamsReturnData(Map<String, Object> params) {
        DynamicObjectCollection respBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("tree_resp_body");
        LinkedHashMap respBodyMap = new LinkedHashMap(respBody.size());
        for (DynamicObject i : respBody) {
            HashMap<String, Object> line = new HashMap<String, Object>(3);
            line.put("id", i.get("id"));
            line.put("pid", i.get("pid"));
            line.put("tree_resp_body_data_type", i.get("tree_resp_body_data_type"));
            line.put("tree_resp_body_is_array", i.get("tree_resp_body_is_array"));
            line.put("tree_resp_body_desc", i.get("tree_resp_body_desc"));
            line.put("tree_resp_body_var", i.get("tree_resp_body_var"));
            line.put("tree_resp_body_name", i.get("tree_resp_body_name"));
            String key = XWebAPIUtil.getFullKeyStr((String)i.getString("tree_resp_body_name"), (DynamicObjectCollection)respBody, (long)D.l((Object)i.get("pid")), (String)"tree_resp_body_name");
            respBodyMap.put(key, line);
        }
        params.put("respBody", respBodyMap);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "save".equals(operateKey = (oper = (AbstractOperate)args.getSource()).getOperateKey())) {
            if (this.checkFixValueAndVar()) {
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            String key = this.getRepeatRespBodyVar();
            if (key != null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u7ed1\u5b9a\u5355\u636e\u4f53\u4e2d,\u8f93\u51fa\u53d8\u91cf\u4e0d\u5141\u8bb8\u91cd\u590d,\u5b58\u5728\u91cd\u590d\u503c:%s", (String)"WebApiFormPlugin_20", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), key));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            List<String> seqList = this.checkReqParentVar();
            if (!seqList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u5355\u636e\u4f53\u4e0d\u5141\u8bb8\u7236\u7ea7\u548c\u5b50\u7ea7\u540c\u65f6\u8bbe\u7f6e\u53c2\u6570\uff0c\u5b50\u7ea7\u884c\u53f7:%s", (String)"WebApiFormPlugin_21", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), seqList), Integer.valueOf(10000));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            List<String> seqList2 = this.checkRespParentVar();
            if (!seqList2.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u7ed1\u5b9a\u5355\u636e\u4f53\u4e0d\u5141\u8bb8\u7236\u7ea7\u548c\u5b50\u7ea7\u540c\u65f6\u8bbe\u7f6e\u53c2\u6570\uff0c\u5b50\u7ea7\u884c\u53f7: %s", (String)"WebApiFormPlugin_22", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), seqList2), Integer.valueOf(10000));
                args.setCancel(Boolean.TRUE.booleanValue());
            }
        }
    }

    private boolean checkFixValueAndVar() {
        DynamicObjectCollection reqBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        for (Object i : reqBody) {
            if (D.s((Object)i.getString("tree_body_fixed_value")) == null || D.s((Object)i.getString("tree_body_var")) == null) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u5355\u636e\u4f53\u4e2d\u76f4\u63a5\u8d4b\u503c\u548c\u8f93\u5165\u53c2\u6570\u8d4b\u503c\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728\uff0c\u884c\u53f7:%s", (String)"WebApiFormPlugin_23", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), i.get("seq")));
            return true;
        }
        DynamicObjectCollection url_params = this.getModel().getDataEntity(true).getDynamicObjectCollection("url_params");
        for (DynamicObject i : url_params) {
            if (D.s((Object)i.getString("param_fixed_value")) == null || D.s((Object)i.getString("param_var")) == null) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"URL\u53c2\u6570\u5355\u636e\u4f53\u4e2d\u76f4\u63a5\u8d4b\u503c\u548c\u8f93\u5165\u53c2\u6570\u8d4b\u503c\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728\uff0c\u884c\u53f7:%s", (String)"WebApiFormPlugin_24", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), i.get("seq")));
            return true;
        }
        DynamicObjectCollection req_header = this.getModel().getDataEntity(true).getDynamicObjectCollection("req_header");
        for (DynamicObject i : req_header) {
            if (D.s((Object)i.getString("header_fixed_value")) == null || D.s((Object)i.getString("header_var")) == null) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u5355\u636e\u4f53\u4e2d\u76f4\u63a5\u8d4b\u503c\u548c\u8f93\u5165\u53c2\u6570\u8d4b\u503c\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728\uff0c\u884c\u53f7:%s", (String)"WebApiFormPlugin_25", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), i.get("seq")));
            return true;
        }
        return false;
    }

    private List<String> checkRespParentVar() {
        DynamicObjectCollection reqBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("tree_resp_body");
        ArrayList<String> seqList = new ArrayList<String>();
        HashMap<String, Object> varMap = new HashMap<String, Object>(reqBody.size());
        for (DynamicObject i : reqBody) {
            String value = D.s((Object)i.get("tree_resp_body_var"));
            String id = i.getString("id");
            varMap.put(id, value);
            if (i.getLong("pid") == 0L || value == null || !this.hasParentVar(varMap, i, reqBody)) continue;
            seqList.add(i.getString("seq"));
        }
        return seqList;
    }

    private List<String> checkReqParentVar() {
        DynamicObjectCollection reqBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
        ArrayList<String> seqList = new ArrayList<String>();
        HashMap<String, Object> varMap = new HashMap<String, Object>(reqBody.size());
        for (DynamicObject i : reqBody) {
            String value = D.s((Object)i.get("tree_body_fixed_value")) == null ? D.s((Object)i.get("tree_body_var")) : D.s((Object)i.get("tree_body_fixed_value"));
            String id = i.getString("id");
            varMap.put(id, value);
            if (i.getLong("pid") == 0L || value == null || !this.hasParentVar(varMap, i, reqBody)) continue;
            seqList.add(i.getString("seq"));
        }
        return seqList;
    }

    private String getRepeatRespBodyVar() {
        DynamicObjectCollection reqBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("tree_resp_body");
        ArrayList<String> list = new ArrayList<String>();
        for (DynamicObject object : reqBody) {
            String key = D.s((Object)object.getString("tree_resp_body_var"));
            if (key == null) continue;
            if (list.contains(key)) {
                return key;
            }
            list.add(key);
        }
        return null;
    }

    private boolean hasParentVar(Map<String, Object> varMap, DynamicObject i, DynamicObjectCollection collection) {
        String pid = i.getString("pid");
        if (varMap.get(pid) != null) {
            return true;
        }
        for (DynamicObject object : collection) {
            if (!object.getString("id").equals(pid)) continue;
            if (object.getLong("pid") == 0L) break;
            return this.hasParentVar(varMap, object, collection);
        }
        return false;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String s = D.s((Object)e.getProperty().getName());
        if (this.setFieldValue(s, e, "param_fixed_value", "param_var") || this.setFieldValue(s, e, "param_var", "param_fixed_value")) {
            this.getView().updateView("url_params");
        }
        if (this.setFieldValue(s, e, "header_fixed_value", "header_var") || this.setFieldValue(s, e, "header_var", "header_fixed_value")) {
            this.getView().updateView("req_header");
        }
        if (this.setFieldValue(s, e, "tree_body_fixed_value", "tree_body_var") || this.setFieldValue(s, e, "tree_body_var", "tree_body_fixed_value")) {
            this.getView().updateView("treeentryentity");
        }
        if ("input".equals(s) || "output".equals(s)) {
            long input = D.l((Object)this.getModel().getValue("input_id"));
            long output = D.l((Object)this.getModel().getValue("output_id"));
            if (input != 0L && input == output) {
                this.getModel().setValue(s, null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8f93\u5165/\u8f93\u51fa\u4e0d\u5141\u8bb8\u662f\u540c\u4e00\u4e2a\u6570\u636e\u6a21\u578b", (String)"WebApiFormPlugin_26", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean setFieldValue(String propertyName, PropertyChangedArgs e, String value1, String value2) {
        if (value1.equals(propertyName)) {
            ChangeData[] changeSet = e.getChangeSet();
            String newValue = (String)changeSet[0].getNewValue();
            String oldValue = (String)changeSet[0].getOldValue();
            if (oldValue != null && !oldValue.equals(newValue) || StringUtils.isNotEmpty((String)newValue)) {
                changeSet[0].getDataEntity().set(value2, null);
                return true;
            }
        }
        return false;
    }
}

