/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.runtime.util.Util;

public class BizEventFormPlugin
extends AbstractResourceEditorFormPlugin
implements CellClickListener {
    @Override
    protected String getResourceType() {
        return "EventModel.BizEvent";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "entity");
        EntryGrid selectors = (EntryGrid)this.getView().getControl("select_fields");
        selectors.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{"field_name"});
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long entityId = this.getModel().getDataEntity().getLong("entity_id");
        this.initEventCombo(entityId);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("auto_fill".equals(args.getOperateKey())) {
            try {
                this.autofill();
            }
            catch (Throwable e) {
                FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
            }
        }
    }

    private void autofill() {
        long entityId = D.l((Object)this.getModel().getValue("entity_id"));
        if (entityId != 0L) {
            List fields = Util.getAllFields((long)entityId);
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("select_fields");
            this.getModel().setValue("select_fields", (Object)ResourceEditorUtil.toObjectCollection(entries, fields));
            this.getView().updateView("select_fields");
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u5b9e\u4f53\u6a21\u578b\u3002", (String)"BizEventFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("entity")) {
            this.resetEventCombo(e);
        }
    }

    private void resetEventCombo(PropertyChangedArgs e) {
        if (e.getChangeSet().length != 0) {
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (oldValue != null && !oldValue.equals(newValue)) {
                this.getModel().setValue("event", null);
            }
            if (newValue != null) {
                this.initEventCombo(newValue.getLong("id"));
            }
        }
    }

    private void initEventCombo(long resId) {
        if (resId > 0L) {
            DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)resId, (String)"iscx_resource_rtm");
            Map details = ResourceUtil.getMergedDetails((DynamicObject)res);
            ComboEdit eventCombo = (ComboEdit)this.getView().getControl("event");
            eventCombo.setComboItems(this.makeEventComboItems(details));
        }
    }

    private List<ComboItem> makeEventComboItems(Map<String, Object> details) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        List events = (List)details.get("events");
        if (events != null) {
            for (Map event : events) {
                ComboItem item = new ComboItem();
                String eventNumber = D.s(event.get("event_number"));
                String eventLabel = D.s(event.get("event_label"));
                item.setCaption(new LocaleString(Util.getResourceLabel((String)eventLabel, (String)eventNumber)));
                item.setValue(eventNumber);
                items.add(item);
            }
        }
        return items;
    }

    @Override
    protected void lockModel() {
        super.lockModel();
        this.getView().setEnable(Boolean.FALSE, new String[]{"entity"});
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        IDataModel model = this.getModel();
        if (!details.isEmpty()) {
            model.setValue("entity", ((Map)details.get("entity")).get("id"));
            model.setValue("event", details.get("event"));
            model.setValue("batch_size", details.get("batch_size"));
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("select_fields");
            model.setValue("select_fields", (Object)ResourceEditorUtil.toObjectCollection(entries, (List)details.get("select_fields")));
        }
        if (EditorMode.EXTENDS == mode) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"entity", "event"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap3"});
        }
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        IDataModel model = this.getModel();
        HashMap<String, Object> details = new HashMap<String, Object>();
        DynamicObject data_provider = (DynamicObject)model.getValue("entity");
        details.put("entity", ResourceEditorUtil.toMap(data_provider));
        details.put("data_model", ResourceEditorUtil.toMap(data_provider));
        details.put("event", model.getValue("event"));
        details.put("batch_size", model.getValue("batch_size"));
        details.put("select_fields", ResourceEditorUtil.toList((DynamicObjectCollection)model.getValue("select_fields")));
        return details;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("field_name".equals(key)) {
            EntryGrid grid = (EntryGrid)this.getControl("select_fields");
            int selectRow = grid.getSelectRows()[0];
            long entityId = this.getModel().getDataEntity().getLong("entity_id");
            this.openSelectFieldForm(selectRow, entityId);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if ("field_name".equals(fieldKey)) {
            int selectRow = cellClickEvent.getRow();
            long entityId = this.getModel().getDataEntity().getLong("entity_id");
            this.openSelectFieldForm(selectRow, entityId);
        }
    }

    private void openSelectFieldForm(int selectRow, long entityId) {
        if (entityId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u636e\u5b9e\u4f53\u6a21\u578b\u3002", (String)"BizEventFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        } else {
            HashMap<String, Serializable> param = new HashMap<String, Serializable>();
            HashMap<String, Integer> customData = new HashMap<String, Integer>();
            customData.put("row", selectRow);
            param.put("customData", customData);
            param.put("resourceId", Long.valueOf(entityId));
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"BizEventFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)"get_fields");
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        try {
            if (action.equals("get_fields")) {
                Object returnData = closedCallBackEvent.getReturnData();
                this.setFields(returnData);
            }
        }
        catch (Throwable e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    private void setFields(Object returnData) {
        if (returnData instanceof List) {
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("select_fields");
            List dataList = (List)returnData;
            if (dataList.size() > 0) {
                this.updateSelectorEntryByDataList(entries, dataList);
                this.getView().updateView("select_fields");
            }
        }
    }

    private void updateSelectorEntryByDataList(DynamicObjectCollection entries, List<Map<String, Object>> dataList) {
        Map<String, Object> firstRecord = dataList.get(0);
        Object customData = firstRecord.get("customData");
        if (customData instanceof Map) {
            int index = D.i(((Map)customData).get("row"));
            Set<String> fieldSet = this.getExistedFieldSet(entries);
            if (dataList.size() == 1) {
                this.updateOneRecord(dataList, index, fieldSet);
            } else {
                DynamicObject entry = this.getModel().getEntryRowEntity("select_fields", index);
                if (StringUtil.isEmpty((String)entry.getString("field_name"))) {
                    entries.remove(index);
                }
                this.updateSelectors(entries, dataList, fieldSet);
            }
        }
    }

    private void updateSelectors(DynamicObjectCollection entries, List<Map<String, Object>> dataList, Set<String> fieldSet) {
        for (Map<String, Object> dataMap : dataList) {
            Object field = dataMap.get("fullnumber");
            if (fieldSet.contains(field)) continue;
            DynamicObject entry = entries.addNew();
            entry.set("id", (Object)ID.genLongId());
            entry.set("field_name", field);
            entry.set("data_type", dataMap.get("type"));
            entry.set("field_label", dataMap.get("fulllabel"));
        }
    }

    private Set<String> getExistedFieldSet(DynamicObjectCollection selectors) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (DynamicObject selector : selectors) {
            String field = D.s((Object)selector.get("field_name"));
            if (field == null) continue;
            fieldSet.add(field);
        }
        return fieldSet;
    }

    private void updateOneRecord(List<Map<String, Object>> dataList, int index, Set<String> fieldSet) {
        Map<String, Object> dataMap = dataList.get(0);
        Object field = dataMap.get("fullnumber");
        if (!fieldSet.contains(field)) {
            DynamicObject entry = this.getModel().getEntryRowEntity("select_fields", index);
            entry.set("id", (Object)ID.genLongId());
            entry.set("field_name", field);
            entry.set("data_type", dataMap.get("type"));
            entry.set("field_label", dataMap.get("fulllabel"));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010%s\u3011\u5df2\u5b58\u5728\u3002", (String)"BizEventFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), field));
        }
    }

    @Override
    protected boolean isUsedInTrigger() {
        return true;
    }

    @Override
    protected String getUsedField() {
        return "event_model_id";
    }
}

