/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.fm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.IDService;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dm.DataEntity;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.fm.PropModel;
import kd.isc.iscx.platform.core.res.meta.fm.PropModelMappingItem;
import kd.isc.iscx.platform.core.res.meta.fm.PropModelMappingProcess;
import kd.isc.iscx.platform.core.res.meta.fm.PropertyUtil;

public class FieldMappingUtil {
    private static List<PropModel> buildPropList(List<Field> tarFields) {
        ArrayList<PropModel> propModels = new ArrayList<PropModel>(tarFields.size());
        for (Field tarField : tarFields) {
            propModels.add(new PropModel(tarField));
        }
        return propModels;
    }

    public static List<PropModelMappingItem> getPropModelMappingItemList(long input_id, long output_id) {
        Resource srcResource = ResourceUtil.getResource((long)input_id);
        List srcFields = ((AbstractDataModel)srcResource).getDataType().getFields();
        List<PropModel> srcPropModels = FieldMappingUtil.buildPropList(srcFields);
        Map srcPropertyMap = PropertyUtil.initPropertyMap(srcPropModels);
        Resource tarResource = ResourceUtil.getResource((long)output_id);
        List tarFields = ((AbstractDataModel)tarResource).getDataType().getFields();
        List<PropModel> tarPropModels = FieldMappingUtil.buildPropList(tarFields);
        Map tarPropertyMap = PropertyUtil.initPropertyMap(tarPropModels);
        return new PropModelMappingProcess(srcPropertyMap, tarPropertyMap).handle();
    }

    public static int addEntry(DynamicObjectCollection mappingEntries, List<PropModelMappingItem> mappingItems, int index, long output_id) {
        for (PropModelMappingItem mappingItem : mappingItems) {
            PropModel tarProp = mappingItem.getTarPropModel();
            if (tarProp.isPrimaryKey() && ResourceUtil.getResource((long)output_id) instanceof DataEntity) continue;
            index = FieldMappingUtil.newEntry(mappingEntries, mappingItem, tarProp, index, output_id);
        }
        return index;
    }

    private static int newEntry(DynamicObjectCollection mappingEntries, PropModelMappingItem mappingItem, PropModel tarProp, int index, long output_id) {
        List childMappingItems;
        if (!tarProp.getDataType().equals("STRUCT")) {
            DynamicObject entry = mappingEntries.addNew();
            long id = IDService.get().genLongId();
            entry.set("id", (Object)id);
            entry.set("seq", (Object)index++);
            FieldMappingUtil.setTarColumnsFromField(tarProp, entry);
            PropModel srcProp = mappingItem.getSrcPropModel();
            if (srcProp != null && !srcProp.isEntry()) {
                FieldMappingUtil.setSrcColumnsFromField(srcProp, entry);
            }
        }
        if ((childMappingItems = mappingItem.getChildMappingItems()) != null) {
            index = FieldMappingUtil.addEntry(mappingEntries, childMappingItems, index, output_id);
        }
        return index;
    }

    private static void setSrcColumnsFromField(PropModel srcProp, DynamicObject entry) {
        entry.set("src_column", (Object)(srcProp.getDataType().equals("REF") ? srcProp.getFullname() + ".number" : srcProp.getFullname()));
        entry.set("src_desc", (Object)srcProp.getLabel());
    }

    private static void setTarColumnsFromField(PropModel tarProp, DynamicObject entry) {
        entry.set("tar_column", (Object)(tarProp.getDataType().equals("REF") ? tarProp.getFullname() + ".number" : tarProp.getFullname()));
        entry.set("tar_desc", (Object)tarProp.getLabel());
    }

    public static List<Map<String, Object>> toList(DynamicObjectCollection mapping_entries) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject entry : mapping_entries) {
            Map<String, Object> map = FieldMappingUtil.buildMap(entry);
            list.add(map);
        }
        return list;
    }

    private static Map<String, Object> buildMap(DynamicObject entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", entry.get("id"));
        map.put("tar_column", entry.get("tar_column"));
        map.put("tar_desc", entry.get("tar_desc"));
        map.put("fixed_value", entry.get("fixed_value"));
        map.put("src_column", entry.get("src_column"));
        map.put("src_desc", entry.get("src_desc"));
        map.put("aggr_fn", entry.get("aggr_fn"));
        map.put("vc_rule", ResourceEditorUtil.toMap((DynamicObject)entry.get("vc_rule")));
        return map;
    }
}

