/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.fm;

import java.io.Serializable;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.IDService;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.SetFilterUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.fm.FieldMappingUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.fm.PropModelMappingItem;

public class TransferFieldFormPlugin
extends AbstractResourceEditorFormPlugin
implements CellClickListener {
    @Override
    protected String getResourceType() {
        return "DataMapping.FieldMapping";
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        IDataModel model = this.getModel();
        if (!details.isEmpty()) {
            model.setValue("input", ((Map)details.get("input")).get("id"));
            model.setValue("src_system", details.get("src_system"));
            model.setValue("output", ((Map)details.get("output")).get("id"));
            model.setValue("tar_system", details.get("tar_system"));
            model.setValue("mapping_entries", (Object)this.toObjectCollection((List)details.get("mapping_entries")));
        }
    }

    @Override
    protected void lockModel() {
        super.lockModel();
        this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output"});
    }

    private DynamicObjectCollection toObjectCollection(List<Map<String, Object>> fields) {
        DynamicObjectCollection mapping_entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("mapping_entries");
        mapping_entries.clear();
        for (Map<String, Object> entry : fields) {
            DynamicObject new_entry = mapping_entries.addNew();
            new_entry.set("id", entry.get("id"));
            new_entry.set("tar_column", entry.get("tar_column"));
            new_entry.set("tar_desc", entry.get("tar_desc"));
            new_entry.set("fixed_value", entry.get("fixed_value"));
            new_entry.set("src_column", entry.get("src_column"));
            new_entry.set("src_desc", entry.get("src_desc"));
            new_entry.set("aggr_fn", entry.get("aggr_fn"));
            if (entry.get("vc_rule") == null) {
                new_entry.set("vc_rule", null);
                continue;
            }
            new_entry.set("vc_rule", (Object)ResourceEditorUtil.fromMap((Map)entry.get("vc_rule")));
        }
        return mapping_entries;
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        IDataModel model = this.getModel();
        Map<String, Object> details = this.collectBasic(model);
        List<Map<String, Object>> mapping_entries = ResourceEditorUtil.toList((DynamicObjectCollection)model.getValue("mapping_entries"));
        details.put("mapping_entries", mapping_entries);
        return details;
    }

    private Map<String, Object> collectBasic(IDataModel model) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        DynamicObject output = (DynamicObject)model.getValue("output");
        details.put("output", ResourceEditorUtil.toMap(output));
        details.put("tar_system", model.getValue("tar_system"));
        DynamicObject input = (DynamicObject)model.getValue("input");
        details.put("input", ResourceEditorUtil.toMap(input));
        details.put("src_system", model.getValue("src_system"));
        return details;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "input", "output", "vc_rule");
        ResourceEditorUtil.bindResourceSelector((AbstractFormPlugin)this, "input", "output");
        this.addClickListeners(new String[]{"tar_column", "src_column", "aggr_fn"});
        EntryGrid mapping_entries = (EntryGrid)this.getControl("mapping_entries");
        mapping_entries.addCellClickListener((CellClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        TextEdit source = (TextEdit)evt.getSource();
        String fieldKey = source.getFieldKey();
        if ("src_column".equals(fieldKey)) {
            int[] entries = ((EntryGrid)this.getControl("mapping_entries")).getSelectRows();
            int row = entries[0];
            this.buildInputParams(row, fieldKey);
        } else if ("tar_column".equals(fieldKey)) {
            int[] entries = ((EntryGrid)this.getControl("mapping_entries")).getSelectRows();
            int row = entries[0];
            this.buildOutputParams(row, fieldKey);
        } else if (fieldKey.equals("aggr_fn")) {
            int[] entries = ((EntryGrid)this.getControl("mapping_entries")).getSelectRows();
            int row = entries[0];
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("$row", row);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_aggr_fn_selecor", (String)ResManager.loadKDString((String)"\u9009\u62e9\u805a\u5408\u51fd\u6570", (String)"TransferFieldFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), params, (String)"get_aggr_fn");
        }
    }

    private void buildOutputParams(int row, String fieldKey) {
        long output_id = this.getModel().getDataEntity().getLong("output_id");
        if (output_id == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u6570\u636e\u3002", (String)"TransferFieldFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Resource resource = ResourceUtil.getResource((long)output_id);
        List fields = ((AbstractDataModel)resource).getDataType().getFields();
        if (fields.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u76ee\u6807\u6570\u636e\u3011\u6ca1\u6709\u5b57\u6bb5\u53ef\u9009\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TransferFieldFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        HashMap<String, Object> customData = new HashMap<String, Object>();
        customData.put("$row", row);
        customData.put("#FLAG", fieldKey);
        param.put("customData", customData);
        param.put("resourceId", Long.valueOf(output_id));
        param.put("single", Boolean.FALSE);
        FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"TransferFieldFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)"get_fields");
    }

    private void buildInputParams(int row, String fieldKey) {
        long input_id = this.getModel().getDataEntity().getLong("input_id");
        if (input_id == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u6570\u636e\u3002", (String)"TransferFieldFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        Resource resource = ResourceUtil.getResource((long)input_id);
        List fields = ((AbstractDataModel)resource).getDataType().getFields();
        if (fields.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u6e90\u6570\u636e\u3011\u6ca1\u6709\u5b57\u6bb5\u53ef\u9009\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TransferFieldFormPlugin_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Serializable> param = new HashMap<String, Serializable>();
        HashMap<String, Object> customData = new HashMap<String, Object>();
        customData.put("$row", row);
        customData.put("#FLAG", fieldKey);
        param.put("customData", customData);
        param.put("resourceId", Long.valueOf(input_id));
        param.put("single", Boolean.FALSE);
        FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5", (String)"TransferFieldFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)"get_fields");
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("auto_mapping".equals(args.getOperateKey())) {
            this.autoMap();
        }
    }

    private void autoMap() {
        long input_id = this.getModel().getDataEntity().getLong("input_id");
        long output_id = this.getModel().getDataEntity().getLong("output_id");
        if (input_id == 0L || output_id == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u6570\u636e\u548c\u76ee\u6807\u6570\u636e\u3002", (String)"TransferFieldFormPlugin_7", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        List<PropModelMappingItem> PropModelMappingItems = FieldMappingUtil.getPropModelMappingItemList(input_id, output_id);
        this.updateViewEntry(PropModelMappingItems);
    }

    private void updateViewEntry(List<PropModelMappingItem> PropModelMappingItems) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection mapping_entries = dataEntity.getDynamicObjectCollection("mapping_entries");
        mapping_entries.clear();
        long output_id = this.getModel().getDataEntity().getLong("output_id");
        int index = 0;
        FieldMappingUtil.addEntry(mapping_entries, PropModelMappingItems, index, output_id);
        dataEntity.set("mapping_entries", (Object)mapping_entries);
        this.getView().updateView("mapping_entries");
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        try {
            ResourceEditorUtil.closedResourceSelector(this, closedCallBackEvent);
            if (action.equals("get_fields")) {
                Object returnData = closedCallBackEvent.getReturnData();
                this.setFields(returnData);
            } else if ("get_aggr_fn".equals(action)) {
                SetFilterUtil.setReturnVariable((ClosedCallBackEvent)closedCallBackEvent, (IFormView)this.getView(), (String)"mapping_entries", (String)"aggr_fn", (String)"aggr_fn");
            }
        }
        catch (Throwable e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    public void setFields(Object returnData) {
        if (returnData instanceof List) {
            DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("mapping_entries");
            List dataList = (List)returnData;
            if (dataList.size() > 0) {
                this.updateSelectorEntryByDataList(entries, dataList);
                this.getView().updateView("mapping_entries");
            }
        }
    }

    private void updateSelectorEntryByDataList(DynamicObjectCollection entries, List<Map<String, Object>> dataList) {
        int index = 0;
        for (Map<String, Object> map : dataList) {
            DynamicObject object;
            int row;
            Map customData = (Map)map.get("customData");
            if ("src_column".equals(customData.get("#FLAG"))) {
                row = D.i(customData.get("$row")) + index;
                object = this.addNewEntry(entries, row);
                object.set("src_column", map.get("fullnumber"));
                object.set("src_desc", (Object)this.buildDesc(map));
            } else {
                row = D.i(customData.get("$row")) + index;
                object = this.addNewEntry(entries, row);
                object.set("tar_column", map.get("fullnumber"));
                object.set("tar_desc", (Object)this.buildDesc(map));
            }
            ++index;
        }
    }

    private DynamicObject addNewEntry(DynamicObjectCollection entries, int row) {
        if (entries.size() > row) {
            return (DynamicObject)entries.get(row);
        }
        DynamicObject object = entries.addNew();
        if (object == null) {
            object = entries.addNew();
            object.set("id", (Object)IDService.get().genLongId());
            object.set("seq", (Object)row);
        }
        return object;
    }

    private String buildDesc(Map<String, Object> map) {
        String desc = D.s((Object)map.get("fulllabel")) + '-' + D.s((Object)map.get("type"));
        if (D.x((Object)map.get("is_primary_key"))) {
            desc = desc + ResManager.loadKDString((String)"-\u4e3b\u952e", (String)"TransferFieldFormPlugin_10", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]);
        }
        if (D.x((Object)map.get("is_required"))) {
            desc = desc + ResManager.loadKDString((String)"-\u5fc5\u586b", (String)"TransferFieldFormPlugin_11", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]);
        }
        return desc;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String field_name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        IDataModel model = this.getModel();
        if ("input".equals(field_name)) {
            if (newValue == null) {
                model.setValue("src_system", null);
            } else {
                long id = ((DynamicObject)newValue).getLong("id");
                DynamicObject output = (DynamicObject)model.getValue("output");
                if (output == null || id != output.getLong("id")) {
                    String scopeName = ResourceUtil.getResource((long)id).getScopeName();
                    model.setValue("src_system", (Object)scopeName);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6a21\u578b\u4e0e\u8f93\u51fa\u6a21\u578b\u4e0d\u80fd\u76f8\u540c\u3002", (String)"TransferFieldFormPlugin_12", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    model.setValue("input", changeSet[0].getOldValue());
                }
            }
        } else if ("output".equals(field_name)) {
            if (newValue == null) {
                model.setValue("tar_system", null);
            } else {
                long id = ((DynamicObject)newValue).getLong("id");
                DynamicObject input = (DynamicObject)model.getValue("input");
                if (input == null || input.getLong("id") != id) {
                    String scopeName = ResourceUtil.getResource((long)id).getScopeName();
                    model.setValue("tar_system", (Object)scopeName);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6a21\u578b\u4e0e\u8f93\u51fa\u6a21\u578b\u4e0d\u80fd\u76f8\u540c\u3002", (String)"TransferFieldFormPlugin_12", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    model.setValue("output", changeSet[0].getOldValue());
                }
            }
        } else if ("tar_column".equals(field_name)) {
            DynamicObject row = model.getEntryRowEntity("mapping_entries", changeSet[0].getRowIndex());
            if (D.s((Object)changeSet[0].getNewValue()) == null) {
                row.set("tar_desc", (Object)"");
            }
            this.getView().updateView("mapping_entries");
        } else if ("src_column".equals(field_name)) {
            this.refreshFieldMapping(changeSet);
        }
    }

    private void refreshFieldMapping(ChangeData[] changeSet) {
        DynamicObject row = this.getModel().getEntryRowEntity("mapping_entries", changeSet[0].getRowIndex());
        if (D.s((Object)changeSet[0].getNewValue()) == null) {
            row.set("src_desc", (Object)"");
            row.set("aggr_fn", (Object)"");
            row.set("vc_rule", null);
        }
        this.getView().updateView("mapping_entries");
    }

    public void cellClick(CellClickEvent evt) {
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equals(operationKey)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection mapping_entries = model.getDataEntity(true).getDynamicObjectCollection("mapping_entries");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject obj : mapping_entries) {
                if (StringUtil.isEmpty((String)obj.getString("fixed_value")) || StringUtil.isEmpty((String)obj.getString("src_column"))) continue;
                sb.append(ResManager.loadKDString((String)"\u7b2c", (String)"TransferFieldFormPlugin_13", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0])).append(obj.get("seq")).append(ResManager.loadKDString((String)"\u884c\u4e0d\u80fd\u540c\u65f6\u914d\u7f6e\u6e90\u5b57\u6bb5\u548c\u76f4\u63a5\u8d4b\u503c", (String)"TransferFieldFormPlugin_14", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0])).append('\n');
            }
            if (sb.length() > 0) {
                args.setCancel(true);
                this.getView().showTipNotification(sb.toString());
            }
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
        int row = evt.getRow();
        if ("src_column".equals(fieldKey)) {
            this.buildInputParams(row, fieldKey);
        } else if ("tar_column".equals(fieldKey)) {
            this.buildOutputParams(row, fieldKey);
        } else if (fieldKey.equals("aggr_fn")) {
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("$row", row);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_aggr_fn_selecor", (String)ResManager.loadKDString((String)"\u9009\u62e9\u805a\u5408\u51fd\u6570", (String)"TransferFieldFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), params, (String)"get_aggr_fn");
        }
    }
}

