/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.guide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.cache.data.DataCopyTrigger;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.build.XDataCopyBuild;
import kd.isc.iscx.platform.core.res.meta.build.XDataTriggerBuild;
import kd.isc.iscx.platform.core.res.meta.build.XFlowNodeParam;

public class DataCopy2DataStreamFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log logger = LogFactory.getLog(DataCopy2DataStreamFormPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit isc_data_copy_trigger;
        BasedataEdit solution_catalog;
        BasedataEdit tar_module;
        super.registerListener(e);
        BasedataEdit src_module = (BasedataEdit)this.getView().getControl("src_module");
        if (src_module != null) {
            src_module.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tar_module = (BasedataEdit)this.getView().getControl("tar_module")) != null) {
            tar_module.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((solution_catalog = (BasedataEdit)this.getView().getControl("solution_catalog")) != null) {
            solution_catalog.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((isc_data_copy_trigger = (BasedataEdit)this.getView().getControl("isc_data_copy_trigger")) != null) {
            isc_data_copy_trigger.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit isc_data_copy = (BasedataEdit)this.getView().getControl("isc_data_copy");
        if (isc_data_copy_trigger != null) {
            isc_data_copy.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        BasedataEdit dbLink = (BasedataEdit)this.getControl("tar_dataflow");
        dbLink.addBeforeF7ViewDetailListener(evt -> {
            evt.setCancel(true);
            ResourceEditorUtil.openResourceEditor(D.l((Object)evt.getPkId()), this, null);
        });
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "trans".equals((oper = (AbstractOperate)args.getSource()).getOperateKey())) {
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (entryentity.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u542f\u52a8\u65b9\u6848\u3002", (String)"DataCopy2DataStreamFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dataCopy = DataCopySchema.get((long)D.l((Object)this.getModel().getValue("isc_data_copy_id")));
            if (dataCopy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u96c6\u6210\u65b9\u6848\u3002", (String)"DataCopy2DataStreamFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            try {
                for (int i = 0; i < entryentity.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)((DynamicObject)entryentity.get(i)).get("isc_data_copy_trigger");
                    if (dynamicObject == null) {
                        return;
                    }
                    DynamicObject dataCopyTrigger = DataCopyTrigger.get((long)D.l((Object)dynamicObject.get("id")));
                    if ("MQ".equals(dataCopyTrigger.get("target_protocal"))) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6682\u672a\u652f\u6301\u3010\u76ee\u6807\u6570\u636e\u63a8\u9001\u65b9\u5f0f\u4e3aMQ\u3011\u7684\u542f\u52a8\u65b9\u6848\u5feb\u901f\u8f6c\u6362\uff0c\u8bf7\u5220\u9664\u7b2c%1$S\u884c\u542f\u52a8\u65b9\u6848\u3002", (String)"DataCopy2DataStreamFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), i + 1));
                        args.setCancel(true);
                    } else if (0L == this.getRealDataSource(dataCopyTrigger, dataCopy, "new_source_system", "data_source").getDbLink()) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$S\u884c\u542f\u52a8\u65b9\u6848,\u5b9e\u9645\u3010\u6e90\u7cfb\u7edf\u3011\u672a\u7ed1\u5b9a\u8fde\u63a5\uff0c\u8bf7\u5220\u9664", (String)"DataCopy2DataStreamFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), i + 1));
                        args.setCancel(true);
                    } else {
                        if (0L != this.getRealDataSource(dataCopyTrigger, dataCopy, "new_target_system", "data_target").getDbLink()) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$S\u884c\u542f\u52a8\u65b9\u6848,\u5b9e\u9645\u3010\u76ee\u6807\u7cfb\u7edf\u3011\u672a\u7ed1\u5b9a\u8fde\u63a5\uff0c\u8bf7\u5220\u9664", (String)"DataCopy2DataStreamFormPlugin_5", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), i + 1));
                        args.setCancel(true);
                    }
                    break;
                }
            }
            catch (Exception e) {
                FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
                args.setCancel(true);
            }
        }
    }

    private DataSource getRealDataSource(DynamicObject trigger, DynamicObject dataCopy, String newSystem, String dataSourceProp) {
        DynamicObject srcDataSource = trigger.getDynamicObject(newSystem);
        if (srcDataSource == null) {
            srcDataSource = dataCopy.getDynamicObject(dataSourceProp);
        }
        return DataSource.get((long)D.l((Object)srcDataSource.getPkValue()));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("trans".equals(operateKey) && args.getOperationResult().isSuccess()) {
            try {
                this.doConvert();
            }
            catch (Exception e) {
                FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConvert() {
        DynamicObject dataCopy = DataCopySchema.get((long)D.l((Object)this.getModel().getValue("isc_data_copy_id")));
        DynamicObject srcModule = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("src_module_id"), (String)"iscx_catalog");
        DynamicObject tarModule = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("tar_module_id"), (String)"iscx_catalog");
        DynamicObject solutionCatalog = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("solution_catalog_id"), (String)"iscx_catalog");
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        HashSet<Integer> batchSizeSet = new HashSet<Integer>();
        for (DynamicObject object : entryentity) {
            DynamicObject dataCopyTrigger = DataCopyTrigger.get((long)D.l((Object)object.get("isc_data_copy_trigger.id")));
            batchSizeSet.add(dataCopyTrigger.getInt("batch_size"));
        }
        XDataCopyBuild xDataCopyBuild = new XDataCopyBuild(dataCopy, srcModule, tarModule, solutionCatalog, batchSizeSet);
        for (DynamicObject object : entryentity) {
            DynamicObject dataCopyTrigger = DataCopyTrigger.get((long)D.l((Object)object.get("isc_data_copy_trigger.id")));
            XDataTriggerBuild triggerBuild = null;
            try {
                triggerBuild = new XDataTriggerBuild(dataCopyTrigger, xDataCopyBuild);
                triggerBuild.build();
                object.set("status", (Object)"success");
                object.set("errorstr", (Object)"");
                object.set("errorstr_tag", (Object)"");
            }
            catch (Exception e) {
                object.set("status", (Object)"error");
                object.set("errorstr", (Object)StringUtil.getCascadeMessage((Throwable)e));
                object.set("errorstr_tag", (Object)e.getMessage());
            }
            finally {
                this.analysisResult(object, triggerBuild, xDataCopyBuild);
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8f6c\u6362\u7ed3\u675f,\u8bf7\u67e5\u770b\u5177\u4f53\u8f6c\u6362\u7ed3\u679c\u3002", (String)"DataCopy2DataStreamFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        this.getView().updateView("entryentity");
        this.saveData(xDataCopyBuild, entryentity);
    }

    private void analysisResult(DynamicObject object, XDataTriggerBuild triggerBuild, XDataCopyBuild xDataCopyBuild) {
        ArrayList<Long> ids = new ArrayList<Long>(xDataCopyBuild.getBuildResList().size());
        if (triggerBuild != null) {
            List list = triggerBuild.getBuildResList();
            for (XFlowNodeParam xFlowNodeParam : list) {
                ids.add(D.l(xFlowNodeParam.getDataModel().get("id")));
            }
            if (triggerBuild.getDataFlow() != null) {
                object.set("tar_dataflow", (Object)triggerBuild.getDataFlow());
            } else {
                List res = triggerBuild.getRollBackRes();
                for (int i = res.size() - 1; i >= 0; --i) {
                    DynamicObject obj = (DynamicObject)res.get(i);
                    long id = obj.getLong("id");
                    try {
                        ConnectorUtil.delete((String)"iscx_resource", (Object)id);
                        ids.remove(id);
                        continue;
                    }
                    catch (Exception e) {
                        logger.warn("delete_iscx_resource_fail" + id + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
                    }
                }
            }
        }
        for (DynamicObject dynamicObject : xDataCopyBuild.getBuildResList()) {
            ids.add(D.l((Object)dynamicObject.getLong("id")));
        }
        object.set("resids", (Object)Json.toString(ids, (boolean)true));
        object.set("viewres", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"DataCopy2DataStreamFormPlugin_9", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
    }

    private void saveData(XDataCopyBuild xDataCopyBuild, DynamicObjectCollection entryentity) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"iscx_guide_resource");
        dynamicObject.set("id", (Object)IDService.get().genLongId());
        String number = xDataCopyBuild.getPre_number() + "_" + xDataCopyBuild.getDataCopy().getString("number");
        dynamicObject.set("number", (Object)StringUtil.trim((String)number, (int)90));
        String name = String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u8f6c\u6570\u636e\u6d41_%s", (String)"DataCopy2DataStreamFormPlugin_7", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), xDataCopyBuild.getDataCopy().get("name"));
        dynamicObject.set("name", (Object)StringUtil.trim((String)name, (int)90));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isc_data_copy", xDataCopyBuild.getDataCopy().getString("id"));
        map.put("src_module", xDataCopyBuild.getSrcModule().getString("id"));
        map.put("tar_module", xDataCopyBuild.getTarModule().getString("id"));
        map.put("solution_catalog", xDataCopyBuild.getSolutionCatalog().getString("id"));
        ArrayList entryList = new ArrayList(entryentity.size());
        for (DynamicObject object : entryentity) {
            HashMap<String, Object> t = new HashMap<String, Object>();
            t.put("isc_data_copy_trigger", object.getDynamicObject("isc_data_copy_trigger").get("id"));
            t.put("status", object.get("status"));
            t.put("errorstr", object.get("errorstr"));
            t.put("errorstr_tag", object.get("errorstr_tag"));
            t.put("resids", object.get("resids"));
            if ("success".equals(D.s((Object)object.get("status")))) {
                t.put("tar_dataflow", object.getDynamicObject("tar_dataflow").get("id"));
            }
            entryList.add(t);
        }
        map.put("entryList", entryList);
        dynamicObject.set("guidedata_tag", (Object)Json.toString(map));
        dynamicObject.set("status", (Object)"A");
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("type", (Object)"datacopy");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        if (event.getSource() instanceof BasedataEdit) {
            String fieldKey = event.getProperty().getName();
            if (fieldKey.equals("isc_data_copy_trigger")) {
                DynamicObject data_copy = (DynamicObject)this.getModel().getValue("isc_data_copy");
                if (data_copy == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u65b9\u6848", (String)"DataCopy2DataStreamFormPlugin_8", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    event.setCancel(true);
                } else {
                    List<String> types = Arrays.asList("auto", "manual", "event");
                    QFilter[] qFilters = new QFilter[]{new QFilter("data_copy.id", "=", (Object)D.l((Object)data_copy.getString("id"))).and("trigger_type", "in", types)};
                    if ("click".equals(event.getSourceMethod())) {
                        FormOpener.showF7((AbstractFormPlugin)this, (String)"isc_data_copy_trigger", (QFilter[])qFilters, (String)"select_trigger", (boolean)true);
                        event.setCancel(true);
                    } else if ("getLookUpList".equals(event.getSourceMethod())) {
                        event.setCustomQFilters(Collections.singletonList(qFilters[0]));
                    }
                }
            } else if ("click".equals(event.getSourceMethod())) {
                event.setCancel(true);
                HashMap<String, String> params = new HashMap<String, String>(1);
                if (fieldKey.contains("module")) {
                    params.put("resType", "DataModel.Entity");
                } else if (fieldKey.contains("solution_catalog")) {
                    params.put("resType", "DataWeaver.DataFlow");
                }
                FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_catalog_tree_select", null, params, (String)fieldKey);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("select_trigger".equals(actionId)) {
            this.setTriggerEntry(e);
            return;
        }
        Object returnData = e.getReturnData();
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            this.getModel().setValue(e.getActionId(), data.get("id"));
        }
    }

    private void setTriggerEntry(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection collection = (ListSelectedRowCollection)e.getReturnData();
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            entryentity.clear();
            for (ListSelectedRow selectedRow : collection) {
                long id = D.l((Object)selectedRow.getPrimaryKeyValue());
                DynamicObject item = entryentity.addNew();
                item.set("isc_data_copy_trigger", (Object)BusinessDataServiceHelper.loadSingleFromCache((String)"isc_data_copy_trigger", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)}));
            }
            this.getView().updateView("entryentity");
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        BasedataEdit edit;
        if (event.getSource() instanceof BasedataEdit && "isc_data_copy".equals((edit = (BasedataEdit)event.getSource()).getKey())) {
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            entryentity.clear();
            DynamicObject obj = (DynamicObject)this.getModel().getValue("isc_data_copy");
            if (obj != null) {
                DynamicObject[] dynamicObjects;
                Long id = obj.getLong("id");
                for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"isc_data_copy_trigger", (String)"id,number,name,trigger_type", (QFilter[])new QFilter[]{new QFilter("data_copy.id", "=", (Object)id)})) {
                    DynamicObject viewObj = entryentity.addNew();
                    viewObj.set("isc_data_copy_trigger", (Object)dynamicObject);
                }
            }
            this.getView().updateView("entryentity");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt.getRowIndex() >= 0 && "viewres".equals(evt.getFieldName())) {
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            DynamicObject entry = (DynamicObject)entryentity.get(evt.getRowIndex());
            if ("success".equals(D.s((Object)entry.get("status")))) {
                DynamicObject dataFlow = (DynamicObject)entry.get("tar_dataflow");
                if (dataFlow == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8d44\u6e90\u53ef\u67e5\u770b\u3002", (String)"DataCopy2DataStreamFormPlugin_10", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                Set resourceIds = ResourceUtil.findAllResourcesIds((long)dataFlow.getLong("id"));
                HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
                map.put("hidden_schemefilterview", true);
                FormOpener.openBillListWithParam((AbstractFormPlugin)this, (String)"iscx_resource", Collections.singletonList(new QFilter("id", "in", (Object)resourceIds)), null, map);
            } else {
                String ids = D.s((Object)entry.get("resids"));
                if (ids == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8d44\u6e90\u53ef\u67e5\u770b\u3002", (String)"DataCopy2DataStreamFormPlugin_10", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                List pkStr = (List)Json.toObject((String)ids);
                ArrayList<Long> pks = new ArrayList<Long>(pkStr.size());
                for (Object o : pkStr) {
                    pks.add(D.l(o));
                }
                FormOpener.showList((AbstractFormPlugin)this, (String)"iscx_resource", (QFilter)new QFilter("id", "in", pks));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("isc_data_copy") != null) {
            this.getModel().setValue("isc_data_copy", (Object)this.getResource("isc_data_copy", D.l(customParams.get("isc_data_copy"))));
            this.getModel().setValue("src_module", (Object)this.getResource("iscx_catalog", D.l(customParams.get("src_module"))));
            this.getModel().setValue("tar_module", (Object)this.getResource("iscx_catalog", D.l(customParams.get("tar_module"))));
            this.getModel().setValue("solution_catalog", (Object)this.getResource("iscx_catalog", D.l(customParams.get("solution_catalog"))));
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            entryentity.clear();
            List entryList = (List)customParams.get("entryList");
            for (Map map : entryList) {
                DynamicObject obj = entryentity.addNew();
                obj.set("isc_data_copy_trigger", (Object)this.getResource("isc_data_copy_trigger", D.l(map.get("isc_data_copy_trigger"))));
                obj.set("status", (Object)D.s(map.get("status")));
                obj.set("errorstr", (Object)D.s(map.get("errorstr")));
                obj.set("errorstr_tag", (Object)D.s(map.get("errorstr_tag")));
                obj.set("resids", (Object)D.s(map.get("resids")));
                obj.set("viewres", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"DataCopy2DataStreamFormPlugin_9", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                if (!"success".equals(D.s(map.get("status")))) continue;
                obj.set("tar_dataflow", (Object)this.getResource("iscx_resource", D.l(map.get("tar_dataflow"))));
            }
            this.getView().updateView("entryentity");
            this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap", "flexpanelap1", "trans"});
        }
    }

    public DynamicObject getResource(String entity, Object id) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)entity, (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
        return obj;
    }
}

