/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.guide;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.platform.core.res.CatalogUtil;

public class DataFlowGuideStepFormPlugin
extends AbstractFormPlugin {
    private static final String LASTSTEP = "laststep";
    private static final String NEXTSTEP = "nextstep";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private void putCache(String key, Object o) {
        this.getView().getFormShowParameter().getCustomParams().put(key, o);
        this.getView().cacheFormShowParameter();
    }

    private Object getCacheByKey(String key) {
        return this.getView().getFormShowParameter().getCustomParams().get(key);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int step = D.i((Object)this.getCacheByKey("current_step"));
        if (step == 0) {
            step = 1;
            this.putCache("current_step", step);
        }
        this.showChildPage(step);
        this.setCurrentVisibleAndEnable();
    }

    private void showChildPage(int step) {
        switch (step) {
            case 1: {
                this.showDataFlowBaseInfoPage();
                return;
            }
            case 2: {
                this.showResourceDetailPage();
                return;
            }
        }
    }

    private void showResourceDetailPage() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("iscx_guide_resourcedetail");
        param.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        param.setParentPageId(this.getView().getPageId());
        this.putCache("iscx_guide_resourcedetail_pageid", param.getPageId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey("mainpane");
        param.setAppId("iscx");
        param.getOpenStyle().setInlineStyleCss(this.getStyleCss());
        this.getView().showForm(param);
    }

    private void collectChildPageData(int step) {
        switch (step) {
            case 1: {
                this.collectBaseDataInfo();
                return;
            }
            case 2: {
                this.collectResourceDetailData();
                return;
            }
        }
    }

    private void collectResourceDetailData() {
        String pageID = D.s((Object)this.getCacheByKey("iscx_guide_resourcedetail_pageid"));
        DynamicObjectCollection collection = this.getView().getView(pageID).getModel().getEntryEntity("entryentity");
        List<Map<String, Object>> list = ResourceEditorUtil.toList(collection);
        this.putCache("isc_guide_resourcedetail_data", list);
        DynamicObjectCollection mainCollection = this.getView().getView(pageID).getModel().getEntryEntity("mainentity");
        List<Map<String, Object>> mainentity = ResourceEditorUtil.toList(mainCollection);
        this.putCache("isc_guide_resourcedetail_data_m", mainentity);
        Map map = (Map)this.getView().getView(pageID).getFormShowParameter().getCustomParam("data_model_id");
        this.putCache("data_model_id", map);
    }

    private void collectBaseDataInfo() {
        String pageID = D.s((Object)this.getCacheByKey("iscx_guide_baseinfo_pageid"));
        Map map = this.getView().getView(pageID).getModel().getDataEntityType().getAllFields();
        HashMap json = new HashMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            json.put(entry.getKey(), this.getView().getView(pageID).getModel().getValue((String)entry.getKey()));
        }
        Map connections = (Map)this.getView().getView(pageID).getFormShowParameter().getCustomParam("connections");
        this.putCache("iscx_guide_baseinfo_data", json);
        this.putCache("connections", connections);
    }

    private void showDataFlowBaseInfoPage() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("iscx_guide_baseinfo");
        param.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        param.setParentPageId(this.getView().getPageId());
        this.putCache("iscx_guide_baseinfo_pageid", param.getPageId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey("mainpane");
        param.setAppId("iscx");
        param.getOpenStyle().setInlineStyleCss(this.getStyleCss());
        this.getView().showForm(param);
    }

    private StyleCss getStyleCss() {
        StyleCss css = new StyleCss();
        css.setWidth("800px");
        css.setHeight("720px");
        return css;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String op = args.getOperateKey();
        int step = D.i((Object)this.getCacheByKey("current_step"));
        if (NEXTSTEP.equals(op)) {
            this.collectChildPageData(step);
            if (this.checkChildPageData(step)) {
                if (step == 1) {
                    this.createResourceData();
                    this.getView().getFormShowParameter().getCustomParams().put("isLockBaseInfo", Boolean.TRUE);
                    this.getView().cacheFormShowParameter();
                }
                this.showChildPage(++step);
                this.putCache("current_step", step);
                this.setCurrentVisibleAndEnable();
            }
        } else if (LASTSTEP.equals(op)) {
            this.collectChildPageData(step);
            this.showChildPage(--step);
            this.putCache("current_step", step);
            this.setCurrentVisibleAndEnable();
        } else if ("close".equals(op)) {
            this.collectChildPageData(step);
            if (D.l((Object)this.getCacheByKey("iscx_guide_id")) != 0L) {
                this.returnDataToParent();
                this.getView().close();
            } else {
                Map map = (Map)this.getCacheByKey("iscx_guide_baseinfo_data");
                if (D.s(map.get("number")) != null && D.s(map.get("name")) != null) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("return_guide_info", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u4fdd\u5b58\u5f53\u524d\u5411\u5bfc,\u53ef\u518d\u6b21\u8fdb\u5165\u5411\u5bfc\u3002", (String)"DataFlowGuideStepFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
                } else {
                    this.getView().close();
                }
            }
        }
    }

    private void createResourceData() {
        Map map = (Map)this.getCacheByKey("iscx_guide_baseinfo_data");
        DynamicObject srcCatalog = this.createSrcCatalog(map);
        this.getView().getFormShowParameter().getCustomParams().put("srcCatalog", srcCatalog.getPkValue());
        DynamicObject tarCatalog = this.createTarCatalog(map);
        this.getView().getFormShowParameter().getCustomParams().put("tarCatalog", tarCatalog.getPkValue());
        this.getView().cacheFormShowParameter();
    }

    private DynamicObject createSrcCatalog(Map<String, Object> map) {
        DynamicObject srcIndustry = this.createCatalog(D.s((Object)map.get("src_industry")), "Industry", null);
        DynamicObject srcSystem = this.createCatalog(D.s((Object)map.get("src_system")), "System", srcIndustry);
        this.getView().getFormShowParameter().getCustomParams().put("src_system_catalog", srcSystem.getPkValue());
        DynamicObject srcModule = this.createCatalog(D.s((Object)map.get("src_module")), "Module", srcSystem);
        return srcModule;
    }

    private DynamicObject createTarCatalog(Map<String, Object> map) {
        DynamicObject tarIndustry = this.createCatalog(D.s((Object)map.get("tar_industry")), "Industry", null);
        DynamicObject tarSystem = this.createCatalog(D.s((Object)map.get("tar_system")), "System", tarIndustry);
        this.getView().getFormShowParameter().getCustomParams().put("tar_system_catalog", tarSystem.getPkValue());
        DynamicObject tarModule = this.createCatalog(D.s((Object)map.get("tar_module")), "Module", tarSystem);
        return tarModule;
    }

    private DynamicObject createCatalog(String name, String type, DynamicObject parent) {
        DynamicObject dynamicObject = this.queryCatalog(type, name, parent);
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"iscx_catalog");
            dynamicObject.set("name", (Object)name);
            dynamicObject.set("type", (Object)type);
            dynamicObject.set("parent", (Object)parent);
            dynamicObject.set("priority", (Object)9999);
            String longNumber = CatalogUtil.generateLongNumber((DynamicObject)dynamicObject);
            dynamicObject.set("long_number", (Object)longNumber);
            dynamicObject.set("icon_url", (Object)CatalogUtil.getDefaultLogo((String)type));
            dynamicObject.set("id", (Object)CatalogUtil.generateCatalogId((String)longNumber));
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"iscx_catalog", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                throw new KDBizException(operationResult.getMessage());
            }
        }
        return dynamicObject;
    }

    private DynamicObject queryCatalog(String type, String name, DynamicObject parent) {
        String number = Hash.mur32((Object[])new Object[]{name});
        String longNumber = parent != null ? parent.get("long_number") + "/" + number : type + "/" + number;
        QFilter qFilter = new QFilter("long_number", "=", (Object)longNumber.toUpperCase()).and(new QFilter("type", "=", (Object)type));
        if (parent != null) {
            qFilter.and(new QFilter("parent.id", "=", parent.get("id")));
        }
        return BusinessDataServiceHelper.loadSingle((String)"iscx_catalog", (QFilter[])new QFilter[]{qFilter});
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (MessageBoxResult.Yes == evt.getResult() && evt.getCallBackId().equals("return_guide_info")) {
            int step = D.i((Object)this.getCacheByKey("current_step"));
            this.collectChildPageData(step);
            this.returnDataToParent();
        } else {
            this.getView().returnDataToParent(null);
        }
        this.getView().close();
    }

    private void returnDataToParent() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        map.remove("iscx_guide_resourcedetail_pageid");
        map.remove("iscx_guide_baseinfo_pageid");
        map.remove("mainPageId");
        map.put("guide_type", "metadata");
        this.getView().returnDataToParent((Object)map);
    }

    private boolean checkChildPageData(int step) {
        if (step == 1) {
            return this.checkBaseInfoData();
        }
        if (step == 2) {
            return this.checkSelectMetaData();
        }
        return true;
    }

    private boolean checkSelectMetaData() {
        Map map = (Map)this.getCacheByKey("iscx_guide_metadata_data");
        if (map.get("src_modeldata") == null || map.get("tar_modeldata") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u597d\u6765\u6e90\u6570\u636e\u6a21\u578b\u53ca\u76ee\u6807\u6570\u636e\u6a21\u578b\uff0c\u6216\u53ef\u9009\u62e9\u96c6\u6210\u5bf9\u8c61\u5e76\u6307\u5b9a\u8d44\u6e90\u8def\u5f84\u540e\u70b9\u51fb\u751f\u6210\u6570\u636e\u6a21\u578b\u3002", (String)"DataFlowGuideStepFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkBaseInfoData() {
        Map map = (Map)this.getCacheByKey("iscx_guide_baseinfo_data");
        if (D.s(map.get("name")) == null || D.s(map.get("number")) == null || map.get("solution") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6570\u636e\u6d41\u4fe1\u606f\u7684\u5fc5\u586b\u5b57\u6bb5", (String)"DataFlowGuideStepFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getView().getFormShowParameter().getCustomParam("isc_guide_resourcedetail_data") == null) {
            DynamicObject catalog = (DynamicObject)map.get("solution");
            if (QueryServiceHelper.exists((String)"iscx_resource", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)D.s(map.get("number"))).and("catalog", "=", catalog.getPkValue())})) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u76ee\u5f55\u3010%1$s\u3011\u4e0b\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u6570\u636e\u6d41", (String)"DataFlowGuideStepFormPlugin_8", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), catalog.getString("name"), D.s(map.get("number"))));
                return false;
            }
        }
        DynamicObject dynamicObject = (DynamicObject)map.get("src_metadata");
        if (D.s(map.get("src_industry")) == null || dynamicObject == null || D.s(map.get("src_system")) == null || D.s(map.get("src_module")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6e90\u6a21\u578b\u4fe1\u606f\u7684\u5fc5\u586b\u5b57\u6bb5", (String)"DataFlowGuideStepFormPlugin_6", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getView().getFormShowParameter().getCustomParams().put("src_metadata_id", dynamicObject.getPkValue());
        dynamicObject = (DynamicObject)map.get("tar_metadata");
        if (D.s(map.get("tar_industry")) == null || dynamicObject == null || D.s(map.get("tar_system")) == null || D.s(map.get("tar_module")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u76ee\u6807\u6a21\u578b\u4fe1\u606f\u7684\u5fc5\u586b\u5b57\u6bb5", (String)"DataFlowGuideStepFormPlugin_7", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getView().getFormShowParameter().getCustomParams().put("tar_metadata_id", dynamicObject.getPkValue());
        this.getView().cacheFormShowParameter();
        return true;
    }

    private void setCurrentVisibleAndEnable() {
        int step = D.i((Object)this.getCacheByKey("current_step"));
        if (step == 0 || step == 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{LASTSTEP});
            this.getView().setEnable(Boolean.TRUE, new String[]{NEXTSTEP});
            this.getView().setVisible(Boolean.TRUE, new String[]{"steped1", "step2", "close", NEXTSTEP});
            this.getView().setVisible(Boolean.FALSE, new String[]{"step1", "steped2", LASTSTEP, "finishlogo1", "finishlogo2"});
        } else if (step == 2) {
            this.getView().setEnable(Boolean.TRUE, new String[]{LASTSTEP});
            this.getView().setEnable(Boolean.TRUE, new String[]{NEXTSTEP});
            this.getView().setVisible(Boolean.TRUE, new String[]{"steped2", LASTSTEP, "close", NEXTSTEP, "finishlogo1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"step2", "steped1", "finishlogo2", "step1", NEXTSTEP});
        }
    }
}

