/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.guide;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.df.DataFlowEditorUtil;
import kd.isc.iscx.formplugin.res.fm.FieldMappingUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.build.util.ModelUtil;
import kd.isc.iscx.platform.core.res.meta.dm.DataEntity;
import kd.isc.iscx.platform.core.res.meta.dm.DataTable;
import kd.isc.iscx.platform.core.res.meta.fm.PropModelMappingItem;
import kd.isc.iscx.platform.core.res.runtime.util.Util;

public class GuideUtil {
    public static DynamicObject createModel(long importMetadataPK, long catalogId) {
        return ModelUtil.createModel((long)importMetadataPK, (long)catalogId);
    }

    public static Object getFilterKey(String key) {
        switch (key) {
            case "src_industry": 
            case "tar_industry": {
                return "Industry";
            }
            case "src_module": 
            case "tar_module": {
                return "Module";
            }
            case "src_system": 
            case "tar_system": {
                return "System";
            }
        }
        return null;
    }

    public static long createTarDataLoad(DynamicObject dynamicObject, DynamicObject catalog) {
        DynamicObject object = (DynamicObject)dynamicObject.get("type");
        String type = D.s((Object)object.get("number"));
        if ("DataModel.Entity".equals(type)) {
            return GuideUtil.createEntityAction(dynamicObject, catalog);
        }
        if ("DataModel.Table".equals(type)) {
            return GuideUtil.createTableAction(dynamicObject, catalog);
        }
        return 0L;
    }

    public static DynamicObject createDataQuery(DynamicObject dynamicObject, DynamicObject catalog) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("ts_field", "id");
        DynamicObject input = BusinessDataServiceHelper.loadSingle((String)"iscx_resource", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"EMPTY_QUERY_PARAMS")});
        details.put("input", ResourceEditorUtil.toMap(input));
        details.put("output", ResourceEditorUtil.toMap(dynamicObject));
        details.put("filters", new ArrayList());
        List<Map<String, Object>> result_fields = GuideUtil.getFieldsList(dynamicObject);
        details.put("result_fields", result_fields);
        details.put("order_by_fields", new ArrayList());
        if (!result_fields.isEmpty()) {
            details.put("ts_field", GuideUtil.getTsField(result_fields));
        }
        return ResourceEditorUtil.createResourceDynamic("DataExtract.DataQuery", GuideUtil.generateNumber(dynamicObject.getString("number") + "_" + System.currentTimeMillis()), String.format(ResManager.loadKDString((String)"%s_\u6570\u636e\u67e5\u8be2", (String)"GuideUtil_11", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), dynamicObject.getString("name")), "", catalog, details);
    }

    private static String getTsField(List<Map<String, Object>> result_fields) {
        for (Map<String, Object> map : result_fields) {
            String str = D.s((Object)map.get("field_name"));
            if (str.contains(".")) continue;
            return str;
        }
        return null;
    }

    public static DynamicObject createAutoRes(DynamicObject dynamicObject, DynamicObject dataQuery, DynamicObject catalog, String schedule) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        ResourceEditorUtil.setInputAndOutputFromDataProvider(details, dataQuery);
        details.put("data_provider", ResourceEditorUtil.toMap(dataQuery));
        details.put("schedule", schedule == null ? "0 30 2 * * ?" : schedule);
        return ResourceEditorUtil.createResourceDynamic("EventModel.Timer", GuideUtil.generateNumber(dynamicObject.getString("number") + "_" + System.currentTimeMillis()), String.format(ResManager.loadKDString((String)"%s_\u5b9a\u65f6\u542f\u52a8", (String)"GuideUtil_12", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), dynamicObject.getString("name")), null, catalog, details);
    }

    public static DynamicObject createManualRes(DynamicObject dynamicObject, DynamicObject dataQuery, DynamicObject catalog) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        ResourceEditorUtil.setInputAndOutputFromDataProvider(details, dataQuery);
        details.put("data_provider", ResourceEditorUtil.toMap(dataQuery));
        return ResourceEditorUtil.createResourceDynamic("EventModel.Manual", GuideUtil.generateNumber(dynamicObject.getString("number") + "_" + System.currentTimeMillis()), String.format(ResManager.loadKDString((String)"%s_\u4eba\u5de5\u542f\u52a8", (String)"GuideUtil_13", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), dynamicObject.getString("name")), null, catalog, details);
    }

    public static long createEventRes(DynamicObject dataProvider, DynamicObject catalog) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("entity", ResourceEditorUtil.toMap(dataProvider));
        details.put("data_model", ResourceEditorUtil.toMap(dataProvider));
        details.put("event", null);
        details.put("batch_size", 0);
        List<Map<String, Object>> select_fields = GuideUtil.getFieldsList(dataProvider);
        details.put("select_fields", select_fields);
        return ResourceEditorUtil.createResource("EventModel.BizEvent", GuideUtil.generateNumber(dataProvider.getString("number") + "_" + System.currentTimeMillis()), String.format(ResManager.loadKDString((String)"%s_\u5355\u636e\u4e8b\u4ef6", (String)"GuideUtil_14", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), dataProvider.getString("name")), null, catalog, details);
    }

    private static List<Map<String, Object>> getFieldsList(DynamicObject dataProvider) {
        List select_fields = Util.getAllFields((long)D.l((Object)dataProvider.get("id")));
        for (Map select_field : select_fields) {
            select_field.put("data_type", D.s(select_field.get("data_type")));
        }
        return select_fields;
    }

    public static long createTableAction(DynamicObject dynamicObject, DynamicObject catalog) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("input", ResourceEditorUtil.toMap(dynamicObject));
        DynamicObject output = BusinessDataServiceHelper.loadSingle((String)"iscx_resource", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"RESPONSE_OF_DATA_LOAD")});
        details.put("output", ResourceEditorUtil.toMap(output));
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("field_label", "");
        map.put("data_type", "");
        map.put("is_candidate_key", "true");
        map.put("id", D.s((Object)IDService.get().genLongId()));
        DataTable dataTable = (DataTable)ResourceUtil.getResource((long)dynamicObject.getLong("id"));
        map.put("field_name", dataTable.getDataType().getPrimaryKey().getName());
        map.put("seq", 1);
        list.add(map);
        details.put("fields", list);
        details.put("data_action", "_SAVE");
        details.put("batch_size", 100);
        return ResourceEditorUtil.createResource("DataLoad.TableAction", GuideUtil.generateNumber(dynamicObject.getString("number") + "_" + System.currentTimeMillis()), String.format(ResManager.loadKDString((String)"%s_\u76ee\u6807\u6570\u636e\u8868\u64cd\u4f5c", (String)"GuideUtil_15", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), dynamicObject.getString("name")), "", catalog, details);
    }

    public static long createEntityAction(DynamicObject dynamicObject, DynamicObject catalog) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("input", ResourceEditorUtil.toMap(dynamicObject));
        DynamicObject output = BusinessDataServiceHelper.loadSingle((String)"iscx_resource", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"RESPONSE_OF_DATA_LOAD")});
        details.put("output", ResourceEditorUtil.toMap(output));
        details.put("proxy_user", "");
        details.put("batch_size", 10);
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("field_label", "");
        map.put("data_type", "");
        map.put("is_candidate_key", "true");
        map.put("id", D.s((Object)IDService.get().genLongId()));
        DataEntity dataEntity = (DataEntity)ResourceUtil.getResource((long)dynamicObject.getLong("id"));
        map.put("field_name", dataEntity.getDataType().getPrimaryKey().getName());
        map.put("seq", 1);
        list.add(map);
        details.put("fields", list);
        details.put("operation", "");
        details.put("operation_options", "");
        return ResourceEditorUtil.createResource("DataLoad.EntityAction", GuideUtil.generateNumber(dynamicObject.getString("number") + "_" + System.currentTimeMillis()), String.format(ResManager.loadKDString((String)"%s_\u76ee\u6807\u5b9e\u4f53\u64cd\u4f5c", (String)"GuideUtil_16", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), dynamicObject.getString("name")), "", catalog, details);
    }

    public static long createNoticeSend(DynamicObject output, DynamicObject catalog) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("data_model", ResourceEditorUtil.toMap(output));
        details.put("ierp_user_list", "");
        details.put("header", "");
        details.put("ierp_user_json", null);
        details.put("ierp_user_expr", "");
        details.put("content", "");
        return ResourceEditorUtil.createResource("DataLoad.NoticeSend", GuideUtil.generateNumber(D.s((Object)output.get("number")) + "_" + System.currentTimeMillis()), String.format(ResManager.loadKDString((String)"%s_\u901a\u77e5\u53d1\u9001", (String)"GuideUtil_17", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), D.s((Object)output.get("name"))), "", catalog, details);
    }

    public static String generateNumber(String name) {
        String number = Hash.mur32((Object[])new Object[]{name});
        char c = number.charAt(0);
        if (c >= '0' && c <= '9') {
            number = (char)(c + 71 - 48) + number;
        }
        return number + "_G";
    }

    public static long createFieldMapping(DynamicObject input, DynamicObject output, DynamicObject catalog) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("input", ResourceEditorUtil.toMap(input));
        details.put("src_system", ResourceUtil.getResource((long)D.l((Object)input.getPkValue())).getScopeName());
        details.put("output", ResourceEditorUtil.toMap(output));
        details.put("tar_system", ResourceUtil.getResource((long)D.l((Object)output.getPkValue())).getScopeName());
        List<PropModelMappingItem> propModelMappingItemList = FieldMappingUtil.getPropModelMappingItemList(D.l((Object)input.get("id")), D.l((Object)output.get("id")));
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"iscx_res_transfer_field_m");
        DynamicObjectCollection entries = object.getDynamicObjectCollection("mapping_entries");
        entries.clear();
        long outputId = D.l((Object)output.get("id"));
        int index = 0;
        FieldMappingUtil.addEntry(entries, propModelMappingItemList, index, outputId);
        List<Map<String, Object>> list = ResourceEditorUtil.toList(entries);
        details.put("mapping_entries", list);
        return ResourceEditorUtil.createResource("DataMapping.FieldMapping", GuideUtil.generateNumber(D.s((Object)input.get("number")) + D.s((Object)output.get("number")) + "_" + System.currentTimeMillis()), String.format(ResManager.loadKDString((String)"%1$s%2$s_\u5b57\u6bb5\u6620\u5c04", (String)"GuideUtil_18", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), D.s((Object)input.get("name")), D.s((Object)output.get("name"))), "", catalog, details);
    }

    public static long createScriptMapping(DynamicObject input, DynamicObject output, DynamicObject catalog) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("input", ResourceEditorUtil.toMap(input));
        details.put("src_system", ResourceUtil.getResource((long)D.l((Object)input.getPkValue())).getScopeName());
        details.put("output", ResourceEditorUtil.toMap(output));
        details.put("tar_system", ResourceUtil.getResource((long)D.l((Object)output.getPkValue())).getScopeName());
        details.put("ext_script", null);
        details.put("ext_script_tag", null);
        details.put("timeout", 30);
        details.put("depends", new ArrayList());
        details.put("default_script", "");
        details.put("default_script_tag", "");
        return ResourceEditorUtil.createResource("DataMapping.ScriptMapping", GuideUtil.generateNumber(D.s((Object)input.get("number")) + D.s((Object)output.get("number")) + "_" + System.currentTimeMillis()), String.format(ResManager.loadKDString((String)"%1$s%2$s_\u8f6c\u6362\u811a\u672c", (String)"GuideUtil_19", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), D.s((Object)input.get("name")), D.s((Object)output.get("name"))), "", catalog, details);
    }

    private static List<Map<String, Object>> getEdges(List<Map<String, Object>> nodes) {
        ArrayList<Map<String, Object>> edges = new ArrayList<Map<String, Object>>(nodes.size() - 1);
        ArrayList<Integer> nodeList = new ArrayList<Integer>(nodes.size());
        for (Map<String, Object> node : nodes) {
            nodeList.add(D.i((Object)node.get("id")));
        }
        int edgeID = nodeList.size() + 1;
        for (int i = 0; i < nodeList.size() - 1; ++i) {
            edges.add(GuideUtil.getEdge(edgeID, (Integer)nodeList.get(i), (Integer)nodeList.get(i + 1)));
            ++edgeID;
        }
        return edges;
    }

    private static Map<String, Object> getEdge(int id, int srcNodeId, int dstNodeId) {
        LinkedHashMap<String, Object> edgesMap = new LinkedHashMap<String, Object>();
        edgesMap.put("type", "Normal");
        edgesMap.put("id", id);
        edgesMap.put("src_node_id", srcNodeId);
        edgesMap.put("dst_node_id", dstNodeId);
        edgesMap.put("from", 6);
        edgesMap.put("to", 4);
        return edgesMap;
    }

    private static List<Map<String, Object>> getNodes(String triggerType, Map<String, Object> dataModelId, Map<String, Object> connections) {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>(dataModelId.size() + 1);
        int index = 1;
        Map<String, Object> startModel = GuideUtil.getDataModel(dataModelId, "start_model");
        GuideUtil.addNodes(nodes, 1, triggerType, startModel, "Starter", index, connections);
        int handlerId = 3;
        Map<String, Object> fieldMapping = GuideUtil.getDataModel(dataModelId, "fieldMapping_model");
        GuideUtil.addNodes(nodes, handlerId, "DataMapping.FieldMapping", fieldMapping, "Handler", ++index, connections);
        if (D.l((Object)dataModelId.get("scriptMapping_model")) != 0L) {
            Map<String, Object> scriptMappingModel = GuideUtil.getDataModel(dataModelId, "scriptMapping_model");
            GuideUtil.addNodes(nodes, ++handlerId, "DataMapping.ScriptMapping", scriptMappingModel, "Handler", ++index, connections);
        }
        if (D.l((Object)dataModelId.get("entityLoad_model")) != 0L) {
            Map<String, Object> entityLoad = GuideUtil.getDataModel(dataModelId, "entityLoad_model");
            GuideUtil.addNodes(nodes, ++handlerId, "DataLoad.EntityAction", entityLoad, "Handler", ++index, connections);
        }
        if (D.l((Object)dataModelId.get("tableLoad_model")) != 0L) {
            Map<String, Object> tableLoad = GuideUtil.getDataModel(dataModelId, "tableLoad_model");
            GuideUtil.addNodes(nodes, ++handlerId, "DataLoad.TableAction", tableLoad, "Handler", ++index, connections);
        }
        if (D.l((Object)dataModelId.get("noticeSend_model")) != 0L) {
            Map<String, Object> noticeSendModel = GuideUtil.getDataModel(dataModelId, "noticeSend_model");
            GuideUtil.addNodes(nodes, ++handlerId, "DataLoad.NoticeSend", noticeSendModel, "Handler", ++index, connections);
        }
        LinkedHashMap<String, Object> endMap = new LinkedHashMap<String, Object>();
        endMap.put("name", ResManager.loadKDString((String)"\u7ed3\u675f", (String)"GuideUtil_9", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        GuideUtil.addNodes(nodes, 2, null, endMap, "End", ++index, connections);
        return nodes;
    }

    private static void addNodes(List<Map<String, Object>> nodes, int nodeID, String resourceType, Map<String, Object> model, String type, int index, Map<String, Object> connections) {
        LinkedHashMap<String, Object> node = new LinkedHashMap<String, Object>();
        node.put("id", nodeID);
        node.put("pos_x", 250 * index);
        node.put("pos_y", 180);
        node.put("name", model.get("name"));
        node.put("type", type);
        if (resourceType != null) {
            node.put("resourceType", resourceType);
            LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
            details.put("resource", model);
            details.put("name", model.get("name"));
            details.put("remark", null);
            details.put("connctor_binding", GuideUtil.getConnectorBinding(model, connections));
            node.put("details", details);
        }
        nodes.add(node);
    }

    private static List<Map<String, Object>> getConnectorBinding(Map<String, Object> model, Map<String, Object> connections) {
        List<Map<String, Object>> list = DataFlowEditorUtil.getResourceSystems(D.l((Object)model.get("id")));
        for (Map<String, Object> map : list) {
            JSONObject cnType;
            if ("$src".equals(map.get("system_number"))) {
                cnType = (JSONObject)connections.get("srcCnType");
                map.put("system_connector", cnType.getString("number"));
                continue;
            }
            if (!"$tar".equals(map.get("system_number"))) continue;
            cnType = (JSONObject)connections.get("tarCnType");
            map.put("system_connector", cnType.getString("number"));
        }
        return list;
    }

    public static Map<String, Object> getDataFlowParams(String triggerType, Map<String, Object> dataModelId, Map<String, Object> connections) {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>(3);
        List<Map<String, Object>> connectors = GuideUtil.getConnectors(connections);
        details.put("connectors", connectors);
        Object input = GuideUtil.getDataFlowParamInput(triggerType, dataModelId);
        details.put("input", input);
        LinkedHashMap<String, Object> define = new LinkedHashMap<String, Object>(3);
        List<Map<String, Object>> nodes = GuideUtil.getNodes(triggerType, dataModelId, connections);
        define.put("nodes", nodes);
        List<Map<String, Object>> edges = GuideUtil.getEdges(nodes);
        define.put("edges", edges);
        define.put("count", nodes.size() + edges.size() + 10);
        details.put("define", define);
        return details;
    }

    public static long createDataFlow(Map<String, Object> details, DynamicObject catalog, String number, String name, String desc) {
        return ResourceEditorUtil.createResource("DataWeaver.DataFlow", number, name, desc, catalog, details);
    }

    private static Object getDataFlowParamInput(String triggerType, Map<String, Object> dataModelId) {
        if ("EventModel.BizEvent".equals(triggerType)) {
            return GuideUtil.getDataModel(dataModelId, "src_model");
        }
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)dataModelId.get("dataQuery_model"), (String)"iscx_resource");
        Map detailsTag = (Map)Json.toObject((String)D.s((Object)res.get("details_tag")));
        return detailsTag.get("input");
    }

    private static Map<String, Object> getDataModel(Map<String, Object> dataModelId, String model) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)dataModelId.get(model), (String)"iscx_resource");
        Map<String, Object> map = ResourceEditorUtil.toMap(obj);
        map.put("id", D.s((Object)map.get("id")));
        return map;
    }

    private static List<Map<String, Object>> getConnectors(Map<String, Object> connections) {
        ArrayList<Map<String, Object>> connectors = new ArrayList<Map<String, Object>>();
        ArrayList<String> tempList = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : connections.entrySet()) {
            JSONObject obj = (JSONObject)entry.getValue();
            String number = obj.getString("number");
            if (tempList.contains(number)) continue;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("connector_remark", "-");
            map.put("connector_number", number);
            map.put("connector_type", obj.getString("name"));
            map.put("connector_name", obj.getString("name"));
            map.put("id", D.s((Object)IDService.get().genLongId()));
            connectors.add(map);
            tempList.add(number);
        }
        return connectors;
    }

    public static void saveDataFlowGuideInfo(Map<String, Object> data) {
        Map baseInfo = (Map)data.get("iscx_guide_baseinfo_data");
        String number = D.s(baseInfo.get("number"));
        String name = D.s(baseInfo.get("name"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"iscx_guide_resource");
        dynamicObject.set("id", (Object)IDService.get().genLongId());
        dynamicObject.set("number", (Object)("data_flow_guide_" + (number == null ? Long.valueOf(System.currentTimeMillis()) : number)));
        dynamicObject.set("name", (Object)String.format(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u5411\u5bfc_%s", (String)"GuideUtil_20", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), name == null ? Long.valueOf(System.currentTimeMillis()) : name));
        dynamicObject.set("guidedata_tag", (Object)Json.toString(data));
        dynamicObject.set("status", (Object)"A");
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("type", data.get("guide_type"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }
}

