/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.tr;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ScriptCommonUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.ScriptEditorUtil;

public class ScriptMappingFormPlugin
extends AbstractResourceEditorFormPlugin {
    @Override
    protected String getResourceType() {
        return "DataMapping.ScriptMapping";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_open_default_script", "btn_open_ext_script"});
        ResourceEditorUtil.bindResourceDetailsViewer(this, "input", "output", "function_ref");
    }

    @Override
    protected void lockModel() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if ("btn_open_default_script".equals(((Button)src).getKey())) {
            this.openScriptEditor("default_script");
        } else if ("btn_open_ext_script".equals(((Button)src).getKey())) {
            this.openScriptEditor("ext_script");
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        IDataModel model = this.getModel();
        if ("input".equals(property)) {
            if (newValue == null) {
                model.setValue("src_system", null);
            } else {
                long id = ((DynamicObject)newValue).getLong("id");
                DynamicObject output = (DynamicObject)model.getValue("output");
                if (output == null || output.getLong("id") != id) {
                    this.setSystem("src_system", (DynamicObject)this.getModel().getValue("input"));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6a21\u578b\u4e0e\u8f93\u51fa\u6a21\u578b\u4e0d\u80fd\u76f8\u540c\u3002", (String)"ScriptMappingFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    model.setValue("input", changeSet[0].getOldValue());
                }
            }
        } else if ("output".equals(property)) {
            if (newValue == null) {
                model.setValue("tar_system", null);
            } else {
                long id = ((DynamicObject)newValue).getLong("id");
                DynamicObject input = (DynamicObject)model.getValue("input");
                if (input == null || input.getLong("id") != id) {
                    this.setSystem("tar_system", (DynamicObject)this.getModel().getValue("output"));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u6a21\u578b\u4e0e\u8f93\u51fa\u6a21\u578b\u4e0d\u80fd\u76f8\u540c\u3002", (String)"ScriptMappingFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    model.setValue("output", changeSet[0].getOldValue());
                }
            }
        }
    }

    private void setSystem(String field, DynamicObject res) {
        long catalogId = D.l((Object)res.get("catalog_id"));
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)catalogId, (String)"iscx_catalog", (String)"parent.name");
        this.getModel().setValue(field, catalog.get("parent.name"));
    }

    private void openScriptEditor(String field) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("remark", this.getModel().getValue(field));
        params.put("script", this.getModel().getValue(field + "_tag"));
        params.put("billStatus", this.getView().getFormShowParameter().getStatus());
        params.put("env", this.getScriptEnv());
        Map<String, String> dataModelVars = this.getDataModelVars();
        ScriptEditorUtil.setScriptEditorTips(this, params, this.getScriptContextVariables(), dataModelVars, true);
        FormOpener.showForm((AbstractFormPlugin)this, (String)ScriptCommonUtil.getEditor(), (String)ResManager.loadKDString((String)"\u811a\u672c\u7f16\u8f91", (String)"ScriptMappingFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), params, (String)("get_" + field));
    }

    protected Map<String, String> getDataModelVars() {
        HashMap<String, String> dataModelVars = new HashMap<String, String>();
        dataModelVars.put("src", "input");
        dataModelVars.put("tar", "output");
        return dataModelVars;
    }

    protected List<String> getScriptContextVariables() {
        return Arrays.asList("src", "tar", "$tar", "$src", "$this");
    }

    protected String getScriptEnv() {
        return "data_copy_mapping_script";
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("get_default_script".equals(e.getActionId())) {
            this.setScriptFromEditor(e, "default_script");
        } else if ("get_ext_script".equals(e.getActionId())) {
            this.setScriptFromEditor(e, "ext_script");
        }
    }

    private void setScriptFromEditor(ClosedCallBackEvent e, String field) {
        Map params = (Map)e.getReturnData();
        if (params != null) {
            this.getModel().setValue(field, params.get("remark"));
            this.getModel().setValue(field + "_tag", params.get("script"));
            this.getView().updateView(field + "_tag");
        }
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        IDataModel model = this.getModel();
        model.setValue("src_system", details.get("src_system"));
        model.setValue("tar_system", details.get("tar_system"));
        ScriptEditorUtil.bindDataModel2(details, model);
        ScriptEditorUtil.bindScript2(details, model);
        ScriptEditorUtil.bindDepends(details, model);
        ScriptEditorUtil.setTimeout(details, model);
        this.getView().updateView("depends");
        this.getView().setVisible(Boolean.valueOf(EditorMode.VIEW != mode), new String[]{"del_function", "add_function"});
        this.getView().setVisible(Boolean.valueOf(EditorMode.EXTENDS == mode || EditorMode.VIEW == mode), new String[]{"ext_script", "btn_open_ext_script", "flex_ext"});
        if (EditorMode.EXTENDS == mode) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output", "btn_open_default_script"});
        }
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        IDataModel model = this.getModel();
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("src_system", model.getValue("src_system"));
        details.put("tar_system", model.getValue("tar_system"));
        ScriptEditorUtil.collectDataModel2(details, model);
        ScriptEditorUtil.collectScript2(details, model);
        ScriptEditorUtil.collectDepends(details, model);
        ScriptEditorUtil.collectTimeout(details, model);
        return details;
    }
}

