/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.res.vc;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscx.formplugin.res.AbstractResourceEditorFormPlugin;
import kd.isc.iscx.formplugin.res.EditorMode;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.Resource;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;

public abstract class AbstractValueConvertBaseFormPlugin
extends AbstractResourceEditorFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"src_field", "tar_field"});
        ResourceEditorUtil.bindResourceDetailsViewer(this, "input", "output");
        ResourceEditorUtil.bindResourceSelector((AbstractFormPlugin)this, "input", "output");
    }

    @Override
    protected boolean isAutoClosed() {
        return false;
    }

    @Override
    protected long save() {
        long id = super.save();
        this.getView().getPageCache().put("id", D.s((Object)id));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"AbstractValueConvertBaseFormPlugin_8", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        return id;
    }

    @Override
    protected long getResourceId() {
        long alreadySaveId = D.l((Object)this.getView().getPageCache().get("id"));
        if (alreadySaveId > 0L) {
            return alreadySaveId;
        }
        return super.getResourceId();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.put("id", this.getResourceId());
        this.getView().returnDataToParent(result);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        if ("input".equals(property)) {
            this.setSystem("src_system", (DynamicObject)this.getModel().getValue("input"));
            this.getModel().setValue("src_field", (Object)"");
        } else if ("output".equals(property)) {
            this.setSystem("tar_system", (DynamicObject)this.getModel().getValue("output"));
            this.getModel().setValue("tar_field", (Object)"");
        }
    }

    @Override
    protected void lockModel() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"input", "output"});
    }

    @Override
    protected void bindResourceDetails(Map<String, Object> details, EditorMode mode) {
        if (!details.isEmpty()) {
            Object output;
            Object input = details.get("input");
            if (input != null) {
                this.getModel().setValue("input", ((Map)details.get("input")).get("id"));
            }
            if ((output = details.get("output")) != null) {
                this.getModel().setValue("output", ((Map)details.get("output")).get("id"));
            }
            this.getModel().setValue("src_system", details.get("src_system"));
            this.getModel().setValue("tar_system", details.get("tar_system"));
            this.getModel().setValue("src_field", details.get("src_field"));
            this.getModel().setValue("tar_field", details.get("tar_field"));
            this.getModel().setValue("default_value", details.get("default_value"));
        }
    }

    @Override
    protected Map<String, Object> collectResourceDetails() {
        HashMap<String, Object> details = new HashMap<String, Object>();
        DynamicObject input = (DynamicObject)this.getModel().getValue("input");
        DynamicObject output = (DynamicObject)this.getModel().getValue("output");
        details.put("input", ResourceEditorUtil.toMap(input));
        details.put("output", ResourceEditorUtil.toMap(output));
        details.put("src_system", this.getModel().getValue("src_system"));
        details.put("tar_system", this.getModel().getValue("tar_system"));
        details.put("src_field", this.getModel().getValue("src_field"));
        details.put("tar_field", this.getModel().getValue("tar_field"));
        details.put("default_value", this.getModel().getValue("default_value"));
        return details;
    }

    private void setSystem(String field, DynamicObject res) {
        if (res != null) {
            long catalogId = D.l((Object)res.get("catalog_id"));
            DynamicObject catalog = BusinessDataServiceHelper.loadSingle((Object)catalogId, (String)"iscx_catalog", (String)"parent.name");
            this.getModel().setValue(field, catalog.get("parent.name"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        try {
            this.doClick(source);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    private void doClick(Control source) {
        if ("src_field".equals(source.getKey())) {
            DynamicObject input = (DynamicObject)this.getModel().getValue("input");
            if (input == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u6570\u636e", (String)"AbstractValueConvertBaseFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            } else {
                Resource resource = ResourceUtil.getResource((long)input.getLong("id"));
                List fields = ((AbstractDataModel)resource).getDataType().getFields();
                if (fields.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u6e90\u6570\u636e\u3011\u6ca1\u6709\u5b57\u6bb5\u53ef\u9009\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractValueConvertBaseFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("resourceId", input.getPkValue());
                params.put("single", this.fieldSelectSingle());
                params.put("value", this.getModel().getValue("src_field"));
                FormOpener.showModalForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)"", params, (String)"SRC_RES_FIELD_SELECT");
            }
        } else if ("tar_field".equals(source.getKey())) {
            DynamicObject output = (DynamicObject)this.getModel().getValue("output");
            if (output == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u6570\u636e", (String)"AbstractValueConvertBaseFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            } else {
                Resource resource = ResourceUtil.getResource((long)output.getLong("id"));
                List fields = ((AbstractDataModel)resource).getDataType().getFields();
                if (fields.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u76ee\u6807\u6570\u636e\u3011\u6ca1\u6709\u5b57\u6bb5\u53ef\u9009\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractValueConvertBaseFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("resourceId", output.getPkValue());
                params.put("single", this.fieldSelectSingle());
                params.put("value", this.getModel().getValue("tar_field"));
                FormOpener.showModalForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)"", params, (String)"TAR_RES_FIELD_SELECT");
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("test".equals(e.getOperateKey())) {
            long resourceId = this.getResourceId();
            if (resourceId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\uff0c\u518d\u6d4b\u8bd5", (String)"AbstractValueConvertBaseFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
            } else {
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("id", resourceId);
                FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_vc_test", params);
            }
        }
    }

    protected boolean fieldSelectSingle() {
        return false;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        boolean check;
        super.closedCallBack(evt);
        ResourceEditorUtil.closedResourceSelector(this, evt);
        if ("SRC_RES_FIELD_SELECT".equals(evt.getActionId())) {
            boolean check2;
            if (evt.getReturnData() != null && (check2 = this.checkFieldType(evt))) {
                this.getModel().setValue("src_field", (Object)this.getLabel(evt.getReturnData()));
            }
        } else if ("TAR_RES_FIELD_SELECT".equals(evt.getActionId()) && evt.getReturnData() != null && (check = this.checkFieldType(evt))) {
            this.getModel().setValue("tar_field", (Object)this.getLabel(evt.getReturnData()));
        }
    }

    private boolean checkFieldType(ClosedCallBackEvent evt) {
        List list = (List)evt.getReturnData();
        for (Map field : list) {
            String type = D.s(field.get("type"));
            if (!"REF".equals(type) && !"REF(?)".equals(type) && !"STRUCT".equals(type) && !"ENTRIES".equals(type)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684%1$s\u5b57\u6bb5\u662f%2$s\u7c7b\u578b\u7684\uff0c\u53ea\u80fd\u9009\u62e9\u7b80\u5355\u503c\u5b57\u6bb5", (String)"AbstractValueConvertBaseFormPlugin_7", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), field.get("fullnumber"), type));
            return false;
        }
        return true;
    }

    private String getLabel(Object returnData) {
        String label;
        StringBuilder labels = new StringBuilder();
        if (returnData != null) {
            List list = (List)returnData;
            for (Map field : list) {
                labels.append(D.s(field.get("fullnumber"))).append(',');
            }
        }
        if ((label = labels.substring(0, labels.length() - 1)).endsWith(".zh_CN") || label.endsWith(".zh_TW") || label.endsWith(".en_US")) {
            label = label.substring(0, label.length() - 6);
        }
        return label;
    }
}

