/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.runtime;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.df.DataFlowEditorUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.event.BizEvent;
import kd.isc.iscx.platform.core.res.runtime.Connector;
import kd.isc.iscx.platform.core.res.runtime.DataFlowDefine;
import kd.isc.iscx.platform.core.res.runtime.DataFlowHelper;
import kd.isc.iscx.platform.core.res.runtime.DataFlowTrigger;

public class DataFlowTriggerEventParamFormPlugin
extends AbstractFormPlugin {
    private static final String[] NUMBERS = new String[]{"number", "billno", "fnumber", "fbillno", "FNumber", "FBillNo"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object id = this.getView().getFormShowParameter().getCustomParam("id");
        if (id == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u542f\u52a8\u65b9\u6848ID\u4e3a\u7a7a", (String)"DataFlowTriggerEventParamFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_data_flow_trigger");
            this.getModel().setValue("trigger", (Object)trigger);
            BizEvent event = (BizEvent)ResourceUtil.getResource((long)trigger.getLong("event_model_id"));
            this.getView().getPageCache().put("dataModelId", D.s((Object)event.getOutput().getId()));
            this.getModel().setValue("entity", event.getMetaData().get("entityId"));
            this.addDefaultFilters(event);
        }
    }

    private void addDefaultFilters(BizEvent event) {
        DynamicObjectCollection filters = this.getModel().getDataEntity(true).getDynamicObjectCollection("filters");
        filters.clear();
        AbstractDataModel dataModel = event.getOutput();
        boolean hasField = this.addNumberEntry(filters, event);
        List pkFields = dataModel.getDataType().getPrimaryKeyFields();
        if (pkFields.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5b9e\u4f53\u6a21\u578b[%s]\u7684\u4e3b\u952e\u5b57\u6bb5", (String)"DataFlowTriggerEventParamFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), event.getMetaData().get("entityName")));
        } else if (!hasField) {
            for (Field f : pkFields) {
                this.addEntry(filters, f);
            }
        }
    }

    private boolean addNumberEntry(DynamicObjectCollection filters, BizEvent event) {
        AbstractDataModel dataModel = event.getOutput();
        for (String number : NUMBERS) {
            Field field = dataModel.getDataType().getField(number);
            if (field == null) continue;
            this.addEntry(filters, field);
            return true;
        }
        return false;
    }

    private void addEntry(DynamicObjectCollection filters, Field f) {
        DynamicObject filter = filters.addNew();
        filter.set("field", (Object)f.getName());
        filter.set("description", (Object)f.getLabel());
        filter.set("data_type", (Object)f.getType());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"field"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("field".equals(key)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("resourceId", this.getView().getPageCache().get("dataModelId"));
            param.put("single", Boolean.TRUE);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_res_field_select", (String)ResManager.loadKDString((String)"\u9009\u62e9\u8fc7\u6ee4\u5b57\u6bb5", (String)"DataFlowTriggerEventParamFormPlugin_8", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), param, (String)"get_field");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        if ("get_field".equals(evt.getActionId()) && (returnData = evt.getReturnData()) instanceof List) {
            Map data = (Map)((List)returnData).get(0);
            this.getModel().setValue("field", data.get("fullnumber"));
            this.getModel().setValue("description", data.get("label"));
            this.getModel().setValue("data_type", data.get("type"));
            this.getView().updateView("filters");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("start_flow".equals(operationKey)) {
            DynamicObjectCollection entity = this.getModel().getDataEntity(true).getDynamicObjectCollection("filters");
            for (DynamicObject f : entity) {
                if (!StringUtil.isEmpty((String)D.s((Object)f.get("value")))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8fc7\u6ee4\u6761\u4ef6\u7684\u503c", (String)"DataFlowTriggerEventParamFormPlugin_2", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getOperateKey().equals("start_flow")) {
            RequestContext current = RequestContext.get();
            RequestContext new_rc = null;
            try {
                long exe_job_user_id = D.l((Object)this.getModel().getValue("exe_job_user_id"));
                String proxyUser = exe_job_user_id == 0L ? null : D.s((Object)exe_job_user_id);
                new_rc = ContextUtil.restoreAndGetContext((RequestContext)current, (String)proxyUser);
                this.execute();
                this.getView().returnDataToParent((Object)"success");
                this.getView().close();
            }
            catch (Throwable e) {
                FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
            }
            finally {
                if (new_rc != null) {
                    RequestContextCreator.restoreForMQ((RequestContext)current);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        Connector connector = this.getFirstNodeConnector();
        List<Map<String, Object>> filters = this.getFilterList();
        Map<String, Object> requires = this.prepareRequires();
        ConnectionWrapper cn = null;
        ObjectReader reader = null;
        try {
            cn = connector.getConnection();
            DynamicObject entity = (DynamicObject)this.getModel().getValue("entity");
            String entityName = entity.getString("number");
            reader = ConnectionManager.query((ConnectionWrapper)cn, (String)entityName, requires, filters, null);
            List<Map<String, Object>> result = this.getResult((ObjectReader<Map<String, Object>>)reader, filters, entityName);
            FormShowParameter formParam = this.getView().getFormShowParameter();
            Object id = formParam.getCustomParam("id");
            String debug = (String)formParam.getCustomParam("#DEBUG");
            DataFlowHelper.start((long)D.l((Object)id), result, (String)debug);
        }
        catch (Throwable throwable) {
            DbUtil.close(reader);
            ConnectorUtil.close((AutoCloseable)cn);
            throw throwable;
        }
        DbUtil.close((ObjectReader)reader);
        ConnectorUtil.close((AutoCloseable)cn);
    }

    private Connector getFirstNodeConnector() {
        Object id = this.getView().getFormShowParameter().getCustomParam("id");
        DataFlowTrigger trigger = DataFlowTrigger.get((long)D.l((Object)id));
        DynamicObject dataFlowDefine = BusinessDataServiceHelper.loadSingle((Object)trigger.getDataFlowId(), (String)"iscx_data_flow_define", (String)"define_json_tag");
        Map json = (Map)Json.toObject((String)dataFlowDefine.getString("define_json_tag"));
        Map define = (Map)ResourceUtil.getValue((Map)json, (String[])new String[]{"diagram", "define"});
        Map<String, Object> node = DataFlowEditorUtil.findNode(define, 1);
        List connctor_binding = (List)ResourceUtil.getValue(node, (String[])new String[]{"details", "connctor_binding"});
        if (connctor_binding.isEmpty()) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6570\u636e\u6d41\u56fe\u7684\u7b2c\u4e00\u4e2a\u8282\u70b9\u7684\u8fde\u63a5\u5668", (String)"DataFlowTriggerEventParamFormPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        }
        String connNumber = D.s(((Map)connctor_binding.get(0)).get("system_connector"));
        DataFlowDefine flow = DataFlowDefine.get((long)trigger.getDataFlowId());
        return flow.getConnector(connNumber);
    }

    private List<Map<String, Object>> getFilterList() {
        DynamicObjectCollection fs = this.getModel().getDataEntity(true).getDynamicObjectCollection("filters");
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>();
        int i = 0;
        for (DynamicObject f : fs) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("filter_left_bracket", Character.valueOf('('));
            map.put("filter_column", f.get("field"));
            map.put("filter_compare", "=");
            String value = D.s((Object)f.get("value"));
            if (value.startsWith("[") && value.endsWith("]")) {
                try {
                    Object o = Json.toObject((String)value);
                    map.put("filter_compare", "in");
                }
                catch (Throwable e) {
                    throw new IscBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u503c\u7684\u683c\u5f0f\u8bbe\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u67e5\u8be2\u6761\u4ef6\u503c", (String)"DataFlowTriggerEventParamFormPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                }
            }
            map.put("filter_value", f.get("value"));
            map.put("filter_right_bracket", Character.valueOf(')'));
            if (i > 0) {
                map.put("filter_link", "and");
            }
            filters.add(map);
            ++i;
        }
        return filters;
    }

    private Map<String, Object> prepareRequires() {
        Object id = this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_data_flow_trigger", (String)"event_model");
        BizEvent event = (BizEvent)ResourceUtil.getResource((long)trigger.getLong("event_model_id"));
        List selectFields = event.getSelectFields();
        LinkedHashMap<String, Object> requires = new LinkedHashMap<String, Object>(selectFields.size());
        for (Map selector : selectFields) {
            String field = D.s(selector.get("field_name"));
            if (field == null) continue;
            if (field.indexOf(46) < 0) {
                requires.put(field, 1);
                continue;
            }
            String[] path = field.split("\\.");
            SQLUtil.addEntryProperty(requires, (String[])path);
        }
        return requires;
    }

    private StringBuilder buildErrorInfo(List<Map<String, Object>> filters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filters.size(); ++i) {
            if (i > 0) {
                sb.append(';');
            }
            Map<String, Object> filter = filters.get(i);
            sb.append(filter.get("filter_column"));
            sb.append('=');
            sb.append(filter.get("filter_value"));
        }
        return sb;
    }

    private List<Map<String, Object>> getResult(ObjectReader<Map<String, Object>> reader, List<Map<String, Object>> filters, String entityName) {
        int totalCount = reader.getTotalCount();
        Map result = new HashMap(2);
        if (totalCount > 1) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6:%1$s\u5728'%2$s'\u67e5\u5230\u591a\u6761\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u8fc7\u6ee4\u6761\u4ef6\uff0c\u786e\u4fdd\u53ea\u67091\u6761\u6570\u636e\u3002", (String)"DataFlowTriggerEventParamFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.buildErrorInfo(filters), entityName));
        }
        Map data = (Map)reader.read();
        while (data != null) {
            result = data;
            data = (Map)reader.read();
            if (data == null) continue;
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6:%1$s\u5728'%2$s'\u67e5\u5230\u591a\u6761\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u8fc7\u6ee4\u6761\u4ef6\uff0c\u786e\u4fdd\u53ea\u67091\u6761\u6570\u636e\u3002", (String)"DataFlowTriggerEventParamFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.buildErrorInfo(filters), entityName));
        }
        if (CollectionUtils.isEmpty(result)) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6:%1$s\u5728'%2$s'\u6ca1\u6709\u627e\u5230\u8bb0\u5f55\uff0c\u8bf7\u4fee\u6539\u8fc7\u6ee4\u6761\u4ef6\uff0c\u786e\u4fdd\u67091\u6761\u6570\u636e\u3002", (String)"DataFlowTriggerEventParamFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.buildErrorInfo(filters), entityName));
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(1);
        resultList.add(result);
        return resultList;
    }
}

