/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.runtime;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.dt.Field;
import kd.isc.iscx.platform.core.res.meta.dt.StructSchema;
import kd.isc.iscx.platform.core.res.meta.dw.ConnectorInfo;
import kd.isc.iscx.platform.core.res.meta.dw.DataFlow;
import kd.isc.iscx.platform.core.res.meta.event.AbstractEventModel;

public class DataFlowTriggerFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "data_flow", "event_model", "failed_notice", "success_notice");
        DynamicObject event = (DynamicObject)this.getModel().getValue("event_model");
        long id = 0L;
        if (event != null) {
            AbstractEventModel meta = (AbstractEventModel)ResourceUtil.getResource((long)event.getLong("id"));
            id = meta.getParams().getId();
        }
        final long finalId = id;
        BeforeF7SelectListener beforeF7SelectListener = new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                if (finalId != 0L) {
                    beforeF7SelectEvent.addCustomQFilter(new QFilter("input_data_model", "=", (Object)finalId));
                }
            }
        };
        BasedataEdit failed_notice = (BasedataEdit)this.getView().getControl("failed_notice");
        failed_notice.addBeforeF7SelectListener(beforeF7SelectListener);
        BasedataEdit success_notice = (BasedataEdit)this.getView().getControl("success_notice");
        success_notice.addBeforeF7SelectListener(beforeF7SelectListener);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        ResourceEditorUtil.closedResourceSelector(this, evt);
    }

    public void beforeBindData(EventObject e) {
        DynamicObject event;
        DynamicObject flow;
        Map map;
        long flow_id;
        super.beforeBindData(e);
        Map name = (Map)this.getModel().getValue("name");
        if (name != null && !name.containsKey(Lang.get().name())) {
            name.put(Lang.get().name(), name.get("GLang"));
        }
        if ((flow_id = D.l((map = this.getView().getFormShowParameter().getCustomParams()).get("flow_id"))) != 0L) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)flow_id, (String)"iscx_resource");
            this.getModel().setValue("data_flow", (Object)obj);
            this.getView().setEnable(Boolean.FALSE, new String[]{"data_flow"});
        }
        if ((flow = (DynamicObject)this.getModel().getValue("data_flow")) != null) {
            this.resetConnectors(flow);
            this.resetEventModel(flow);
        }
        if ((event = (DynamicObject)this.getModel().getValue("event_model")) != null) {
            this.resetParams(event);
            this.setEventType(event);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("data_flow".equals(e.getProperty().getName())) {
            IDataModel m = this.getModel();
            DynamicObject flow = (DynamicObject)m.getValue("data_flow");
            if (flow != null) {
                this.resetConnectors(flow);
                this.resetEventModel(flow);
                this.resetThreadsWorkSize();
            }
        } else if ("name".equals(e.getProperty().getName())) {
            IDataModel m = this.getModel();
            String name = D.s((Object)m.getValue("name"));
            String number = D.s((Object)m.getValue("number"));
            if (name != null && number == null) {
                m.setValue("number", (Object)Hash.mur24((Object[])new Object[]{name}));
            }
        }
    }

    private void resetThreadsWorkSize() {
        if (D.l((Object)this.getModel().getValue("id")) != 0L) {
            return;
        }
        String type = D.s((Object)this.getModel().getValue("event_type"));
        if ("EventModel.Manual".equals(type) || "EventModel.Timer".equals(type)) {
            this.getModel().setValue("max_threads", (Object)6);
            this.getModel().setValue("work_area_size", (Object)10000);
        } else {
            this.getModel().setValue("max_threads", (Object)1);
            this.getModel().setValue("work_area_size", (Object)100);
        }
    }

    private void resetEventModel(DynamicObject flow) {
        AbstractEventModel eventModel = ((DataFlow)ResourceUtil.getResource((long)flow.getLong("id"))).getEventModel();
        if (eventModel != null) {
            IDataModel m = this.getModel();
            m.setValue("event_model", (Object)eventModel.getId());
            DynamicObject event = (DynamicObject)m.getValue("event_model");
            this.resetParams(event);
            this.setEventType(event);
        }
    }

    private void setEventType(DynamicObject event) {
        String type = event.getString("type.id");
        if (!type.equals(this.getModel().getValue("event_type"))) {
            this.getModel().setValue("event_type", (Object)type);
        }
    }

    private void resetConnectors(DynamicObject flow) {
        DynamicObjectCollection entries;
        DataFlow meta = (DataFlow)ResourceUtil.getResource((long)flow.getLong("id"));
        List connectors = meta.getConnectors();
        if (this.isConnectorsChanged(connectors, entries = this.getModel().getDataEntity().getDynamicObjectCollection("connectors"))) {
            this.adjustCollectionSize(entries, connectors.size());
            for (int i = 0; i < connectors.size(); ++i) {
                ConnectorInfo item = (ConnectorInfo)connectors.get(i);
                DynamicObject row = (DynamicObject)entries.get(i);
                row.set("connector_type", (Object)item.getType());
                row.set("connector_number", (Object)item.getNumber());
                row.set("connector_name", (Object)item.getName());
            }
            this.getModel().getDataEntity(true).set("connectors", (Object)entries);
            this.getView().updateView("connectors");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("modify".equals(operationKey) || "save".equals(operationKey)) {
            this.checkEnable(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("modify".equals(operateKey)) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("save".equals(operateKey) && args.getOperationResult().isSuccess() && D.x((Object)this.getView().getFormShowParameter().getCustomParam("isGuide"))) {
            long trigger_id = D.l((Object)this.getModel().getValue("id"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", trigger_id);
            map.put("number", this.getModel().getValue("number"));
            map.put("name", this.getModel().getValue("name"));
            map.put("modifytime", D.t((Object)this.getModel().getValue("modifytime")));
            map.put("createtime", D.t((Object)this.getModel().getValue("createtime")));
            map.put("creator", this.getModel().getValue("creator"));
            map.put("modifier", this.getModel().getValue("modifier"));
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        if ("disable_trigger".equals(evt.getCallBackId())) {
            this.getView().invokeOperation("disable");
            this.getView().invokeOperation("modify");
        }
    }

    private void checkEnable(BeforeDoOperationEventArgs args) {
        DynamicObject trigger;
        long trigger_id = D.l((Object)this.getModel().getValue("id"));
        if (trigger_id > 0L && (trigger = BusinessDataServiceHelper.loadSingle((Object)trigger_id, (String)"iscx_data_flow_trigger", (String)"enable")).getInt("enable") == 1) {
            args.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disable_trigger", (IFormPlugin)this);
            String tips = OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus()) ? ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"DataFlowTriggerFormPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"DataFlowTriggerFormPlugin_1", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tips, MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    private boolean isConnectorsChanged(List<ConnectorInfo> connectors, DynamicObjectCollection entries) {
        HashMap<String, DynamicObject> mapping = new HashMap<String, DynamicObject>(entries.size());
        for (DynamicObject row : entries) {
            mapping.put(row.getString("connector_number"), row);
        }
        for (ConnectorInfo item : connectors) {
            DynamicObject row = (DynamicObject)mapping.remove(item.getNumber());
            if (row == null) {
                return true;
            }
            if (!item.getType().equals(row.get("connector_type"))) {
                return true;
            }
            if (item.getName().equals(row.get("connector_name"))) continue;
            return true;
        }
        return !mapping.isEmpty();
    }

    private void resetParams(DynamicObject event) {
        AbstractEventModel meta = (AbstractEventModel)ResourceUtil.getResource((long)event.getLong("id"));
        DynamicObjectCollection entries = this.getModel().getDataEntity().getDynamicObjectCollection("params");
        if (meta.isDataPulling()) {
            StructSchema schema = meta.getParams().getDataType();
            if (this.isParamsChanged(schema, entries)) {
                this.adjustCollectionSize(entries, schema.fieldCount());
                for (int i = 0; i < schema.fieldCount(); ++i) {
                    DynamicObject row = (DynamicObject)entries.get(i);
                    Field field = schema.getField(i);
                    row.set("param_number", (Object)field.getName());
                    row.set("param_name", (Object)field.getLabel());
                    row.set("param_type", (Object)field.getType().toString());
                }
                this.getModel().getDataEntity(true).set("params", (Object)entries);
                this.getView().updateView("params");
            }
        } else {
            if (!entries.isEmpty()) {
                entries.clear();
                this.getModel().getDataEntity(true).set("params", (Object)entries);
                this.getView().updateView("params");
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap21"});
        }
    }

    private void adjustCollectionSize(DynamicObjectCollection entries, int size) {
        while (entries.size() < size) {
            entries.addNew();
        }
        while (entries.size() > size) {
            entries.remove(entries.size() - 1);
        }
    }

    private boolean isParamsChanged(StructSchema schema, DynamicObjectCollection entries) {
        HashMap<String, DynamicObject> mapping = new HashMap<String, DynamicObject>(entries.size());
        for (DynamicObject row : entries) {
            mapping.put(row.getString("param_number"), row);
        }
        for (int i = 0; i < schema.fieldCount(); ++i) {
            Field field = schema.getField(i);
            DynamicObject row = (DynamicObject)mapping.remove(field.getName());
            if (row == null) {
                return true;
            }
            if (!field.getLabel().equals(row.get("param_name"))) {
                return true;
            }
            if (field.getType().toString().equals(row.get("param_type"))) continue;
            return true;
        }
        return !mapping.isEmpty();
    }
}

