/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.runtime;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.misc.StringUtil;
import kd.isc.iscx.formplugin.res.df.DataFlowEditorUtil;
import kd.isc.iscx.platform.core.res.runtime.DataFlowHelper;

public class DataStreamListPlugin
extends AbstractListPlugin {
    public void afterBindData(EventObject e) {
        this.setListUnitStyle();
        super.afterBindData(e);
    }

    private void setListUnitStyle() {
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        List rows = (List)billList.getQingData(0, billList.getCurrentListAllRowCollection().size()).get("rows");
        for (int i = 0; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String state = D.s(row.get(10));
            if (!"F".equals(state)) continue;
            CellStyle cellStyle = new CellStyle();
            cellStyle.setFieldKey("state");
            cellStyle.setRow(i);
            cellStyle.setForeColor("rgb(251,35,35)");
            cellStyles.add(cellStyle);
        }
        billList.setCellStyle(cellStyles);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("retry".equals(e.getOperateKey())) {
            this.sendRetryJobs(e);
        } else if ("view_log".equals(e.getOperateKey())) {
            FormOpener.showList((AbstractFormPlugin)this, (String)"iscx_data_stream_log", (String)"data_stream", (AfterDoOperationEventArgs)e);
        } else if ("view_trace".equals(e.getOperateKey())) {
            FormOpener.showList((AbstractFormPlugin)this, (String)"iscx_data_stream_trace", (String)"data_stream", (AfterDoOperationEventArgs)e);
        } else if ("terminate".equals(e.getOperateKey())) {
            this.cancelJobs(e);
        }
    }

    private void cancelJobs(AfterDoOperationEventArgs e) {
        List ids = e.getOperationResult().getSuccessPkIds();
        if (ids != null) {
            for (Object id : ids) {
                DataFlowHelper.tryTerminate((long)D.l(id));
            }
        }
    }

    private void sendRetryJobs(AfterDoOperationEventArgs e) {
        List ids = e.getOperationResult().getSuccessPkIds();
        int jobs = DataFlowHelper.retry((List)ids);
        if (jobs == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5931\u8d25\u3001\u521b\u5efa\u4e2d\u7684\u4efb\u52a1\u652f\u6301\u91cd\u8bd5\u3002", (String)"DataStreamListPlugin_0", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u91cd\u8bd5\u64cd\u4f5c\u4e00\u5171\u63d0\u4ea4\u4e86%s\u4e2a\u6570\u636e\u6d41\u7684\u540e\u53f0\u4efb\u52a1\uff0c\u8bf7\u7a0d\u5019\u5237\u65b0\u5217\u8868\u67e5\u770b\u72b6\u6001\u3002", (String)"DataStreamListPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), jobs));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("number".equalsIgnoreCase(fieldName)) {
            args.setCancel(true);
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            long id = D.l((Object)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue());
            if (id > 0L) {
                DataFlowEditorUtil.openDataFlowProcess((AbstractFormPlugin)this, id);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            long now = System.currentTimeMillis();
            ArrayList<Object> ids = new ArrayList<Object>(rows.size());
            for (DynamicObject row : rows) {
                if (!"R".equals(row.get("state")) || D.t((Object)row.get("modifytime")).getTime() + 30000L >= now) continue;
                row.set("state", (Object)"B");
                ids.add(row.get("id"));
            }
            if (!ids.isEmpty()) {
                String sql = "UPDATE t_iscx_datax_stream SET fstate='B' WHERE fid IN(" + StringUtil.join(ids) + ")";
                Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
                try {
                    DbUtil.executeUpdate((Connection)cn, (String)sql);
                }
                finally {
                    DbUtil.close((Connection)cn, (boolean)true);
                }
            }
            return rows;
        }
    }
}

