/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.runtime;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscx.formplugin.res.ResourceEditorUtil;
import kd.isc.iscx.formplugin.res.df.DataFlowEditorUtil;
import kd.isc.iscx.formplugin.runtime.DataStreamLogListPlugin;
import kd.isc.iscx.platform.core.res.ResourceUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.runtime.RuntimeUtil;

public class DataStreamLogFormPlugin
extends AbstractFormPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        long id = this.getModel().getDataEntity().getLong("id");
        if ("flow_diagram".equals(args.getOperateKey())) {
            this.openDiagram(id);
        } else if ("show_data_stream".equals(args.getOperateKey())) {
            FormOpener.showList((AbstractFormPlugin)this, (String)"iscx_data_stream", (String)"id", (Object)this.getModel().getDataEntity().getLong("data_stream_id"));
        } else if ("download_txt".equals(args.getOperateKey())) {
            DataStreamLogListPlugin.download(this.getView(), id);
        } else if ("show_node_details".equals(args.getOperateKey())) {
            String node_id = this.getModel().getDataEntity().getString("node");
            long data_stream_id = this.getModel().getDataEntity().getLong("data_stream_id");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)data_stream_id, (String)"iscx_data_stream");
            Map<String, Object> detailsByDataStream = DataFlowEditorUtil.getDetailsByDataStream(object);
            Map define = (Map)ResourceUtil.getValue(detailsByDataStream, (String[])new String[]{"define"});
            Map<String, Object> node = DataFlowEditorUtil.findNode(define, D.i((Object)node_id));
            long resource_id = D.l((Object)ResourceUtil.getValue(node, (String[])new String[]{"details", "resource", "id"}));
            ResourceEditorUtil.openResourceViewer1(resource_id, this);
        }
    }

    private void openDiagram(long id) {
        if ("FiberTask".equals(this.getTaskType())) {
            DataFlowEditorUtil.openDataFlowErrorLogDiagram(this, id);
        } else if ("StreamTask".equals(this.getTaskType())) {
            DataFlowEditorUtil.openDataFlowQueryDiagram(this, id, "iscx_data_stream_log", this.getModel().getDataEntity().getString("data_tag"), "failed", this.getModel().getDataEntity().getInt("node"));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long pk_id = D.l(params.get("pk_id"));
        if (D.l((Object)pk_id) > 0L) {
            this.initData(pk_id);
        }
        String type = this.getTaskType();
        this.getView().setVisible(Boolean.valueOf(!"BatchTask".equalsIgnoreCase(type)), new String[]{"flow_diagram"});
        if ("FiberTask".equals(type)) {
            long id = D.l((Object)this.getModel().getValue("id"));
            FlowRuntime runtime = RuntimeUtil.loadErrorLogRuntime((long)id);
            Map variables = runtime.getFlow().getVariables();
            DynamicObjectCollection entries = this.getModel().getEntryEntity("variables");
            entries.clear();
            int i = 0;
            for (Map.Entry entry : variables.entrySet()) {
                Variable value = (Variable)entry.getValue();
                AbstractDataModel dataModel = (AbstractDataModel)value.getAttribute("data_model");
                DynamicObject object = entries.addNew();
                object.set("seq", (Object)i++);
                object.set("id", (Object)dataModel.getId());
                object.set("resource", (Object)BusinessDataServiceHelper.loadSingle((Object)dataModel.getId(), (String)"iscx_resource"));
                object.set("number", (Object)dataModel.getNumber());
                object.set("name", (Object)dataModel.getName());
                object.set("system", (Object)dataModel.getSystemInfo().getName());
                object.set("catalog", (Object)dataModel.getCatalogName());
                Map varValue = (Map)runtime.get(value.getName());
                object.set("var_data", (Object)DataStreamLogFormPlugin.getDigest(dataModel.getId(), varValue));
                String stringVarValue = JSON.toJSONString((Object)varValue, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
                object.set("var_data_tag", (Object)StringUtil.trim((String)stringVarValue, (int)16384));
            }
            this.getView().updateView("variables");
        } else if ("StreamTask".equals(type)) {
            String task_context_tag = this.getModel().getDataEntity().getString("task_context_tag");
            Map stream_task_context = (Map)Json.toObject((String)task_context_tag);
            long data_model_id = D.l(stream_task_context.get("query"));
            DynamicObject data_model = BusinessDataServiceHelper.loadSingle((String)"iscx_resource", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)data_model_id)});
            this.getModel().setValue("data_model", (Object)data_model);
            long connector_id = D.l(stream_task_context.get("connector"));
            DynamicObject connector = BusinessDataServiceHelper.loadSingle((String)"iscx_connector", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)connector_id)});
            this.getModel().setValue("connector", (Object)connector);
            Map query_params = (Map)stream_task_context.get("params");
            this.getModel().setValue("query_params", (Object)DataStreamLogFormPlugin.getQueryDigest(data_model_id, query_params));
            String stringVarValue = JSON.toJSONString((Object)query_params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
            this.getModel().setValue("query_params_tag", (Object)StringUtil.trim((String)stringVarValue, (int)16384));
            this.getModel().setValue("total", (Object)Math.max(-1, D.i(stream_task_context.get("total"))));
        }
        this.getModel().setDataChanged(false);
    }

    private String getTaskType() {
        return this.getModel().getDataEntity().getString("task_type");
    }

    public static String getQueryDigest(long data_model_id, Map<String, Object> query_params) {
        Map detailsByResId = ResourceUtil.getDetailsByResId((long)data_model_id);
        return DataStreamLogFormPlugin.getDigest(D.l((Object)ResourceUtil.getValue((Map)detailsByResId, (String[])new String[]{"input", "id"})), query_params);
    }

    private void initData(long pk_id) {
        DynamicObject data_stream = BusinessDataServiceHelper.loadSingle((Object)pk_id, (String)"iscx_data_stream_log");
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            this.getModel().setValue(property.getName(), data_stream.get(property.getName()));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ResourceEditorUtil.bindResourceDetailsViewer(this, "resource", "data_model");
    }

    public static String getDigest(long resourceId, Map<String, Object> data) {
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        Map details = ResourceUtil.getDetailsByResId((long)resourceId);
        String digest_format = "$$(\"" + D.s(details.get("digest_format")) + "\")";
        return D.s((Object)Script.compile((String)digest_format).eval(data));
    }
}

