/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.export.DownloadUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Json2;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.df.DataFlowEditorUtil;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.runtime.RuntimeUtil;

public class DataStreamLogListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(DataStreamLogListPlugin.class);

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        if (currentListSelectedRow == null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flow_diagram"});
            return;
        }
        Object primaryKeyValue = currentListSelectedRow.getPrimaryKeyValue();
        String type = this.getTaskType(primaryKeyValue);
        this.getView().setVisible(Boolean.valueOf(!type.equalsIgnoreCase("BatchTask")), new String[]{"flow_diagram"});
    }

    private String getTaskType(Object primaryKeyValue) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"iscx_data_stream_log", (String)"id,task_type", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        if (object == null) {
            return "";
        }
        return object.getString("task_type");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            int size = args.getListSelectedData().size();
            if ("download_zip".equals(operate.getOperateKey()) || "exportlist_expt".equals(operate.getOperateKey())) {
                int max = D.i((Object)System.getProperty("isc.allow.max.export", "500"));
                if (size > (max = Math.max(max, 1))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6700\u5927\u652f\u6301%s\u884c\u7684\u5bfc\u51fa\u3002", (String)"DataStreamLogListPlugin_16", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), max));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String op = args.getOperateKey();
        if (args.getOperationResult() == null) {
            return;
        }
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        if ("download_txt".equals(op)) {
            this.downLoadTxt(successPkIds);
        } else if ("download_zip".equals(op)) {
            this.downloadZip(successPkIds);
        } else if ("flow_diagram".equals(args.getOperateKey())) {
            this.openDiagram(args);
        } else if ("show_data_stream".equals(args.getOperateKey())) {
            this.showDataStream(args);
        }
    }

    private void showDataStream(AfterDoOperationEventArgs args) {
        long id = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, (AfterDoOperationEventArgs)args));
        if (id > 0L) {
            DynamicObject data_stream = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_data_stream_log", (String)"data_stream_id");
            FormOpener.showList((AbstractFormPlugin)this, (String)"iscx_data_stream", (QFilter)new QFilter("id", "=", (Object)data_stream.getLong("data_stream_id")));
        }
    }

    private void openDiagram(AfterDoOperationEventArgs args) {
        long id = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, (AfterDoOperationEventArgs)args));
        if (id > 0L) {
            DynamicObject object = QueryServiceHelper.queryOne((String)"iscx_data_stream_log", (String)"id,task_type,data_tag,node", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            String taskType = object.getString("task_type");
            if ("FiberTask".equals(taskType)) {
                DataFlowEditorUtil.openDataFlowErrorLogDiagram((AbstractFormPlugin)this, id);
            } else if ("StreamTask".equals(taskType)) {
                DataFlowEditorUtil.openDataFlowQueryDiagram((AbstractFormPlugin)this, id, "iscx_data_stream_log", object.getString("data_tag"), "failed", object.getInt("node"));
            }
        }
    }

    private void downLoadTxt(List<Object> successPkIds) {
        if (successPkIds.size() == 1) {
            long id = D.l((Object)successPkIds.get(0));
            DataStreamLogListPlugin.download(this.getView(), id);
        } else {
            this.downloadZip(successPkIds);
        }
    }

    private void downloadZip(List<Object> successPkIds) {
        try {
            byte[] bytes;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                try (ZipOutputStream zipOutputStream = new ZipOutputStream(out);){
                    this.buildByteOutputStream(zipOutputStream, successPkIds);
                }
                bytes = out.toByteArray();
            }
            var4_3 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
                String urls = DownloadUtil.getZipUrl((InputStream)input, (String)ResManager.loadKDString((String)"\u6570\u636e\u6d41\u65e5\u5fd7_", (String)"DataStreamLogListPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                FileUtil.addDownloadPermission((String)"iscx_data_stream_log", (String)urls, (String)this.getView().getFormShowParameter().getServiceAppId());
                this.getView().openUrl(urls);
            }
            catch (Throwable throwable) {
                var4_3 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.warn("\u4e0b\u8f7dzip\u5305\u5931\u8d25", (Throwable)e);
            FormOpener.showErrorMessage((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u4e0b\u8f7dzip\u5305\u5931\u8d25", (String)"DataStreamLogListPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), (String)StringUtil.toString((Throwable)e));
        }
    }

    private void buildByteOutputStream(ZipOutputStream zipOutputStream, List<Object> successPkIds) throws IOException {
        for (Object id : successPkIds) {
            Map<String, Object> log = DataStreamLogListPlugin.buildLog(D.l((Object)id));
            ZipEntry zipEntry = new ZipEntry(DataStreamLogListPlugin.getFileName(log));
            zipOutputStream.putNextEntry(zipEntry);
            byte[] bytes = DataStreamLogListPlugin.buildLogString(log).getBytes(D.UTF_8);
            zipOutputStream.write(bytes);
            zipOutputStream.closeEntry();
        }
    }

    private static String buildLogString(Map<String, Object> log) {
        String error_stack = D.s((Object)log.remove("error_stack"));
        return Json2.toString(log) + "\r\n\r\n" + error_stack;
    }

    public static String getFileName(Map<String, Object> log) {
        return FileUtil.removeIllegalChar((String)D.s((Object)(D.s((Object)log.get("stream_number")) + '-' + log.get("log_id")))) + ".txt";
    }

    public static void download(IFormView view, long id) {
        Map<String, Object> log = DataStreamLogListPlugin.buildLog(id);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String format = sdf.format(new Date());
        try (ByteArrayInputStream input = new ByteArrayInputStream(DataStreamLogListPlugin.buildLogString(log).getBytes(StandardCharsets.UTF_8));){
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u65e5\u5fd7_%s", (String)"DataStreamLogListPlugin_17", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), format) + ".txt", (InputStream)input, 600);
            FileUtil.addDownloadPermission((String)"iscx_data_stream_log", (String)urls, (String)view.getFormShowParameter().getServiceAppId());
            view.openUrl(urls);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"DataStreamLogListPlugin_18", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    private static Map<String, Object> buildLog(long id) {
        DynamicObject dataflow_log = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_data_stream_log");
        LinkedHashMap<String, Object> log = new LinkedHashMap<String, Object>();
        DynamicObject data_stream = dataflow_log.getDynamicObject("data_stream");
        log.put("stream_number", data_stream.get("number"));
        log.put("Summary", dataflow_log.get("data"));
        log.put("node_title", dataflow_log.get("node_title"));
        log.put("node_id", dataflow_log.get("node"));
        log.put("time", dataflow_log.get("time"));
        log.put("server", dataflow_log.get("host"));
        log.put("log_id", id);
        try {
            if ("FiberTask".equals(dataflow_log.getString("task_type"))) {
                FlowRuntime runtime = RuntimeUtil.loadErrorLogRuntime((long)id);
                Map variables = runtime.getFlow().getVariables();
                for (Map.Entry entry : variables.entrySet()) {
                    Variable value = (Variable)entry.getValue();
                    AbstractDataModel dataModel = (AbstractDataModel)value.getAttribute("data_model");
                    Map varValue = (Map)runtime.get(value.getName());
                    log.put(dataModel.getNumber() + '(' + dataModel.getName() + ')', varValue);
                }
            }
        }
        catch (Throwable e) {
            Map task_context_tag = (Map)Json.toObject((String)dataflow_log.getString("task_context_tag"));
            Map runtime = (Map)task_context_tag.get("runtime");
            Map memory = (Map)runtime.get("memory");
            Object values = memory.get("values");
            log.put("task_context_tag_values", values);
        }
        log.put("error_stack", D.s((Object)dataflow_log.get("error_tag")));
        return log;
    }
}

