/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscx.formplugin.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.export.DownloadUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Json2;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscx.formplugin.res.df.DataFlowEditorUtil;
import kd.isc.iscx.formplugin.runtime.DataStreamLogListPlugin;
import kd.isc.iscx.platform.core.res.meta.dm.AbstractDataModel;
import kd.isc.iscx.platform.core.res.runtime.RuntimeUtil;

public class DataStreamTraceListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(DataStreamTraceListPlugin.class);

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            int size = args.getListSelectedData().size();
            if ("download_zip".equals(operate.getOperateKey()) || "exportlist_expt".equals(operate.getOperateKey())) {
                int max = D.i((Object)System.getProperty("isc.allow.max.export", "500"));
                if (size > (max = Math.max(max, 1))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6700\u5927\u652f\u6301%s\u884c\u7684\u5bfc\u51fa\u3002", (String)"DataStreamLogListPlugin_16", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), max));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null) {
            return;
        }
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        if ("flow_diagram".equals(args.getOperateKey())) {
            this.openDiagram(args);
        } else if ("show_data_stream".equals(args.getOperateKey())) {
            this.showDataStream(args);
        } else if ("download_txt".equals(args.getOperateKey())) {
            this.downLoadTxt(successPkIds);
        }
    }

    private void downLoadTxt(List<Object> successPkIds) {
        if (successPkIds.size() == 1) {
            long id = D.l((Object)successPkIds.get(0));
            DataStreamTraceListPlugin.download(this.getView(), id);
        } else {
            this.downloadZip(successPkIds);
        }
    }

    public static void download(IFormView view, long id) {
        Map<String, Object> log = DataStreamTraceListPlugin.buildLog(id);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String format = sdf.format(new Date());
        try (ByteArrayInputStream input = new ByteArrayInputStream(Json2.toString(log).getBytes(StandardCharsets.UTF_8));){
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6d41\u65e5\u5fd7_%s", (String)"DataStreamLogListPlugin_17", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), format) + ".txt", (InputStream)input, 600);
            FileUtil.addDownloadPermission((String)"iscx_data_stream_trace", (String)urls, (String)view.getFormShowParameter().getServiceAppId());
            view.openUrl(urls);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"DataStreamLogListPlugin_18", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    private void downloadZip(List<Object> successPkIds) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(out);){
                this.buildByteOutputStream(zipOutputStream, successPkIds);
            }
            var5_8 = null;
            try (ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());){
                String urls = DownloadUtil.getZipUrl((InputStream)input, (String)ResManager.loadKDString((String)"\u6570\u636e\u6d41\u65e5\u5fd7_", (String)"DataStreamLogListPlugin_3", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]));
                FileUtil.addDownloadPermission((String)"iscx_data_stream_trace", (String)urls, (String)this.getView().getFormShowParameter().getServiceAppId());
                this.getView().openUrl(urls);
            }
            catch (Throwable throwable) {
                var5_8 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.warn("\u4e0b\u8f7dzip\u5305\u5931\u8d25", (Throwable)e);
            FormOpener.showErrorMessage((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u4e0b\u8f7dzip\u5305\u5931\u8d25", (String)"DataStreamLogListPlugin_4", (String)"isc-iscx-platform-formplugin", (Object[])new Object[0]), (String)StringUtil.toString((Throwable)e));
        }
    }

    private void buildByteOutputStream(ZipOutputStream zipOutputStream, List<Object> successPkIds) throws IOException {
        for (Object id : successPkIds) {
            Map<String, Object> log = DataStreamTraceListPlugin.buildLog(D.l((Object)id));
            ZipEntry zipEntry = new ZipEntry(DataStreamLogListPlugin.getFileName(log));
            zipOutputStream.putNextEntry(zipEntry);
            byte[] bytes = Json2.toString(log).getBytes(D.UTF_8);
            zipOutputStream.write(bytes);
            zipOutputStream.closeEntry();
        }
    }

    private static Map<String, Object> buildLog(long id) {
        DynamicObject dataflow_log = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_data_stream_trace");
        LinkedHashMap<String, Object> log = new LinkedHashMap<String, Object>();
        DynamicObject data_stream = dataflow_log.getDynamicObject("data_stream");
        log.put("stream_number", data_stream.get("number"));
        log.put("Summary", dataflow_log.get("data"));
        log.put("time", dataflow_log.get("time"));
        log.put("state", dataflow_log.get("state"));
        log.put("log_id", id);
        if ("FiberTask".equals(dataflow_log.getString("type"))) {
            try {
                FlowRuntime runtime = RuntimeUtil.loadSuccessLogRuntime((long)id);
                Map variables = runtime.getFlow().getVariables();
                for (Map.Entry entry : variables.entrySet()) {
                    Variable value = (Variable)entry.getValue();
                    AbstractDataModel dataModel = (AbstractDataModel)value.getAttribute("data_model");
                    Map varValue = (Map)runtime.get(value.getName());
                    log.put(dataModel.getNumber() + '(' + dataModel.getName() + ')', varValue);
                }
            }
            catch (Throwable e) {
                Map task_context_tag = (Map)Json.toObject((String)dataflow_log.getString("data_tag"));
                Map runtime = (Map)task_context_tag.get("runtime");
                Map memory = (Map)runtime.get("memory");
                Object values = memory.get("values");
                log.put("data_tag_values", values);
            }
        }
        return log;
    }

    private void showDataStream(AfterDoOperationEventArgs args) {
        long id = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, (AfterDoOperationEventArgs)args));
        if (id > 0L) {
            DynamicObject data_stream = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_data_stream_trace", (String)"data_stream_id");
            FormOpener.showList((AbstractFormPlugin)this, (String)"iscx_data_stream", (QFilter)new QFilter("id", "=", (Object)data_stream.getLong("data_stream_id")));
        }
    }

    private void openDiagram(AfterDoOperationEventArgs args) {
        long id = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, (AfterDoOperationEventArgs)args));
        if (id > 0L) {
            DynamicObject object = QueryServiceHelper.queryOne((String)"iscx_data_stream_trace", (String)"id,type,data_tag,data_stream_id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            String taskType = object.getString("type");
            if ("FiberTask".equals(taskType)) {
                DataFlowEditorUtil.openDataFlowTraceDiagram((AbstractFormPlugin)this, "iscx_data_stream_trace", id, object.getLong("data_stream_id"));
            } else if ("StreamTask".equals(taskType)) {
                DataFlowEditorUtil.openDataFlowQueryDiagram((AbstractFormPlugin)this, id, "iscx_data_stream_trace", object.getString("data_tag"), "completed", this.findNodeId(object));
            }
        }
    }

    private int findNodeId(DynamicObject object) {
        String data_tag = object.getString("data_tag");
        Map stream_task_context = (Map)Json.toObject((String)data_tag);
        return D.i(stream_task_context.get("startNodeId"));
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        if (currentListSelectedRow == null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flow_diagram"});
            return;
        }
        Object primaryKeyValue = currentListSelectedRow.getPrimaryKeyValue();
        DynamicObject object = QueryServiceHelper.queryOne((String)"iscx_data_stream_trace", (String)"id, type", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        String type = D.s((Object)object.get("type"));
        this.getView().setVisible(Boolean.valueOf(!type.equalsIgnoreCase("BatchTask")), new String[]{"flow_diagram"});
    }
}

