/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import kd.isc.kem.common.constants.EventType;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.common.util.KemAssert;

public class Event
implements Serializable {
    private static final long serialVersionUID = 1269751134093L;
    public static final String CRON_EVENT_NUMBER = "KemCronEvent";
    private final long eventId;
    private final String eventNumber;
    private final long dataSourceId;
    private final EventType eventType;
    private final JsonHashMap data;

    @JsonCreator
    public Event(@JsonProperty(value="eventId") long eventId, @JsonProperty(value="eventNumber") String eventNumber, @JsonProperty(value="dataSourceId") long dataSourceId, @JsonProperty(value="eventType") EventType eventType, @JsonProperty(value="data") JsonHashMap data) {
        if (eventId != -1L || !CRON_EVENT_NUMBER.equals(eventNumber)) {
            KemAssert.isTrue((eventId > 0L ? 1 : 0) != 0, (String)"eventId must not be null");
            KemAssert.notNull((Object)eventNumber, (String)"eventNumber must not be null");
            KemAssert.isTrue((dataSourceId > 0L ? 1 : 0) != 0, (String)"dataSourceId must not be null");
            KemAssert.notNull((Object)eventType, (String)"eventType must not be null");
            KemAssert.notNull((Object)data, (String)"data must not be null");
        }
        this.eventId = eventId;
        this.eventNumber = eventNumber;
        this.dataSourceId = dataSourceId;
        this.eventType = eventType;
        this.data = data;
    }

    public String toString() {
        return "Event{eventId=" + this.eventId + ", eventNumber='" + this.eventNumber + '\'' + ", dataSourceId=" + this.dataSourceId + ", eventType=" + this.eventType + ", data=" + this.data + '}';
    }

    public long getEventId() {
        return this.eventId;
    }

    public String getEventNumber() {
        return this.eventNumber;
    }

    public long getDataSourceId() {
        return this.dataSourceId;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public JsonHashMap getData() {
        return this.data;
    }

    public static boolean isCronEvent(Event event) {
        return CRON_EVENT_NUMBER.equals(event.getEventNumber()) && event.getEventId() == -1L;
    }

    public boolean isCronEvent() {
        return Event.isCronEvent(this);
    }
}

