/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.event;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.kem.common.encrypt.KemSignEncryptHelper;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.ConfigHelper;
import kd.isc.kem.core.event.EventPubInfo;
import kd.isc.kem.core.event.KemEventFactory;
import kd.isc.kem.core.event.webhook.encrypt.WebhookUtil;
import kd.isc.kem.core.exception.KemCoreError;

@ApiController(value="kem", desc="MLang_isc-kem-core_EventApiController_0")
@ApiMapping(value="/event")
public class EventApiController {
    private static final Log LOGGER = LogFactory.getLog(EventApiController.class);

    @ApiPostMapping(value="/publish", desc="MLang_isc-kem-core_EventApiController_1")
    public CustomApiResult<List<EventPubInfo>> publish(@NotNull @ApiParam(value="MLang_isc-kem-core_EventApiController_2") @NotNull @ApiParam(value="MLang_isc-kem-core_EventApiController_2") String eventNumber, @NotNull @ApiParam(value="MLang_isc-kem-core_EventApiController_3") @NotNull @ApiParam(value="MLang_isc-kem-core_EventApiController_3") long dataSourceId, @NotNull @ApiParam(value="MLang_isc-kem-core_EventApiController_4") @NotNull @ApiParam(value="MLang_isc-kem-core_EventApiController_4") Map<String, Object> data) {
        try {
            this.checkKemEventBodyLength();
            CustomApiResult<List<EventPubInfo>> apiResult = KemEventFactory.getEventService().publishByEventNumberWithApiResult(eventNumber, dataSourceId, data);
            return apiResult;
        }
        catch (KemException ex) {
            throw new KDException(new ErrorCode(ex.getErrorCode().getCode(), ex.getMessage()), ex.getArgs());
        }
    }

    @ApiPostMapping(value="/push/{__kem_uuid__}", desc="MLang_isc-kem-core_EventApiController_5")
    public CustomApiResult<Object> push(@ApiRequestBody Map<String, Object> data) {
        String uuidMD5;
        this.checkKemEventBodyLength();
        String uuid = D.s((Object)data.remove("__kem_uuid__"));
        Map queryMap = ServiceApiContext.getRequest().getHttpQueryString();
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String queryUrl = ServiceApiContext.getRequest().getHttpRequestUrl();
        long linkId = WebhookUtil.findLinkId(headers, queryMap, queryUrl);
        String linkIdStr = String.valueOf(linkId);
        if (!linkIdStr.equals(uuid) && !(uuidMD5 = KemSignEncryptHelper.md5((String)linkIdStr)).equals(uuid)) {
            throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{"invalid request"});
        }
        Map<String, Object> dataParams = EventApiController.getWebhookMap(linkId, data, headers == null ? null : new HashMap(headers));
        Object result = WebhookUtil.execute(linkId, dataParams);
        return CustomApiResult.success((Object)result);
    }

    public static Map<String, Object> getWebhookMap(long linkId, Map<String, Object> body, Map<String, Object> headers) {
        HashMap<String, Object> dataParams = new HashMap<String, Object>(5);
        dataParams.put("linkId", linkId);
        dataParams.put("body", body);
        dataParams.put("header", headers);
        return dataParams;
    }

    private void checkKemEventBodyLength() {
        if (OpenApiContext.getInputParameter() != null) {
            int maxLength = ConfigHelper.getKemMaxBodySize();
            int length = OpenApiContext.getInputParameter().length();
            if (length > maxLength) {
                String msg = String.format("The event body size is too long. Only %s bytes are allowed, but the current event body size is %s bytes.", maxLength, length);
                throw new KemException((KemErrorTemplate)KemCommonError.TooLarge, new Object[]{msg});
            }
        }
    }
}

