/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.common.model.MultiLangString;
import kd.isc.kem.core.event.Event;
import kd.isc.kem.core.event.EventDataProp;

public class EventDataPropUtil {
    private EventDataPropUtil() {
    }

    public static void fixEventDataType(Event event) {
        DynamicObject eventDO = BusinessDataServiceHelper.loadSingle((Object)event.getEventId(), (String)"kem_event");
        EventDataPropUtil.fixEventDataType(event, eventDO);
    }

    public static void fixEventDataType(Event event, DynamicObject eventDO) {
        JsonHashMap data = event.getData();
        DynamicObjectCollection dataEntry = eventDO.getDynamicObjectCollection("data_entry");
        HashMap<Long, EventDataProp> dataPropMap = new HashMap<Long, EventDataProp>(1);
        ArrayList<EventDataProp> rootProp = new ArrayList<EventDataProp>(1);
        for (DynamicObject row : dataEntry) {
            long id = row.getLong("id");
            long pid = row.getLong("pid");
            boolean isMulti = row.getBoolean("ismultivalue");
            String type = row.getString("paratype");
            String name = row.getString("paraname");
            EventDataProp prop = new EventDataProp();
            prop.setId(id);
            prop.setName(name);
            prop.setType(type);
            prop.setMulti(isMulti);
            if (pid == 0L) {
                rootProp.add(prop);
            } else {
                EventDataProp parentProp = (EventDataProp)dataPropMap.get(pid);
                if (parentProp != null) {
                    parentProp.addSubProp(prop);
                }
            }
            dataPropMap.put(id, prop);
        }
        for (EventDataProp prop : rootProp) {
            EventDataPropUtil.fixEventDataType(prop, (Map<String, Object>)data);
        }
    }

    private static Map<String, Object> getMapDataAsMap(Map<String, Object> map, String key) {
        Object val = map.get(key);
        if (val instanceof Map) {
            return (Map)val;
        }
        return null;
    }

    private static List<Object> getMapDataAsList(Map<String, Object> map, String key) {
        Object val = map.get(key);
        if (val instanceof List) {
            return (List)val;
        }
        return null;
    }

    private static void fixEventDataType(EventDataProp prop, Map<String, Object> data) {
        if (data == null) {
            return;
        }
        if ("mulilang".equals(prop.getType())) {
            if (prop.isMulti()) {
                EventDataPropUtil.fixListMLStr(prop, data);
            } else {
                EventDataPropUtil.fixMLStr(prop, data);
            }
        } else if (prop.getSubProps() != null && !prop.getSubProps().isEmpty()) {
            if (prop.isMulti()) {
                EventDataPropUtil.fixListSubProp(prop, data);
            } else {
                EventDataPropUtil.fixSubProp(prop, data);
            }
        }
    }

    private static void fixSubProp(EventDataProp prop, Map<String, Object> data) {
        Map<String, Object> value = EventDataPropUtil.getMapDataAsMap(data, prop.getName());
        if (value == null) {
            return;
        }
        for (EventDataProp subProp : prop.getSubProps()) {
            EventDataPropUtil.fixEventDataType(subProp, value);
        }
    }

    private static void fixListSubProp(EventDataProp prop, Map<String, Object> data) {
        List<Object> listData = EventDataPropUtil.getMapDataAsList(data, prop.getName());
        if (listData == null) {
            return;
        }
        listData.forEach(lv -> {
            if (!(lv instanceof Map)) {
                return;
            }
            for (EventDataProp subProp : prop.getSubProps()) {
                EventDataPropUtil.fixEventDataType(subProp, (Map)lv);
            }
        });
    }

    private static void fixMLStr(EventDataProp prop, Map<String, Object> data) {
        Map<String, Object> value = EventDataPropUtil.getMapDataAsMap(data, prop.getName());
        MultiLangString mlStr = EventDataPropUtil.covertMap2MLString(value);
        if (mlStr != null) {
            data.put(prop.getName(), mlStr);
        }
    }

    private static void fixListMLStr(EventDataProp prop, Map<String, Object> data) {
        List<Object> listData = EventDataPropUtil.getMapDataAsList(data, prop.getName());
        if (listData == null) {
            return;
        }
        int len = listData.size();
        for (int i = 0; i < len; ++i) {
            MultiLangString mlStr;
            Object lv = listData.get(i);
            if (!(lv instanceof Map) || (mlStr = EventDataPropUtil.covertMap2MLString((Map)lv)) == null) continue;
            listData.set(i, mlStr);
        }
    }

    private static MultiLangString covertMap2MLString(Map<String, Object> mapData) {
        if (mapData == null) {
            return null;
        }
        HashMap<String, Object> mlData = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : mapData.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (MultiLangString.isInvalidKey((String)key)) continue;
            mlData.put(key, entry.getValue());
        }
        if (!mlData.isEmpty()) {
            return new MultiLangString(mlData);
        }
        return null;
    }
}

