/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.event;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.kem.common.constants.ConfigConstant;
import kd.isc.kem.common.constants.EventType;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.model.JsonHashMap;
import kd.isc.kem.common.util.CollectionUtil;
import kd.isc.kem.common.util.ConfigHelper;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.common.util.KemAssert;
import kd.isc.kem.common.util.KemLicenseUtil;
import kd.isc.kem.common.util.LocalCacheUtil;
import kd.isc.kem.core.event.CronEvent;
import kd.isc.kem.core.event.Event;
import kd.isc.kem.core.event.EventPubInfo;
import kd.isc.kem.core.event.IEventService;
import kd.isc.kem.core.queue.KemQueueFactory;
import kd.isc.kem.core.queue.KemQueuePriority;
import kd.isc.kem.core.queue.KemQueueType;
import kd.isc.kem.core.subscribe.handler.LogHandler;
import kd.isc.kem.core.subscribe.model.SubscribeInfo;
import kd.isc.kem.core.subscribe.model.SubscribeModel;
import kd.isc.kem.core.task.KemCronJobUtil;

public class EventServiceImpl
implements IEventService {
    private final String CACHE_TYPE_SUBLIST = "kem_sub_list";
    private static final String KEM_EVENT_ENTITY = "kem_event";
    private static final Log log = LogFactory.getLog(EventServiceImpl.class);

    @Override
    public List<EventPubInfo> publishByEventId(long eventId, long dataSourceId, Map<String, Object> data) {
        this.checkKemDataLength(data);
        return this.publish(eventId, dataSourceId, 0L, data);
    }

    @Override
    public List<EventPubInfo> publishByEventNumber(String eventNumber, long dataSourceId, Map<String, Object> data) {
        Event event = EventServiceImpl.getEvent(eventNumber, dataSourceId, data);
        if (event == null) {
            String msg = String.format("Event %s does not exists.", eventNumber);
            throw new KemException((KemErrorTemplate)KemCommonError.EventNotExists, new Object[]{msg});
        }
        this.checkKemDataLength(data);
        return this.publish(event.getEventId(), dataSourceId, 0L, data);
    }

    @Override
    public List<EventPubInfo> publishBySubId(long subId, Map<String, Object> data) {
        this.checkKemDataLength(data);
        return this.publish(0L, 0L, subId, data);
    }

    @Override
    public CustomApiResult<List<EventPubInfo>> publishByUUID(String eventUUId, long linkId, Map<String, Object> data) {
        try {
            this.checkKemDataLength(data);
            List dataSourceList = DataSource.getAllByDbLink((long)linkId);
            Set dataSourceIds = dataSourceList.stream().map(DataSource::getId).collect(Collectors.toSet());
            ArrayList<EventPubInfo> eventPubInfoList = new ArrayList<EventPubInfo>();
            if (dataSourceIds.size() > 0) {
                for (Long dsId : dataSourceIds) {
                    Event event = EventServiceImpl.getEventByUUID(eventUUId, dsId, data);
                    if (event != null) {
                        try {
                            List<EventPubInfo> lstPubInfo = this.publish(event.getEventId(), dsId, 0L, data);
                            eventPubInfoList.addAll(lstPubInfo);
                            continue;
                        }
                        catch (KemException ex) {
                            if (KemCommonError.NotSubscribed.getCode().equals(ex.getErrorCode().getCode())) continue;
                            throw ex;
                        }
                    }
                    String msg = String.format("Cannot found the event, eventUUID:%s, dataSourceId:%s. ", eventUUId, dsId);
                    EventPubInfo pubInfo = new EventPubInfo(0L, "", "", msg, KemCommonError.EventNotExists.getCode());
                    eventPubInfoList.add(pubInfo);
                }
            } else {
                String msg = "DataSourceId cannot be empty.";
                EventPubInfo pubInfo = new EventPubInfo(0L, "", "", msg, KemCommonError.EventNotExists.getCode());
                eventPubInfoList.add(pubInfo);
            }
            return CustomApiResult.success(eventPubInfoList);
        }
        catch (Exception ex) {
            return this.getExceptionEventPubInfoApiResult(ex, eventUUId);
        }
    }

    @Override
    public List<Map<String, Object>> publishCustomEvent2(String eventNumber, Map<String, Object> data) {
        List<EventPubInfo> list = this.publishCustomEvent(eventNumber, data);
        return (List)JacksonUtil.convertValue(list, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
    }

    @Override
    public List<EventPubInfo> publishCustomEvent(String eventNumber, Map<String, Object> data) {
        this.checkKemDataLength(data);
        KemAssert.hasText((String)eventNumber, (String)"eventNumber\uff1a must not be null");
        KemAssert.notEmpty(data, (String)"data\uff1a must not be null");
        QFilter qFilter = new QFilter("status", "=", (Object)"B").and("eventid.number", "=", (Object)eventNumber).and("eventid.eventtype", "=", (Object)String.valueOf(EventType.SDK.getCode())).and("eventid.enable", "=", (Object)"1").and("eventdatasourceid.connection_type", "=", (Object)"self");
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"kem_subscribe", (String)"id,number", (QFilter[])qFilter.toArray());
        if (CollectionUtil.isEmpty((Collection)objects)) {
            throw new KemException("publishCustomEvent", ResManager.loadKDString((String)"\u901a\u8fc7\u4e8b\u4ef6\u7f16\u7801 {0} \u672a\u627e\u5230\u76f8\u5173\u8ba2\u9605\uff0c\u53ef\u80fd\u539f\u56e0\u4e3a\u4e8b\u4ef6\u4e0d\u5b58\u5728\uff0c\u672a\u542f\u7528\u6216\u975e\u81ea\u5b9a\u4e49\u4e8b\u4ef6\uff0c\u8ba2\u9605\u672a\u53d1\u5e03\u6216\u6765\u6e90\u6570\u636e\u6e90\u662f\u975e\u5f53\u524d\u8d26\u5957\u3002", (String)"EventServiceImpl_0", (String)"isc-kem-core", (Object[])new Object[]{eventNumber}));
        }
        Map<Long, String> subIdNumbers = objects.stream().collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getString("number")));
        return this.publishByMulDataSource(eventNumber, subIdNumbers, data);
    }

    private List<EventPubInfo> publishByMulDataSource(String eventNumber, Map<Long, String> subIdNumbers, Map<String, Object> data) {
        ArrayList<EventPubInfo> eventPubInfoList = new ArrayList<EventPubInfo>(subIdNumbers.size());
        for (Map.Entry<Long, String> entry : subIdNumbers.entrySet()) {
            try {
                List<EventPubInfo> lstPubInfo = this.publish(0L, 0L, entry.getKey(), data);
                eventPubInfoList.addAll(lstPubInfo);
            }
            catch (KemException e) {
                if (KemCommonError.EventNotExists.getCode().equals(e.getErrorCode().getCode()) || KemCommonError.NotSubscribed.getCode().equals(e.getErrorCode().getCode())) continue;
                String msg = String.format("eventNumber:%s, subNumber:%s >>>\r\n %s", eventNumber, entry.getValue(), StringUtil.getMessage((Throwable)e));
                EventPubInfo pubInfo = new EventPubInfo(0L, entry.getValue(), eventNumber, msg, "publishByMulDataSource");
                eventPubInfoList.add(pubInfo);
            }
        }
        return eventPubInfoList;
    }

    @Override
    public CustomApiResult<List<EventPubInfo>> publishByEventNumberWithApiResult(String eventNumber, long dataSourceId, Map<String, Object> data) {
        try {
            List<EventPubInfo> eventPubInfoList = this.publishByEventNumber(eventNumber, dataSourceId, data);
            return CustomApiResult.success(eventPubInfoList);
        }
        catch (Exception ex) {
            return this.getExceptionEventPubInfoApiResult(ex, eventNumber);
        }
    }

    @Override
    public List<EventPubInfo> publishCronEvent(long subId, String subNumber, String cronExpress, Map<String, Object> data, boolean isPub) {
        long subInstanceId = ID.genLongId();
        Date scheduleTime = KemCronJobUtil.getNextScheduleTime(cronExpress);
        JsonHashMap jsonEventData = new JsonHashMap();
        if (data != null) {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                jsonEventData.put((Object)entry.getKey(), entry.getValue());
            }
        }
        jsonEventData.put((Object)"scheduleTime", (Object)scheduleTime);
        jsonEventData.put((Object)"cronExpress", (Object)cronExpress);
        Event event = new Event(-1L, "KemCronEvent", -1L, EventType.Pool, jsonEventData);
        SubscribeInfo subInfo = new SubscribeInfo(subInstanceId, subId, subNumber, event, scheduleTime);
        CronEvent cronEventData = new CronEvent(subId, subNumber, cronExpress, scheduleTime, isPub, subInfo);
        String queueName = "KemCronEvent";
        String remark = event.getEventNumber() + ":" + scheduleTime.toString();
        KemQueueFactory.getQueue(queueName).publish(subInstanceId, queueName, KemQueueType.Cron, KemQueuePriority.Normal, scheduleTime, 1, cronEventData, subId, subInstanceId, remark);
        ArrayList<EventPubInfo> eventPubInfoList = new ArrayList<EventPubInfo>();
        eventPubInfoList.add(new EventPubInfo(subInstanceId, subNumber, "", "", ""));
        return eventPubInfoList;
    }

    @Override
    public void clearCache() {
        LocalCacheUtil.clear((String)"kem_sub_list");
    }

    private List<EventPubInfo> publish(long eventId, long dataSourceId, long subId, Map<String, Object> data) {
        ArrayList<EventPubInfo> eventPubInfoList = new ArrayList<EventPubInfo>(1);
        Set<SubscribeModel> subList = subId != 0L ? this.getSubListBySubId(subId) : this.getSubListByEvent(eventId, dataSourceId);
        if (subList != null && subList.size() > 0) {
            for (SubscribeModel item : subList) {
                this.checkLicense(item.getSrcSubType());
                long subInstanceId = ID.genLongId();
                Date date = new Date();
                long subEventDataSourceId = item.getEventDataSourceId();
                Event event = EventServiceImpl.getEvent(item.getEventId(), subEventDataSourceId, data);
                if (event != null) {
                    SubscribeInfo subInfo = new SubscribeInfo(subInstanceId, item.getSubId(), item.getSubNumber(), event, date);
                    String remark = event.getEventNumber() + ":" + event.getEventType();
                    KemQueueFactory.getQueue(event.getEventNumber()).publish(subInstanceId, event.getEventNumber(), KemQueueType.Event, KemQueuePriority.Normal, date, 1, subInfo, item.getSubId(), subInstanceId, remark);
                    eventPubInfoList.add(new EventPubInfo(subInstanceId, item.getSubNumber(), event.getEventNumber(), "", ""));
                    continue;
                }
                String msg = String.format("Cannot found the event, eventId:%s, dataSourceId:%s. ", item.getEventId(), subEventDataSourceId);
                EventPubInfo pubInfo = new EventPubInfo(0L, "", "", msg, KemCommonError.EventNotExists.getCode());
                eventPubInfoList.add(pubInfo);
            }
        } else {
            String errMsg = "";
            if (subId != 0L) {
                errMsg = String.format("Cannot find the Subscription Data, subId:%s.", subId);
            } else {
                Event event = EventServiceImpl.getEvent(eventId, dataSourceId, null);
                String eventNumber = event != null ? event.getEventNumber() : "";
                errMsg = String.format("Cannot find the Subscription Data, eventNumber:%s, dataSourceId:%s.", eventNumber, dataSourceId);
            }
            throw new KemException((KemErrorTemplate)KemCommonError.NotSubscribed, new Object[]{errMsg});
        }
        return eventPubInfoList;
    }

    private void checkKemDataLength(Map<String, Object> data) {
        int maxSize;
        String value = JacksonUtil.writeValueAsString(data);
        long objectSize = value == null ? 0L : (long)value.length();
        if (objectSize > (long)(maxSize = ConfigHelper.getKemMaxBodySize())) {
            String msg = String.format("The event data size is too long. Only %s bytes are allowed, but the current event data size is %s bytes.", maxSize, objectSize);
            throw new KemException((KemErrorTemplate)KemCommonError.TooLarge, new Object[]{msg});
        }
    }

    private List<EventPubInfo> getExceptionEventPubInfo(Exception ex, String eventNumber) {
        ArrayList<EventPubInfo> eventPubInfoList = new ArrayList<EventPubInfo>(1);
        String errorCode = "";
        errorCode = ex instanceof KDException ? ((KDException)ex).getErrorCode().getCode() : KemCommonError.CommonError.getCode();
        eventPubInfoList.add(new EventPubInfo(0L, "", eventNumber, LogHandler.getExMsg(ex), errorCode));
        return eventPubInfoList;
    }

    private CustomApiResult<List<EventPubInfo>> getExceptionEventPubInfoApiResult(Exception ex, String eventNumber) {
        List<EventPubInfo> eventPubInfoList = this.getExceptionEventPubInfo(ex, eventNumber);
        String errCode = "";
        String errMsg = "";
        if (eventPubInfoList.size() >= 1) {
            errCode = eventPubInfoList.get(0).getSubErrCode();
            errMsg = eventPubInfoList.get(0).getMsg();
        }
        CustomApiResult result = new CustomApiResult();
        result.setData(eventPubInfoList);
        result.setErrorCode(errCode);
        result.setMessage(errMsg);
        result.setStatus(false);
        return result;
    }

    private void checkLicense(String srcSubType) {
        KemLicenseUtil.checkGrayLicense((String)srcSubType);
    }

    public static Event getEvent(String eventNumber, long dataSourceId, Map<String, Object> eventData) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)eventNumber), new QFilter("enable", "=", (Object)"1")};
        DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((String)KEM_EVENT_ENTITY, (QFilter[])filters);
        if (data == null) {
            return null;
        }
        Event event = EventServiceImpl.getEventFromDynamicObject(data, dataSourceId, eventData);
        return event;
    }

    public static Event getEvent(long eventId, long dataSourceId, Map<String, Object> eventData) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)eventId), new QFilter("enable", "=", (Object)"1")};
        DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((String)KEM_EVENT_ENTITY, (QFilter[])filters);
        if (data == null) {
            return null;
        }
        Event event = EventServiceImpl.getEventFromDynamicObject(data, dataSourceId, eventData);
        return event;
    }

    public static Event getEventByUUID(String eventUUId, long dataSourceId, Map<String, Object> eventData) {
        QFilter[] filters = new QFilter[]{new QFilter("eventuuid", "=", (Object)eventUUId), new QFilter("enable", "=", (Object)"1")};
        DynamicObject data = BusinessDataServiceHelper.loadSingleFromCache((String)KEM_EVENT_ENTITY, (QFilter[])filters);
        if (data == null) {
            return null;
        }
        Event event = EventServiceImpl.getEventFromDynamicObject(data, dataSourceId, eventData);
        return event;
    }

    private static Event getEventFromDynamicObject(DynamicObject data, long dataSourceId, Map<String, Object> eventData) {
        long eventId = data.getLong("id");
        String eventNumber = data.getString("number");
        int type = data.getInt("eventType");
        EventType eventType = EventType.getEventType((int)type);
        JsonHashMap jsonEventData = new JsonHashMap();
        if (eventData != null) {
            for (Map.Entry<String, Object> entry : eventData.entrySet()) {
                jsonEventData.put((Object)entry.getKey(), entry.getValue());
            }
        }
        Event event = new Event(eventId, eventNumber, dataSourceId, eventType, jsonEventData);
        return event;
    }

    private Set<SubscribeModel> getSubListByEvent(long eventId, long dataSourceId) {
        return this.getSubFromDbOrCache(eventId, dataSourceId, 0L);
    }

    private Set<SubscribeModel> getSubListBySubId(long subId) {
        return this.getSubFromDbOrCache(0L, 0L, subId);
    }

    private Set<SubscribeModel> getSubFromDbOrCache(long eventId, long dataSourceId, long subId) {
        String cacheKey = subId != 0L ? String.valueOf(subId) : String.valueOf(eventId) + "-" + String.valueOf(dataSourceId);
        Set<SubscribeModel> data = (Set<SubscribeModel>)LocalCacheUtil.getCacheByKey((String)"kem_sub_list", (String)cacheKey);
        if (data == null) {
            data = this.getSubFromDb(eventId, dataSourceId, subId);
            LocalCacheUtil.setCacheByKey((String)"kem_sub_list", data);
        }
        return data;
    }

    private Set<SubscribeModel> getSubFromDb(long eventId, long dataSourceId, long subId) {
        String sql;
        Object[] params;
        if (subId != 0L) {
            params = new Object[]{subId};
            sql = "select fid,fnumber,feventid,feventDataSourceId,fsrcsubtype from t_kem_sub  where fid=? and fenable='1' and fstatus='B' ";
        } else {
            params = new Object[]{eventId, dataSourceId};
            sql = "select fid,fnumber,feventid,feventDataSourceId,fsrcsubtype from t_kem_sub  where feventId=? and feventDataSourceId=? and fenable='1' and fstatus='B' ";
        }
        HashSet<SubscribeModel> subList = new HashSet<SubscribeModel>(2);
        try (DataSet dataSet = DB.queryDataSet((String)"kem.sub", (DBRoute)ConfigConstant.DB_ROUTE, (String)sql, (Object[])params);){
            for (Row row : dataSet) {
                Long dbSubId = row.getLong("fid");
                Long dbEventId = row.getLong("feventid");
                String dbSubNumber = row.getString("fnumber");
                Long dbEventDataSourceId = row.getLong("feventDataSourceId");
                String dbSrcSubType = row.getString("fsrcsubtype");
                SubscribeModel subModel = new SubscribeModel(dbSubId, dbSubNumber, dbEventId, dbEventDataSourceId, dbSrcSubType);
                subList.add(subModel);
            }
        }
        return subList;
    }
}

