/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.event.operate;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.connector.self.triggerhandler.TriggerHandler;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.kem.common.constants.EventType;
import kd.isc.kem.common.constants.ParamType;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.CollectionUtil;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.core.event.EventPubInfo;
import kd.isc.kem.core.event.KemEventFactory;
import kd.isc.kem.core.exception.KemCoreError;

public class SubOperateEventHandler
implements TriggerHandler {
    private static final Log LOG = LogFactory.getLog(SubOperateEventHandler.class);
    public static final String $OPERATION = "_$OPERATION";
    public static final String $ENTITY_NUMBER = "_$ENTITY_NUMBER";

    public Object handle(long subId, List<?> list) {
        LOG.info("KEM_LOG:SubOperateEventHandler.handle InstanceId\uff1a{},  TraceId\uff1a{}, subId = {}, list = {}", new Object[]{Instance.getInstanceId(), RequestContext.get().getTraceId(), subId, JacksonUtil.writeValueAsString(list)});
        try {
            if (CollectionUtil.isEmpty(list)) {
                throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{MessageFormat.format("subId {0} operate event data must not be null", subId)});
            }
            DynamicObject sub = BusinessDataServiceHelper.loadSingleFromCache((Object)subId, (String)"kem_subscribe");
            if (sub == null) {
                throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{MessageFormat.format("subId {0} does not exist", subId)});
            }
            long eventId = sub.getLong("eventid.id");
            DynamicObject event = BusinessDataServiceHelper.loadSingleFromCache((Object)eventId, (String)"kem_event");
            if (event == null) {
                throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{MessageFormat.format("eventId {0} does not exist", eventId)});
            }
            if (!"1".equals(event.getString("enable"))) {
                throw new KemException((KemErrorTemplate)KemCoreError.CoreError, new Object[]{MessageFormat.format("event \u3010{0}\u3011 is disabled", event.getString("number"))});
            }
            List<Map<String, Object>> dataList = list;
            List<Map<String, Object>> newDataList = SubOperateEventHandler.getDataList(event, dataList);
            ArrayList<EventPubInfo> result = new ArrayList<EventPubInfo>(16);
            for (Map<String, Object> map : newDataList) {
                List<EventPubInfo> eventPubInfoList = KemEventFactory.getEventService().publishBySubId(subId, map);
                result.addAll(eventPubInfoList);
            }
            return result.stream().distinct().collect(Collectors.toList());
        }
        catch (Exception e) {
            if (e instanceof KemException) {
                throw e;
            }
            LOG.error("KEM_LOG:SubOperateEventHandler.handle", (Throwable)e);
            throw new KemException((Throwable)e, (KemErrorTemplate)KemCoreError.CoreError, new Object[]{e.getMessage()});
        }
    }

    private static List<Map<String, Object>> getDataList(DynamicObject event, List<Map<String, Object>> dataList) {
        DynamicObjectCollection entry = event.getDynamicObjectCollection("data_entry");
        if (entry.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Long, List<DynamicObject>> collect = entry.stream().collect(Collectors.groupingBy(it -> it.getLong("pid")));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(dataList.size());
        for (Map<String, Object> data : dataList) {
            Map<String, Object> map = SubOperateEventHandler.getData(data, 0L, collect, null, EventType.ENTITY);
            if (map != null) {
                map.put($ENTITY_NUMBER, event.getString("bizobjectnumber"));
            }
            result.add(map);
        }
        return result;
    }

    public static Map<String, Object> getData(Map<String, Object> data, long pid, Map<Long, List<DynamicObject>> collect, String fullParent, EventType eventType) {
        List<DynamicObject> params = collect.get(pid);
        if (CollectionUtil.isEmpty(params)) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(params.size());
        for (DynamicObject it : params) {
            Map map;
            String param = it.getString("paraname");
            Object value = data.get(param);
            if (value == null) {
                result.put(param, null);
                continue;
            }
            String fullParam = kd.isc.kem.common.util.StringUtil.isBlank((CharSequence)fullParent) ? param : fullParent + "." + param;
            ParamType paramType = ParamType.getParamType((String)it.getString("paratype"));
            boolean isMul = it.getBoolean("ismultivalue");
            if (ParamType.Multilingual == paramType) {
                map = (Map)paramType.validator(fullParam, value, isMul);
                Map<String, Object> mapVal = SubOperateEventHandler.getData(new HashMap<String, Object>(map), it.getLong("id"), collect, fullParam, eventType);
                Object val = mapVal == null ? LocaleString.fromMap((Map)map).getLocaleValue() : mapVal;
                result.put(param, val);
                continue;
            }
            if (ParamType.Struct == paramType) {
                if (isMul) {
                    List list = (List)paramType.validator(fullParam, value, isMul);
                    ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(list.size());
                    for (Map map2 : list) {
                        mapList.add(SubOperateEventHandler.getData(map2, it.getLong("id"), collect, fullParam, eventType));
                    }
                    result.put(param, mapList);
                    continue;
                }
                try {
                    map = (Map)paramType.validator(fullParam, value, isMul);
                }
                catch (Exception e) {
                    List<DynamicObject> objects;
                    if (eventType == EventType.ENTITY && CollectionUtil.isEmpty(objects = collect.get(it.getLong("id")))) {
                        result.put(param, D.isLong((String)value.toString()) ? Long.valueOf(D.l((Object)value)) : value);
                        continue;
                    }
                    throw new KemException((Throwable)e, (KemErrorTemplate)KemCoreError.CoreError, new Object[]{StringUtil.getMessage((Throwable)e)});
                }
                result.put(param, SubOperateEventHandler.getData(map, it.getLong("id"), collect, fullParam, eventType));
                continue;
            }
            if (ParamType.DateTime == paramType || ParamType.Date == paramType || ParamType.Time == paramType) {
                paramType.validator(fullParam, value, isMul);
                result.put(param, value);
                continue;
            }
            result.put(param, paramType.validator(fullParam, value, isMul));
        }
        if (eventType == EventType.ENTITY && pid == 0L) {
            result.put($OPERATION, data.get("#EVENT"));
        }
        return result;
    }
}

