/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.event.webhook.encrypt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.kem.common.encrypt.KemEncryptType;
import kd.isc.kem.common.encrypt.KemSignEncryptHelper;
import kd.isc.kem.common.encrypt.KemSignType;
import kd.isc.kem.common.util.JacksonUtil;
import kd.isc.kem.common.util.KHashMap;
import kd.isc.kem.core.subscribe.model.JsonNodeExt;
import kd.sdk.annotation.SdkInternal;

@ApiController(value="kem", desc="\u7b7e\u540d\u52a0\u89e3\u5bc6Demo")
@ApiMapping(value="/setest")
@SdkInternal
public class EncryptDemoController {
    @ApiPostMapping(value="/test")
    public CustomApiResult<Object> test(@ApiRequestBody(required=true) Map<String, Object> map) {
        String encryptTypeCode;
        String subNumber = (String)ServiceApiContext.getRequest().getHttpQueryString().get("subNumber");
        DynamicObject sub = BusinessDataServiceHelper.loadSingleFromCache((String)"kem_subscribe", (QFilter[])new QFilter("number", "=", (Object)subNumber).toArray());
        DynamicObjectCollection targets = sub.getDynamicObjectCollection("target_entry");
        String actionConfig = ((DynamicObject)targets.get(0)).getString("actionconfig_tag");
        JsonNodeExt targetConfig = JsonNodeExt.of(JacksonUtil.readTree((String)actionConfig));
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("sign", "no sign");
        Map reqHeader = ServiceApiContext.getRequest().getRequestHeaders();
        String signTypeCode = targetConfig.orElseGet("signtype", () -> new TextNode(KemSignType.UNSIGN.getCode())).asText();
        if (!KemSignType.UNSIGN.getCode().equals(signTypeCode)) {
            String orgSign;
            String signKey = targetConfig.get("signsecretkey").asText();
            signKey = KemSignEncryptHelper.decode((String)signKey);
            String timestamp = (String)reqHeader.get("x-kem-request-timestamp");
            String nonce = (String)reqHeader.get("x-kem-request-nonce");
            String bodyString = JacksonUtil.writeValueAsString(map);
            String sign = KemSignType.getSignType((String)signTypeCode).sign(signKey, timestamp, nonce, bodyString);
            if (!sign.equals(orgSign = (String)reqHeader.get("x-kem-signature"))) {
                return CustomApiResult.fail((String)"sign error", (String)KHashMap.create().set((Object)"timestamp", (Object)timestamp).set((Object)"nonce", (Object)nonce).set((Object)"bodyString", (Object)bodyString).set((Object)"orgSign", (Object)orgSign).set((Object)"sign", (Object)sign).toString());
            }
            result.put("sign", "sign success");
        }
        if (kd.isc.kem.common.util.StringUtil.isNotBlank((CharSequence)(encryptTypeCode = targetConfig.orElse("encrypttype", (JsonNode)new TextNode(null)).asText())) && !"0".equals(encryptTypeCode)) {
            Object obj = map.get("encrypt");
            if (obj == null) {
                return CustomApiResult.fail((String)"encrypt error", (String)"encrypt content null");
            }
            String iv = (String)reqHeader.get("x-kem-encrypt-iv");
            try {
                String encryptKey = targetConfig.get("encryptsecretkey").asText();
                encryptKey = KemSignEncryptHelper.decode((String)encryptKey);
                byte[] data = KemEncryptType.getEncryptType((String)encryptTypeCode).decryptBase64(obj.toString(), encryptKey, iv);
                byte[] ret = Arrays.copyOf(data, data.length);
                byte zeroByte = 0;
                Arrays.fill(data, zeroByte);
                return EncryptDemoController.getCustomApiResult(ret);
            }
            catch (Throwable e) {
                return CustomApiResult.fail((String)"encrypt error", (String)StringUtil.toString((Throwable)e));
            }
        }
        result.put("encrypt", "no decrypt");
        result.put("data", map);
        return CustomApiResult.success(result);
    }

    private static CustomApiResult<Object> getCustomApiResult(byte[] ss) {
        return CustomApiResult.success((Object)new String(ss, StandardCharsets.UTF_8));
    }
}

