/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.event.webhook.encrypt;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;
import kd.bos.openapi.thirdapp.ThirdAppService;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.kem.api.encrypt.KemEncryptionService;
import kd.isc.kem.common.constants.ConfigConstant;
import kd.isc.kem.common.encrypt.KemEncryptType;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.ConfigHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang3.RandomStringUtils;

@SdkInternal
public class KemEncryptionServiceImpl
implements KemEncryptionService {
    private static final Log log = LogFactory.getLog(KemEncryptionServiceImpl.class);

    public String getRandomStr(int count) {
        return this.getRandomString(count);
    }

    private String getRandomString(int length) {
        if (length < 1) {
            throw new KemException((KemErrorTemplate)KemCommonError.CommonError, new Object[]{"INVALID length, should be more than 0."});
        }
        return RandomStringUtils.randomAlphanumeric((int)length);
    }

    public String getBaseAuthUrl(Long connectLinkId) {
        String agentUserString = ConfigHelper.getSystemParam((String)"kem_webhook_userid", (String)"0");
        String agentUserId = "0";
        int idIndex = agentUserString.indexOf("id=");
        if (idIndex > 0 && agentUserString.indexOf(44) > idIndex + 3) {
            agentUserId = agentUserString.substring(idIndex + 3, agentUserString.indexOf(44));
        }
        if ("0".equals(agentUserId)) {
            throw new KemException((KemErrorTemplate)KemCommonError.CommonError, new Object[]{ResManager.loadKDString((String)"\u672a\u914d\u7f6ewebhook\u56de\u8c03\u63a5\u53e3\u7684\u4ee3\u7406\u7528\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u524d\u5f80\u3010\u57fa\u7840\u670d\u52a1\u4e91-\u516c\u5171\u8bbe\u7f6e-\u53c2\u6570\u914d\u7f6e-\u7cfb\u7edf\u53c2\u6570\u3011\u9875\u9762\u914d\u7f6e\u4e8b\u4ef6\u7f51\u683c\u5e94\u7528\u53c2\u6570\u3002", (String)"KemEncryptionServiceImpl_0", (String)"isc-kem-core", (Object[])new Object[0])});
        }
        DynamicObject connectConfig = ConnectionConfig.getConfig((long)connectLinkId);
        String number = connectConfig.getString("number");
        String basicSignToken = (String)DispatchApiServiceHelper.invokeApiService((String)ThirdAppService.class.getSimpleName(), (String)"genBasicSignToken", (Object[])new Object[]{ConfigConstant.KEM_EVENT_THIRD_ID.toString(), agentUserId, connectLinkId + "", number});
        String uuid = connectLinkId.toString();
        String accessUrl = String.format("%1$skapi/v2/kem/event/push/%2$s?openapisign=%3$s", RequestContext.get().getClientFullContextPath(), uuid, basicSignToken);
        return accessUrl;
    }

    public String encryptBase64(String transformation, String keyBase64, String ivBase64, String originalStr) {
        return (String)KemEncryptType.getEncryptType((String)transformation).encryptBase64(originalStr, keyBase64, ivBase64).getEncrypt();
    }

    public byte[] decryptBase64(String transformation, String keyBase64, String ivBase64, String encryptBase64) {
        return KemEncryptType.getEncryptType((String)transformation).decryptBase64(encryptBase64, keyBase64, ivBase64);
    }

    public byte[] encrypt(String transformation, byte[] key, byte[] iv, byte[] originalData) {
        return (byte[])KemEncryptType.getEncryptType((String)transformation).encrypt(originalData, key, iv).getEncrypt();
    }

    public byte[] decrypt(String transformation, byte[] key, byte[] iv, byte[] encrypt) {
        return KemEncryptType.getEncryptType((String)transformation).decrypt(encrypt, key, iv);
    }
}

