/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.kem.core.event.webhook.encrypt;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.ThirdAppSecurityUtil;
import kd.bos.openapi.security.model.BaseAuthInfoDto;
import kd.bos.openapi.security.util.ParameterUtil;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.webapi.SupportWebhookEvent;
import kd.isc.kem.common.exception.KemCommonError;
import kd.isc.kem.common.exception.KemErrorTemplate;
import kd.isc.kem.common.exception.KemException;
import kd.isc.kem.common.util.LambdaUtil;
import kd.isc.kem.common.util.StringUtil;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang3.math.NumberUtils;

@SdkInternal
public class WebhookUtil {
    private static final Log LOGGER = LogFactory.getLog(WebhookUtil.class);
    public static final String LINK_ID = "linkId";
    public static final String DS_ID_LIST = "dsIdList";

    public static long findLinkId(Map<String, String> headers, Map<String, String> queryMap, String queryUrl) {
        String accessKey = ParameterUtil.getBasicAuthAccessKeyAuthParamsBy(queryMap, headers, (String)queryUrl, (String)"openapisign");
        if (StringUtil.isEmpty((CharSequence)accessKey)) {
            throw new KemException((KemErrorTemplate)KemCommonError.CommonError, new Object[]{"invalid accessKey, accessKey is empty."});
        }
        long linkId = 0L;
        if (StringUtil.isNotEmpty((CharSequence)accessKey)) {
            Map signMap = ParameterUtil.getAccountIdAndSignCode((String)accessKey);
            if (StringUtil.isEmpty((CharSequence)((CharSequence)signMap.get("signCode")))) {
                throw new KemException((KemErrorTemplate)KemCommonError.CommonError, new Object[]{"invalid accessKey, signCode is empty."});
            }
            String signEncode = EncrypterFactory.getEncrypter().encode((String)signMap.get("signCode"));
            BaseAuthInfoDto baseAuthResult = ThirdAppSecurityUtil.getBaseAuthInfoBySign((String)((String)signMap.get("accountId")), (String)signEncode);
            if (baseAuthResult == null) {
                throw new KemException((KemErrorTemplate)KemCommonError.CommonError, new Object[]{"invalid accessKey, baseAuthResult is null."});
            }
            String connectLinkId = baseAuthResult.getSysTag();
            if (StringUtil.isNotBlank((CharSequence)connectLinkId) && NumberUtils.isDigits((String)connectLinkId)) {
                DynamicObject connectConfig = ConnectionConfig.getConfig((long)Long.parseLong(connectLinkId));
                long l = linkId = connectConfig != null ? connectConfig.getLong("id") : 0L;
            }
        }
        if (linkId == 0L) {
            throw new KemException((KemErrorTemplate)KemCommonError.CommonError, new Object[]{"invalid connectLinkId."});
        }
        return linkId;
    }

    public static Object execute(long linkId, Map<String, Object> data) {
        return LambdaUtil.connectionManager((boolean)true, () -> {
            try (ConnectionWrapper cn = ConnectionManager.getConnection((long)linkId);){
                ConnectionFactory factory = cn.getFactory();
                if (!(factory instanceof SupportWebhookEvent)) {
                    throw new IllegalArgumentException("facotry [" + factory.getClass() + "] should implement SupportWebhookEvent");
                }
                SupportWebhookEvent supportWebhookEvent = (SupportWebhookEvent)factory;
                Object object = supportWebhookEvent.webhookMsgHandle(cn, data);
                return object;
            }
        });
    }
}

